/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.NotMatchFileException;

public class IDClass {
    int numplayers = 0;

    public IDClass(int num) {
        this.numplayers = num;
    }

    protected Object clone() {
        return new IDClass(this.numplayers);
    }

    public static IDClass parse(String line) throws NullPointerException, NotMatchFileException {
        int numplayers = 0;
        if (!(line = line.trim()).startsWith("id")) {
            throw new NotMatchFileException();
        }
        boolean flag = true;
        int index = 0;
        while ((index = line.indexOf(" ", index) + 1) > 0 && flag) {
            flag = line.substring(index, index + String.valueOf(++numplayers).length()).equals(String.valueOf(numplayers));
        }
        if (!flag) {
            throw new NotMatchFileException();
        }
        return new IDClass(numplayers);
    }

    public String toString() {
        String output = "id";
        for (int i = 1; i <= this.numplayers; ++i) {
            output = output + " " + i;
        }
        return output + "\r\n";
    }

    public boolean equals(IDClass i) {
        return this.getNumberOfPlayers() == i.getNumberOfPlayers();
    }

    public void setNumberOfPlayers(int num) {
        this.numplayers = num;
    }

    public int getNumberOfPlayers() {
        return this.numplayers;
    }
}

