/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import edu.caltech.ssel.multistage.server.util.matchingservice.GroupingList;
import edu.caltech.ssel.multistage.server.util.matchingservice.GroupingNode;
import java.util.AbstractList;
import java.util.Iterator;

public class Groupings
extends AbstractList {
    private GroupingNode tail = null;
    private int count = 0;
    private int counter = 0;

    public void add(GroupingList value) {
        this.addLast(value);
    }

    public void addFirst(GroupingList value) {
        GroupingNode temp = new GroupingNode(value);
        if (this.tail == null) {
            this.tail = temp;
            this.tail.setNext(this.tail);
        } else {
            temp.setNext(this.tail.next());
            this.tail.setNext(temp);
        }
        ++this.count;
    }

    public void addLast(GroupingList value) {
        this.addFirst(value);
        this.tail = this.tail.next();
    }

    public GroupingList getFirst() {
        return this.tail.next().value();
    }

    public GroupingList getLast() {
        return this.tail.value();
    }

    public GroupingList removeFirst() {
        GroupingNode temp = this.tail.next();
        if (this.tail == this.tail.next()) {
            this.tail = null;
        } else {
            this.tail.setNext(temp.next());
            temp.setNext(null);
        }
        --this.count;
        return temp.value();
    }

    public GroupingList removeLast() {
        if (this.isEmpty()) {
            System.err.println("The Group List is empty. Cannot removeLast");
            return null;
        }
        GroupingNode finger = this.tail;
        while (finger.next() != this.tail) {
            finger = finger.next();
        }
        GroupingNode temp = this.tail;
        if (finger == this.tail) {
            this.tail = null;
        } else {
            finger.setNext(this.tail.next());
            this.tail = finger;
        }
        --this.count;
        return temp.value();
    }

    public boolean contains(GroupingList value) {
        GroupingNode finger;
        if (this.tail == null) {
            return false;
        }
        for (finger = this.tail.next(); finger != this.tail && !finger.value().equals(value); finger = finger.next()) {
        }
        return finger.value().equals(value);
    }

    public GroupingList remove(GroupingList value) {
        if (this.tail == null) {
            return null;
        }
        GroupingNode finger = this.tail.next();
        GroupingNode previous = this.tail;
        for (int compares = 0; compares < this.count && !finger.value().equals(value); ++compares) {
            previous = finger;
            finger = finger.next();
        }
        if (finger.value().equals(value)) {
            if (this.tail == this.tail.next()) {
                this.tail = null;
            } else {
                if (finger == this.tail) {
                    this.tail = previous;
                }
                previous.setNext(previous.next().next());
            }
            finger.setNext(null);
            --this.count;
            return finger.value();
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public GroupingList getAt(int i) {
        GroupingNode finger = this.tail.next();
        while (i > 0) {
            finger = finger.next();
            --i;
        }
        return finger.value();
    }

    public GroupingList next() {
        GroupingList gList = this.getAt(this.counter);
        ++this.counter;
        return gList;
    }

    public Object get(int i) {
        return this.getAt(i);
    }

    public GroupingList set(int i, GroupingList o) {
        if (i >= this.size()) {
            return null;
        }
        GroupingNode finger = this.tail.next();
        while (i > 0) {
            finger = finger.next();
            --i;
        }
        GroupingList result = finger.value();
        finger.setValue(o);
        return result;
    }

    public void add(int i, GroupingList o) {
        if (i >= 0 && i <= this.size()) {
            if (i == 0) {
                this.addFirst(o);
            } else if (i == this.size()) {
                this.addLast(o);
            } else {
                GroupingNode previous = this.tail;
                GroupingNode next = this.tail.next();
                while (i > 0) {
                    previous = next;
                    next = next.next();
                    --i;
                }
                GroupingNode current = new GroupingNode(o, next);
                ++this.count;
                previous.setNext(current);
            }
        } else {
            System.err.println("Index " + i + " is out of bound. Failed to add GroupingList object");
        }
    }

    public GroupingList removeAt(int i) {
        if (i >= 0 && i < this.size()) {
            if (i == 0) {
                return this.removeFirst();
            }
            if (i == this.size() - 1) {
                return this.removeLast();
            }
            GroupingNode previous = this.tail;
            GroupingNode finger = this.tail.next();
            while (i > 0) {
                --i;
                previous = finger;
                finger = finger.next();
            }
            previous.setNext(finger.next());
            --this.count;
            return finger.value();
        }
        System.err.println("Index " + i + " is out of bound. Failed to remove GroupingList object");
        return this.tail.next().value();
    }

    public Object remove(int i) {
        return this.removeAt(i);
    }

    public int indexOf(GroupingList value) {
        int i = 0;
        GroupingNode finger = this.tail.next();
        while (finger != null && !finger.value().equals(value)) {
            finger = finger == this.tail ? null : finger.next();
            ++i;
        }
        if (finger == null) {
            return -1;
        }
        return i;
    }

    public int lastIndexOf(GroupingList value) {
        int result = -1;
        int i = 0;
        GroupingNode finger = this.tail.next();
        while (finger != null) {
            if (finger.value().equals(value)) {
                result = i;
            }
            finger = finger == this.tail ? null : finger.next();
            ++i;
        }
        return result;
    }

    public Iterator iterator() {
        return null;
    }

    public boolean isEmpty() {
        return this.tail == null;
    }

    public void clear() {
        this.count = 0;
        this.tail = null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("<Groupings:");
        Iterator li = this.iterator();
        while (li.hasNext()) {
            s.append(" " + li.next());
        }
        s.append(">");
        return s.toString();
    }
}

