/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util.matchingservice;

import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class ExtensionFilter
extends FileFilter {
    private Vector extensions = new Vector();
    private String description = "";
    private boolean directoriesblocked = false;

    public ExtensionFilter() {
        this.extensions.add("match");
        this.setDescription("Matching Files (*.match)");
    }

    public ExtensionFilter(String ext) {
        if (ext == null) {
            throw new NullPointerException();
        }
        this.extensions.add(ext);
    }

    public boolean accept(File f) {
        boolean flag = false;
        String name = f.getName();
        if (f.isDirectory()) {
            flag = !this.directoriesblocked;
        } else {
            for (int i = 0; i < this.extensions.size(); ++i) {
                flag = flag || name.endsWith("." + (String)this.extensions.elementAt(i));
            }
        }
        if (f.isHidden()) {
            flag = false;
        }
        return flag;
    }

    public void setDirectoriesBlocked(boolean blocked) {
        this.directoriesblocked = blocked;
    }

    public boolean getDirectoriesBlocked() {
        return this.directoriesblocked;
    }

    public void addExtension(String ext) {
        if (ext == null) {
            throw new NullPointerException();
        }
        this.extensions.add(ext);
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        return (String[])this.extensions.toArray();
    }
}

