/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util;

import edu.caltech.ssel.multistage.server.interfaces.LoggingMonitor;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class guiAppender
extends AppenderSkeleton {
    private LoggingMonitor logMonitor;

    public guiAppender(LoggingMonitor logMonitor) {
        this.logMonitor = logMonitor;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    protected void append(LoggingEvent loggingEvent) {
        String logStr;
        Level p = loggingEvent.getLevel();
        String priority = p.toString();
        String thread = "[" + loggingEvent.getThreadName() + "]";
        String message = loggingEvent.getRenderedMessage();
        String className = "";
        if (this.logMonitor.isDisplayLocationInfo()) {
            LocationInfo locInfo = loggingEvent.getLocationInformation();
            className = locInfo.getClassName();
            String methodName = locInfo.getMethodName();
            String fileName = locInfo.getFileName();
            String truncFileName = fileName.substring(0, fileName.length() - 5);
            logStr = priority + ":  [" + truncFileName + "." + methodName + "]  :  " + message;
        } else {
            logStr = priority + " " + thread + ": " + message;
        }
        this.logMonitor.addLogMessage(logStr, (Priority)loggingEvent.getLevel(), className);
    }
}

