/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Binomial;
import edu.caltechUcla.sselCassel.variate.Normal;
import edu.caltechUcla.sselCassel.variate.Uniform2;
import edu.caltechUcla.sselCassel.variate.Variate;
import org.apache.log4j.Category;

public class VariateGenerator {
    private Variate variate;
    private String distName;
    public static final String DISTNAME = "uniform";
    public static final double MIN = 0.0;
    public static final double MAX = 10.0;
    private static Category log = Category.getInstance(VariateGenerator.class);

    public VariateGenerator() {
    }

    public VariateGenerator(String distName, double[] params) {
        this.initialize(distName, params);
    }

    public void initialize(String distname, double[] params) {
        long seed = System.currentTimeMillis();
        if (distname == null || params == null || params.length != 2) {
            this.distName = DISTNAME;
            try {
                this.variate = new Uniform2(0.0, 10.0, seed);
            }
            catch (BadParameterException e) {
                log.error((Object)("Failed to initialize default uniform random generator: " + (Object)((Object)e)));
            }
        } else {
            this.distName = distname;
            if (this.distName.equalsIgnoreCase("normal")) {
                try {
                    this.variate = new Normal(params[0], params[1], seed);
                    log.info((Object)("Normal distribution with mean: " + params[0] + " and sigma: " + params[1] + " is generated!"));
                }
                catch (BadParameterException e) {
                    log.error((Object)("Failed to initialize specified normal distribution, with mean:  " + params[0] + " sigma: " + params[1] + " : " + (Object)((Object)e)));
                }
            } else if (this.distName.equalsIgnoreCase(DISTNAME)) {
                try {
                    this.variate = new Uniform2(params[0], params[1], seed);
                    log.info((Object)("Uniform distribution with min: " + params[0] + " and max: " + params[1] + " is generated!"));
                }
                catch (BadParameterException e) {
                    log.error((Object)("Failed to initialize default uniform random generator, with min: " + params[0] + " and max: " + params[1] + (Object)((Object)e)));
                }
            } else if (this.distName.equalsIgnoreCase("binomial")) {
                try {
                    this.variate = new Binomial(params[0], params[1], seed);
                    log.info((Object)("Bonomial distribution with numOfTrails: " + params[0] + " and probForHead: " + params[1] + " is generated!"));
                }
                catch (BadParameterException e) {
                    log.error((Object)("Failed to initialize default binomial random generator, with numOfTrails: " + params[0] + " and probForHead: " + params[1] + (Object)((Object)e)));
                }
            } else {
                log.error((Object)("Failed to initiate random generator with distribution type: " + this.distName));
            }
        }
    }

    public double nextDoubleVariate() {
        if (this.variate != null) {
            return this.variate.gen();
        }
        return 0.0;
    }
}

