/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.util;

import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.Param;
import java.util.Vector;

public abstract class ParamVerifier {
    private int groupSize;
    private Vector params = new Vector();

    public void fillParams(int groupSize) {
        this.fillStandardParams();
        this.fillGameSpecificParams(groupSize);
    }

    private void fillStandardParams() {
        Param maxRounds = new Param("maxRounds", false);
        maxRounds.setLabel("Max Rounds");
        maxRounds.setInitialValue("10");
        this.addStandardParam(maxRounds);
        Param exchangeRate = new Param("exchangeRate", false);
        exchangeRate.setLabel("Exchange Rate");
        exchangeRate.setInitialValue("1.0");
        this.addStandardParam(exchangeRate);
        Param practice = new Param("practice", true);
        practice.setLabel("Practice Match");
        practice.setInitialValue("false");
        this.addStandardParam(practice);
        Param totalPayoff = new Param("showTotalPayoff", true);
        totalPayoff.setLabel("Show Total Payoff");
        totalPayoff.setInitialValue("true");
        this.addStandardParam(totalPayoff);
        Param matching = new Param("matching", true);
        matching.setLabel("Matching Algorithm");
        matching.setInitialValue("random");
        this.addStandardParam(matching);
        Param matchingFile = new Param("matchFile", false);
        matchingFile.setLabel("Matching File");
        this.addStandardParam(matchingFile);
        Param historyNumber = new Param("historyRounds", false);
        historyNumber.setLabel("History Rounds");
        this.addStandardParam(historyNumber);
        Param enableChat = new Param("enableChat", false);
        enableChat.setLabel("Enable Chat");
        enableChat.setInitialValue("false");
        this.addStandardParam(enableChat);
        Param chatIdentifier = new Param("chatIdentifier", false);
        chatIdentifier.setLabel("Chat Identifier");
        chatIdentifier.setInitialValue("Subject %client%");
        this.addStandardParam(chatIdentifier);
        Param preserve = new Param("preserve", false);
        preserve.setLabel("Preserve GUI");
        preserve.setInitialValue("false");
        this.addStandardParam(preserve);
        Param displayFinishedInfo = new Param("displayFinishedInfo", false);
        displayFinishedInfo.setLabel("Display Finished Info");
        displayFinishedInfo.setInitialValue("true");
        this.addStandardParam(displayFinishedInfo);
        Param optionChat = new Param("optionChat", false);
        optionChat.setLabel("Option Chatting");
        optionChat.setInitialValue("false");
        this.addStandardParam(optionChat);
        Param defaultView = new Param("defaultView", false);
        defaultView.setLabel("Default History View");
        defaultView.setInitialValue("tabbed");
        this.addStandardParam(defaultView);
        Param viewSwitchable = new Param("viewSwitchable");
        viewSwitchable.setLabel("History View Switchable");
        viewSwitchable.setInitialValue("false");
        this.addStandardParam(viewSwitchable);
        Param asyncReauthMode = new Param("asyncReauthMode");
        asyncReauthMode.setLabel("Asyn Reauth Mode");
        asyncReauthMode.setInitialValue("abort");
        this.addStandardParam(asyncReauthMode);
    }

    private void addStandardParam(Param prm) {
        prm.setGameSpecific(false);
        this.params.add(prm);
    }

    protected void addParam(Param prm) {
        prm.setGameSpecific(true);
        this.params.add(prm);
    }

    protected abstract void fillGameSpecificParams(int var1);

    public abstract boolean verifyGroupSize(int var1) throws InvalidParameterException;

    public Vector getParams() {
        return this.params;
    }

    protected boolean isInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean isFloat(String value) {
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean isBoolean(String value) {
        try {
            return value.equals("true") || value.equals("false");
        }
        catch (Exception e) {
            return false;
        }
    }
}

