/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.network.gameverifiers;

import edu.caltech.ssel.multistage.server.network.Verifier;
import edu.caltech.ssel.multistage.shared.data.Information;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

public class DatabaseIdVerifier
extends Verifier {
    PreparedStatement pstmt = null;
    String mediaDataDir;
    public Information information = new Information();

    public DatabaseIdVerifier() {
        this.loadProperties("auth-db.properties");
        Connection conn = null;
        try {
            Class.forName(this.getStringProperty("dbDriver"));
            conn = DriverManager.getConnection(this.getStringProperty("dbServer"), this.getStringProperty("dbLogin"), this.getStringProperty("dbPassword"));
            this.pstmt = conn.prepareStatement("select * from " + this.getStringProperty("dbName") + " where " + this.getStringProperty("dbLoginColumn") + "=?");
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not load SQL driver." + e));
            System.err.println(e);
        }
        catch (SQLException e) {
            log.error((Object)("Error opening database connection." + e));
        }
        this.mediaDataDir = this.getStringProperty("mediaDataDir");
    }

    public void printIDEmailList(String fileName) {
        Connection conn = null;
        ResultSet rsltSet = null;
        try {
            PrintWriter listFile = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            conn = DriverManager.getConnection(this.getStringProperty("dbServer"), this.getStringProperty("dbLogin"), this.getStringProperty("dbPassword"));
            this.pstmt = conn.prepareStatement("select * from " + this.getStringProperty("dbName"));
            if (this.pstmt != null) {
                rsltSet = this.pstmt.executeQuery();
                while (rsltSet.next()) {
                    int id = rsltSet.getInt("sub_id");
                    String email = rsltSet.getString(this.getStringProperty("dbLoginColumn"));
                    listFile.println("" + id + " " + email);
                }
                rsltSet.close();
            }
            listFile.close();
        }
        catch (SQLException e) {
            System.err.println("Error.");
            log.error((Object)("Failed to load the login from the database:" + e));
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Hashtable getIDEmailTable() {
        Connection conn = null;
        ResultSet rsltSet = null;
        Hashtable<Integer, String> table = new Hashtable<Integer, String>();
        try {
            conn = DriverManager.getConnection(this.getStringProperty("dbServer"), this.getStringProperty("dbLogin"), this.getStringProperty("dbPassword"));
            this.pstmt = conn.prepareStatement("select * from " + this.getStringProperty("dbName"));
            if (this.pstmt != null) {
                rsltSet = this.pstmt.executeQuery();
                while (rsltSet.next()) {
                    int id = rsltSet.getInt("sub_id");
                    String email = rsltSet.getString(this.getStringProperty("dbLoginColumn"));
                    table.put(new Integer(id), email);
                }
                rsltSet.close();
            }
        }
        catch (SQLException e) {
            System.err.println("Error.");
            log.error((Object)("Failed to load the login from the database:" + e));
            e.printStackTrace();
        }
        return table;
    }

    public boolean verify(String login) {
        ResultSet rsltSet = null;
        try {
            if (this.pstmt != null) {
                this.pstmt.setString(1, login);
                rsltSet = this.pstmt.executeQuery();
                if (rsltSet.next()) {
                    ResultSetMetaData md = rsltSet.getMetaData();
                    Information dbInfo = new Information();
                    for (int column = 1; column <= md.getColumnCount(); ++column) {
                        dbInfo.addInfo(md.getColumnName(column), rsltSet.getObject(column));
                    }
                    this.information.addInfo(login, dbInfo);
                    rsltSet.close();
                    return true;
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Error.");
            log.error((Object)("Failed to load the login from the database:" + e));
            e.printStackTrace();
        }
        return false;
    }
}

