/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.network;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Category;

public abstract class Verifier
extends ServerVariables
implements MSConstants {
    Properties props = ServerVariables.multistageProps;
    public static int INT_NOT_FOUND = -32000;
    public static float FLOAT_NOT_FOUND = -32000.0f;
    public static Category log = Category.getInstance(Verifier.class);

    public abstract boolean verify(String var1);

    protected float getFloatProperty(String prop) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return FLOAT_NOT_FOUND;
            }
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve float property " + prop + " in multistage server properties file" + newline + e));
            return FLOAT_NOT_FOUND;
        }
    }

    protected float getFloatProperty(String prop, float defaultFloat) {
        float value = this.getFloatProperty(prop);
        if (value == FLOAT_NOT_FOUND) {
            value = defaultFloat;
        }
        return value;
    }

    protected int getIntProperty(String prop) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return INT_NOT_FOUND;
            }
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve int property " + prop + " in multistage server properties file" + newline + e));
            return INT_NOT_FOUND;
        }
    }

    protected int getIntProperty(String prop, int defaultInt) {
        int value = this.getIntProperty(prop);
        if (value == INT_NOT_FOUND) {
            value = defaultInt;
        }
        return value;
    }

    protected boolean getBooleanProperty(String prop) {
        return this.getBooleanProperty(prop, false);
    }

    protected boolean getBooleanProperty(String prop, boolean defaultBool) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return defaultBool;
            }
            return Boolean.valueOf(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve boolean property " + prop + " in multistage server properties file" + newline + e));
            return defaultBool;
        }
    }

    protected String getStringProperty(String prop) {
        try {
            String val = this.props.getProperty(prop);
            if (val != null) {
                val = val.trim();
            }
            log.debug((Object)("Retrieved property " + prop + " = " + val));
            return val;
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve string property " + prop + " in multistage server properties file" + newline + e));
            return null;
        }
    }

    protected String getStringProperty(String prop, String defaultStr) {
        String value = this.getStringProperty(prop);
        if (value == null) {
            value = defaultStr;
        }
        return value;
    }

    protected void loadProperties(String fileStr) {
        try {
            URL multiConfig = ClassLoader.getSystemResource(fileStr);
            if (multiConfig != null) {
                Properties props = new Properties();
                props.load(multiConfig.openStream());
                this.props = props;
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to load a properties file from a system resource" + MSConstants.newline + e));
        }
    }

    protected void loadProperties(File propFile) {
        try {
            FileInputStream in = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(in);
            this.props = props;
        }
        catch (Exception e) {
            log.error((Object)("Failed to load a properties file directly from a File object" + MSConstants.newline + e));
        }
    }
}

