/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.network;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.interfaces.AuthStatusView;
import edu.caltech.ssel.multistage.server.network.ServerCommunicator;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.AuthorizationPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.util.Vector;
import org.apache.log4j.Category;

public abstract class ServerAuthenticator
implements MSConstants {
    protected int numClients;
    private int clientsSoFar;
    private int[] assignments;
    protected Vector clients;
    private int state;
    protected Vector clientData;
    private AuthStatusView authView;
    private static Category log = Category.getInstance(ServerAuthenticator.class);
    private static int AUTH_IN_PROCESS = 0;
    private static int AUTH_CANCELED = 1;
    private static int AUTH_SUCCESS = 2;

    public ServerAuthenticator(int numClients) {
        this.numClients = numClients;
        this.initServer();
    }

    public abstract void initServer();

    public abstract AuthorizationPacket receiveAuthRequestIfPossible();

    public abstract AuthorizationPacket receiveAuthRequest();

    public abstract void sendAuthMessage(String var1, AuthorizationPacket var2);

    public abstract void recycleAuthPacket(AuthorizationPacket var1);

    public abstract ServerCommunicator getCommunicator();

    public abstract boolean reauthenticate(int var1);

    public abstract void shutdown();

    public synchronized boolean getClients() {
        this.clients = new Vector();
        this.authView = new AuthStatusView(ServerVariables.ui, this.numClients, this);
        this.authView.setVisible(true);
        this.clientsSoFar = 0;
        try {
            while (true) {
                AuthorizationPacket auth_request;
                if ((auth_request = this.receiveAuthRequestIfPossible()) != null) {
                    if (auth_request.getType() == 0 && this.clientsSoFar < this.numClients) {
                        this.authorizeClient(auth_request);
                    } else {
                        this.recycleAuthPacket(auth_request);
                    }
                }
                if (this.state == AUTH_SUCCESS) {
                    this.rejectRemainingClients();
                    return true;
                }
                if (this.state == AUTH_CANCELED) {
                    this.rejectRemainingClients();
                    return false;
                }
                if (auth_request != null) continue;
                this.wait(500L);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to collect the client list in the mail authenticator", (Throwable)e);
            return false;
        }
    }

    private void rejectRemainingClients() {
        Runnable rejector = new Runnable(){

            public void run() {
                log.info((Object)"Authenticator is rejecting all new client connections");
                while (true) {
                    AuthorizationPacket auth_request;
                    if ((auth_request = ServerAuthenticator.this.receiveAuthRequest()) == null) continue;
                    if (auth_request.getType() == 6) break;
                    if (auth_request.getType() == 0) {
                        ServerAuthenticator.this.sendAuthMessage(auth_request.getName(), new AuthorizationPacket(auth_request.getName(), 5));
                        continue;
                    }
                    ServerAuthenticator.this.recycleAuthPacket(auth_request);
                }
                log.debug((Object)"Authenticator no longer rejecting new client conenctions -- shutting down rejection thread");
            }
        };
        Thread thr = new Thread(rejector);
        thr.start();
    }

    public void cancelAuthentication() {
        this.authView.destroy();
        this.state = AUTH_CANCELED;
    }

    private void authorizeClient(AuthorizationPacket auth_request) {
        try {
            int position = this.authView.addConnected(auth_request.getName());
            String name = auth_request.getName();
            if (position == -1) {
                log.error((Object)"Client not added - no more connections accepted");
                return;
            }
            log.debug((Object)("Received authentication request, creating ID " + position));
            if (ServerVariables.verifier != null) {
                try {
                    if (!ServerVariables.verifier.verify(name)) {
                        log.warn((Object)("Client " + name + " failed to pass verification test - setting to invalid"));
                        this.authView.setStatus(position, AuthStatusView.STATUS_INVALID);
                    } else {
                        log.debug((Object)("Client " + name + " passed authentication verification test"));
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Client " + name + " caused a verification system error - setting to invalid"));
                    this.authView.setStatus(position, AuthStatusView.STATUS_INVALID);
                }
            }
            ClientData client = new ClientData(position, name, true);
            log.debug((Object)("Created new ClientData object with name " + name + " and temporary position holder: " + client.getId()));
            this.clients.add(client);
            ++this.clientsSoFar;
            log.debug((Object)("There are now " + this.clientsSoFar + " clients. " + this.numClients + " clients are needed to begin"));
            this.authView.submitIfTesting();
        }
        catch (Exception e) {
            log.error((Object)("Authentication system fialure: Failed to authenticate client with name: " + auth_request.getName() + newline + e));
        }
    }

    public void confirmClients() {
        try {
            if (this.authView.checkDoneStatus(this.numClients)) {
                this.authView.destroy();
                for (int j = 0; j < this.clients.size(); ++j) {
                    ClientData client = (ClientData)this.clients.get(j);
                    client.setId(j);
                    this.sendAuthMessage(client.getName(), new AuthorizationPacket(client.getName(), 4, j));
                }
                this.clientData = this.clients;
                log.debug((Object)"Client list has been confirmed and validated");
                this.state = AUTH_SUCCESS;
                return;
            }
            log.debug((Object)"Client list has NOT been confirmed");
        }
        catch (Exception e) {
            log.error((Object)"Failed to confirm client list and send out authentication confirmations", (Throwable)e);
        }
    }

    public void dropClient(int dropID) {
        this.authView.setStatus(dropID, AuthStatusView.STATUS_DROPPED);
        boolean dropHolder = true;
        for (int i = 0; i < this.clients.size(); ++i) {
            ClientData client = (ClientData)this.clients.get(i);
            int position = client.getId();
            if (position != dropID) continue;
            this.clients.remove(i);
            --this.clientsSoFar;
            this.authView.setStatus(dropID, AuthStatusView.STATUS_WAITING);
            this.authView.setName(dropID, "Client " + dropID);
            dropHolder = false;
            log.debug((Object)("Dropping client with name " + client.getName() + " at position " + position));
            break;
        }
        log.debug((Object)"Finished dropping a client");
        if (dropHolder) {
            --this.numClients;
            this.authView.setNumClients(this.numClients);
        }
        log.debug((Object)("There are now " + this.clientsSoFar + " clients. " + this.numClients + " clients are needed to begin"));
    }

    public void close() {
        this.recycleAuthPacket(new AuthorizationPacket("none", 6));
        this.shutdown();
    }

    public Vector getClientData() {
        return this.clientData;
    }
}

