/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.network;

import edu.caltech.ssel.multistage.server.network.ServerCommunicator;
import edu.caltech.ssel.multistage.shared.network.GameMessage;
import edu.caltech.ssel.multistage.shared.network.GamePingPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.Message;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import edu.caltech.ssel.multistage.shared.network.PingPacket;
import edu.caltech.ssel.multistage.shared.network.Request;
import edu.caltech.ssel.multistage.shared.network.RequestPacket;
import edu.caltech.ssel.multistage.shared.network.Response;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.util.Hashtable;
import org.apache.log4j.Category;

public class MailServerCommunicator
implements ServerCommunicator,
MSConstants {
    private static Category log = Category.getInstance(MailServerCommunicator.class);
    private Hashtable pingInboxes;
    private Hashtable pingOutboxes;
    private Hashtable messageOutboxes;
    private Hashtable messageInboxes;
    private Hashtable chatOutboxes;
    private Hashtable chatInboxes;
    private Hashtable outboxes;
    private Hashtable inboxes;
    private int numPlayers;
    private PingPacket[] pingers;

    public MailServerCommunicator(int numPlayers, Hashtable outboxes, Hashtable inboxes, Hashtable pingInboxes, Hashtable pingOutboxes, Hashtable messageOutboxes, Hashtable messageInboxes, Hashtable chatOutboxes, Hashtable chatInboxes) {
        try {
            this.numPlayers = numPlayers;
            this.outboxes = outboxes;
            this.inboxes = inboxes;
            this.pingInboxes = pingInboxes;
            this.pingOutboxes = pingOutboxes;
            this.messageOutboxes = messageOutboxes;
            this.messageInboxes = messageInboxes;
            this.chatOutboxes = chatOutboxes;
            this.chatInboxes = chatInboxes;
            this.pingers = new PingPacket[numPlayers];
            this.getPingPackets();
        }
        catch (Exception e) {
            log.error((Object)("Failed to create the mail communicator for server with numPlayers: " + numPlayers), (Throwable)e);
        }
    }

    public void sendRequest(int client, Request req) {
        try {
            Mailbox serverOut = (Mailbox)this.outboxes.get(new Integer(client));
            serverOut.deposit(req);
            log.debug((Object)("Server has sent request to client id: " + client));
        }
        catch (ConnectException e) {
            log.warn((Object)("Server failed to establish an outgoing connection to client " + client + " using the main communication channel -- retrying"));
            this.sendRequest(client, req);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            this.sendRequest(client, req);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send request to client " + client + " using mail communicator with numPlayers: " + this.numPlayers + " and server->client hashmap: " + this.outboxes), (Throwable)e);
        }
    }

    public void sendMessage(int client, Message mes) {
        try {
            Mailbox serverOut = (Mailbox)this.messageOutboxes.get(new Integer(client));
            serverOut.deposit(mes);
            log.debug((Object)("Server has sent message to client id: " + client));
        }
        catch (ConnectException e) {
            log.warn((Object)("Server failed to establish an outgoing connection to client " + client + " using the message communication channel -- retrying"));
            this.sendMessage(client, mes);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            this.sendMessage(client, mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send message to client " + client + " using mail communicator with numPlayers: " + this.numPlayers));
        }
    }

    public RequestPacket getResponse(int client) {
        try {
            Mailbox serverIn = (Mailbox)this.inboxes.get(new Integer(client));
            Response res = (Response)serverIn.receive();
            log.debug((Object)("Server has received response from client " + client));
            return this.getRequestPacket(res);
        }
        catch (ConnectException e) {
            log.warn((Object)("Server failed to establish an incoming connection to client " + client + " using the main communication channel -- retrying"));
            return this.getResponse(client);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            return this.getResponse(client);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get response from client " + client + " using mail communicator"), (Throwable)e);
            return null;
        }
    }

    private RequestPacket getRequestPacket(Response res) {
        try {
            return res.getRequestPacket();
        }
        catch (ConnectException e) {
            log.warn((Object)"Server failed to retrieve data from response using the main communication channel due to network error -- retrying");
            return this.getRequestPacket(res);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            return this.getRequestPacket(res);
        }
        catch (Exception e) {
            log.error((Object)"Failed to retrieve data from response using the main communication channel", (Throwable)e);
            return null;
        }
    }

    public MessagePacket getMessage(int client) {
        try {
            Mailbox messageIn = (Mailbox)this.messageInboxes.get(new Integer(client));
            Message mes = (Message)messageIn.receive();
            log.debug((Object)("Server has received an instant message from client " + client));
            return this.getMessagePacket(mes);
        }
        catch (ConnectException e) {
            log.warn((Object)("Server failed to establish an incoming connection to client " + client + " using the message communication channel -- retrying"));
            return this.getMessage(client);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            return this.getMessage(client);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get an instant message from client " + client + " using mail communicator"), (Throwable)e);
            return null;
        }
    }

    private MessagePacket getMessagePacket(Message mes) {
        try {
            return mes.getMessagePacket();
        }
        catch (ConnectException e) {
            log.warn((Object)"Server failed to retrieve data from message using the message or chat communication channel due to network error -- retrying");
            return this.getMessagePacket(mes);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            return this.getMessagePacket(mes);
        }
        catch (Exception e) {
            log.error((Object)"Failed to retrieve data from message using the message or chat communication channel", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public void flushIncomingMessages(int client) {
        try {
            Mailbox messageIn = (Mailbox)this.messageInboxes.get(new Integer(client));
            for (int i = 0; i < messageIn.capacity(); ++i) {
                messageIn.receiveIfPossible();
            }
        }
        catch (ConnectException e) {
            log.warn((Object)("Server failed to establish an incoming connection to client " + client + " using the message communication channel -- retrying"));
            this.flushIncomingMessages(client);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            this.flushIncomingMessages(client);
        }
        catch (Exception e) {
            log.error((Object)("Failed to flush message inbox for client " + client + " using mail communicator"), (Throwable)e);
        }
    }

    public void sendInternalMessage(int client, MessagePacket mes) {
        try {
            Mailbox messageIn = (Mailbox)this.messageInboxes.get(new Integer(client));
            messageIn.deposit(new GameMessage(mes));
        }
        catch (Exception e) {
            log.error((Object)("Failed to send an internal message to the message inbox of client " + client), (Throwable)e);
        }
    }

    private void getPingPackets() {
        try {
            log.debug((Object)"Getting ping packets for server-side client connection verification system...");
            for (int i = 0; i < this.numPlayers; ++i) {
                Mailbox pingOut = (Mailbox)this.pingOutboxes.get(new Integer(i));
                Mailbox pingIn = (Mailbox)this.pingInboxes.get(new Integer(i));
                pingOut.deposit(new GamePingPacket(0));
                this.pingers[i] = (PingPacket)pingIn.receive();
            }
            log.info((Object)"Server-side client connection verification system initialized and running");
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize the client connection verification system", (Throwable)e);
        }
    }

    public synchronized void getPingPacket(int client) {
        try {
            int attempt = 0;
            Mailbox pingOut = (Mailbox)this.pingOutboxes.get(new Integer(client));
            Mailbox pingIn = (Mailbox)this.pingInboxes.get(new Integer(client));
            pingOut.deposit(new GamePingPacket(0));
            PingPacket received = null;
            while (attempt < 10 && (received = (PingPacket)pingIn.receiveIfPossible()) == null) {
                this.wait(500L);
            }
            if (received != null) {
                this.pingers[client] = received;
                log.info((Object)("Server has re-initialized the client verification system for client " + client));
            }
            if (received == null) {
                log.info((Object)("Server failed to re-initialize the client verification system for client " + client));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to re-initialize the client verification system for client " + client), (Throwable)e);
        }
    }

    public boolean checkConnection(int client) {
        try {
            if (this.pingers[client].getStatus() != 1) {
                throw new Exception();
            }
            return true;
        }
        catch (Exception e) {
            log.warn((Object)("Server failed to verify connection of client " + client + " - this client is now set to disconnected status"));
            this.pingers[client] = null;
            return false;
        }
    }

    public void sendChat(int client, Message mes) {
        try {
            Mailbox serverOut = (Mailbox)this.chatOutboxes.get(new Integer(client));
            serverOut.deposit(mes);
            log.debug((Object)("Server has sent chat message to client id: " + client));
        }
        catch (ConnectException e) {
            log.warn((Object)("Server failed to establish an outgoing connection to client " + client + " using the message communication channel -- retrying"));
            this.sendChat(client, mes);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            this.sendChat(client, mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send chat message to client " + client + " using mail communicator with numPlayers: " + this.numPlayers), (Throwable)e);
        }
    }

    public MessagePacket getChat(int client) {
        try {
            Mailbox chatIn = (Mailbox)this.chatInboxes.get(new Integer(client));
            Message mes = (Message)chatIn.receive();
            log.debug((Object)("Server has received a chat message from client " + client));
            return this.getMessagePacket(mes);
        }
        catch (ConnectException e) {
            log.warn((Object)("Server failed to establish an incoming connection to client " + client + " using the message communication channel -- retrying"));
            return this.getChat(client);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing connection using communication channel -- retrying");
            return this.getChat(client);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get a chat message from client " + client + " using mail communicator"), (Throwable)e);
            return null;
        }
    }

    public void sendInternalChat(int client, MessagePacket mes) {
        try {
            Mailbox chatIn = (Mailbox)this.chatInboxes.get(new Integer(client));
            chatIn.deposit(new GameMessage(mes));
        }
        catch (Exception e) {
            log.error((Object)("Failed to send an internal message to the message inbox of client " + client), (Throwable)e);
        }
    }

    public void sendInternalResponse(int client, Response res) {
        try {
            Mailbox in = (Mailbox)this.inboxes.get(new Integer(client));
            in.deposit(res);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send an internal message to the main inbox of client " + client), (Throwable)e);
        }
    }
}

