/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.network;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.interfaces.ReauthView;
import edu.caltech.ssel.multistage.server.network.MailServerCommunicator;
import edu.caltech.ssel.multistage.server.network.ServerAuthenticator;
import edu.caltech.ssel.multistage.server.network.ServerCommunicator;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.AuthorizationPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.QueuedMailbox;
import edu.caltech.ssel.multistage.shared.network.SimpleObjectRegistry;
import java.util.Hashtable;
import org.apache.log4j.Category;

public class MailServerAuthenticator
extends ServerAuthenticator
implements MSConstants {
    private SimpleObjectRegistry registry;
    private static Category log = Category.getInstance(MailServerAuthenticator.class);
    private Mailbox auth_out;
    private Mailbox auth_in;
    private Hashtable outboxMap;
    private Hashtable inboxMap;
    private Hashtable pingInMap;
    private Hashtable pingOutMap;
    private Hashtable messageOutMap;
    private Hashtable messageInMap;
    private Hashtable chatOutMap;
    private Hashtable chatInMap;
    private MailServerCommunicator com;

    public MailServerAuthenticator(int numClients) {
        super(numClients);
    }

    public void initServer() {
        try {
            this.registry = new SimpleObjectRegistry();
            this.auth_out = new QueuedMailbox(this.numClients * 2 + 100);
            this.auth_in = new QueuedMailbox(this.numClients * 2 + 100);
            this.registry.rebind("auth_inbox", this.auth_in);
            this.registry.rebind("auth_outbox", this.auth_out);
            this.inboxMap = new Hashtable();
            this.outboxMap = new Hashtable();
            this.pingInMap = new Hashtable();
            this.pingOutMap = new Hashtable();
            this.messageOutMap = new Hashtable();
            this.messageInMap = new Hashtable();
            this.chatOutMap = new Hashtable();
            this.chatInMap = new Hashtable();
            for (int i = 0; i < this.numClients; ++i) {
                QueuedMailbox outbox = new QueuedMailbox(30);
                QueuedMailbox inbox = new QueuedMailbox(30);
                QueuedMailbox pingIn = new QueuedMailbox(60);
                QueuedMailbox pingOut = new QueuedMailbox(60);
                QueuedMailbox messageOut = new QueuedMailbox(60);
                QueuedMailbox messageIn = new QueuedMailbox(60);
                QueuedMailbox chatOut = new QueuedMailbox(60);
                QueuedMailbox chatIn = new QueuedMailbox(60);
                this.outboxMap.put(new Integer(i), outbox);
                this.inboxMap.put(new Integer(i), inbox);
                this.pingInMap.put(new Integer(i), pingIn);
                this.pingOutMap.put(new Integer(i), pingOut);
                this.messageOutMap.put(new Integer(i), messageOut);
                this.messageInMap.put(new Integer(i), messageIn);
                this.chatOutMap.put(new Integer(i), chatOut);
                this.chatInMap.put(new Integer(i), chatIn);
                this.registry.rebind("inbox-" + i, inbox);
                this.registry.rebind("outbox-" + i, outbox);
                this.registry.rebind("pingIn-" + i, pingIn);
                this.registry.rebind("pingOut-" + i, pingOut);
                this.registry.rebind("messageOut-" + i, messageOut);
                this.registry.rebind("messageIn-" + i, messageIn);
                this.registry.rebind("chatOut-" + i, chatOut);
                this.registry.rebind("chatIn-" + i, chatIn);
            }
            log.info((Object)("Successfully binded authentication and communication mailboxes to the registry on port " + this.registry.port()));
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize the server for the mail authenticator", (Throwable)e);
        }
    }

    public AuthorizationPacket receiveAuthRequestIfPossible() {
        try {
            AuthorizationPacket auth_request = (AuthorizationPacket)this.auth_in.receiveIfPossible();
            return auth_request;
        }
        catch (Exception e) {
            log.error((Object)"Failed to receive an authentication request", (Throwable)e);
            return null;
        }
    }

    public AuthorizationPacket receiveAuthRequest() {
        try {
            AuthorizationPacket auth_request = (AuthorizationPacket)this.auth_in.receive();
            return auth_request;
        }
        catch (Exception e) {
            log.error((Object)"Failed to receive an authentication request", (Throwable)e);
            return null;
        }
    }

    public void sendAuthMessage(String name, AuthorizationPacket auth_packet) {
        try {
            if (this.auth_out.depositIfPossible(auth_packet)) {
                return;
            }
            Thread.sleep(300L);
            this.sendAuthMessage(name, auth_packet);
        }
        catch (Exception e) {
            log.error((Object)"Failed to send out an authentication confirmation message", (Throwable)e);
        }
    }

    public void recycleAuthPacket(AuthorizationPacket auth_request) {
        try {
            this.auth_in.depositIfPossible(auth_request);
        }
        catch (Exception e) {
            log.error((Object)"Failed to recycle an authentication packet", (Throwable)e);
        }
    }

    public ServerCommunicator getCommunicator() {
        this.com = new MailServerCommunicator(this.numClients, this.outboxMap, this.inboxMap, this.pingInMap, this.pingOutMap, this.messageOutMap, this.messageInMap, this.chatOutMap, this.chatInMap);
        log.debug((Object)("Created new server mail communicator for " + this.numClients + " clients"));
        return this.com;
    }

    public synchronized boolean reauthenticate(int client) {
        try {
            String clientName = ((ClientData)this.clients.get(client)).getName();
            Mailbox com_in = (Mailbox)this.inboxMap.get(new Integer(client));
            Mailbox ping_in = (Mailbox)this.pingInMap.get(new Integer(client));
            Mailbox message_in = (Mailbox)this.messageInMap.get(new Integer(client));
            Mailbox chat_in = (Mailbox)this.chatInMap.get(new Integer(client));
            this.flushBox(com_in);
            this.flushBox(ping_in);
            this.flushBox(message_in);
            this.flushBox(chat_in);
            QueuedMailbox com_out = new QueuedMailbox(3);
            QueuedMailbox ping_out = new QueuedMailbox(6);
            QueuedMailbox message_out = new QueuedMailbox(6);
            QueuedMailbox chat_out = new QueuedMailbox(6);
            this.outboxMap.remove(new Integer(client));
            this.pingOutMap.remove(new Integer(client));
            this.messageOutMap.remove(new Integer(client));
            this.chatOutMap.remove(new Integer(client));
            this.outboxMap.put(new Integer(client), com_out);
            this.pingOutMap.put(new Integer(client), ping_out);
            this.messageOutMap.put(new Integer(client), message_out);
            this.chatOutMap.put(new Integer(client), chat_out);
            this.registry.rebind("reauth_com_in", com_in);
            this.registry.rebind("reauth_com_out", com_out);
            this.registry.rebind("reauth_ping_in", ping_in);
            this.registry.rebind("reauth_ping_out", ping_out);
            this.registry.rebind("reauth_message_out", message_out);
            this.registry.rebind("reauth_message_in", message_in);
            this.registry.rebind("reauth_chat_out", chat_out);
            this.registry.rebind("reauth_chat_in", chat_in);
            boolean reconnected = false;
            ReauthView reauthView = new ReauthView(ServerVariables.ui, client, clientName, this.auth_in);
            while (true) {
                AuthorizationPacket authPacket;
                if ((authPacket = (AuthorizationPacket)this.auth_in.receive()).getType() == 1 && authPacket.getName().equals(clientName)) {
                    log.info((Object)("Reauthentication request received from client " + client + " with name " + clientName));
                    this.auth_out.deposit(new AuthorizationPacket(clientName, 2, client));
                    reauthView.setConnected();
                    reconnected = true;
                    continue;
                }
                if (authPacket.getType() == 3) {
                    if (reconnected) {
                        this.auth_out.deposit(new AuthorizationPacket(clientName, 7, client));
                    }
                    log.info((Object)("Reauthentication for client " + client + " with name " + clientName + " has been canceled"));
                    return false;
                }
                if (authPacket.getType() == 2) {
                    log.info((Object)("Server has confirmed the reauthentication request from client " + client + " with name " + clientName));
                    if (reconnected) {
                        this.auth_out.deposit(new AuthorizationPacket(clientName, 8, client));
                        this.com.getPingPacket(client);
                    }
                    return true;
                }
                this.auth_in.deposit(authPacket);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to reauthenticate client " + client), (Throwable)e);
            return false;
        }
    }

    private void flushBox(Mailbox box) throws Exception {
        for (int i = 0; i < box.capacity(); ++i) {
            box.receiveIfPossible();
        }
    }

    public void shutdown() {
        try {
            this.auth_out.close();
            this.auth_in.close();
            this.registry.close();
            log.debug((Object)"Registry has been closed in the MailAuthenticator");
        }
        catch (Exception e) {
            log.error((Object)"Failed to fully shut down mailbox resources and disconnect server", (Throwable)e);
        }
    }
}

