/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.data.Parameters;
import edu.caltech.ssel.multistage.server.interfaces.ClientHistoryFrame;
import edu.caltech.ssel.multistage.server.interfaces.GlobalHistoryView;
import edu.caltech.ssel.multistage.server.interfaces.LoggingMonitor;
import edu.caltech.ssel.multistage.server.interfaces.MessageSendView;
import edu.caltech.ssel.multistage.server.interfaces.ParamGUI;
import edu.caltech.ssel.multistage.server.interfaces.ParamView;
import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class ServerGUI
extends JFrame {
    private JPanel ClientMonitor;
    private JPanel ClientTitlePanel;
    private JLabel ClientLabel;
    private JPanel ClientBlankFiller;
    private JPanel ClientHolder;
    private JPanel ClientNamesPanel;
    private JLabel NameLabel;
    private JLabel StatusLabel;
    private JLabel ActionLabel;
    private JLabel Information;
    private JScrollPane ClientScroller;
    private JPanel ClientDataPanel;
    private JPanel BlankFiller;
    private JPanel LogActionSplitter;
    private JPanel SplitterBlankFiller;
    private JPanel ActionButtons;
    private JLabel CommandsLabel;
    private JButton NextRoundButton;
    private JButton OutputSetButton;
    private JButton AuthenticateButton;
    private JButton DisconnectButton;
    private JPanel BlankTableCell;
    private JButton MessageButton;
    private JPanel SplitterSecondFiller;
    private JButton SetPlayersButton;
    private JButton ReadParamsButton;
    private JButton StartGameButton;
    private JPanel InfoPane;
    private JLabel NumPlayersLabel;
    private JLabel ParamFileLabel;
    private JLabel OutputPathLabel;
    private JMenuBar MenuBar;
    private JMenu Options;
    private JMenuItem ExitMenuItem;
    private JCheckBoxMenuItem FilterNetMessagesBox;
    private JMenu SetupMenu;
    private JMenu LoggingMenu;
    private JMenuItem OutputMenuItem;
    private JMenuItem NumPlayersMenuItem;
    private JMenuItem PersistFileMenuItem;
    private JMenuItem ParamFileMenuItem;
    private JCheckBoxMenuItem FilterClientMessagesBox;
    private JMenuItem LogFileMenuItem;
    private JButton GlobalHistoryButton;
    private JMenu ActionMenu;
    private JMenuItem ForceOutputMenuItem;
    private JMenuItem ForceNextMenuItem;
    private JMenuItem ForceReauthMenuItem;
    private JMenuItem SendMessageMenuItem;
    private JMenuItem AuthMenuItem;
    private JMenuItem StartMenuItem;
    private JMenuItem DisconnectMenuItem;
    private JMenuItem ResetClientsMenuItem;
    private JMenuItem ShowHistoryMenuItem;
    private JCheckBoxMenuItem AutoRoundProceedBox;
    private JCheckBoxMenuItem AutoMatchProceedBox;
    private JCheckBoxMenuItem LocationInfoBox;
    private JMenuItem GameDelayMenuItem;
    private JMenuItem ParamVerifyMenuItem;
    private JLabel ClientMatchLabel;
    private JPanel ClientMatchPanel;
    private JMenuItem AbortMatchMenuItem;
    private JMenuItem AbortRoundMenuItem;
    private JCheckBoxMenuItem ParamVerificationBox;
    private JMenuItem ParamViewMenuItem;
    private int numPlayers;
    private Vector clients;
    private Mailbox guiInput;
    private Mailbox guiOutput;
    private LoggingMonitor logMonitor;
    private static Category log = Category.getInstance(ServerGUI.class);
    private Hashtable buttonToId;
    private Hashtable historyMap;
    private Hashtable historyButtonMap;
    File paramsFile;
    File outputFile;
    File persistenceFile;
    private int clientsNotReady;
    private int numFinished;
    private boolean authenticationDone;
    private boolean nextMatchReady;
    private GlobalHistoryView globalHistory;
    private Timer timer;
    private boolean asyncMode;

    public ServerGUI() {
    }

    public ServerGUI(Mailbox guiInput, Mailbox guiOutput) {
        this.guiInput = guiInput;
        this.guiOutput = guiOutput;
        this.timer = new Timer();
        this.numPlayers = 0;
        this.setSize(1100, 800);
        this.initComponents();
        this.centerOnScreen();
        this.setVisible(true);
    }

    private void initComponents() {
        this.setTitle("Multistage Server Controller");
        this.ClientMonitor = new JPanel();
        this.ClientTitlePanel = new JPanel();
        this.ClientLabel = new JLabel();
        this.ClientBlankFiller = new JPanel();
        this.ClientHolder = new JPanel();
        this.ClientNamesPanel = new JPanel();
        this.NameLabel = new JLabel();
        this.StatusLabel = new JLabel();
        this.ActionLabel = new JLabel();
        this.Information = new JLabel();
        this.ClientScroller = new JScrollPane();
        this.ClientDataPanel = new JPanel();
        this.BlankFiller = new JPanel();
        this.LogActionSplitter = new JPanel();
        this.SplitterBlankFiller = new JPanel();
        this.ActionButtons = new JPanel();
        this.CommandsLabel = new JLabel();
        this.NextRoundButton = new JButton();
        this.OutputSetButton = new JButton();
        this.AuthenticateButton = new JButton();
        this.DisconnectButton = new JButton();
        this.MessageButton = new JButton();
        this.BlankTableCell = new JPanel();
        this.SplitterSecondFiller = new JPanel();
        this.SetPlayersButton = new JButton();
        this.ReadParamsButton = new JButton();
        this.StartGameButton = new JButton();
        this.InfoPane = new JPanel();
        this.ParamFileLabel = new JLabel();
        this.NumPlayersLabel = new JLabel();
        this.OutputPathLabel = new JLabel();
        this.GlobalHistoryButton = new JButton();
        this.MenuBar = new JMenuBar();
        this.Options = new JMenu();
        this.SetupMenu = new JMenu();
        this.ActionMenu = new JMenu();
        this.LoggingMenu = new JMenu();
        this.ExitMenuItem = new JMenuItem();
        this.FilterNetMessagesBox = new JCheckBoxMenuItem();
        this.OutputMenuItem = new JMenuItem();
        this.NumPlayersMenuItem = new JMenuItem();
        this.PersistFileMenuItem = new JMenuItem();
        this.ParamFileMenuItem = new JMenuItem();
        this.FilterClientMessagesBox = new JCheckBoxMenuItem();
        this.LogFileMenuItem = new JMenuItem();
        this.ForceOutputMenuItem = new JMenuItem();
        this.ForceNextMenuItem = new JMenuItem();
        this.ForceReauthMenuItem = new JMenuItem();
        this.SendMessageMenuItem = new JMenuItem();
        this.AuthMenuItem = new JMenuItem();
        this.StartMenuItem = new JMenuItem();
        this.DisconnectMenuItem = new JMenuItem();
        this.ShowHistoryMenuItem = new JMenuItem();
        this.AutoRoundProceedBox = new JCheckBoxMenuItem();
        this.AutoMatchProceedBox = new JCheckBoxMenuItem();
        this.LocationInfoBox = new JCheckBoxMenuItem();
        this.GameDelayMenuItem = new JMenuItem();
        this.ParamVerifyMenuItem = new JMenuItem();
        this.AbortRoundMenuItem = new JMenuItem();
        this.AbortMatchMenuItem = new JMenuItem();
        this.ParamVerificationBox = new JCheckBoxMenuItem();
        this.ParamViewMenuItem = new JMenuItem();
        this.ResetClientsMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ServerGUI.this.exitForm(evt);
            }
        });
        this.Options.setText("File");
        this.ParamViewMenuItem.setText("Open Parameter Verifier");
        this.ParamViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.showParamViewer();
            }
        });
        this.Options.add(this.ParamViewMenuItem);
        this.ParamVerifyMenuItem.setText("Open Parameter Generator");
        this.ParamVerifyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.showParamGUI(null);
            }
        });
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.ExitMenuItemAction(evt);
            }
        });
        this.Options.add(this.ExitMenuItem);
        this.SetupMenu.setText("Setup");
        this.AutoRoundProceedBox.setText("Auto Advance Rounds");
        this.SetupMenu.add(this.AutoRoundProceedBox);
        this.AutoMatchProceedBox.setText("Auto Advance Matches");
        this.SetupMenu.add(this.AutoMatchProceedBox);
        this.ParamVerificationBox.setText("Enable Parameter Verification");
        this.ParamVerificationBox.setSelected(true);
        this.SetupMenu.add(this.ParamVerificationBox);
        this.GameDelayMenuItem.setText("Set Auto Advance Delay");
        this.GameDelayMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.GameDelayMenuItemAction(evt);
            }
        });
        this.SetupMenu.add(this.GameDelayMenuItem);
        this.NumPlayersMenuItem.setText("Set Number of Players");
        this.NumPlayersMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.SetPlayersButtonAction(evt);
            }
        });
        this.SetupMenu.add(this.NumPlayersMenuItem);
        this.ParamFileMenuItem.setText("Load Parameter File");
        this.ParamFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.ReadParamsButtonAction(evt);
            }
        });
        this.SetupMenu.add(this.ParamFileMenuItem);
        this.OutputMenuItem.setText("Set Output File");
        this.OutputMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.SetOutputAction(evt);
            }
        });
        this.SetupMenu.add(this.OutputMenuItem);
        this.PersistFileMenuItem.setText("Set Persistence File");
        this.PersistFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.SetPersistenceFileAction(evt);
            }
        });
        this.SetupMenu.add(this.PersistFileMenuItem);
        this.ActionMenu.setText("Actions");
        this.AuthMenuItem.setText("Authenticate Clients");
        this.AuthMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.AuthenticateButtonAction(evt);
            }
        });
        this.ActionMenu.add(this.AuthMenuItem);
        this.StartMenuItem.setText("Start Game");
        this.StartMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.StartGameButtonAction(evt);
            }
        });
        this.StartMenuItem.setEnabled(false);
        this.ActionMenu.add(this.StartMenuItem);
        this.SendMessageMenuItem.setText("Send Message");
        this.SendMessageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.MessageButtonAction(evt);
            }
        });
        this.SendMessageMenuItem.setEnabled(false);
        this.ActionMenu.add(this.SendMessageMenuItem);
        this.ShowHistoryMenuItem.setText("Display History");
        this.ShowHistoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.GlobalHistoryAction(evt);
            }
        });
        this.ShowHistoryMenuItem.setEnabled(false);
        this.ActionMenu.add(this.ShowHistoryMenuItem);
        this.AbortRoundMenuItem.setText("Abort Round");
        this.AbortRoundMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.AbortRoundAction(evt);
            }
        });
        this.AbortRoundMenuItem.setEnabled(false);
        this.ActionMenu.add(this.AbortRoundMenuItem);
        this.AbortMatchMenuItem.setText("Abort Match");
        this.AbortMatchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.AbortMatchAction(evt);
            }
        });
        this.AbortMatchMenuItem.setEnabled(false);
        this.ActionMenu.add(this.AbortMatchMenuItem);
        this.ForceOutputMenuItem.setText("Force Output");
        this.ForceOutputMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.ForceOutput(evt);
            }
        });
        this.ForceOutputMenuItem.setEnabled(false);
        this.ActionMenu.add(this.ForceOutputMenuItem);
        this.ForceNextMenuItem.setText("Force Next Round");
        this.ForceNextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.ForceNextGameAction(evt);
            }
        });
        this.ForceNextMenuItem.setEnabled(false);
        this.ActionMenu.add(this.ForceNextMenuItem);
        this.ForceReauthMenuItem.setText("Force Reauthentication");
        this.ForceReauthMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.ForceReauthAction(evt);
            }
        });
        this.ForceReauthMenuItem.setEnabled(false);
        this.ActionMenu.add(this.ForceReauthMenuItem);
        this.ResetClientsMenuItem.setText("Reset Clients");
        this.ResetClientsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.ResetClientsAction(evt);
            }
        });
        this.ResetClientsMenuItem.setEnabled(false);
        this.ActionMenu.add(this.ResetClientsMenuItem);
        this.DisconnectMenuItem.setText("Disconnect Server");
        this.DisconnectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.DisconnectButtonAction(evt);
            }
        });
        this.DisconnectMenuItem.setEnabled(false);
        this.ActionMenu.add(this.DisconnectMenuItem);
        this.LoggingMenu.setText("Logging");
        this.LocationInfoBox.setText("Show Location Info");
        this.LocationInfoBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.LocationInfoAction(evt);
            }
        });
        this.LoggingMenu.add(this.LocationInfoBox);
        this.FilterNetMessagesBox.setText("Filter Network Messages");
        this.FilterNetMessagesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ServerGUI.this.FilterNetMessagesBox.isSelected()) {
                    ServerGUI.this.logMonitor.setDisplayNetworkLog(false);
                } else {
                    ServerGUI.this.logMonitor.setDisplayNetworkLog(true);
                }
            }
        });
        this.LoggingMenu.add(this.FilterNetMessagesBox);
        this.FilterNetMessagesBox.setEnabled(false);
        this.FilterClientMessagesBox.setText("Filter Client Messages");
        this.FilterClientMessagesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ServerGUI.this.FilterClientMessagesBox.isSelected()) {
                    ServerGUI.this.logMonitor.setDisplayClientLog(false);
                } else {
                    ServerGUI.this.logMonitor.setDisplayClientLog(true);
                }
            }
        });
        this.LoggingMenu.add(this.FilterClientMessagesBox);
        this.FilterClientMessagesBox.setEnabled(false);
        this.LogFileMenuItem.setText("Log to File");
        this.LoggingMenu.add(this.LogFileMenuItem);
        this.MenuBar.add(this.Options);
        this.MenuBar.add(this.SetupMenu);
        this.MenuBar.add(this.ActionMenu);
        this.MenuBar.add(this.LoggingMenu);
        this.setJMenuBar(this.MenuBar);
        this.ClientMonitor.setLayout(new BoxLayout(this.ClientMonitor, 1));
        this.ClientMonitor.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.ClientTitlePanel.setLayout(new BoxLayout(this.ClientTitlePanel, 0));
        this.ClientLabel.setText("Client Monitor");
        this.ClientLabel.setForeground(new Color(0, 51, 51));
        this.ClientLabel.setFont(new Font("Lucida Console", 0, 18));
        this.ClientTitlePanel.add(this.ClientLabel);
        this.ClientMonitor.add(this.ClientTitlePanel);
        this.ClientMatchPanel = new JPanel();
        this.ClientMatchPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        this.ClientMatchLabel = new JLabel();
        this.ClientMatchLabel.setText("No Experiment Running");
        this.ClientMatchLabel.setFont(new Font("Book Antiqua", 1, 16));
        this.ClientMatchLabel.setForeground(new Color(40, 40, 200));
        this.ClientMatchLabel.setHorizontalAlignment(0);
        this.ClientMatchPanel.add(this.ClientMatchLabel);
        this.ClientMonitor.add(this.ClientMatchPanel);
        this.ClientHolder.setLayout(new BoxLayout(this.ClientHolder, 1));
        this.ClientHolder.setPreferredSize(new Dimension(Short.MAX_VALUE, 5000));
        this.ClientNamesPanel.setLayout(new GridLayout(1, 6, 0, 5));
        this.NameLabel.setVerticalAlignment(1);
        this.NameLabel.setText("Name ");
        this.NameLabel.setForeground(Color.black);
        this.NameLabel.setHorizontalAlignment(0);
        this.NameLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.ClientNamesPanel.add(this.NameLabel);
        this.StatusLabel.setVerticalAlignment(1);
        this.StatusLabel.setText("Status    ");
        this.StatusLabel.setForeground(Color.black);
        this.StatusLabel.setHorizontalAlignment(0);
        this.StatusLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.ClientNamesPanel.add(this.StatusLabel);
        this.ActionLabel.setVerticalAlignment(1);
        this.ActionLabel.setText("Actions       ");
        this.ActionLabel.setForeground(Color.black);
        this.ActionLabel.setHorizontalAlignment(0);
        this.ActionLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.ClientNamesPanel.add(this.ActionLabel);
        this.Information.setVerticalAlignment(1);
        this.Information.setText("Information       ");
        this.Information.setForeground(Color.black);
        this.Information.setHorizontalAlignment(0);
        this.Information.setFont(new Font("Book Antiqua", 1, 14));
        this.ClientNamesPanel.add(this.Information);
        this.ClientHolder.add(this.ClientNamesPanel);
        this.ClientScroller.setVerticalScrollBarPolicy(22);
        this.ClientScroller.setHorizontalScrollBarPolicy(31);
        this.ClientScroller.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.ClientDataPanel.setBackground(Color.white);
        this.ClientScroller.setViewportView(this.ClientDataPanel);
        this.ClientHolder.add(this.ClientScroller);
        this.ClientMonitor.add(this.ClientHolder);
        this.getContentPane().add(this.ClientMonitor);
        this.LogActionSplitter.setLayout(new BoxLayout(this.LogActionSplitter, 0));
        this.logMonitor = new LoggingMonitor();
        this.LogActionSplitter.add(this.logMonitor);
        this.SplitterBlankFiller.setPreferredSize(new Dimension(3000, 10));
        this.LogActionSplitter.add(this.SplitterBlankFiller);
        this.ActionButtons.setLayout(new GridLayout(11, 0));
        this.ActionButtons.setPreferredSize(new Dimension(1200, 135));
        this.CommandsLabel.setVerticalAlignment(1);
        this.CommandsLabel.setText("Commands");
        this.CommandsLabel.setForeground(new Color(0, 51, 51));
        this.CommandsLabel.setHorizontalAlignment(0);
        this.CommandsLabel.setFont(new Font("Lucida Console", 0, 18));
        this.CommandsLabel.setHorizontalTextPosition(0);
        this.ActionButtons.add(this.CommandsLabel);
        this.StartGameButton.setText("Start Game");
        this.StartGameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.StartGameButtonAction(evt);
            }
        });
        this.StartGameButton.setEnabled(false);
        this.ActionButtons.add(this.StartGameButton);
        this.NextRoundButton.setText("Next Round");
        this.NextRoundButton.setEnabled(false);
        this.NextRoundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.NextRoundButtonAction(evt);
            }
        });
        this.ActionButtons.add(this.NextRoundButton);
        this.MessageButton.setText("Send Message");
        this.MessageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.MessageButtonAction(evt);
            }
        });
        this.MessageButton.setEnabled(false);
        this.ActionButtons.add(this.MessageButton);
        this.GlobalHistoryButton.setText("Display History");
        this.GlobalHistoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.GlobalHistoryAction(evt);
            }
        });
        this.GlobalHistoryButton.setEnabled(false);
        this.ActionButtons.add(this.GlobalHistoryButton);
        this.OutputSetButton.setText("Set Output File");
        this.OutputSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.SetOutputAction(evt);
            }
        });
        this.ActionButtons.add(this.OutputSetButton);
        this.ReadParamsButton.setText("Load Parameters File");
        this.ReadParamsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.ReadParamsButtonAction(evt);
            }
        });
        this.ActionButtons.add(this.ReadParamsButton);
        this.SetPlayersButton.setText("Set Number of Players");
        this.SetPlayersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.SetPlayersButtonAction(evt);
            }
        });
        this.ActionButtons.add(this.SetPlayersButton);
        this.AuthenticateButton.setText("Authenticate Clients");
        this.AuthenticateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.AuthenticateButtonAction(evt);
            }
        });
        this.ActionButtons.add(this.AuthenticateButton);
        this.DisconnectButton.setText("Disconnect Server");
        this.DisconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerGUI.this.DisconnectButtonAction(evt);
            }
        });
        this.DisconnectButton.setEnabled(false);
        this.ActionButtons.add(this.DisconnectButton);
        this.ActionButtons.add(this.BlankTableCell);
        this.LogActionSplitter.add(this.ActionButtons);
        this.SplitterSecondFiller.setPreferredSize(new Dimension(3000, 10));
        this.LogActionSplitter.add(this.SplitterSecondFiller);
        this.getContentPane().add(this.LogActionSplitter);
        this.InfoPane.setLayout(new GridLayout(1, 3));
        this.NumPlayersLabel.setText("Number of Players: " + this.numPlayers);
        this.NumPlayersLabel.setForeground(Color.black);
        this.NumPlayersLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.NumPlayersLabel.setHorizontalAlignment(0);
        this.InfoPane.add(this.NumPlayersLabel);
        this.ParamFileLabel.setText("Parameters File: None Selected");
        this.ParamFileLabel.setForeground(Color.black);
        this.ParamFileLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.ParamFileLabel.setHorizontalAlignment(0);
        this.InfoPane.add(this.ParamFileLabel);
        this.OutputPathLabel.setText("Output File: None Selected");
        this.OutputPathLabel.setForeground(Color.black);
        this.OutputPathLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.OutputPathLabel.setHorizontalAlignment(0);
        this.InfoPane.add(this.OutputPathLabel);
        this.getContentPane().add(this.InfoPane);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void StartGameButtonAction(ActionEvent evt) {
        try {
            if (this.paramsFile == null) {
                JOptionPane.showMessageDialog(null, "Please load a parameter file before starting the game", "Start Game Error", 0);
            } else if (this.outputFile == null) {
                JOptionPane.showMessageDialog(null, "Please select an output file before starting the game", "Start Game Error", 0);
            } else if (!this.authenticationDone) {
                JOptionPane.showMessageDialog(null, "Please wait for authentication to finish before starting the game", "Start Game Error", 0);
            } else if (ServerVariables.groupLCM == 0) {
                JOptionPane.showMessageDialog(null, "Server has not finished initializing - try again in five seconds");
            } else if (ServerVariables.clients.size() % ServerVariables.groupLCM != 0) {
                JOptionPane.showMessageDialog(null, "The current parameter file requires that the number of players is divisible by " + ServerVariables.groupLCM, "Start Game Error", 0);
            } else {
                log.debug((Object)"Start Game activated by user");
                this.guiOutput.deposit("start");
                this.MessageButton.setEnabled(true);
                this.SendMessageMenuItem.setEnabled(true);
                this.ReadParamsButton.setEnabled(false);
                this.StartGameButton.setEnabled(false);
                this.StartMenuItem.setEnabled(false);
                this.OutputSetButton.setEnabled(false);
                this.OutputMenuItem.setEnabled(false);
                this.ParamFileMenuItem.setEnabled(false);
                this.PersistFileMenuItem.setEnabled(false);
                this.NumPlayersMenuItem.setEnabled(false);
                this.GlobalHistoryButton.setEnabled(true);
                this.ShowHistoryMenuItem.setEnabled(true);
                this.ForceNextMenuItem.setEnabled(true);
                this.ForceOutputMenuItem.setEnabled(true);
                this.AbortMatchMenuItem.setEnabled(true);
                this.AbortRoundMenuItem.setEnabled(true);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to start the game" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void ForceReauthAction(ActionEvent evt) {
        if (0 == JOptionPane.showConfirmDialog(null, "Forcing the enabling of all reauthentication buttons may cause the server to become unstable.  Continue?", "Force Reauthentication Confirmation", 0)) {
            for (int i = 0; i < this.clients.size(); ++i) {
                Vector panel = (Vector)this.buttonToId.get(new Integer(i));
                JButton reauthButton = (JButton)panel.get(3);
                reauthButton.setEnabled(true);
            }
            log.info((Object)"All reauthentication buttons enabled");
        }
    }

    private void ForceOutput(ActionEvent evt) {
        try {
            if (0 == JOptionPane.showConfirmDialog(null, "<html>Write an incomplete output file?<br>(Future output writings will overwrite this one)</html>", "Force Output Confirmation", 0)) {
                log.info((Object)"Forcing activation of output writing");
                this.guiOutput.deposit("force_output");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to force output" + MSConstants.newline + e));
        }
    }

    private void AbortRoundAction(ActionEvent evt) {
        try {
            if (0 == JOptionPane.showConfirmDialog(null, "Abort the current round?", "Confirm Abort", 0)) {
                log.info((Object)"Manually aborting the current round");
                this.guiOutput.deposit("abort_round");
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to abort the current round", (Throwable)e);
        }
    }

    private void AbortMatchAction(ActionEvent evt) {
        block4: {
            try {
                Object[] abortValues = new Object[]{"Immediately", "After Current Round", "Cancel Abortion"};
                int selectedValue = JOptionPane.showOptionDialog(null, "When would like to abort the match?", "Select Abort Type", 1, 1, null, abortValues, abortValues[2]);
                if (selectedValue == 0) {
                    log.info((Object)"Manually aborting the current round and match (immediately)");
                    this.guiOutput.deposit("abort_match");
                    this.guiOutput.deposit("abort_round");
                    break block4;
                }
                if (selectedValue == 1) {
                    log.info((Object)"Manually aborting this match after the current round is completed");
                    this.guiOutput.deposit("abort_match");
                    break block4;
                }
                return;
            }
            catch (Exception e) {
                log.error((Object)"Failed to abort the current match", (Throwable)e);
            }
        }
    }

    private void ForceNextGameAction(ActionEvent evt) {
        if (0 == JOptionPane.showConfirmDialog(null, "Forcing the next game may cause the server to become unstable.  Continue?", "Force Next Confirmation", 0)) {
            this.NextRoundButtonAction(evt);
        }
    }

    private void NextRoundButtonAction(ActionEvent evt) {
        this.NextRoundButton.setEnabled(false);
        this.NextRoundMatch();
    }

    public void activateAsyncMode() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.asyncMode = true;
                ServerGUI.this.NextRoundButton.setEnabled(true);
                ServerGUI.this.NextRoundButton.setText("End Round Early");
                ServerGUI.this.NextRoundButton.setForeground(Color.red);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void deactivateAsyncMode() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.asyncMode = false;
                ServerGUI.this.NextRoundButton.setEnabled(false);
                ServerGUI.this.NextRoundButton.setText("Next Round");
                ServerGUI.this.NextRoundButton.setForeground(Color.black);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void updateTimeLeft(int match, int round, long time) {
        final int m = match;
        final int r = round;
        final long t = time;
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (t >= 0L) {
                    ServerGUI.this.ClientMatchLabel.setText("Match: " + m + ", Round: " + r + ", Time Remaining: " + t);
                } else {
                    ServerGUI.this.ClientMatchLabel.setText("Match: " + m + ", Round: " + r + ", No Time Limit");
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private synchronized void NextRoundMatch() {
        try {
            TimerTask task = new TimerTask(){

                public void run() {
                    Runnable doUpdate = new Runnable(){

                        public void run() {
                            try {
                                if (ServerGUI.this.nextMatchReady) {
                                    ServerGUI.this.nextMatchReady = false;
                                    ServerGUI.this.NextRoundButton.setText("Next Round");
                                    ServerGUI.this.NextRoundButton.setForeground(Color.black);
                                    ServerGUI.this.guiOutput.deposit("nextmatch");
                                } else if (ServerGUI.this.asyncMode) {
                                    Enumeration en = ServerVariables.serverMap.elements();
                                    while (en.hasMoreElements()) {
                                        ServerControl scon = (ServerControl)en.nextElement();
                                        scon.terminateAsyncEarly();
                                    }
                                } else {
                                    ServerGUI.this.guiOutput.deposit("nextgame");
                                }
                                ServerGUI.this.NextRoundButton.setEnabled(false);
                                ServerGUI.this.AutoRoundProceedBox.setEnabled(true);
                                ServerGUI.this.AutoMatchProceedBox.setEnabled(true);
                            }
                            catch (Exception e) {
                                log.error((Object)("Failed to send a nextgame message in scheduled timer task" + MSConstants.newline + e));
                            }
                        }
                    };
                    SwingUtilities.invokeLater(doUpdate);
                }
            };
            long delay = 0L;
            if (this.nextMatchReady && this.AutoMatchProceedBox.isSelected() || !this.nextMatchReady && this.AutoRoundProceedBox.isSelected()) {
                delay = ServerVariables.gameDelay;
            }
            this.timer.schedule(task, delay);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send nextgame message to ServerAdmin" + MSConstants.newline + e));
        }
    }

    private void MessageButtonAction(ActionEvent evt) {
        MessageSendView messageView = new MessageSendView(this, -1);
        messageView.setVisible(true);
        log.info((Object)"Opening messaging interface");
    }

    private void GlobalHistoryAction(ActionEvent evt) {
        if (this.globalHistory == null || !this.globalHistory.isVisible()) {
            this.globalHistory = new GlobalHistoryView(this);
        }
        log.debug((Object)"Opened the global history window");
    }

    public void updateDisplays() {
        try {
            this.guiOutput.deposit("move update");
            this.updateHistories();
        }
        catch (Exception e) {
            log.error((Object)("Failed to update history windows and send the partner move update alert to the ServerAdmin" + MSConstants.newline + e));
        }
    }

    private void updateHistories() {
        for (ClientHistoryFrame historyFrame : this.historyMap.values()) {
            JToggleButton sourceButton = (JToggleButton)this.historyButtonMap.get(historyFrame);
            int id = (Integer)this.buttonToId.get(sourceButton);
            ClientData cData = (ClientData)this.clients.get(id);
            historyFrame.update(cData);
        }
        if (this.globalHistory != null && this.globalHistory.isVisible()) {
            this.globalHistory.formAllData();
        }
    }

    private void SetPersistenceFileAction(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Create or Load Persistence File");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            this.persistenceFile = chooser.getSelectedFile();
            this.guiOutput.deposit("persistence file");
            this.guiOutput.deposit(this.persistenceFile);
        }
        catch (Exception e) {
            log.error((Object)("Failed to select a valid persistence file and send it to the ServerAdmin" + MSConstants.newline + e));
        }
    }

    private void SetOutputAction(ActionEvent evt) {
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    String path = ServerVariables.multistageProps.getProperty("output_home");
                    JFileChooser chooser = path != null && path.length() > 0 ? new JFileChooser(path) : new JFileChooser("../");
                    chooser.setDialogTitle("Create or Load Output File");
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        ServerGUI.this.outputFile = chooser.getSelectedFile();
                        if (ServerGUI.this.outputFile.exists()) {
                            ServerGUI.this.outputFile = new File(ServerGUI.this.outputFile.getPath() + ("_" + new Date()).replaceAll(" ", "_").replaceAll(":", "."));
                        }
                    } else {
                        return;
                    }
                    ServerGUI.this.guiOutput.deposit("output file");
                    ServerGUI.this.guiOutput.deposit(ServerGUI.this.outputFile);
                    Runnable doUpdate = new Runnable(){

                        public void run() {
                            ServerGUI.this.OutputPathLabel.setText("Output File: " + ServerGUI.this.outputFile.getName());
                        }
                    };
                    SwingUtilities.invokeLater(doUpdate);
                    log.info((Object)("Output file path " + ServerGUI.this.outputFile.getName() + " has been received"));
                }
                catch (Exception e) {
                    log.error((Object)("Failed to select a valid output file and send it to the ServerAdmin" + MSConstants.newline + e));
                }
            }
        };
        SwingUtilities.invokeLater(worker);
    }

    private void ReadParamsButtonAction(ActionEvent evt) {
        final ServerGUI sg = this;
        Runnable worker = new Runnable(){

            public void run() {
                String path = ServerVariables.multistageProps.getProperty("parameters_home");
                JFileChooser chooser = path != null && path.length() > 0 ? new JFileChooser(path) : new JFileChooser("../");
                chooser.setDialogTitle("Load Parameters File");
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                ServerGUI.this.paramsFile = chooser.getSelectedFile();
                if (ServerGUI.this.paramsFile == null) {
                    return;
                }
                log.info((Object)("Parsing parameter file " + ServerGUI.this.paramsFile.getName() + " at " + ServerGUI.this.paramsFile.getPath()));
                try {
                    Parameters params = null;
                    if (ServerGUI.this.ParamVerificationBox.isSelected()) {
                        try {
                            ParamView pView = new ParamView(sg);
                            params = pView.loadParamsFromServerGUI(ServerGUI.this.paramsFile);
                        }
                        catch (InvalidParameterException e) {
                            log.debug((Object)"Invalid parameters received - ParamView opened");
                        }
                    } else {
                        try {
                            params = new Parameters(ServerGUI.this.paramsFile);
                        }
                        catch (InvalidParameterException e) {
                            log.debug((Object)("Invalid parameter received: " + e.getMessage()));
                            JOptionPane.showMessageDialog(null, "Invalid parameter file: " + e.getMessage(), "Parameter Invalid", 0);
                        }
                    }
                    if (params != null) {
                        ServerGUI.this.loadParametersFile(ServerGUI.this.paramsFile, params);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Invalid parameter file received at ServerGUI - user notified");
                    JOptionPane.showMessageDialog(null, "Invalid parameter file:  " + e.getMessage(), "Input Error", 0);
                }
            }
        };
        SwingUtilities.invokeLater(worker);
    }

    public void loadParametersFile(File paramFile, Parameters params) {
        try {
            this.paramsFile = paramFile;
            this.guiOutput.deposit("parameters");
            this.guiOutput.deposit(this.paramsFile);
            this.guiOutput.deposit(params);
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ServerGUI.this.ParamFileLabel.setText("Parameters File: " + ServerGUI.this.paramsFile.getName());
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)"Failed to load a validated parameter file into ServerGUI");
        }
    }

    private void AuthenticateButtonAction(ActionEvent evt) {
        try {
            if (this.numPlayers < 1) {
                JOptionPane.showMessageDialog(null, "Please set the number of players before initializing authentication", "Authentication Error", 0);
            } else {
                this.authenticationDone = false;
                this.guiOutput.deposit("authenticate");
                this.DisconnectButton.setEnabled(true);
                this.DisconnectMenuItem.setEnabled(true);
                this.StartGameButton.setEnabled(true);
                this.StartMenuItem.setEnabled(true);
                this.ResetClientsMenuItem.setEnabled(true);
                this.SetPlayersButton.setEnabled(false);
                this.AuthenticateButton.setEnabled(false);
                this.AuthMenuItem.setEnabled(false);
                this.NumPlayersMenuItem.setEnabled(false);
                this.ForceReauthMenuItem.setEnabled(true);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to receive client information from the ServerAdmin" + MSConstants.newline + e));
        }
    }

    private void ResetClientsAction(ActionEvent evt) {
        block4: {
            try {
                Object[] resetValues = new Object[]{"Pre-Authentication", "Post-Authentication", "Cancel Reset"};
                int selectedValue = JOptionPane.showOptionDialog(null, "Reset clients to what state?", "Select Reset Type", 1, 1, null, resetValues, resetValues[2]);
                if (selectedValue == 0) {
                    this.guiOutput.deposit("reset pre_auth");
                    break block4;
                }
                if (selectedValue == 1) {
                    this.guiOutput.deposit("reset post_auth");
                    break block4;
                }
                return;
            }
            catch (Exception e) {
                log.error((Object)"Failed to reset the clients to pre-experiment state", (Throwable)e);
            }
        }
    }

    private void DisconnectButtonAction(ActionEvent evt) {
        try {
            if (!this.isEndOfLastMatch()) {
                if (1 == JOptionPane.showConfirmDialog(null, "Disconnect from all clients?", "Confirm Disconnect", 0)) {
                    return;
                }
                if (0 == JOptionPane.showConfirmDialog(null, "Write output file for this experiment?", "Write Output", 0)) {
                    this.guiOutput.deposit("write_output");
                } else {
                    this.guiOutput.deposit("disconnect");
                }
            } else {
                this.guiOutput.deposit("write_output");
            }
            this.disconnectUpdate();
        }
        catch (Exception e) {
            log.error((Object)("Failed to disconnect the server" + MSConstants.newline + e));
        }
    }

    public void disconnectUpdate() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.DisconnectButton.setEnabled(false);
                ServerGUI.this.DisconnectButton.setText("Disconnect Server");
                ServerGUI.this.DisconnectButton.setForeground(Color.black);
                ServerGUI.this.DisconnectMenuItem.setEnabled(false);
                ServerGUI.this.DisconnectMenuItem.setText("Disconnect Server");
                ServerGUI.this.DisconnectMenuItem.setForeground(Color.black);
                ServerGUI.this.ReadParamsButton.setEnabled(true);
                ServerGUI.this.SetPlayersButton.setEnabled(true);
                ServerGUI.this.NextRoundButton.setEnabled(false);
                ServerGUI.this.StartGameButton.setEnabled(false);
                ServerGUI.this.AuthenticateButton.setEnabled(true);
                ServerGUI.this.OutputSetButton.setEnabled(true);
                ServerGUI.this.MessageButton.setEnabled(false);
                ServerGUI.this.NumPlayersMenuItem.setEnabled(true);
                ServerGUI.this.OutputMenuItem.setEnabled(true);
                ServerGUI.this.ParamFileMenuItem.setEnabled(true);
                ServerGUI.this.PersistFileMenuItem.setEnabled(true);
                ServerGUI.this.NumPlayersMenuItem.setEnabled(true);
                ServerGUI.this.GlobalHistoryButton.setEnabled(false);
                ServerGUI.this.ShowHistoryMenuItem.setEnabled(false);
                ServerGUI.this.AuthMenuItem.setEnabled(true);
                ServerGUI.this.StartMenuItem.setEnabled(false);
                ServerGUI.this.ForceOutputMenuItem.setEnabled(false);
                ServerGUI.this.AbortMatchMenuItem.setEnabled(false);
                ServerGUI.this.AbortRoundMenuItem.setEnabled(false);
                ServerGUI.this.ForceNextMenuItem.setEnabled(false);
                ServerGUI.this.ForceReauthMenuItem.setEnabled(false);
                ServerGUI.this.SendMessageMenuItem.setEnabled(false);
                ServerGUI.this.deleteClientData();
                ServerGUI.this.setMessagingEnabled(false);
                ServerGUI.this.outputFile = null;
                ServerGUI.this.OutputPathLabel.setText("Output File: None Selected");
                ServerGUI.this.ClientMatchLabel.setText("No Experiment Running");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void cancelAuthentication() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.DisconnectButton.setEnabled(false);
                ServerGUI.this.DisconnectMenuItem.setEnabled(false);
                ServerGUI.this.StartGameButton.setEnabled(false);
                ServerGUI.this.StartMenuItem.setEnabled(false);
                ServerGUI.this.SetPlayersButton.setEnabled(true);
                ServerGUI.this.AuthenticateButton.setEnabled(true);
                ServerGUI.this.AuthMenuItem.setEnabled(true);
                ServerGUI.this.NumPlayersMenuItem.setEnabled(true);
                ServerGUI.this.ForceReauthMenuItem.setEnabled(false);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void SetPlayersButtonAction(ActionEvent evt) {
        String numPlayerStr = JOptionPane.showInputDialog(null, (Object)"Please input the number of players below");
        if (numPlayerStr == null) {
            return;
        }
        try {
            this.numPlayers = Integer.parseInt(numPlayerStr);
            if (this.numPlayers < 1) {
                JOptionPane.showMessageDialog(null, "There must be at least one player", "Input Error", 0);
            } else if (this.numPlayers >= 1) {
                if (ServerVariables.groupLCM != 0 && this.numPlayers % ServerVariables.groupLCM != 0) {
                    JOptionPane.showMessageDialog(null, "Please note that " + this.numPlayers + " players is not valid with the current parameter file (which requires divisibility by " + ServerVariables.groupLCM + ")", "Input Warning", 0);
                }
                this.guiOutput.deposit("numPlayersChange");
                this.guiOutput.deposit(numPlayerStr);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "The number of players must be an INTEGER value", "Input Error", 0);
        }
    }

    private void GameDelayMenuItemAction(ActionEvent evt) {
        String gameDelayStr = JOptionPane.showInputDialog(null, "Please input the desired game delay in milliseconds", "Input Game Delay", 3);
        if (gameDelayStr == null) {
            return;
        }
        try {
            long tempGameDelay = Long.parseLong(gameDelayStr);
            log.info((Object)("The auto game delay has been changed from " + ServerVariables.gameDelay + " to " + tempGameDelay + " milliseconds"));
            ServerVariables.gameDelay = tempGameDelay;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "The game delay must be a value in milliseconds!");
        }
    }

    public void eraseClientData() {
        try {
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ServerGUI.this.deleteClientData();
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to erase client data in event-thread" + MSConstants.newline + e));
        }
    }

    public void deleteClientData() {
        try {
            this.closeAllHistory();
            this.ClientDataPanel = new JPanel();
            this.ClientDataPanel.setBackground(Color.white);
            this.ClientScroller.setViewportView(this.ClientDataPanel);
        }
        catch (Exception e) {
            log.error((Object)("Failed to delete client data" + MSConstants.newline + e));
        }
    }

    public void formClientData(boolean partnered) {
        try {
            final boolean partneredb = partnered;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ServerGUI.this.formCData(partneredb);
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to run the client data formation event thread" + MSConstants.newline + e));
        }
    }

    public void formCData(boolean partnered) {
        int i;
        this.clients = ServerVariables.clients;
        this.buttonToId = new Hashtable();
        this.historyMap = new Hashtable();
        this.historyButtonMap = new Hashtable();
        this.ClientDataPanel = new JPanel();
        this.ClientDataPanel.setBackground(Color.white);
        this.ClientDataPanel.setLayout(new BoxLayout(this.ClientDataPanel, 1));
        Vector ordering = ServerVariables.clients;
        if (partnered) {
            ordering = this.orderClientsByPartners();
        }
        this.clientsNotReady = this.numPlayers;
        this.numFinished = 0;
        this.authenticationDone = true;
        for (i = 0; i < this.numPlayers; ++i) {
            ClientData client = (ClientData)ordering.get(i);
            JPanel SingleClientPanel = new JPanel();
            SingleClientPanel.setLayout(new GridLayout(1, 0));
            Color backColor = partnered && ServerVariables.groupSize > 0 ? (i / ServerVariables.groupSize % 2 == 0 ? new Color(202, 219, 241) : Color.white) : Color.white;
            SingleClientPanel.setBackground(backColor);
            JLabel Name2 = new JLabel();
            Name2.setText(client.getName());
            Name2.setHorizontalAlignment(0);
            SingleClientPanel.add(Name2);
            JPanel ConDisCon = new JPanel();
            ConDisCon.setLayout(new GridLayout(1, 0));
            ConDisCon.setBackground(backColor);
            JLabel Connected = new JLabel();
            Connected.setText("Connected");
            Connected.setForeground(new Color(5, 187, 10));
            Connected.setHorizontalAlignment(0);
            Connected.setVerticalTextPosition(1);
            Connected.setHorizontalTextPosition(0);
            ConDisCon.add(Connected);
            JLabel Received = new JLabel();
            Received.setText("Waiting");
            Received.setHorizontalAlignment(0);
            Received.setVerticalTextPosition(1);
            Received.setHorizontalTextPosition(0);
            ConDisCon.add(Received);
            SingleClientPanel.add(ConDisCon);
            JPanel Actions = new JPanel();
            Actions.setLayout(new BoxLayout(Actions, 0));
            Actions.setBackground(backColor);
            JButton Reauthenticate = new JButton();
            Reauthenticate.setText("Reauth");
            Reauthenticate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ServerGUI.this.ReauthenticateAction(evt);
                }
            });
            Reauthenticate.setEnabled(false);
            Actions.add(Reauthenticate);
            JButton SendMessageButton = new JButton();
            SendMessageButton.setText("Message");
            SendMessageButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ServerGUI.this.SendMessageButtonAction(evt);
                }
            });
            SendMessageButton.setEnabled(partnered);
            Actions.add(SendMessageButton);
            JToggleButton ShowHistoryButton = new JToggleButton();
            ShowHistoryButton.setText("History");
            ShowHistoryButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ServerGUI.this.ShowHistoryButtonAction(evt);
                }
            });
            Actions.add(ShowHistoryButton);
            SingleClientPanel.add(Actions);
            JLabel Information2 = new JLabel();
            Information2.setText("Payoff: 0");
            Information2.setHorizontalAlignment(0);
            SingleClientPanel.add(Information2);
            SingleClientPanel.setPreferredSize(new Dimension(980, 27));
            this.buttonToId.put(Reauthenticate, new Integer(client.getId()));
            this.buttonToId.put(SendMessageButton, new Integer(client.getId()));
            this.buttonToId.put(Information2, new Integer(client.getId()));
            this.buttonToId.put(ShowHistoryButton, new Integer(client.getId()));
            Vector<JComponent> otherPanels = new Vector<JComponent>();
            otherPanels.add(Information2);
            otherPanels.add(Connected);
            otherPanels.add(Received);
            otherPanels.add(Reauthenticate);
            otherPanels.add(SendMessageButton);
            this.buttonToId.put(new Integer(client.getId()), otherPanels);
            this.ClientDataPanel.add(SingleClientPanel);
        }
        if (this.numPlayers < 15) {
            for (i = 0; i < 15 - this.numPlayers; ++i) {
                JPanel BlankGridFiller = new JPanel();
                BlankGridFiller.setBackground(Color.white);
                BlankGridFiller.setPreferredSize(new Dimension(980, 100));
                this.ClientDataPanel.add(BlankGridFiller);
            }
        }
        this.ClientScroller.setViewportView(this.ClientDataPanel);
    }

    private void ReauthenticateAction(ActionEvent evt) {
        try {
            JButton source = (JButton)evt.getSource();
            int id = (Integer)this.buttonToId.get(source);
            log.info((Object)("Attempting to reauthenticate client " + id));
            this.guiOutput.deposit("reauthenticate");
            this.guiOutput.deposit(new Integer(id));
            this.disableReauthenticateButtons();
        }
        catch (Exception e) {
            log.error((Object)("Failed to send reauthentication message from GUI to ServerAdmin" + MSConstants.newline + e));
        }
    }

    private void disableReauthenticateButtons() {
        for (int i = 0; i < this.clients.size(); ++i) {
            this.setReauthenticateEnabled(false, i);
        }
    }

    public void enableReauthenticateButtons() {
        for (int i = 0; i < this.clients.size(); ++i) {
            if (!this.isConnected(i)) {
                this.setReauthenticateEnabled(true, i);
                continue;
            }
            this.setReauthenticateEnabled(false, i);
        }
    }

    private void SendMessageButtonAction(ActionEvent evt) {
        JButton source = (JButton)evt.getSource();
        int id = (Integer)this.buttonToId.get(source);
        MessageSendView messageView = new MessageSendView(this, id);
        messageView.setVisible(true);
        log.info((Object)("Message interface created for sending to client " + id));
    }

    public void sendMessages(int[] subject_ids, String message) {
        try {
            Vector<Integer> subjects = new Vector<Integer>();
            for (int i = 0; i < subject_ids.length; ++i) {
                subjects.add(new Integer(subject_ids[i]));
            }
            this.guiOutput.deposit("send messages");
            this.guiOutput.deposit(subjects);
            this.guiOutput.deposit(message);
            log.debug((Object)"Gui has sent message request to ServerAdmin");
        }
        catch (Exception e) {
            log.error((Object)("Failed to send message request from GUI to ServerAdmin" + MSConstants.newline + e));
        }
    }

    private void ShowHistoryButtonAction(ActionEvent evt) {
        JToggleButton source = (JToggleButton)evt.getSource();
        if (!source.isSelected()) {
            ClientHistoryFrame historyFrame = (ClientHistoryFrame)this.historyMap.get(source);
            historyFrame.setVisible(false);
            historyFrame.dispose();
            this.historyMap.remove(source);
            this.historyButtonMap.remove(historyFrame);
            log.debug((Object)"Client history has been hidden");
        } else {
            int id = (Integer)this.buttonToId.get(source);
            ClientData client = (ClientData)this.clients.get(id);
            ClientHistoryFrame historyFrame = new ClientHistoryFrame(this, client, client.getName());
            this.historyMap.put(source, historyFrame);
            this.historyButtonMap.put(historyFrame, source);
            log.debug((Object)("History for client " + client.getName() + " displayed"));
        }
    }

    private void closeAllHistory() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                Enumeration frames = ServerGUI.this.historyMap.elements();
                while (frames.hasMoreElements()) {
                    ClientHistoryFrame historyFrame = (ClientHistoryFrame)frames.nextElement();
                    historyFrame.setVisible(false);
                    historyFrame.dispose();
                }
                log.debug((Object)"All client history frames have been hidden");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void deselectHistoryButton(ClientHistoryFrame cFrame) {
        final ClientHistoryFrame cf = cFrame;
        Runnable doUpdate = new Runnable(){

            public void run() {
                JToggleButton source = (JToggleButton)ServerGUI.this.historyButtonMap.get(cf);
                source.setSelected(false);
                ServerGUI.this.historyMap.remove(source);
                ServerGUI.this.historyButtonMap.remove(cf);
                log.debug((Object)"Client history has been hidden");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void updateClientInfo(int clientNum) {
        final int cNum = clientNum;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.clients = ServerVariables.clients;
                JLabel info = (JLabel)((Vector)ServerGUI.this.buttonToId.get(new Integer(cNum))).get(0);
                ClientData client = (ClientData)ServerGUI.this.clients.get(cNum);
                float payoff = client.getTotalPayoff();
                info.setText("Payoff: " + payoff);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void updateClientStatus(int clientNum, String text) {
        final int cNum = clientNum;
        final String txt = text;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.clients = ServerVariables.clients;
                JLabel received = (JLabel)((Vector)ServerGUI.this.buttonToId.get(new Integer(cNum))).get(2);
                received.setText(txt);
                received.setForeground(new Color(102, 102, 153));
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void updateClientStatus(int clientNum, String text, Color color) {
        final int cNum = clientNum;
        final String txt = text;
        final Color c = color;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.clients = ServerVariables.clients;
                JLabel received = (JLabel)((Vector)ServerGUI.this.buttonToId.get(new Integer(cNum))).get(2);
                received.setText(txt);
                received.setForeground(c);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void setReadyForNextGame(int clientNum) {
        this.updateClientStatus(clientNum, "Ready for Next Round");
        --this.clientsNotReady;
        log.debug((Object)("Status for client " + clientNum + " set to Ready for Next Round.  Number of clients not ready for next round: " + this.clientsNotReady));
        if (this.clientsNotReady == 0) {
            this.processRoundEnd();
        }
    }

    public void setFinished(int clientNum) {
        ++this.numFinished;
        --this.clientsNotReady;
        this.updateClientStatus(clientNum, "Finished Match", Color.blue);
        this.checkFinishedStatus();
        log.debug((Object)("Client " + clientNum + " set to finished status"));
    }

    private void processLastMatch() {
        for (int i = 0; i < this.clients.size(); ++i) {
            this.updateClientStatus(i, "Finished", Color.blue);
        }
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.NextRoundButton.setEnabled(false);
                ServerGUI.this.DisconnectButton.setText("Write Output");
                ServerGUI.this.DisconnectButton.setForeground(Color.blue);
                ServerGUI.this.DisconnectMenuItem.setText("Write Output");
                ServerGUI.this.DisconnectMenuItem.setForeground(Color.blue);
                log.info((Object)"All clients have finished all matches. Next Game disabled. Write Output enabled");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void processMatchEnd() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.nextMatchReady = true;
                if (!ServerGUI.this.AutoMatchProceedBox.isSelected()) {
                    ServerGUI.this.NextRoundButton.setEnabled(true);
                }
                ServerGUI.this.NextRoundButton.setText("Next Match");
                ServerGUI.this.NextRoundButton.setForeground(Color.blue);
                log.info((Object)("All clients have finished match " + ServerVariables.currentMatch + ".  Next Match enabled"));
                if (ServerGUI.this.AutoMatchProceedBox.isSelected()) {
                    ServerGUI.this.AutoMatchProceedBox.setEnabled(false);
                    ServerGUI.this.NextRoundMatch();
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void processRoundEnd() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.updateDisplays();
                if (!ServerGUI.this.AutoRoundProceedBox.isSelected()) {
                    ServerGUI.this.NextRoundButton.setEnabled(true);
                }
                ServerGUI.this.clientsNotReady = ServerGUI.this.clients.size() - ServerGUI.this.numFinished;
                log.debug((Object)"All clients ready: Next Round button enabled");
                if (ServerGUI.this.AutoRoundProceedBox.isSelected()) {
                    ServerGUI.this.AutoRoundProceedBox.setEnabled(false);
                    ServerGUI.this.NextRoundMatch();
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private boolean isEndOfMatch() {
        return this.numFinished == this.clients.size();
    }

    private boolean isEndOfLastMatch() {
        return this.isEndOfMatch() && ServerVariables.lastMatch;
    }

    private boolean isEndOfRound() {
        return this.clientsNotReady == 0;
    }

    private synchronized void checkFinishedStatus() {
        try {
            if (this.isEndOfMatch()) {
                this.updateHistories();
                if (ServerVariables.lastMatch) {
                    this.processLastMatch();
                } else {
                    this.processMatchEnd();
                }
            } else if (this.isEndOfRound()) {
                this.processRoundEnd();
            }
            log.debug((Object)("Number of clients not ready for next round: " + this.clientsNotReady));
        }
        catch (Exception e) {
            log.error((Object)("Failed to update a client to finished status or failed to set server to finished game status" + MSConstants.newline + e));
        }
    }

    public void setConnected(int clientNum) {
        if (this.buttonToId == null || ServerVariables.integratedTest) {
            return;
        }
        this.clients = ServerVariables.clients;
        final JLabel connected = (JLabel)((Vector)this.buttonToId.get(new Integer(clientNum))).get(1);
        Runnable doUpdate = new Runnable(){

            public void run() {
                connected.setForeground(new Color(5, 187, 10));
                connected.setText("Connected");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        this.setReauthenticateEnabled(false, clientNum);
    }

    public boolean isConnected(int clientNum) {
        this.clients = ServerVariables.clients;
        if (this.buttonToId == null || ServerVariables.integratedTest) {
            return true;
        }
        JLabel connected = (JLabel)((Vector)this.buttonToId.get(new Integer(clientNum))).get(1);
        return connected.getText().equals("Connected");
    }

    public void setDisconnected(int clientNum) {
        if (this.buttonToId == null || ServerVariables.integratedTest) {
            return;
        }
        this.clients = ServerVariables.clients;
        final JLabel disconnected = (JLabel)((Vector)this.buttonToId.get(new Integer(clientNum))).get(1);
        Runnable doUpdate = new Runnable(){

            public void run() {
                disconnected.setForeground(Color.red);
                disconnected.setText("Disconnected");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        this.setReauthenticateEnabled(true, clientNum);
    }

    public void setReauthenticateEnabled(boolean enabled, int clientNum) {
        final JButton ReauthenticateButton = (JButton)((Vector)this.buttonToId.get(new Integer(clientNum))).get(3);
        final boolean en = enabled;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ReauthenticateButton.setEnabled(en);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void setMessagingEnabled(boolean enabled) {
        final boolean en = enabled;
        Runnable doUpdate = new Runnable(){

            public void run() {
                for (int i = 0; i < ServerGUI.this.clients.size(); ++i) {
                    JButton MessagingButton = (JButton)((Vector)ServerGUI.this.buttonToId.get(new Integer(i))).get(4);
                    MessagingButton.setEnabled(en);
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private Vector orderClientsByPartners() {
        Vector<ClientData> ordered = new Vector<ClientData>();
        for (int i = 0; i < this.numPlayers; ++i) {
            if (ordered.contains(this.clients.get(i))) continue;
            ClientData client = (ClientData)this.clients.get(i);
            ordered.add(client);
            int[] partners = client.getPartners();
            for (int j = 0; j < partners.length; ++j) {
                if (j == client.getPartnerNum()) continue;
                ClientData partner = (ClientData)this.clients.get(partners[j]);
                ordered.add(partner);
            }
        }
        return ordered;
    }

    public void setNumPlayers(int nPlayers) {
        this.numPlayers = nPlayers;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.NumPlayersLabel.setText("Number of Players: " + ServerGUI.this.numPlayers);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public static void main(String[] args) throws Exception {
    }

    private void ExitMenuItemAction(ActionEvent evt) {
        System.exit(0);
    }

    public void LocationInfoAction(ActionEvent evt) {
        if (!this.LocationInfoBox.isSelected()) {
            this.FilterNetMessagesBox.setEnabled(false);
            this.FilterClientMessagesBox.setEnabled(false);
            this.FilterNetMessagesBox.setSelected(false);
            this.FilterClientMessagesBox.setSelected(false);
            this.logMonitor.setDisplayLocationInfo(false);
            this.logMonitor.setDisplayClientLog(true);
            this.logMonitor.setDisplayNetworkLog(true);
        } else {
            this.FilterNetMessagesBox.setEnabled(true);
            this.FilterClientMessagesBox.setEnabled(true);
            this.FilterNetMessagesBox.setSelected(true);
            this.FilterClientMessagesBox.setSelected(true);
            this.logMonitor.setDisplayLocationInfo(true);
            this.logMonitor.setDisplayNetworkLog(false);
            this.logMonitor.setDisplayClientLog(false);
        }
    }

    public void setMatchRoundLabel(int match, int round) {
        final int m = match;
        final int r = round;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.ClientMatchLabel.setText("Match: " + m + ", Round: " + r);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void setMatcherLabel(int match) {
        final int m = match;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.ClientMatchLabel.setText("Match " + m + " Initializing Groups");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void setMatchIndependentLabel(int match) {
        final int m = match;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ServerGUI.this.ClientMatchLabel.setText("Match: " + m + ", Independent Round Advancement");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void showParamGUI(File file) {
        ParamGUI pgui = new ParamGUI();
        pgui.reset();
        pgui.pack();
        pgui.centerOnScreen();
        pgui.setVisible(true);
        if (file != null) {
            pgui.loadFile(file);
        }
    }

    private void showParamViewer() {
        final ServerGUI sg = this;
        Runnable worker = new Runnable(){

            public void run() {
                ParamView pView = new ParamView(sg);
                pView.reset();
                if (ServerGUI.this.paramsFile != null) {
                    pView.load(ServerGUI.this.paramsFile);
                } else {
                    pView.pack();
                    pView.centerOnScreen();
                    pView.setVisible(true);
                }
            }
        };
        SwingUtilities.invokeLater(worker);
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }

    public void initIntegratedTest(String paramFilePath, String outputFilePath) {
        try {
            this.paramsFile = new File(paramFilePath);
            log.info((Object)("Parsing parameter file " + this.paramsFile.getName() + " at " + this.paramsFile.getPath()));
            Parameters params = new Parameters(this.paramsFile);
            this.guiOutput.deposit("parameters");
            this.guiOutput.deposit(this.paramsFile);
            this.guiOutput.deposit(params);
            this.ParamFileLabel.setText("Parameters File: " + this.paramsFile.getName());
            this.outputFile = new File(outputFilePath);
            this.guiOutput.deposit("output file");
            this.guiOutput.deposit(this.outputFile);
            this.OutputPathLabel.setText("Output File: " + this.outputFile.getName());
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize Multistage Integrated Test on the ServerGUI" + MSConstants.newline + e));
        }
    }

    public void setPlayersItest(int numGroups) {
        try {
            int numPlayers = ServerVariables.groupLCM * numGroups;
            this.guiOutput.deposit("numPlayersChange");
            this.guiOutput.deposit("" + numPlayers);
        }
        catch (Exception e) {
            log.error((Object)("Failed to set the number of players for an integrated test" + MSConstants.newline + e));
        }
    }

    public void authIntegratedTest() {
        this.AuthenticateButtonAction(null);
    }

    public void startIntegratedTest() {
        this.AutoRoundProceedBox.setSelected(true);
        this.AutoMatchProceedBox.setSelected(true);
        this.StartGameButtonAction(null);
    }

    public void outputIntegratedTest() {
        this.DisconnectButtonAction(null);
    }

    public LoggingMonitor getLoggingMonitor() {
        return this.logMonitor;
    }
}

