/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.shared.network.AuthorizationPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Category;

public class ReauthView
extends JDialog {
    private JPanel jPanel1;
    private JLabel ReauthenticateLabel;
    private JPanel StatusPanel;
    private JLabel ClientIDLabel;
    private JLabel ClientNameLabel;
    private JLabel ClientStatusLabel;
    private JButton CancelButton;
    private JPanel Filler;
    private JButton ConfirmButton;
    private Mailbox authOut;
    private boolean connected;
    private static Category log = Category.getInstance(ReauthView.class);

    public ReauthView(JFrame owner, int clientNum, String clientName, Mailbox authOut) {
        super(owner);
        this.setTitle("Reauthentication");
        this.authOut = authOut;
        this.connected = false;
        this.initComponents();
        this.ClientIDLabel.setText("Client ID: " + clientNum);
        this.ClientNameLabel.setText(clientName);
        this.centerOnScreen();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ReauthenticateLabel = new JLabel();
        this.StatusPanel = new JPanel();
        this.ClientIDLabel = new JLabel();
        this.ClientNameLabel = new JLabel();
        this.ClientStatusLabel = new JLabel();
        this.CancelButton = new JButton();
        this.Filler = new JPanel();
        this.ConfirmButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ReauthView.this.exitForm(evt);
            }
        });
        this.ReauthenticateLabel.setText("Reauthenticating");
        this.ReauthenticateLabel.setForeground(Color.black);
        this.ReauthenticateLabel.setHorizontalAlignment(0);
        this.ReauthenticateLabel.setFont(new Font("Bookman Old Style", 1, 14));
        this.ReauthenticateLabel.setPreferredSize(new Dimension(350, 17));
        this.jPanel1.add(this.ReauthenticateLabel);
        this.getContentPane().add(this.jPanel1);
        this.StatusPanel.setLayout(new GridLayout(2, 3));
        this.ClientIDLabel.setText("Client ID: ");
        this.ClientIDLabel.setForeground(Color.blue);
        this.ClientIDLabel.setHorizontalAlignment(0);
        this.ClientIDLabel.setFont(new Font("Dialog", 1, 14));
        this.StatusPanel.add(this.ClientIDLabel);
        this.ClientNameLabel.setText("Client Name: ");
        this.ClientNameLabel.setForeground(Color.blue);
        this.ClientNameLabel.setHorizontalAlignment(0);
        this.ClientNameLabel.setFont(new Font("Dialog", 1, 14));
        this.StatusPanel.add(this.ClientNameLabel);
        this.ClientStatusLabel.setText("Disconnected");
        this.ClientStatusLabel.setForeground(Color.red);
        this.ClientStatusLabel.setHorizontalAlignment(0);
        this.ClientStatusLabel.setFont(new Font("Dialog", 1, 14));
        this.StatusPanel.add(this.ClientStatusLabel);
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReauthView.this.CancelButtonActionPerformed(evt);
            }
        });
        this.StatusPanel.add(this.CancelButton);
        this.Filler.setPreferredSize(new Dimension(50, 10));
        this.StatusPanel.add(this.Filler);
        this.ConfirmButton.setText("Confirm");
        this.ConfirmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReauthView.this.ConfirmButtonActionPerformed(evt);
            }
        });
        this.StatusPanel.add(this.ConfirmButton);
        this.getContentPane().add(this.StatusPanel);
        this.pack();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        try {
            this.authOut.deposit(new AuthorizationPacket(null, 3));
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception e) {
            log.error((Object)("Failed to send authentication canceled message from ReauthView to Authenticator" + MSConstants.newline + e));
        }
    }

    private void ConfirmButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.connected) {
                this.authOut.deposit(new AuthorizationPacket(null, 2));
                this.setVisible(false);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "The client has not yet been reauthenticated!", "Connection Error", 0);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to send authentication confirmed message from ReauthView to Authenticator" + MSConstants.newline + e));
        }
    }

    private void exitForm(WindowEvent evt) {
        try {
            this.authOut.deposit(new AuthorizationPacket(null, 3));
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception e) {
            log.error((Object)("Failed to send authentication canceled message from ReauthView to Authenticator" + MSConstants.newline + e));
        }
    }

    public void setConnected() {
        this.ClientStatusLabel.setText("Connected");
        this.ClientStatusLabel.setForeground(new Color(39, 198, 42));
        this.connected = true;
    }

    public static void main(String[] args) {
        new ReauthView(null, 0, null, null).setVisible(true);
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

