/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.data.Parameters;
import edu.caltech.ssel.multistage.server.interfaces.ServerGUI;
import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.ParamHolder;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.log4j.Category;

public class ParamView
extends JFrame {
    private JTextPane ParamText;
    private JPanel TextPanel;
    private JTextPane ErrorText;
    private JMenuItem ExitMenuItem;
    private JMenuItem SaveMenuItem;
    private JPanel TitlePanel;
    private JMenuBar ParamMenu;
    private JMenuItem ResetMenuItem;
    private JLabel TitleLabel;
    private JMenu FileMenu;
    private JLabel IDLabel;
    private JMenuItem LoadFileMenuItem;
    private JScrollPane GenScroller;
    private JScrollPane ErrorScroller;
    private JButton SaveRunButton;
    private JButton CheckButton;
    DefaultStyledDocument doc;
    DefaultStyledDocument errorDoc;
    private Hashtable paramHolders;
    private Vector errorLocations;
    private Vector generalErrors;
    private Hashtable errorMap;
    private Rectangle userClick;
    private String numErrorsString;
    private File paramsFile;
    private ServerGUI ui;
    private static Category log = Category.getInstance(ParamView.class);

    public ParamView() {
        this.reset();
    }

    public ParamView(ServerGUI ui) {
        this.ui = ui;
        this.reset();
    }

    public void reset() {
        try {
            this.errorLocations = new Vector();
            this.generalErrors = new Vector();
            this.errorMap = new Hashtable();
            this.numErrorsString = "";
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ParamView.this.getContentPane().removeAll();
                    ParamView.this.initComponents();
                    ParamView.this.configureParamPane();
                    ParamView.this.configureErrorPane();
                    ParamView.this.setJMenuBar(ParamView.this.ParamMenu);
                    if (ParamView.this.ui == null) {
                        ParamView.this.SaveRunButton.setEnabled(false);
                    }
                    ParamView.this.pack();
                    ParamView.this.repaint();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                this.getContentPane().removeAll();
                this.initComponents();
                this.configureParamPane();
                this.configureErrorPane();
                this.setJMenuBar(this.ParamMenu);
                if (this.ui == null) {
                    this.SaveRunButton.setEnabled(false);
                }
                this.pack();
                this.repaint();
            } else {
                SwingUtilities.invokeAndWait(doUpdate);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to reset the ParamView" + MSConstants.newline + e));
        }
    }

    private void clear() {
        try {
            this.generalErrors = new Vector();
            this.errorLocations = new Vector();
            this.errorMap = new Hashtable();
            this.numErrorsString = "";
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ParamView.this.ParamText.setText("");
                    ParamView.this.ErrorText.setText("");
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                doUpdate.run();
            } else {
                SwingUtilities.invokeAndWait(doUpdate);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to clear the ParamView display" + MSConstants.newline + e));
        }
    }

    private void configureParamPane() {
        this.doc = new DefaultStyledDocument();
        this.ParamText = new JTextPane(this.doc){

            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                int panelLength = this.getSize().width;
                int panelHeight = this.getSize().height;
                Rectangle2D.Double background = new Rectangle2D.Double(0.0, 0.0, panelLength, panelHeight);
                g2d.setPaint(Color.white);
                g2d.draw(background);
                g2d.fill(background);
                for (int i = 0; i < ParamView.this.errorLocations.size(); ++i) {
                    Rectangle rec = (Rectangle)ParamView.this.errorLocations.get(i);
                    g2d.setPaint(Color.red);
                    Rectangle2D.Double line = new Rectangle2D.Double(0.0, rec.getY(), panelLength, rec.getHeight());
                    g2d.draw(line);
                    g2d.fill(line);
                }
                if (ParamView.this.userClick != null) {
                    g2d.setPaint(Color.blue);
                    Rectangle2D.Double outline = new Rectangle2D.Double(0.0, ParamView.this.userClick.getY(), panelLength, ParamView.this.userClick.getHeight());
                    g2d.draw(outline);
                }
                super.paint(g);
            }
        };
        this.ParamText.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ParamView.this.ParamTextMousePressed(evt);
            }
        });
        this.ParamText.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                ParamView.this.ParamTextMouseMoved(evt);
            }
        });
        this.ParamText.setOpaque(false);
        this.GenScroller.setViewportView(this.ParamText);
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style defaultStyle = context.getStyle("default");
        Style errorStyle = this.ParamText.addStyle("error", defaultStyle);
        StyleConstants.setForeground(errorStyle, Color.white);
        StyleConstants.setBackground(errorStyle, Color.red);
        StyleConstants.setBold(errorStyle, true);
        Style commentStyle = this.ParamText.addStyle("comment", defaultStyle);
        StyleConstants.setBold(commentStyle, true);
        StyleConstants.setForeground(commentStyle, Color.magenta);
        Style importantStyle = this.ParamText.addStyle("important", defaultStyle);
        StyleConstants.setBold(importantStyle, true);
        Style gameSpecific = this.ParamText.addStyle("gameSpecific", defaultStyle);
        StyleConstants.setForeground(gameSpecific, Color.blue);
        Style unrecognized = this.ParamText.addStyle("unrecognized", defaultStyle);
        StyleConstants.setForeground(unrecognized, new Color(137, 137, 137));
        Style normalStyle = this.ParamText.addStyle("normal", defaultStyle);
    }

    private void configureErrorPane() {
        this.errorDoc = new DefaultStyledDocument();
        this.ErrorText.setStyledDocument(this.errorDoc);
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style defaultStyle = context.getStyle("default");
        Style headerStyle = this.ErrorText.addStyle("header", defaultStyle);
        StyleConstants.setForeground(headerStyle, Color.blue);
        StyleConstants.setBold(headerStyle, true);
        Style errorStyle = this.ErrorText.addStyle("error", defaultStyle);
        StyleConstants.setForeground(errorStyle, Color.red);
        Style selectedStyle = this.ErrorText.addStyle("selected", errorStyle);
        StyleConstants.setBold(selectedStyle, true);
        Style titleStyle = this.ErrorText.addStyle("title", defaultStyle);
        StyleConstants.setForeground(titleStyle, Color.black);
        StyleConstants.setBold(titleStyle, true);
        StyleConstants.setItalic(titleStyle, true);
        this.ErrorText.setEditable(false);
    }

    private void initComponents() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.ParamMenu = new JMenuBar();
        this.FileMenu = new JMenu();
        this.LoadFileMenuItem = new JMenuItem();
        this.ResetMenuItem = new JMenuItem();
        this.ExitMenuItem = new JMenuItem();
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.SaveMenuItem = new JMenuItem();
        this.IDLabel = new JLabel();
        this.TextPanel = new JPanel();
        this.GenScroller = new JScrollPane();
        this.ParamText = new JTextPane();
        this.ErrorScroller = new JScrollPane();
        this.ErrorText = new JTextPane();
        this.SaveRunButton = new JButton();
        this.CheckButton = new JButton();
        this.FileMenu.setText("File");
        this.LoadFileMenuItem.setText("Load Parameters File");
        this.LoadFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamView.this.LoadFileMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.LoadFileMenuItem);
        this.SaveMenuItem.setText("Save Parameters File");
        this.SaveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamView.this.SaveMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.SaveMenuItem);
        this.ResetMenuItem.setText("Reset");
        this.ResetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamView.this.ResetMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.ResetMenuItem);
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamView.this.ExitMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.ExitMenuItem);
        this.ParamMenu.add(this.FileMenu);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setDefaultCloseOperation(2);
        this.setTitle("Parameter Viewer");
        this.setName("ParamView");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ParamView.this.exitForm(evt);
            }
        });
        this.TitlePanel.setLayout(new BorderLayout());
        this.TitlePanel.setMaximumSize(new Dimension(32000, 36));
        this.TitlePanel.setPreferredSize(new Dimension((int)((double)screen.width * 0.65), 36));
        this.TitleLabel.setFont(new Font("Arial Black", 0, 16));
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setText("Parameter File Editor");
        this.TitleLabel.setHorizontalAlignment(0);
        this.TitlePanel.add((Component)this.TitleLabel, "Center");
        JPanel ButtonPanel = new JPanel();
        this.CheckButton.setText("Check Errors");
        this.CheckButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Runnable worker = new Runnable(){

                    public void run() {
                        try {
                            ParamView.this.checkParameters();
                        }
                        catch (InvalidParameterException e) {
                            JOptionPane.showMessageDialog(null, "Unreadable Parameters: " + e.getMessage(), "Invalid Parameters", 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error((Object)("Failed to perform a check error operation on parameter file" + MSConstants.newline + e));
                        }
                    }
                };
                Thread workThread = new Thread(worker);
                workThread.start();
            }
        });
        ButtonPanel.add(this.CheckButton);
        this.SaveRunButton.setText("Save and Run");
        this.SaveRunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Runnable worker = new Runnable(){

                    public void run() {
                        try {
                            boolean saved = ParamView.this.saveParameterFile();
                            Parameters params = ParamView.this.load(ParamView.this.paramsFile);
                            if (params != null) {
                                ParamView.this.ui.loadParametersFile(ParamView.this.paramsFile, params);
                            }
                            Runnable doUpdate = new Runnable(){

                                public void run() {
                                    ParamView.this.exitForm(null);
                                }
                            };
                            if (saved) {
                                SwingUtilities.invokeLater(doUpdate);
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to perform a save and run operation on parameter file" + MSConstants.newline + e));
                        }
                    }
                };
                Thread workThread = new Thread(worker);
                workThread.start();
            }
        });
        ButtonPanel.add(this.SaveRunButton);
        this.TitlePanel.add((Component)ButtonPanel, "East");
        this.getContentPane().add(this.TitlePanel);
        this.TextPanel.setLayout(new BoxLayout(this.TextPanel, 0));
        this.TextPanel.setMaximumSize(new Dimension(32000, (int)((double)screen.height * 0.9)));
        this.TextPanel.setMinimumSize(new Dimension((int)((double)screen.width * 0.65), (int)((double)screen.height * 0.75)));
        this.TextPanel.setPreferredSize(new Dimension((int)((double)screen.width * 0.65), (int)((double)screen.height * 0.75)));
        this.GenScroller.setViewportBorder(new TitledBorder("Parameter File View"));
        this.GenScroller.setMaximumSize(new Dimension(32000, (int)((double)screen.height * 0.9)));
        this.GenScroller.setMinimumSize(new Dimension((int)((double)screen.width * 0.39), (int)((double)screen.height * 0.75)));
        this.GenScroller.setPreferredSize(new Dimension((int)((double)screen.width * 0.39), (int)((double)screen.height * 0.75)));
        this.ParamText.setMinimumSize(new Dimension((int)((double)screen.width * 0.39), (int)((double)screen.height * 0.75)));
        this.ParamText.setPreferredSize(new Dimension(6, 6));
        this.ParamText.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ParamView.this.ParamTextMousePressed(evt);
            }
        });
        this.ParamText.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                ParamView.this.ParamTextMouseMoved(evt);
            }
        });
        this.GenScroller.setViewportView(this.ParamText);
        this.TextPanel.add(this.GenScroller);
        this.ErrorScroller.setViewportBorder(new TitledBorder("Error Message"));
        this.ErrorScroller.setMaximumSize(new Dimension(32000, (int)((double)screen.height * 0.9)));
        this.ErrorScroller.setMinimumSize(new Dimension((int)((double)screen.width * 0.26), (int)((double)screen.height * 0.75)));
        this.ErrorScroller.setPreferredSize(new Dimension((int)((double)screen.width * 0.26), (int)((double)screen.height * 0.75)));
        this.ErrorText.setPreferredSize(new Dimension(6, 6));
        this.ErrorScroller.setViewportView(this.ErrorText);
        this.TextPanel.add(this.ErrorScroller);
        this.getContentPane().add(this.TextPanel);
        this.pack();
    }

    public boolean checkErrors() {
        return this.errorLocations == null || this.errorLocations.size() <= 0;
    }

    private void ResetMenuItemActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void ExitMenuItemActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void ParamTextMouseMoved(MouseEvent evt) {
        try {
            Point pt = evt.getPoint();
            boolean mouseOverError = false;
            for (int i = 0; i < this.errorLocations.size(); ++i) {
                Rectangle rec = (Rectangle)this.errorLocations.get(i);
                Rectangle2D.Double bigRec = new Rectangle2D.Double(0.0, rec.getY(), this.ParamText.getSize().width, rec.getHeight());
                if (!bigRec.contains(pt.getX(), pt.getY())) continue;
                mouseOverError = true;
                this.displayErrorHeader();
                String error = (String)this.errorMap.get(rec);
                this.displayErrors(error);
            }
            if (!mouseOverError) {
                this.displayErrorHeader();
                this.displayErrors(null);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to display error message on mouse movement" + MSConstants.newline + e));
        }
    }

    private void displayErrorHeader() {
        try {
            this.ErrorText.setText("");
            this.errorDoc.insertString(this.errorDoc.getLength(), this.numErrorsString + "\n", this.ErrorText.getStyle("header"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to display the headers for the ErrorText window" + MSConstants.newline + e));
        }
    }

    private void displayErrors(String selected) {
        try {
            if (this.generalErrors == null) {
                return;
            }
            Vector<String> duplicates = new Vector<String>();
            for (int j = 0; j < this.generalErrors.size(); ++j) {
                String genError = (String)this.generalErrors.get(j);
                if (duplicates.contains(genError)) continue;
                String style = "error";
                if (genError.equals(selected)) {
                    style = "selected";
                }
                this.errorDoc.insertString(this.errorDoc.getLength(), "ERROR\n", this.ErrorText.getStyle("title"));
                this.errorDoc.insertString(this.errorDoc.getLength(), genError + "\n", this.ErrorText.getStyle(style));
                duplicates.add(genError);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to display general error messages on ErrorText window" + MSConstants.newline + e));
        }
    }

    private void ParamTextMousePressed(MouseEvent evt) {
        try {
            Point pt = evt.getPoint();
            this.userClick = this.ParamText.modelToView(this.ParamText.viewToModel(pt));
            this.repaint();
        }
        catch (Exception e) {
            log.error((Object)("Failed to record the location of a user click in the text window" + MSConstants.newline + e));
        }
    }

    public void writeErrors() {
        try {
            Vector<String> uniques = new Vector<String>();
            for (int i = 0; i < this.generalErrors.size(); ++i) {
                String error = (String)this.generalErrors.get(i);
                if (uniques.contains(error)) continue;
                uniques.add(error);
            }
            int numErrors = uniques.size();
            this.numErrorsString = numErrors == 0 ? "No Errors Found" : (numErrors == 1 ? "Found " + numErrors + " Error" : "Found " + numErrors + " Errors");
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ParamView.this.displayErrorHeader();
                    ParamView.this.displayErrors(null);
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to write error information" + MSConstants.newline + e));
        }
    }

    private void displayFile(File inputFile, Hashtable paramMap) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            this.displayParams(reader, paramMap);
            reader.close();
        }
        catch (Exception e) {
            log.error((Object)("Failed to display parameters from an input file" + MSConstants.newline + e));
        }
    }

    private void displayString(String text, Hashtable paramMap) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(text));
            this.displayParams(reader, paramMap);
        }
        catch (Exception e) {
            log.error((Object)("Failed to display parameters from input text" + MSConstants.newline + e));
        }
    }

    private void displayParams(BufferedReader reader, Hashtable paramMap) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(35) >= 0) {
                    this.write(line + "\n", "comment");
                    continue;
                }
                line = this.doubleTrim(line);
                ParamHolder param = (ParamHolder)paramMap.get(line);
                if (line.startsWith("numOfMatches=")) {
                    this.write(line + "\n", "important");
                    continue;
                }
                if (line.startsWith("exp.id=")) {
                    this.write(line + "\n", "important");
                    continue;
                }
                if (param == null) {
                    this.write(line + "\n", "unrecognized");
                    continue;
                }
                this.writeParam(param);
            }
            this.writeGeneralErrors(paramMap);
            this.ParamText.setCaretPosition(0);
            this.repaint();
        }
        catch (Exception e) {
            log.error((Object)("Failed to display parameter input file" + MSConstants.newline + e));
        }
    }

    private String doubleTrim(String line) {
        try {
            StringTokenizer token = new StringTokenizer(line, "=");
            String property = token.nextToken();
            String value = token.nextToken();
            return property.trim() + "=" + value.trim();
        }
        catch (Exception e) {
            return line;
        }
    }

    public void writeParam(ParamHolder p) {
        try {
            String param = p.getParamString();
            String value = p.getParamValue();
            String error = p.getErrorString();
            String style = p.getStyle();
            String str = param + "=" + value;
            if (error == null) {
                this.write(str + "\n", style);
            } else {
                this.writeError(str + "\n", error);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to write parameter" + MSConstants.newline + e));
        }
    }

    private void write(String str, String style) throws Exception {
        this.doc.insertString(this.doc.getLength(), str, this.ParamText.getStyle(style));
    }

    private void writeError(String str, String error) throws Exception {
        Rectangle rec = this.ParamText.modelToView(this.doc.getLength());
        this.errorLocations.add(rec);
        this.errorMap.put(rec, error);
        this.doc.insertString(this.doc.getLength(), str, this.ParamText.getStyle("error"));
    }

    private void writeGeneralErrors(Hashtable paramMap) {
        Enumeration en = paramMap.elements();
        while (en.hasMoreElements()) {
            ParamHolder ph = (ParamHolder)en.nextElement();
            String error = ph.getErrorString();
            if (error == null) continue;
            this.generalErrors.add(error);
        }
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
        this.setVisible(false);
        if (this.ui == null) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        ParamView pgui = new ParamView();
        pgui.reset();
        pgui.pack();
        pgui.centerOnScreen();
        pgui.setVisible(true);
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }

    public Parameters loadParamsFromServerGUI(File paramsFile) throws InvalidParameterException, Exception {
        try {
            if (this.ui == null) {
                return null;
            }
            this.paramsFile = paramsFile;
            final Parameters params = this.processParameters(false);
            final ParamView pv = this;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ParamView.this.SaveRunButton.setEnabled(true);
                    if (params.containsErrors()) {
                        JOptionPane.showMessageDialog(pv, "<html><center>Errors were detected in the parameter file.<br>Please correct the errors then click the 'Save and Run' button to load them into the Multistage Server", "Parameter Verification Failure", 0);
                        ParamView.this.ParamText.updateUI();
                        ParamView.this.repaint();
                    }
                }
            };
            SwingUtilities.invokeLater(doUpdate);
            if (params.containsErrors()) {
                return null;
            }
            return params;
        }
        catch (InvalidParameterException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public Parameters load(File paramsFile) {
        try {
            this.paramsFile = paramsFile;
            Parameters params = this.processParameters(true);
            return params;
        }
        catch (InvalidParameterException e) {
            log.warn((Object)("Parameter File Unreadable: " + e.getMessage()));
            JOptionPane.showMessageDialog(this, "Unreadable Parameter File: " + e.getMessage(), "Invalid File", 0);
        }
        catch (Exception e) {
            log.error((Object)("Error reading parameter file" + MSConstants.newline + e));
            JOptionPane.showMessageDialog(this, "Unknown error occured while reading the parameter file", "Read Error", 0);
        }
        return null;
    }

    private Parameters processParameters(boolean displayOK) throws InvalidParameterException, Exception {
        if (this.paramsFile == null) {
            return null;
        }
        final Parameters params = new Parameters(this.paramsFile);
        final boolean dok = displayOK;
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (params.containsErrors() || dok) {
                    ParamView.this.clear();
                    ParamView.this.displayFile(ParamView.this.paramsFile, params.getParamMap());
                    ParamView.this.writeErrors();
                    ParamView.this.ParamText.updateUI();
                    ParamView.this.pack();
                    ParamView.this.centerOnScreen();
                    ParamView.this.setVisible(true);
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        return params;
    }

    private Parameters checkParameters() throws InvalidParameterException, Exception {
        try {
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ParamView.this.ParamText.setEditable(false);
                }
            };
            SwingUtilities.invokeLater(doUpdate);
            final String text = this.ParamText.getText();
            byte[] byteArray = text.getBytes();
            ByteArrayInputStream stream = new ByteArrayInputStream(byteArray);
            final Parameters params = new Parameters(stream);
            Runnable update = new Runnable(){

                public void run() {
                    ParamView.this.clear();
                    ParamView.this.displayString(text, params.getParamMap());
                    ParamView.this.writeErrors();
                    ParamView.this.ParamText.updateUI();
                    ParamView.this.pack();
                    ParamView.this.setVisible(true);
                    ParamView.this.ParamText.setEditable(true);
                }
            };
            SwingUtilities.invokeLater(update);
            return params;
        }
        catch (InvalidParameterException e) {
            this.ParamText.setEditable(true);
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Exception e) {
            this.ParamText.setEditable(true);
            throw new Exception(e);
        }
    }

    private boolean saveParameterFile(File targetFile, boolean check) {
        try {
            if (targetFile == null) {
                return false;
            }
            String fileName = targetFile.getAbsolutePath();
            String shortName = targetFile.getName();
            if (check && !this.verifySave()) {
                return false;
            }
            FileWriter writer = new FileWriter(fileName);
            writer.write(this.ParamText.getText());
            writer.close();
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to save the parameters file to given location" + MSConstants.newline + e));
            return false;
        }
    }

    private boolean saveParameterFile() {
        if (this.paramsFile == null) {
            return false;
        }
        return this.saveParameterFile(this.paramsFile, true);
    }

    private void LoadFileMenuItemActionPerformed(ActionEvent evt) {
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    JFileChooser chooser = ParamView.this.getFileChooser();
                    File paramsFile = null;
                    chooser.setDialogTitle("Load Parameters File");
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        paramsFile = chooser.getSelectedFile();
                    }
                    if (paramsFile != null) {
                        ParamView.this.load(paramsFile);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed to load a parameter file in ParamView interface" + MSConstants.newline + e));
                }
            }
        };
        Thread workThread = new Thread(worker);
        workThread.start();
    }

    private void SaveMenuItemActionPerformed(ActionEvent evt) {
        final ParamView pv = this;
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    if (!ParamView.this.verifySave()) {
                        return;
                    }
                    JFileChooser chooser = ParamView.this.getFileChooser();
                    chooser.setDialogTitle("Save Parameter File");
                    chooser.setApproveButtonText("Save");
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0 && ParamView.this.saveParameterFile(chooser.getSelectedFile(), false)) {
                        String shortName = chooser.getSelectedFile().getName();
                        JOptionPane.showMessageDialog(pv, "Parameters successfully saved to " + shortName);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(pv, "Failed to save the parameter file!", "File Error", 0);
                }
            }
        };
        Thread workThread = new Thread(worker);
        workThread.start();
    }

    private boolean verifySave() throws Exception {
        try {
            Parameters params = this.checkParameters();
            if ((params == null || params.containsErrors()) && 1 == JOptionPane.showConfirmDialog(this, "This parameter file contains errors. Continue?", "Errors Found", 0)) {
                return false;
            }
        }
        catch (InvalidParameterException e) {
            if (1 == JOptionPane.showConfirmDialog(this, "This parameter file contains errors. Continue?", "Errors Found", 0)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new Exception();
        }
        return true;
    }

    private JFileChooser getFileChooser() {
        try {
            String resource = "mult-server.properties";
            URL multiConfig = ClassLoader.getSystemResource(resource);
            JFileChooser chooser = null;
            String path = null;
            if (multiConfig != null) {
                Properties props = new Properties();
                props.load(multiConfig.openStream());
                path = props.getProperty("parameters_home");
            }
            chooser = path != null && path.length() > 0 ? new JFileChooser(path) : new JFileChooser();
            return chooser;
        }
        catch (Exception e) {
            log.error((Object)("Failed to load a path-specific file chooser - returning a default file chooser" + MSConstants.newline + e));
            return new JFileChooser();
        }
    }

    public void setServerGUI(ServerGUI ui) {
        this.ui = ui;
    }

    public ServerGUI getServerGUI() {
        return this.ui;
    }

    public void finalize() {
        log.info((Object)"The parameter viewer has been shut down and freed from memory");
    }
}

