/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.util.Param;
import java.awt.Color;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParamPanel {
    private JPanel panel;
    private Param prm;
    private int gameNum;

    public ParamPanel(JPanel panel, int gameNum) {
        this.panel = panel;
        this.gameNum = gameNum;
    }

    public ParamPanel() {
    }

    public void setPanel(JPanel panel) {
        this.panel = panel;
    }

    public void setGameNum(int gameNum) {
        this.gameNum = gameNum;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public int getGameNum() {
        return this.gameNum;
    }

    public Param getParam() {
        return this.prm;
    }

    public void setParam(Param prm) {
        this.prm = prm;
    }

    public void setValue(Object value) {
        JTextField field = (JTextField)this.panel.getComponent(1);
        field.setText((String)value);
    }

    public void setDefaultValue() {
        String value = this.prm.getInitialValue();
        this.setValue(value);
    }

    public void setIncluded() {
        JPanel optionPanel = (JPanel)this.panel.getComponent(2);
        JCheckBox box = (JCheckBox)optionPanel.getComponent(1);
        box.setSelected(true);
    }

    public boolean isIncluded() {
        JPanel optionPanel = (JPanel)this.panel.getComponent(2);
        JCheckBox optionCheck = (JCheckBox)optionPanel.getComponent(1);
        return optionCheck.isSelected();
    }

    public boolean isOptional() {
        JPanel optionPanel = (JPanel)this.panel.getComponent(2);
        JLabel optional = (JLabel)optionPanel.getComponent(0);
        return optional.getText().equalsIgnoreCase("optional");
    }

    public void setOptional(boolean uncheck) {
        JPanel optionPanel = (JPanel)this.panel.getComponent(2);
        JLabel optionText = (JLabel)optionPanel.getComponent(0);
        optionText.setText("Optional");
        optionText.setForeground(Color.blue);
        JCheckBox optionCheck = (JCheckBox)optionPanel.getComponent(1);
        if (uncheck) {
            optionCheck.setSelected(false);
        }
        optionCheck.setEnabled(true);
    }

    public void setRequired() {
        JPanel optionPanel = (JPanel)this.panel.getComponent(2);
        JLabel optionText = (JLabel)optionPanel.getComponent(0);
        optionText.setText("Required");
        optionText.setForeground(Color.red);
        JCheckBox optionCheck = (JCheckBox)optionPanel.getComponent(1);
        optionCheck.setSelected(true);
        optionCheck.setEnabled(false);
    }

    public void setNormal() {
        if (this.prm.isRequired()) {
            this.setRequired();
        } else {
            this.setOptional(false);
        }
    }

    public String getValue() {
        String value = ((JTextField)this.panel.getComponent(1)).getText();
        return value;
    }
}

