/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.data.Match;
import edu.caltech.ssel.multistage.server.data.Parameters;
import edu.caltech.ssel.multistage.server.interfaces.MatchParamTab;
import edu.caltech.ssel.multistage.server.interfaces.ParamPanel;
import edu.caltech.ssel.multistage.server.interfaces.ProgressDialog;
import edu.caltech.ssel.multistage.server.interfaces.SwingWorker;
import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.Param;
import edu.caltech.ssel.multistage.server.util.ParamVerifier;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.log4j.Category;

public class ParamGUI
extends JFrame {
    private JTextPane ParamText;
    private JPanel TextPanel;
    private JTextPane ErrorText;
    private JTabbedPane CardPanel;
    private JMenuItem ExitMenuItem;
    private JButton SaveButton;
    private JPanel TitlePanel;
    private JMenuBar ParamMenu;
    private JTextField IDText;
    private JMenuItem ResetMenuItem;
    private JComboBox NumMatchesBox;
    private JLabel TitleLabel;
    private JMenu FileMenu;
    private JLabel IDLabel;
    private JPanel NumMatchesPanel;
    private JMenuItem LoadFileMenuItem;
    private JButton MatchCommitButton;
    private JScrollPane GenScroller;
    private JLabel NumMatchesLabel;
    private JScrollPane ErrorScroller;
    DefaultStyledDocument doc;
    DefaultStyledDocument errorDoc;
    private Hashtable paramStrings;
    private Hashtable errorStrings;
    private Hashtable paramStyles;
    private int numMatches;
    private Hashtable matchTabs;
    private Vector errorLocations;
    private Hashtable errorMap;
    private Rectangle userClick;
    private String numErrorsString;
    private Hashtable paramValues;
    private Properties props;
    private Vector repColors;
    private int colorIndex;
    private Vector gameTypes;
    private ProgressDialog pdiag;
    private static Category log = Category.getInstance(ParamGUI.class);

    private void fillGameTypes() {
        block16: {
            try {
                this.gameTypes = new Vector();
                String pckgname = "edu.caltech.ssel.projects.multistage.server.util.paramverifiers";
                String name = "/edu/caltech/ssel/projects/multistage/server/util/paramverifiers";
                URL url = ParamGUI.class.getResource(name);
                File directory = new File(url.getFile());
                if (directory.exists()) {
                    String[] files = directory.list();
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].endsWith(".class")) continue;
                        String classname = files[i].substring(0, files[i].length() - 6);
                        try {
                            Object o = Class.forName(pckgname + "." + classname).newInstance();
                            if (!(o instanceof ParamVerifier) || !classname.endsWith("Verifier")) continue;
                            this.gameTypes.add(classname.substring(0, classname.length() - 8));
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            log.warn((Object)("Error loading verifier class" + MSConstants.newline + e));
                            continue;
                        }
                        catch (InstantiationException e) {
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            log.warn((Object)("Loaded verifier class is not public!" + MSConstants.newline + e));
                        }
                    }
                    break block16;
                }
                try {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    String starts = conn.getEntryName();
                    JarFile jfile = conn.getJarFile();
                    Enumeration<JarEntry> e = jfile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String entryname = entry.getName();
                        if (!entryname.startsWith(starts) || entryname.lastIndexOf(47) > starts.length() || !entryname.endsWith(".class")) continue;
                        String classname = entryname.substring(0, entryname.length() - 6);
                        if (classname.startsWith("/")) {
                            classname = classname.substring(1);
                        }
                        classname = classname.replace('/', '.');
                        try {
                            Object o = Class.forName(classname).newInstance();
                            if (!(o instanceof ParamVerifier) || !classname.endsWith("Verifier")) continue;
                            String cname = classname.substring(classname.lastIndexOf(46) + 1);
                            this.gameTypes.add(cname.substring(0, cname.length() - 8));
                        }
                        catch (ClassNotFoundException cnfex) {
                            log.warn((Object)("Error loading verifier class" + MSConstants.newline + e));
                        }
                        catch (InstantiationException cnfex) {
                        }
                        catch (IllegalAccessException iaex) {
                            log.warn((Object)("Loaded verifier class is not public!" + MSConstants.newline + e));
                        }
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Unknown IO Error" + MSConstants.newline + e));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to fill the game type box with all available game types" + MSConstants.newline + e));
            }
        }
    }

    public void reset() {
        this.matchTabs = new Hashtable();
        this.paramStrings = new Hashtable();
        this.errorStrings = new Hashtable();
        this.paramStyles = new Hashtable();
        this.errorLocations = new Vector();
        this.paramValues = new Hashtable();
        this.getContentPane().removeAll();
        this.initComponents();
        this.configureParamPane();
        this.configureErrorPane();
        this.setJMenuBar(this.ParamMenu);
        this.fillGameTypes();
        this.fillMiscBoxes();
        this.fillColors();
    }

    public void resetNoListeners() {
        this.matchTabs = new Hashtable();
        this.paramStrings = new Hashtable();
        this.errorStrings = new Hashtable();
        this.paramStyles = new Hashtable();
        this.errorLocations = new Vector();
        this.paramValues = new Hashtable();
        this.getContentPane().removeAll();
        this.initComponents();
        this.configureParamPane();
        this.configureErrorPane();
        this.setJMenuBar(this.ParamMenu);
        this.fillGameTypes();
        this.fillColors();
        ActionListener listener = ((ActionListener[])this.NumMatchesBox.getListeners(ActionListener.class))[0];
        this.NumMatchesBox.removeActionListener(listener);
        this.fillMiscBoxes();
        this.NumMatchesBox.addActionListener(listener);
    }

    public void resetAndWait() {
        try {
            this.matchTabs = new Hashtable();
            this.paramStrings = new Hashtable();
            this.errorStrings = new Hashtable();
            this.paramStyles = new Hashtable();
            this.errorLocations = new Vector();
            this.paramValues = new Hashtable();
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ParamGUI.this.getContentPane().removeAll();
                    ParamGUI.this.initComponents();
                    ParamGUI.this.configureParamPane();
                    ParamGUI.this.configureErrorPane();
                    ParamGUI.this.fillGameTypes();
                    ParamGUI.this.fillMiscBoxes();
                    ParamGUI.this.setJMenuBar(ParamGUI.this.ParamMenu);
                    ParamGUI.this.fillColors();
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to reset the ParamGUI and wait" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void configureParamPane() {
        this.doc = new DefaultStyledDocument();
        this.ParamText = new JTextPane(this.doc){

            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                int panelLength = this.getSize().width;
                int panelHeight = this.getSize().height;
                Rectangle2D.Double background = new Rectangle2D.Double(0.0, 0.0, panelLength, panelHeight);
                g2d.setPaint(Color.white);
                g2d.draw(background);
                g2d.fill(background);
                for (int i = 0; i < ParamGUI.this.errorLocations.size(); ++i) {
                    Rectangle rec = (Rectangle)ParamGUI.this.errorLocations.get(i);
                    g2d.setPaint(Color.red);
                    Rectangle2D.Double line = new Rectangle2D.Double(0.0, rec.getY(), panelLength, rec.getHeight());
                    g2d.draw(line);
                    g2d.fill(line);
                }
                if (ParamGUI.this.userClick != null) {
                    g2d.setPaint(Color.blue);
                    Rectangle2D.Double outline = new Rectangle2D.Double(0.0, ParamGUI.this.userClick.getY(), panelLength, ParamGUI.this.userClick.getHeight());
                    g2d.draw(outline);
                }
                super.paint(g);
            }
        };
        this.ParamText.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ParamGUI.this.ParamTextMousePressed(evt);
            }
        });
        this.ParamText.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                ParamGUI.this.ParamTextMouseMoved(evt);
            }
        });
        this.ParamText.setEditable(false);
        this.ParamText.setOpaque(false);
        this.GenScroller.setViewportView(this.ParamText);
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style defaultStyle = context.getStyle("default");
        Style errorStyle = this.ParamText.addStyle("error", defaultStyle);
        StyleConstants.setForeground(errorStyle, Color.white);
        StyleConstants.setBackground(errorStyle, Color.red);
        StyleConstants.setBold(errorStyle, true);
        Style commentStyle = this.ParamText.addStyle("comment", defaultStyle);
        StyleConstants.setBold(commentStyle, true);
        StyleConstants.setForeground(commentStyle, Color.magenta);
        Style importantStyle = this.ParamText.addStyle("important", defaultStyle);
        StyleConstants.setBold(importantStyle, true);
        Style gameSpecific = this.ParamText.addStyle("gameSpecific", defaultStyle);
        StyleConstants.setForeground(gameSpecific, Color.blue);
        Style gameParam = this.ParamText.addStyle("gameParam", defaultStyle);
        StyleConstants.setForeground(gameParam, new Color(40, 80, 40));
    }

    private void configureErrorPane() {
        this.errorDoc = new DefaultStyledDocument();
        this.ErrorText.setStyledDocument(this.errorDoc);
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style defaultStyle = context.getStyle("default");
        Style headerStyle = this.ErrorText.addStyle("header", defaultStyle);
        StyleConstants.setForeground(headerStyle, Color.blue);
        StyleConstants.setBold(headerStyle, true);
        Style errorStyle = this.ErrorText.addStyle("error", defaultStyle);
        StyleConstants.setForeground(errorStyle, Color.red);
        Style titleStyle = this.ErrorText.addStyle("title", defaultStyle);
        StyleConstants.setForeground(titleStyle, Color.black);
        StyleConstants.setBold(titleStyle, true);
        StyleConstants.setItalic(titleStyle, true);
        this.ErrorText.setEditable(false);
    }

    private void fillMiscBoxes() {
        for (int i = 0; i < 150; ++i) {
            Integer element = new Integer(i + 1);
            this.NumMatchesBox.addItem(element);
        }
    }

    private void fillColors() {
        this.repColors = new Vector();
        this.repColors.add(Color.blue);
        this.repColors.add(Color.red);
        this.repColors.add(Color.green);
        this.colorIndex = -1;
    }

    private void initComponents() {
        this.ParamMenu = new JMenuBar();
        this.FileMenu = new JMenu();
        this.LoadFileMenuItem = new JMenuItem();
        this.ResetMenuItem = new JMenuItem();
        this.ExitMenuItem = new JMenuItem();
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.NumMatchesPanel = new JPanel();
        this.NumMatchesLabel = new JLabel();
        this.NumMatchesBox = new JComboBox();
        this.MatchCommitButton = new JButton();
        this.SaveButton = new JButton();
        this.IDLabel = new JLabel();
        this.IDText = new JTextField();
        this.CardPanel = new JTabbedPane();
        this.TextPanel = new JPanel();
        this.GenScroller = new JScrollPane();
        this.ParamText = new JTextPane();
        this.ErrorScroller = new JScrollPane();
        this.ErrorText = new JTextPane();
        this.FileMenu.setText("File");
        this.LoadFileMenuItem.setText("Load Parameters File");
        this.LoadFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamGUI.this.LoadFileMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.LoadFileMenuItem);
        this.ResetMenuItem.setText("Reset");
        this.ResetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamGUI.this.ResetMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.ResetMenuItem);
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamGUI.this.ExitMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.ExitMenuItem);
        this.ParamMenu.add(this.FileMenu);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setDefaultCloseOperation(2);
        this.setTitle("Parameter Generator");
        this.setName("ParamGUI");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ParamGUI.this.exitForm(evt);
            }
        });
        this.TitlePanel.setMaximumSize(new Dimension(32000, 36));
        this.TitlePanel.setPreferredSize(new Dimension(1000, 36));
        this.TitleLabel.setFont(new Font("Arial Black", 0, 18));
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setText("Parameter File Generator");
        this.TitlePanel.add(this.TitleLabel);
        this.getContentPane().add(this.TitlePanel);
        this.NumMatchesPanel.setLayout(new FlowLayout(1, 10, 5));
        this.NumMatchesPanel.setMaximumSize(new Dimension(32000, 31));
        this.NumMatchesPanel.setPreferredSize(new Dimension(1000, 36));
        this.NumMatchesLabel.setFont(new Font("Dialog", 1, 14));
        this.NumMatchesLabel.setForeground(Color.black);
        this.NumMatchesLabel.setText("Number of Matches");
        this.NumMatchesPanel.add(this.NumMatchesLabel);
        this.NumMatchesBox.setToolTipText("Select the number of matches for this experiment");
        this.NumMatchesBox.setMinimumSize(new Dimension(50, 26));
        this.NumMatchesBox.setPreferredSize(new Dimension(60, 26));
        this.NumMatchesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamGUI.this.NumMatchesBoxActionPerformed(evt);
            }
        });
        this.NumMatchesPanel.add(this.NumMatchesBox);
        this.MatchCommitButton.setText("Check Errors");
        this.MatchCommitButton.setToolTipText("Display the generated file in the Parameter File View and show all errors");
        this.MatchCommitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamGUI.this.MatchCommitButtonActionPerformed(evt);
            }
        });
        this.NumMatchesPanel.add(this.MatchCommitButton);
        this.SaveButton.setText("Save to File");
        this.SaveButton.setToolTipText("Save the generated parameter file to disk");
        this.SaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamGUI.this.SaveButtonActionPerformed(evt);
            }
        });
        this.NumMatchesPanel.add(this.SaveButton);
        this.IDLabel.setFont(new Font("Dialog", 1, 14));
        this.IDLabel.setText("Experiment ID");
        this.NumMatchesPanel.add(this.IDLabel);
        this.IDText.setFont(new Font("Dialog", 1, 12));
        this.IDText.setText("100");
        this.IDText.setToolTipText("Enter the experiment's ID number");
        this.IDText.setPreferredSize(new Dimension(30, 25));
        this.NumMatchesPanel.add(this.IDText);
        this.getContentPane().add(this.NumMatchesPanel);
        this.CardPanel.setMaximumSize(new Dimension(32000, Short.MAX_VALUE));
        this.CardPanel.setPreferredSize(new Dimension(1000, 450));
        this.getContentPane().add(this.CardPanel);
        this.TextPanel.setLayout(new BoxLayout(this.TextPanel, 0));
        this.TextPanel.setMaximumSize(new Dimension(32000, 301));
        this.TextPanel.setMinimumSize(new Dimension(1400, 299));
        this.TextPanel.setPreferredSize(new Dimension(1000, 300));
        this.GenScroller.setViewportBorder(new TitledBorder("Parameter File View"));
        this.GenScroller.setMaximumSize(new Dimension(32000, 300));
        this.GenScroller.setMinimumSize(new Dimension(600, 300));
        this.GenScroller.setPreferredSize(new Dimension(600, 300));
        this.ParamText.setEditable(false);
        this.ParamText.setMinimumSize(new Dimension(600, 300));
        this.ParamText.setPreferredSize(new Dimension(6, 6));
        this.ParamText.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ParamGUI.this.ParamTextMousePressed(evt);
            }
        });
        this.ParamText.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                ParamGUI.this.ParamTextMouseMoved(evt);
            }
        });
        this.GenScroller.setViewportView(this.ParamText);
        this.TextPanel.add(this.GenScroller);
        this.ErrorScroller.setViewportBorder(new TitledBorder("Error Message"));
        this.ErrorScroller.setMaximumSize(new Dimension(32000, 300));
        this.ErrorScroller.setMinimumSize(new Dimension(300, 300));
        this.ErrorScroller.setPreferredSize(new Dimension(200, 300));
        this.ErrorText.setPreferredSize(new Dimension(6, 6));
        this.ErrorScroller.setViewportView(this.ErrorText);
        this.TextPanel.add(this.ErrorScroller);
        this.getContentPane().add(this.TextPanel);
        this.pack();
    }

    public boolean checkErrors() {
        this.MatchCommitButtonActionPerformed(null);
        return this.errorLocations == null || this.errorLocations.size() <= 0;
    }

    private void SaveButtonActionPerformed(ActionEvent evt) {
        this.MatchCommitButtonActionPerformed(null);
        int proceed = 0;
        if (this.errorLocations != null & this.errorLocations.size() > 0) {
            proceed = JOptionPane.showConfirmDialog(this, "This parameter file contains errors. Continue?", "Errors Found", 0);
        }
        if (proceed == 0) {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Save Parameter File");
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                String shortName = chooser.getSelectedFile().getName();
                FileWriter writer = new FileWriter(fileName);
                writer.write(this.ParamText.getText());
                writer.close();
                JOptionPane.showMessageDialog(this, "Parameters successfully saved to " + shortName);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to save the parameter file!", "File Error", 0);
            }
        }
    }

    private void ResetMenuItemActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void ExitMenuItemActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void LoadFileMenuItemActionPerformed(ActionEvent evt) {
        File paramsFile = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Load Parameters File");
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            paramsFile = chooser.getSelectedFile();
        }
        if (paramsFile != null) {
            this.resetNoListeners();
            this.pdiag = new ProgressDialog((Frame)this, false);
            final File pfile = paramsFile;
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    ActionListener listener = ((ActionListener[])ParamGUI.this.NumMatchesBox.getListeners(ActionListener.class))[0];
                    ParamGUI.this.NumMatchesBox.removeActionListener(listener);
                    ParamGUI.this.loadFile(pfile);
                    ParamGUI.this.pdiag.kill();
                    ParamGUI.this.pdiag = null;
                    ParamGUI.this.NumMatchesBox.addActionListener(listener);
                    return null;
                }
            };
            worker.start();
        }
    }

    private boolean groupSizeChanged(int match) {
        MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
        int thisGroupSize = tab.getGroupSize();
        int parent = tab.getRepetitionOf();
        if (parent == -1) {
            return false;
        }
        MatchParamTab parentTab = (MatchParamTab)this.matchTabs.get(new Integer(parent));
        int parentGroupSize = parentTab.getGroupSize();
        return parentGroupSize != thisGroupSize;
    }

    private void NumMatchesBoxActionPerformed(ActionEvent evt) {
        this.pdiag = new ProgressDialog((Frame)this, false);
        Vector vect = new Vector();
        int numMatches = -1;
        try {
            numMatches = (Integer)this.NumMatchesBox.getSelectedItem();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please enter a valid integer for the number of matches", "Invalid Number of Matches", 0);
        }
        if (numMatches > 0) {
            this.numMatches = numMatches;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ParamGUI.this.initMatchParams();
                ParamGUI.this.pdiag.kill();
                ParamGUI.this.pdiag = null;
                return null;
            }
        };
        worker.start();
    }

    private void ParamTextMouseMoved(MouseEvent evt) {
        try {
            Point pt = evt.getPoint();
            for (int i = 0; i < this.errorLocations.size(); ++i) {
                Rectangle rec = (Rectangle)this.errorLocations.get(i);
                Rectangle2D.Double bigRec = new Rectangle2D.Double(0.0, rec.getY(), this.ParamText.getSize().width, rec.getHeight());
                if (!bigRec.contains(pt.getX(), pt.getY())) continue;
                this.ErrorText.setText("");
                this.errorDoc.insertString(this.errorDoc.getLength(), this.numErrorsString + MSConstants.newline, this.ErrorText.getStyle("header"));
                String error = (String)this.errorMap.get(rec);
                this.errorDoc.insertString(this.errorDoc.getLength(), "ERROR" + MSConstants.newline, this.ErrorText.getStyle("title"));
                this.errorDoc.insertString(this.errorDoc.getLength(), error + MSConstants.newline, this.ErrorText.getStyle("error"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to display error message on mouse movement" + MSConstants.newline + e));
        }
    }

    private void ParamTextMousePressed(MouseEvent evt) {
        try {
            Point pt = evt.getPoint();
            this.userClick = this.ParamText.modelToView(this.ParamText.viewToModel(pt));
            this.repaint();
        }
        catch (Exception e) {
            log.error((Object)("Failed to record the location of a user click in the text window" + MSConstants.newline + e));
        }
    }

    private MatchParamTab createMatchCard(int match) {
        try {
            MatchParamTab matchTab = new MatchParamTab(match, this, this.gameTypes);
            this.CardPanel.addTab("Match " + match, matchTab);
            return matchTab;
        }
        catch (Exception e) {
            log.error((Object)("Failed to create a match tabbed panel for match " + match));
            return null;
        }
    }

    private void MatchCommitButtonActionPerformed(ActionEvent evt) {
        try {
            this.errorMap = new Hashtable();
            this.ErrorText.setText("");
            for (int i = 0; i < this.numMatches; ++i) {
                this.updateParamStrings(i);
                this.scanForErrors(i);
            }
            this.writeAllParams();
            this.writeErrors();
        }
        catch (Exception e) {
            log.error((Object)("Failed to process commit parameters button request" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void writeErrors() {
        try {
            int numErrors = this.errorLocations.size();
            this.numErrorsString = numErrors == 0 ? "No Errors Found" : (numErrors == 1 ? "Found " + this.errorLocations.size() + " Error" : "Found " + this.errorLocations.size() + " Errors");
            this.errorDoc.insertString(this.errorDoc.getLength(), this.numErrorsString + MSConstants.newline, this.ErrorText.getStyle("header"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to write error information" + MSConstants.newline + e));
        }
    }

    private void writeAllParams() {
        try {
            this.errorLocations = new Vector();
            this.ParamText.setText("");
            this.write("# Experiment Parameters #" + MSConstants.newline, "comment");
            this.write("exp.id=" + this.IDText.getText() + MSConstants.newline, "important");
            this.write("numOfMatches=" + this.numMatches + MSConstants.newline + MSConstants.newline, "important");
            for (int i = 0; i < this.numMatches; ++i) {
                this.write("# Match " + i + " Parameters #" + MSConstants.newline, "comment");
                MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(i));
                String gameType = tab.getGameType();
                int groupSize = tab.getGroupSize();
                int reps = tab.getNumReps();
                int repData = tab.getRepetitionOf();
                ParamVerifier verifier = tab.getVerifier();
                Hashtable allValues = (Hashtable)this.paramValues.get(new Integer(i));
                if (repData == -1) {
                    this.write("match." + i + ".type=" + gameType + MSConstants.newline, "important");
                }
                if (repData == -1 || this.groupSizeChanged(i)) {
                    String str = "match." + i + ".groupSize=" + groupSize + MSConstants.newline;
                    boolean verified = true;
                    String error = "";
                    try {
                        verified = verifier.verifyGroupSize(groupSize);
                    }
                    catch (InvalidParameterException e) {
                        error = e.getMessage();
                        verified = false;
                    }
                    if (verified) {
                        this.write(str, "important");
                    } else {
                        this.writeError(str, error);
                    }
                }
                Vector pStrings = (Vector)this.paramStrings.get(new Integer(i));
                Vector eStrings = (Vector)this.errorStrings.get(new Integer(i));
                Vector pStyles = (Vector)this.paramStyles.get(new Integer(i));
                if (pStrings == null || eStrings == null || pStyles == null) {
                    this.write(MSConstants.newline + "", "normal");
                    continue;
                }
                for (int j = 0; j < pStrings.size(); ++j) {
                    String error = (String)eStrings.get(j);
                    String str = (String)pStrings.get(j) + MSConstants.newline;
                    String style = (String)pStyles.get(j);
                    if (error == null) {
                        this.write(str, style);
                        continue;
                    }
                    this.writeError(str, error);
                }
                if (repData == -1 && reps > 1) {
                    this.write("match." + i + ".repetitions=" + reps + MSConstants.newline, "important");
                }
                this.write("" + MSConstants.newline, "normal");
                this.repaint();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error when attempting to write all Params to the text area" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void write(String str, String style) throws Exception {
        this.doc.insertString(this.doc.getLength(), str, this.ParamText.getStyle(style));
    }

    private void writeError(String str, String error) throws Exception {
        Rectangle rec = this.ParamText.modelToView(this.doc.getLength());
        this.errorLocations.add(rec);
        this.errorMap.put(rec, error);
        this.doc.insertString(this.doc.getLength(), str, this.ParamText.getStyle("error"));
    }

    private void scanForErrors(int match) {
        try {
            this.errorStrings.put(new Integer(match), new Vector());
            Vector eStrings = (Vector)this.errorStrings.get(new Integer(match));
            MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
            if (tab == null) {
                return;
            }
            Vector panels = tab.getPanelGroup();
            if (panels == null) {
                return;
            }
            for (int i = 0; i < panels.size(); ++i) {
                ParamPanel panel = (ParamPanel)panels.get(i);
                String value = panel.getValue();
                if (!panel.isIncluded()) continue;
                String error = this.checkForError(match, panel.getParam(), value);
                eStrings.add(error);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error when scanning for errors in parameter creation" + MSConstants.newline + e));
        }
    }

    private String checkForError(int match, Param prm, String value) {
        Hashtable allValues = (Hashtable)this.paramValues.get(new Integer(match));
        try {
            prm.verify(value, allValues);
        }
        catch (InvalidParameterException e) {
            return e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown Error";
        }
        return null;
    }

    private void updateParamStrings(int match) {
        try {
            this.paramStrings.put(new Integer(match), new Vector());
            this.paramStyles.put(new Integer(match), new Vector());
            this.paramValues.put(new Integer(match), new Hashtable());
            MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
            if (tab == null) {
                return;
            }
            Vector pStrings = (Vector)this.paramStrings.get(new Integer(match));
            Vector panels = tab.getPanelGroup();
            Vector pStyles = (Vector)this.paramStyles.get(new Integer(match));
            Hashtable values = (Hashtable)this.paramValues.get(new Integer(match));
            if (panels == null) {
                return;
            }
            for (int i = 0; i < panels.size(); ++i) {
                String absoluteValue;
                ParamPanel panel = (ParamPanel)panels.get(i);
                Param prm = panel.getParam();
                String name = prm.getParamName();
                String value = panel.getValue();
                if (panel.isIncluded()) {
                    pStrings.add("match." + match + "." + name + "=" + value);
                    if (prm.isGameSpecific()) {
                        pStyles.add("gameSpecific");
                    } else {
                        pStyles.add("normal");
                    }
                }
                if ((absoluteValue = this.getAbsoluteValue(match, prm, panel)) == null) continue;
                values.put(name, absoluteValue);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error updating match param data for match " + match + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    public Hashtable getAllValuesTable(int match) {
        MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
        Vector panels = tab.getPanelGroup();
        Hashtable<String, String> values = new Hashtable<String, String>();
        for (int i = 0; i < panels.size(); ++i) {
            ParamPanel panel = (ParamPanel)panels.get(i);
            Param prm = panel.getParam();
            String absoluteValue = this.getAbsoluteValue(match, prm, panel);
            if (absoluteValue == null) continue;
            values.put(prm.getParamName(), absoluteValue);
        }
        return values;
    }

    private String getAbsoluteValue(int match, Param prm, ParamPanel ppanel) {
        String value = ppanel.getValue();
        if (ppanel.isIncluded()) {
            return value;
        }
        MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
        int parentMatch = tab.getRepetitionOf();
        if (parentMatch == -1) {
            return null;
        }
        ParamPanel parentPanel = this.getParentPanel(match - 1, ppanel);
        if (parentPanel == null) {
            return null;
        }
        Param parentPrm = parentPanel.getParam();
        return this.getAbsoluteValue(match - 1, parentPrm, parentPanel);
    }

    private ParamPanel getParentPanel(int parentMatch, ParamPanel panel) {
        try {
            Param childPrm = panel.getParam();
            String paramName = childPrm.getParamName();
            MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(parentMatch));
            Vector parentPanels = tab.getPanelGroup();
            for (int i = 0; i < parentPanels.size(); ++i) {
                ParamPanel parentPanel = (ParamPanel)parentPanels.get(i);
                Param parentPrm = parentPanel.getParam();
                if (!parentPrm.getParamName().equals(paramName)) continue;
                return parentPanel;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("No parent panel found in match " + parentMatch + MSConstants.newline + e));
            return null;
        }
    }

    private void exitForm(WindowEvent evt) {
        int i;
        this.setVisible(false);
        this.removeAll();
        EventListener[] list = this.ExitMenuItem.getListeners(ActionListener.class);
        if (list != null) {
            for (i = 0; i < list.length; ++i) {
                this.ExitMenuItem.removeActionListener((ActionListener)list[i]);
            }
        }
        if ((list = this.MatchCommitButton.getListeners(ActionListener.class)) != null) {
            for (i = 0; i < list.length; ++i) {
                this.MatchCommitButton.removeActionListener((ActionListener)list[i]);
            }
        }
        if ((list = this.LoadFileMenuItem.getListeners(ActionListener.class)) != null) {
            for (i = 0; i < list.length; ++i) {
                this.LoadFileMenuItem.removeActionListener((ActionListener)list[i]);
            }
        }
        if ((list = this.NumMatchesBox.getListeners(ActionListener.class)) != null) {
            for (i = 0; i < list.length; ++i) {
                this.NumMatchesBox.removeActionListener((ActionListener)list[i]);
            }
        }
        if ((list = this.ResetMenuItem.getListeners(ActionListener.class)) != null) {
            for (i = 0; i < list.length; ++i) {
                this.ResetMenuItem.removeActionListener((ActionListener)list[i]);
            }
        }
        if ((list = this.SaveButton.getListeners(ActionListener.class)) != null) {
            for (i = 0; i < list.length; ++i) {
                this.SaveButton.removeActionListener((ActionListener)list[i]);
            }
        }
        list = this.getListeners(WindowListener.class);
        for (i = 0; i < list.length; ++i) {
            this.removeWindowListener((WindowListener)list[i]);
        }
        this.doc = null;
        this.errorDoc = null;
        this.paramStrings = null;
        this.errorStrings = null;
        this.paramStyles = null;
        this.matchTabs = null;
        this.errorLocations = null;
        this.errorMap = null;
        this.userClick = null;
        this.numErrorsString = null;
        this.paramValues = null;
        this.props = null;
        this.repColors = null;
        this.gameTypes = null;
        this.ParamText = null;
        this.ErrorText = null;
        this.dispose();
    }

    public static void main(String[] args) {
        ParamGUI pgui = new ParamGUI();
        pgui.resetAndWait();
        pgui.pack();
        pgui.centerOnScreen();
        pgui.setVisible(true);
    }

    public void initMatchParams() {
        try {
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ParamGUI.this.CardPanel.removeAll();
                    for (int m = 0; m < ParamGUI.this.numMatches; ++m) {
                        MatchParamTab tab = (MatchParamTab)ParamGUI.this.matchTabs.get(new Integer(m));
                        if (tab != null) {
                            int repMax;
                            int numReps = tab.getNumReps();
                            if (numReps >= (repMax = ParamGUI.this.numMatches - m + 1)) {
                                numReps = repMax - 1;
                            }
                            tab.setNumReps(numReps);
                            ParamGUI.this.CardPanel.add((Component)tab, "Match " + m);
                            continue;
                        }
                        tab = ParamGUI.this.createMatchCard(m);
                        tab.fillRepBox(ParamGUI.this.numMatches, 1);
                        ParamGUI.this.matchTabs.put(new Integer(m), tab);
                    }
                    ParamGUI.this.recalculateRepetitions();
                    ParamGUI.this.CardPanel.setSelectedIndex(0);
                    ParamGUI.this.CardPanel.revalidate();
                    ParamGUI.this.CardPanel.updateUI();
                    ParamGUI.this.CardPanel.repaint();
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Failed to initialize the fixed parameters" + MSConstants.newline + e));
        }
    }

    private void recalculateRepetitions() {
        for (int m = 0; m < this.numMatches; ++m) {
            MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(m));
            int numReps = tab.getNumReps();
            tab.fillRepBox(this.numMatches, numReps);
            tab.RepetitionsBox.setSelectedItem(new Integer(numReps));
            Color c = this.getRepColor(numReps);
            if (tab.getRepetitionOf() == -1) {
                this.CardPanel.setForegroundAt(m, c);
            }
            for (int i = m + 1; i < m + numReps; ++i) {
                MatchParamTab child = (MatchParamTab)this.matchTabs.get(new Integer(i));
                this.CardPanel.setForegroundAt(i, c);
                this.CardPanel.updateUI();
            }
        }
        this.CardPanel.updateUI();
    }

    public void alterRepetitions(int match) {
        MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
        if (tab == null) {
            return;
        }
        int numReps = tab.getNumReps();
        for (int i = match + 1; i < match + numReps; ++i) {
            MatchParamTab child = (MatchParamTab)this.matchTabs.get(new Integer(i));
            if (child == null) continue;
            child.setRepetition(match, tab.getGameType(), tab.getGroupSize());
        }
    }

    private Color getRepColor(int reps) {
        ++this.colorIndex;
        if (this.colorIndex >= this.repColors.size()) {
            this.colorIndex = 0;
        }
        Color repColor = (Color)this.repColors.get(this.colorIndex);
        if (reps == 1) {
            repColor = Color.black;
        }
        return repColor;
    }

    public void processRepetitions(int match, int reps) {
        try {
            MatchParamTab child;
            int i;
            MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
            String gameType = tab.getGameType();
            int groupSize = tab.getGroupSize();
            Vector pathways = tab.getPathways();
            Color repColor = this.getRepColor(reps);
            if (tab.getRepetitionOf() == -1) {
                this.CardPanel.setForegroundAt(match, repColor);
            }
            tab.setNumReps(reps);
            for (i = match + 1; i < match + reps; ++i) {
                child = (MatchParamTab)this.matchTabs.get(new Integer(i));
                int currentRep = child.getRepetitionOf();
                if (currentRep == match) {
                    this.CardPanel.setForegroundAt(i, repColor);
                    continue;
                }
                child.GameTypeBox.setSelectedItem(gameType);
                child.GroupSizeBox.setSelectedItem(new Integer(groupSize));
                ActionListener listener = ((ActionListener[])child.RepetitionsBox.getListeners(ActionListener.class))[0];
                child.RepetitionsBox.removeActionListener(listener);
                child.RepetitionsBox.setSelectedItem(new Integer(1));
                child.RepetitionsBox.addActionListener(listener);
                child.setRepetition(match, gameType, groupSize);
                this.CardPanel.setForegroundAt(i, repColor);
            }
            for (i = match + reps; i < this.numMatches; ++i) {
                child = (MatchParamTab)this.matchTabs.get(new Integer(i));
                if (child.getRepetitionOf() != match) continue;
                child.undoRepetition();
                this.CardPanel.setForegroundAt(i, Color.black);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process " + reps + " repetitions for match " + match + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    public void applyToReps(int match) {
        MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(match));
        int numReps = tab.getNumReps();
        for (int i = match + 1; i < match + numReps; ++i) {
            MatchParamTab child = (MatchParamTab)this.matchTabs.get(new Integer(i));
            child.GameTypeBox.setSelectedItem(tab.getGameType());
            child.GroupSizeBox.setSelectedItem(new Integer(tab.getGroupSize()));
            child.setRepetition(match, tab.getGameType(), tab.getGroupSize());
        }
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }

    public void loadFile(File paramsFile) {
        try {
            FileInputStream in = new FileInputStream(paramsFile);
            this.props = new Properties();
            this.props.load(in);
            Parameters params = null;
            try {
                log.info((Object)("Parsing parameter file " + paramsFile.getName() + " at " + paramsFile.getPath()));
                params = new Parameters(paramsFile);
            }
            catch (Exception e) {
                log.error((Object)"Invalid parameter file received at ParamGUI - user notified");
                JOptionPane.showMessageDialog(null, "Invalid parameter file: " + e.getMessage(), "Input Error", 0);
            }
            if (params == null) {
                return;
            }
            this.numMatches = params.getNumMatches();
            this.IDText.setText("" + params.getId());
            this.NumMatchesBox.setSelectedItem(new Integer(this.numMatches));
            this.initMatchParams();
            Vector matches = params.getMatches();
            for (int m = 0; m < matches.size(); ++m) {
                Match match = (Match)matches.get(m);
                MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(m));
                String gameType = match.getGameType();
                tab.GameTypeBox.setSelectedItem(gameType);
                int groupSize = match.getGroupSize();
                tab.GroupSizeBox.setSelectedItem(new Integer(groupSize));
                String repetitions_str = this.getProperty(m, "repetitions");
                int repetitions = repetitions_str == null ? 1 : Integer.parseInt(repetitions_str);
                tab.RepetitionsBox.setSelectedItem(new Integer(repetitions));
                boolean numGames = false;
                this.parseParameters(m);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to load a parameter file's base values" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void parseParameters(int m) {
        MatchParamTab tab = (MatchParamTab)this.matchTabs.get(new Integer(m));
        Vector panels = tab.getPanelGroup();
        for (int i = 0; i < panels.size(); ++i) {
            ParamPanel panel = (ParamPanel)panels.get(i);
            Param prm = panel.getParam();
            String paramName = prm.getParamName();
            String value = this.getProperty(m, paramName);
            if (value == null) {
                panel.setDefaultValue();
                continue;
            }
            panel.setValue(value);
            panel.setIncluded();
        }
    }

    private String getProperty(int match, String prop) {
        try {
            String fullstr = "match." + match + "." + prop;
            String val = this.props.getProperty(fullstr);
            return val;
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve string match property " + prop + MSConstants.newline + e));
            return null;
        }
    }

    public void finalize() {
        System.out.println("The parameter service has been shut down and freed from memory");
        log.info((Object)"The parameter service has been shut down and freed from memory");
    }
}

