/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MessageSendView
extends JDialog {
    private ButtonGroup GroupSelectionButtonGroup;
    private JPanel TitlePanel;
    private JLabel TitleLabel;
    private JPanel ButtonsPanel;
    private JPanel GroupSelectionPanel;
    private JPanel AllSubjectsPanel;
    private JRadioButton AllSubjectsButton;
    private JPanel SelectPartnerPanel;
    private JRadioButton SelectPartnerButton;
    private JTextField PartnerNumText;
    private JLabel PartnerSubjectsLabel;
    private JPanel SelectFromListPanel;
    private JRadioButton SelectFromListButton;
    private JScrollPane SubjectListScroller;
    private JList SubjectsList;
    private JScrollPane TextScroller;
    private JTextArea MessageText;
    private JPanel SubmitPanel;
    private JButton CancelButton;
    private JButton SubmitButton;

    public MessageSendView(JFrame owner, int client_id) {
        super(owner);
        this.initComponents();
        this.fillList();
        this.initialSelection(client_id);
        this.centerOnScreen();
    }

    private void initComponents() {
        this.GroupSelectionButtonGroup = new ButtonGroup();
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.ButtonsPanel = new JPanel();
        this.GroupSelectionPanel = new JPanel();
        this.AllSubjectsPanel = new JPanel();
        this.AllSubjectsButton = new JRadioButton();
        this.SelectPartnerPanel = new JPanel();
        this.SelectPartnerButton = new JRadioButton();
        this.PartnerNumText = new JTextField();
        this.PartnerSubjectsLabel = new JLabel();
        this.SelectFromListPanel = new JPanel();
        this.SelectFromListButton = new JRadioButton();
        this.SubjectListScroller = new JScrollPane();
        this.SubjectsList = new JList();
        this.TextScroller = new JScrollPane();
        this.MessageText = new JTextArea();
        this.SubmitPanel = new JPanel();
        this.CancelButton = new JButton();
        this.SubmitButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setTitle("Send Message");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MessageSendView.this.exitForm(evt);
            }
        });
        this.TitleLabel.setText("Message Subjects");
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setFont(new Font("Book Antiqua", 1, 14));
        this.TitlePanel.add(this.TitleLabel);
        this.getContentPane().add(this.TitlePanel);
        this.ButtonsPanel.setLayout(new GridLayout(1, 2));
        this.GroupSelectionPanel.setLayout(new BoxLayout(this.GroupSelectionPanel, 1));
        this.AllSubjectsPanel.setLayout(new FlowLayout(0));
        this.AllSubjectsButton.setSelected(true);
        this.AllSubjectsButton.setText("All Subjects");
        this.GroupSelectionButtonGroup.add(this.AllSubjectsButton);
        this.AllSubjectsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSendView.this.AllSubjectsButtonActionPerformed(evt);
            }
        });
        this.AllSubjectsPanel.add(this.AllSubjectsButton);
        this.GroupSelectionPanel.add(this.AllSubjectsPanel);
        this.SelectPartnerPanel.setLayout(new FlowLayout(0));
        this.SelectPartnerButton.setText("All Player");
        this.GroupSelectionButtonGroup.add(this.SelectPartnerButton);
        this.SelectPartnerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSendView.this.SelectPartnerButtonActionPerformed(evt);
            }
        });
        this.SelectPartnerPanel.add(this.SelectPartnerButton);
        this.PartnerNumText.setPreferredSize(new Dimension(30, 21));
        this.PartnerNumText.setEnabled(false);
        this.SelectPartnerPanel.add(this.PartnerNumText);
        this.PartnerSubjectsLabel.setText(" Subjects");
        this.PartnerSubjectsLabel.setForeground(Color.black);
        this.SelectPartnerPanel.add(this.PartnerSubjectsLabel);
        this.GroupSelectionPanel.add(this.SelectPartnerPanel);
        this.SelectFromListPanel.setLayout(new FlowLayout(0));
        this.SelectFromListButton.setText("Select Subjects from List");
        this.GroupSelectionButtonGroup.add(this.SelectFromListButton);
        this.SelectFromListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSendView.this.SelectFromListButtonActionPerformed(evt);
            }
        });
        this.SelectFromListPanel.add(this.SelectFromListButton);
        this.GroupSelectionPanel.add(this.SelectFromListPanel);
        this.ButtonsPanel.add(this.GroupSelectionPanel);
        this.SubjectsList.setEnabled(false);
        this.SubjectListScroller.setViewportView(this.SubjectsList);
        this.ButtonsPanel.add(this.SubjectListScroller);
        this.getContentPane().add(this.ButtonsPanel);
        this.TextScroller.setHorizontalScrollBarPolicy(31);
        this.TextScroller.setPreferredSize(new Dimension(500, 100));
        this.TextScroller.setViewportView(this.MessageText);
        this.getContentPane().add(this.TextScroller);
        this.SubmitPanel.setLayout(new GridLayout(1, 0));
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSendView.this.CancelButtonActionPerformed(evt);
            }
        });
        this.SubmitPanel.add(this.CancelButton);
        this.SubmitButton.setText("Submit");
        this.SubmitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSendView.this.SubmitButtonActionPerformed(evt);
            }
        });
        this.SubmitPanel.add(this.SubmitButton);
        this.getContentPane().add(this.SubmitPanel);
        this.pack();
    }

    private void SelectPartnerButtonActionPerformed(ActionEvent evt) {
        this.SubjectsList.setEnabled(false);
        this.PartnerNumText.setEnabled(true);
    }

    private void AllSubjectsButtonActionPerformed(ActionEvent evt) {
        this.SubjectsList.setEnabled(false);
        this.PartnerNumText.setEnabled(false);
    }

    private void SelectFromListButtonActionPerformed(ActionEvent evt) {
        this.SubjectsList.setEnabled(true);
        this.PartnerNumText.setEnabled(false);
    }

    private void SubmitButtonActionPerformed(ActionEvent evt) {
        int[] subject_ids = new int[1];
        if (this.AllSubjectsButton.isSelected()) {
            subject_ids = new int[ServerVariables.clients.size()];
            for (int i = 0; i < subject_ids.length; ++i) {
                subject_ids[i] = i;
            }
        }
        if (this.SelectPartnerButton.isSelected()) {
            int partnerNum;
            subject_ids = new int[ServerVariables.clients.size() / ServerVariables.groupSize];
            try {
                partnerNum = Integer.parseInt(this.PartnerNumText.getText());
                if (partnerNum < 0 || partnerNum >= ServerVariables.groupSize) {
                    throw new Exception("Invalid partner number");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Please enter a valid partner number between 0 (inclusive) and the group size (exclusive)", "Invalid Partner Number", 0);
                return;
            }
            int j = 0;
            for (int i = 0; i < ServerVariables.clients.size(); ++i) {
                if (((ClientData)ServerVariables.clients.get(i)).getPartnerNum() != partnerNum) continue;
                subject_ids[j] = i;
                ++j;
            }
        }
        if (this.SelectFromListButton.isSelected()) {
            subject_ids = this.SubjectsList.getSelectedIndices();
        }
        ServerVariables.ui.sendMessages(subject_ids, this.MessageText.getText());
        this.setVisible(false);
        this.dispose();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new MessageSendView(null, -1).setVisible(true);
    }

    private void fillList() {
        Vector<String> subjectNames = new Vector<String>();
        Vector clients = ServerVariables.clients;
        for (int i = 0; i < clients.size(); ++i) {
            subjectNames.add(((ClientData)clients.get(i)).getName());
        }
        this.SubjectsList.setListData(subjectNames);
    }

    private void initialSelection(int client_id) {
        if (client_id >= 0) {
            this.getContentPane().remove(this.ButtonsPanel);
            String clientName = ((ClientData)ServerVariables.clients.get(client_id)).getName();
            this.TitleLabel.setText("Message " + clientName);
            this.SelectFromListButton.setSelected(true);
            this.SubjectsList.setEnabled(true);
            this.SubjectsList.setSelectedIndex(client_id);
            this.TextScroller.setPreferredSize(new Dimension(500, 75));
            this.pack();
        }
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

