/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.interfaces.ParamGUI;
import edu.caltech.ssel.multistage.server.interfaces.ParamPanel;
import edu.caltech.ssel.multistage.server.util.Param;
import edu.caltech.ssel.multistage.server.util.ParamVerifier;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Category;

public class MatchParamTab
extends JPanel {
    private int match;
    private String gameType;
    private int groupSize;
    private int repetitionOf;
    private int numReps;
    private Vector mParams;
    private Vector gParams;
    private Vector panelGroup;
    private ParamVerifier verifier;
    private ParamGUI pgui;
    private Vector pathways;
    public JPanel MatchTitlePanel;
    public JLabel MatchTitleLabel;
    public JPanel MatchInfoPanel;
    public JLabel MatchInfoLabel;
    public JPanel SelectPanel;
    public JLabel GameTypeLabel;
    public JComboBox GameTypeBox;
    public JLabel RepetitionsLabel;
    public JComboBox RepetitionsBox;
    public JLabel GroupSizeLabel;
    public JComboBox GroupSizeBox;
    public JScrollPane MatchParamScroller;
    public JPanel MatchParamPanel;
    public JButton ApplyRepsButton;
    private static Category log = Category.getInstance(MatchParamTab.class);

    public MatchParamTab(int match, ParamGUI pgui, Vector gameTypes) {
        this.match = match;
        this.pgui = pgui;
        this.pathways = new Vector();
        this.initComponents();
        this.initialize();
        this.fillGameTypeBox(gameTypes);
        this.fillMiscBoxes();
        this.panelGroup = new Vector();
        this.numReps = 1;
        this.repetitionOf = -1;
        this.initMatchParams();
        this.displayParams();
    }

    private void fillGameTypeBox(Vector gameTypes) {
        for (int i = 0; i < gameTypes.size(); ++i) {
            String gtype = (String)gameTypes.get(i);
            this.GameTypeBox.addItem(gtype);
        }
    }

    private void fillMiscBoxes() {
        for (int i = 0; i < 150; ++i) {
            Integer element = new Integer(i + 1);
            this.GroupSizeBox.addItem(element);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void initialize() {
        this.MatchTitlePanel = new JPanel();
        this.MatchTitleLabel = new JLabel();
        this.MatchInfoPanel = new JPanel();
        this.MatchInfoLabel = new JLabel();
        this.SelectPanel = new JPanel();
        this.GameTypeLabel = new JLabel();
        this.GameTypeBox = new JComboBox();
        this.RepetitionsLabel = new JLabel();
        this.RepetitionsBox = new JComboBox();
        this.GroupSizeLabel = new JLabel();
        this.GroupSizeBox = new JComboBox();
        this.MatchParamScroller = new JScrollPane();
        this.MatchParamPanel = new JPanel();
        this.ApplyRepsButton = new JButton();
        this.setLayout(new BoxLayout(this, 1));
        this.MatchTitlePanel.setBackground(Color.white);
        this.MatchTitlePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        this.MatchTitleLabel.setFont(new Font("Arial Black", 0, 18));
        this.MatchTitleLabel.setForeground(Color.red);
        this.MatchTitleLabel.setText("Match " + this.match);
        this.MatchTitlePanel.add(this.MatchTitleLabel);
        this.add(this.MatchTitlePanel);
        this.MatchInfoPanel.setBackground(new Color(218, 218, 247));
        this.MatchInfoPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 27));
        this.MatchInfoLabel.setForeground(Color.black);
        this.MatchInfoLabel.setText("Freestanding Match");
        this.MatchInfoPanel.add(this.MatchInfoLabel);
        this.add(this.MatchInfoPanel);
        this.SelectPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 38));
        this.GameTypeLabel.setFont(new Font("Dialog", 1, 14));
        this.GameTypeLabel.setForeground(Color.black);
        this.GameTypeLabel.setText("Game Type");
        this.SelectPanel.add(this.GameTypeLabel);
        this.GameTypeBox.setToolTipText("Select the type of match to be played");
        this.GameTypeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchParamTab.this.GameTypeBoxActionPerformed(evt);
            }
        });
        this.SelectPanel.add(this.GameTypeBox);
        this.RepetitionsLabel.setFont(new Font("Dialog", 1, 14));
        this.RepetitionsLabel.setForeground(Color.black);
        this.RepetitionsLabel.setText("Repetitions");
        this.SelectPanel.add(this.RepetitionsLabel);
        this.RepetitionsBox.setMinimumSize(new Dimension(50, 26));
        this.RepetitionsBox.setPreferredSize(new Dimension(60, 26));
        this.RepetitionsBox.setToolTipText("Select how many matches will be clones of this match");
        this.RepetitionsBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchParamTab.this.RepetitionsBoxActionPerformed(evt);
            }
        });
        this.SelectPanel.add(this.RepetitionsBox);
        this.GroupSizeLabel.setFont(new Font("Dialog", 1, 14));
        this.GroupSizeLabel.setForeground(Color.black);
        this.GroupSizeLabel.setText("Group Size");
        this.SelectPanel.add(this.GroupSizeLabel);
        this.GroupSizeBox.setMinimumSize(new Dimension(50, 26));
        this.GroupSizeBox.setPreferredSize(new Dimension(60, 26));
        this.GroupSizeBox.setToolTipText("Select how many players per group in this match");
        this.GroupSizeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchParamTab.this.GroupSizeBoxActionPerformed(evt);
            }
        });
        this.SelectPanel.add(this.GroupSizeBox);
        this.ApplyRepsButton.setText("Apply to Repetitions");
        this.ApplyRepsButton.setToolTipText("Click to apply the settings of this match to all its repetitions");
        this.ApplyRepsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatchParamTab.this.pgui.applyToReps(MatchParamTab.this.match);
                JOptionPane.showMessageDialog(MatchParamTab.this.pgui, "Settings applied to all repetitions");
            }
        });
        this.SelectPanel.add(this.ApplyRepsButton);
        this.add(this.SelectPanel);
        this.MatchParamScroller.setViewportBorder(new TitledBorder("Option Parameters"));
        this.MatchParamScroller.setMaximumSize(new Dimension(32000, 320));
        this.MatchParamScroller.setMinimumSize(new Dimension(800, 320));
        this.MatchParamScroller.setPreferredSize(new Dimension(800, 320));
        this.MatchParamPanel.setLayout(new BoxLayout(this.MatchParamPanel, 1));
        this.MatchParamPanel.setMaximumSize(new Dimension(3209482, 23423443));
        this.MatchParamPanel.setMinimumSize(new Dimension(400, 300));
        this.MatchParamPanel.setPreferredSize(new Dimension(400, 280));
        this.MatchParamScroller.setViewportView(this.MatchParamPanel);
        this.add(this.MatchParamScroller);
    }

    private void GameTypeBoxActionPerformed(ActionEvent evt) {
        try {
            String gameType = (String)this.GameTypeBox.getSelectedItem();
            if (!gameType.equals(this.gameType)) {
                this.gameType = gameType;
                this.loadParameters(gameType, this.groupSize);
                this.initMatchParams();
                this.displayParams();
            }
            this.pgui.alterRepetitions(this.match);
        }
        catch (Exception e) {
            log.error((Object)("Error processing GameBox action" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void GroupSizeBoxActionPerformed(ActionEvent evt) {
        try {
            Integer groupSize = (Integer)this.GroupSizeBox.getSelectedItem();
            int gSize = groupSize;
            if (this.groupSize != gSize) {
                this.groupSize = gSize;
                this.loadParameters(this.gameType, this.groupSize);
                this.initMatchParams();
                this.displayParams();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to change the group size through the GroupSizeBox" + MSConstants.newline + e));
        }
    }

    private void loadParameters(String gameType, int groupSize) {
        try {
            ParamVerifier verifier = (ParamVerifier)Class.forName("edu.caltech.ssel.projects.multistage.server.util.paramverifiers." + gameType + "Verifier").newInstance();
            verifier.fillParams(groupSize);
            this.mParams = verifier.getParams();
            this.verifier = verifier;
        }
        catch (Exception e) {
            log.error((Object)("Error loading game type verifier" + MSConstants.newline + e));
        }
    }

    public void displayParams() {
        try {
            Runnable doUpdate = new Runnable(){

                public void run() {
                    MatchParamTab.this.MatchParamPanel.removeAll();
                    JPanel matchParams = new JPanel();
                    matchParams.setLayout(new BoxLayout(matchParams, 1));
                    TitledBorder border = new TitledBorder("Match Parameters");
                    border.setTitleColor(Color.black);
                    border.setBorder(BorderFactory.createEtchedBorder(0));
                    matchParams.setBorder(border);
                    Vector<JPanel> gameParams = new Vector<JPanel>();
                    Vector group = MatchParamTab.this.panelGroup;
                    if (group != null) {
                        int i;
                        for (i = 0; i < group.size(); ++i) {
                            JPanel gamePanel;
                            ParamPanel ppanel = (ParamPanel)group.get(i);
                            JPanel panel = ppanel.getPanel();
                            panel.setPreferredSize(new Dimension(800, 37));
                            panel.setMaximumSize(new Dimension(1200, 37));
                            panel.setMinimumSize(new Dimension(400, 37));
                            int gamenum = ppanel.getGameNum();
                            if (gamenum < 0) {
                                matchParams.add(ppanel.getPanel());
                                continue;
                            }
                            if (gamenum < gameParams.size()) {
                                gamePanel = (JPanel)gameParams.get(gamenum);
                                gamePanel.add(ppanel.getPanel());
                                continue;
                            }
                            gamePanel = new JPanel();
                            gamePanel.setLayout(new BoxLayout(gamePanel, 1));
                            TitledBorder tborder = new TitledBorder("Game " + gamenum + " Parameters");
                            tborder.setTitleColor(Color.black);
                            tborder.setBorder(BorderFactory.createEtchedBorder(0));
                            gamePanel.setBorder(tborder);
                            gamePanel.add(ppanel.getPanel());
                            gameParams.add(gamePanel);
                        }
                        matchParams.setPreferredSize(new Dimension(400, 20 + matchParams.getComponentCount() * 37));
                        MatchParamTab.this.MatchParamPanel.add(matchParams);
                        for (i = 0; i < gameParams.size(); ++i) {
                            JPanel gameParam = (JPanel)gameParams.get(i);
                            gameParam.setPreferredSize(new Dimension(400, 20 + 37 * gameParam.getComponentCount()));
                            MatchParamTab.this.MatchParamPanel.add(gameParam);
                        }
                        MatchParamTab.this.MatchParamPanel.setPreferredSize(new Dimension(400, 30 * MatchParamTab.this.MatchParamPanel.getComponentCount() + group.size() * 37));
                    }
                    MatchParamTab.this.validate();
                    MatchParamTab.this.repaint();
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to display the panels for match " + this.match + MSConstants.newline + e));
        }
    }

    private Hashtable mapValues() {
        Hashtable<String, ParamPanel> oldPanels = new Hashtable<String, ParamPanel>();
        if (this.panelGroup != null) {
            for (int i = 0; i < this.panelGroup.size(); ++i) {
                ParamPanel panel = (ParamPanel)this.panelGroup.get(i);
                Param prm = panel.getParam();
                String paramName = prm.getParamName();
                oldPanels.put(paramName, panel);
            }
        }
        return oldPanels;
    }

    private void initMatchParams() {
        try {
            Hashtable oldPanels = this.mapValues();
            this.panelGroup = new Vector();
            if (this.mParams == null || this.gParams == null) {
                Integer gSize = (Integer)this.GroupSizeBox.getSelectedItem();
                String gType = (String)this.GameTypeBox.getSelectedItem();
                if (gSize == null || gType == null) {
                    return;
                }
                this.loadParameters(gType, gSize);
            }
            for (int i = 0; i < this.mParams.size(); ++i) {
                Param prm = (Param)this.mParams.get(i);
                ParamPanel generated = this.generatePanel(prm, -1);
                generated.setParam(prm);
                this.panelGroup.add(generated);
                ParamPanel oldPanel = (ParamPanel)oldPanels.get(prm.getParamName());
                if (oldPanel == null) continue;
                String oldValue = oldPanel.getValue();
                boolean isIncluded = oldPanel.isIncluded();
                boolean isOptional = oldPanel.isOptional();
                if (oldValue != null) {
                    generated.setValue(oldValue);
                }
                if (isOptional) {
                    generated.setOptional(true);
                }
                if (!isIncluded) continue;
                generated.setIncluded();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to build parameter panels for match " + this.match));
            e.printStackTrace();
        }
    }

    private ParamPanel generatePanel(Param prm, int gamenum) {
        try {
            JPanel paramPanel = new JPanel();
            paramPanel.setLayout(new GridLayout(1, 3));
            JLabel paramLabel = new JLabel(prm.getLabel());
            paramLabel.setFont(new Font("Book Antiqua", 1, 14));
            if (prm.isGameSpecific()) {
                paramLabel.setForeground(Color.blue);
            } else {
                paramLabel.setForeground(Color.black);
            }
            paramPanel.add(paramLabel);
            JTextField tfield = new JTextField("" + prm.getInitialValue());
            paramPanel.add(tfield);
            JPanel optionPanel = new JPanel();
            optionPanel.setLayout(new FlowLayout(1, 40, 5));
            JLabel opReq = new JLabel();
            if (prm.isRequired()) {
                opReq.setText("Required");
            } else {
                opReq.setText("Optional");
            }
            opReq.setFont(new Font("Book Antiqua", 1, 14));
            if (prm.isRequired()) {
                opReq.setForeground(Color.red);
            } else {
                opReq.setForeground(Color.blue);
            }
            opReq.setHorizontalAlignment(0);
            optionPanel.add(opReq);
            JCheckBox optionCheck = new JCheckBox("Include?");
            if (prm.isRequired()) {
                optionCheck.setEnabled(false);
                optionCheck.setSelected(true);
            }
            optionPanel.add(optionCheck);
            paramPanel.add(optionPanel);
            paramPanel.setMaximumSize(new Dimension(30000, 30));
            return new ParamPanel(paramPanel, gamenum);
        }
        catch (Exception e) {
            log.error((Object)("Failed to generate a panel for a Param in the ParamGUI" + MSConstants.newline + e));
            e.printStackTrace();
            return null;
        }
    }

    private void RepetitionsBoxActionPerformed(ActionEvent evt) {
        try {
            if (this.RepetitionsBox.getSelectedItem() == null) {
                return;
            }
            int reps = (Integer)this.RepetitionsBox.getSelectedItem();
            this.pgui.processRepetitions(this.match, reps);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please select a valid number of repetitions", "Input Error", 0);
        }
    }

    public void setRepetition(int parent, String gameType, int groupSize) {
        this.gameType = gameType;
        this.groupSize = groupSize;
        this.loadParameters(gameType, groupSize);
        this.initMatchParams();
        this.displayParams();
        this.setRepetitionOf(parent);
        Vector panels = this.panelGroup;
        for (int j = 0; j < panels.size(); ++j) {
            ParamPanel panel = (ParamPanel)panels.get(j);
            panel.setOptional(true);
        }
        this.RepetitionsBox.setEnabled(false);
        this.GameTypeBox.setEnabled(false);
        this.MatchInfoLabel.setText("Repetition of Match " + this.repetitionOf);
    }

    public void undoRepetition() {
        this.setRepetitionOf(-1);
        Vector panels = this.panelGroup;
        for (int i = 0; i < panels.size(); ++i) {
            ParamPanel ppanel = (ParamPanel)panels.get(i);
            Param prm = ppanel.getParam();
            JPanel panel = ppanel.getPanel();
            JPanel optionPanel = (JPanel)panel.getComponent(2);
            JLabel optionText = (JLabel)optionPanel.getComponent(0);
            if (prm.isRequired()) {
                optionText.setText("Required");
                optionText.setForeground(Color.red);
            } else {
                optionText.setText("Optional");
                optionText.setForeground(Color.blue);
            }
            JCheckBox optionCheck = (JCheckBox)optionPanel.getComponent(1);
            if (!prm.isRequired()) continue;
            optionCheck.setSelected(true);
            optionCheck.setEnabled(false);
        }
        this.RepetitionsBox.setEnabled(true);
        this.GameTypeBox.setEnabled(true);
        this.MatchInfoLabel.setText("Freestanding Match");
    }

    public void fillRepBox(int numMatches, int current) {
        ActionListener listener = ((ActionListener[])this.RepetitionsBox.getListeners(ActionListener.class))[0];
        this.RepetitionsBox.removeActionListener(listener);
        this.RepetitionsBox.removeAllItems();
        for (int i = 1; i < numMatches - this.match + 1; ++i) {
            this.RepetitionsBox.addItem(new Integer(i));
        }
        this.RepetitionsBox.setSelectedItem(new Integer(current));
        this.RepetitionsBox.addActionListener(listener);
    }

    public void close() {
        this.pgui = null;
    }

    public String getGameType() {
        return this.gameType;
    }

    public void setGameType(String gameType) {
        this.gameType = gameType;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
    }

    public int getMatch() {
        return this.match;
    }

    public void setMatch(int match) {
        this.match = match;
    }

    public int getRepetitionOf() {
        return this.repetitionOf;
    }

    public void setRepetitionOf(int repetitionOf) {
        this.repetitionOf = repetitionOf;
    }

    public int getNumReps() {
        return this.numReps;
    }

    public void setNumReps(int numReps) {
        this.numReps = numReps;
    }

    public Vector getPanelGroup() {
        return this.panelGroup;
    }

    public ParamVerifier getVerifier() {
        return this.verifier;
    }

    public Vector getPathways() {
        return this.pathways;
    }
}

