/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Category;

public class LoginGUI
extends JDialog {
    private JPanel TitlePanel;
    private JLabel Title;
    private JPanel NamePanel;
    private JLabel NameLabel;
    private JTextField NameText;
    private JPanel EmailPanel;
    private JLabel EmailLabel;
    private JTextField emailText;
    private JPanel SubmitPanel;
    private JButton SubmitButton;
    private JPanel SubmitFiller;
    private JMenuBar MenuBar;
    private JMenu Options;
    private JMenuItem ExitMenuItem;
    private String name;
    private String email;
    private Mailbox box;
    private static Category log = Category.getInstance(LoginGUI.class);
    private boolean itest;

    public LoginGUI(boolean integratedTest, Mailbox loginBox, JFrame parent) {
        super((Frame)parent, true);
        this.itest = integratedTest;
        this.box = loginBox;
        this.initComponents();
        this.centerOnScreen();
    }

    private void initComponents() {
        this.setTitle("Experimenter Login");
        this.TitlePanel = new JPanel();
        this.Title = new JLabel();
        this.NamePanel = new JPanel();
        this.NameLabel = new JLabel();
        this.NameText = new JTextField();
        this.EmailPanel = new JPanel();
        this.EmailLabel = new JLabel();
        this.emailText = new JTextField();
        this.SubmitPanel = new JPanel();
        this.SubmitButton = new JButton();
        this.SubmitFiller = new JPanel();
        this.MenuBar = new JMenuBar();
        this.Options = new JMenu();
        this.ExitMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.Options.setText("Options");
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginGUI.this.ExitMenuItemAction(evt);
            }
        });
        this.Options.add(this.ExitMenuItem);
        this.MenuBar.add(this.Options);
        this.setJMenuBar(this.MenuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LoginGUI.this.exitForm(evt);
            }
        });
        this.Title.setText("Experimenter Login");
        this.Title.setForeground(Color.black);
        this.Title.setHorizontalAlignment(0);
        this.Title.setFont(new Font("Book Antiqua", 1, 24));
        this.TitlePanel.add(this.Title);
        this.getContentPane().add(this.TitlePanel);
        this.NameLabel.setText("Name:");
        this.NameLabel.setForeground(Color.black);
        this.NameLabel.setFont(new Font("Dialog", 1, 14));
        this.NamePanel.add(this.NameLabel);
        this.NameText.setFont(new Font("Dialog", 0, 14));
        this.NameText.setPreferredSize(new Dimension(200, 21));
        this.NamePanel.add(this.NameText);
        this.getContentPane().add(this.NamePanel);
        this.EmailLabel.setText("Email:");
        this.EmailLabel.setForeground(Color.black);
        this.EmailLabel.setFont(new Font("Dialog", 1, 14));
        this.EmailLabel.setPreferredSize(new Dimension(43, 20));
        this.EmailLabel.setMinimumSize(new Dimension(43, 20));
        this.EmailLabel.setMaximumSize(new Dimension(43, 20));
        this.EmailPanel.add(this.EmailLabel);
        this.emailText.setFont(new Font("Dialog", 0, 14));
        this.emailText.setPreferredSize(new Dimension(200, 21));
        this.EmailPanel.add(this.emailText);
        this.getContentPane().add(this.EmailPanel);
        this.SubmitPanel.setLayout(new FlowLayout(2));
        this.SubmitButton.setText("Submit");
        this.SubmitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginGUI.this.SubmitButtonAction(evt);
            }
        });
        this.SubmitPanel.add(this.SubmitButton);
        this.SubmitFiller.setPreferredSize(new Dimension(64, 10));
        this.SubmitPanel.add(this.SubmitFiller);
        this.getContentPane().add(this.SubmitPanel);
        this.pack();
    }

    private void ExitMenuItemAction(ActionEvent evt) {
        System.exit(0);
    }

    private void SubmitButtonAction(ActionEvent evt) {
        try {
            this.name = this.NameText.getText();
            this.email = this.emailText.getText();
            if (this.name == null || this.name.length() < 1) {
                JOptionPane.showMessageDialog(null, "You must enter a valid name to proceed", "Input Error", 0);
            } else if (this.email == null || this.email.length() < 1) {
                JOptionPane.showMessageDialog(null, "You must enter a valid email to proceed", "Input Error", 0);
            } else {
                this.box.deposit(this.name);
                this.box.deposit(this.email);
                this.setVisible(false);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the client information" + MSConstants.newline + e));
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new LoginGUI(false, null, null).setVisible(true);
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

