/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.apache.log4j.Priority;

public class LoggingMonitor
extends JPanel {
    private JPanel LogInfoPanel;
    private JLabel LMonLabel;
    private JPanel LogBlankFiller1;
    private JPanel LogBlankFiller2;
    private JPanel LogDisablePanel;
    private JPanel LogResolutionPanel;
    private JPanel LogClearPanel;
    private JButton DebugButton;
    private JButton InfoButton;
    private JButton WarnButton;
    private JScrollPane LogScroller;
    private JTextArea LogText;
    private JToggleButton DisableAutoScrolling;
    private JButton ClearLogsButton;
    private JButton MessageViewButton;
    private StringBuffer debugMessages = new StringBuffer();
    private StringBuffer infoMessages = new StringBuffer();
    private StringBuffer warnMessages = new StringBuffer();
    private StringBuffer chatMessages = new StringBuffer();
    private int loggingLevel = 20000;
    private boolean displayClientLog = true;
    private boolean displayNetworkLog = true;
    private boolean displayLocationInfo = false;

    public LoggingMonitor() {
        this.LogInfoPanel = new JPanel();
        this.LMonLabel = new JLabel();
        this.LogBlankFiller1 = new JPanel();
        this.LogBlankFiller2 = new JPanel();
        this.LogDisablePanel = new JPanel();
        this.LogResolutionPanel = new JPanel();
        this.LogClearPanel = new JPanel();
        this.DebugButton = new JButton();
        this.InfoButton = new JButton();
        this.WarnButton = new JButton();
        this.LogScroller = new JScrollPane();
        this.LogText = new JTextArea();
        this.DisableAutoScrolling = new JToggleButton();
        this.ClearLogsButton = new JButton();
        this.MessageViewButton = new JButton();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(Short.MAX_VALUE, 10000));
        this.LogInfoPanel.setLayout(new GridLayout(2, 6));
        this.LogInfoPanel.add(this.LogBlankFiller1);
        this.LMonLabel.setText("Logging Monitor");
        this.LMonLabel.setHorizontalAlignment(0);
        this.LMonLabel.setForeground(new Color(0, 51, 51));
        this.LMonLabel.setFont(new Font("Lucida Console", 0, 18));
        this.LogInfoPanel.add(this.LMonLabel);
        this.LogInfoPanel.add(this.LogBlankFiller2);
        this.DisableAutoScrolling.setText("Disable Autoscrolling");
        this.LogDisablePanel.add(this.DisableAutoScrolling);
        this.LogInfoPanel.add(this.LogDisablePanel);
        this.LogResolutionPanel.setLayout(new FlowLayout(1, 1, 5));
        this.DebugButton.setText("Debug");
        this.DebugButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggingMonitor.this.DebugButtonAction(evt);
            }
        });
        this.LogResolutionPanel.add(this.DebugButton);
        this.InfoButton.setText("Info");
        this.InfoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggingMonitor.this.InfoButtonAction(evt);
            }
        });
        this.InfoButton.setForeground(Color.red);
        this.LogResolutionPanel.add(this.InfoButton);
        this.WarnButton.setText("Warn");
        this.WarnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggingMonitor.this.WarnButtonAction(evt);
            }
        });
        this.LogResolutionPanel.add(this.WarnButton);
        this.MessageViewButton.setText("Messages");
        this.MessageViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggingMonitor.this.MessageViewButtonAction(evt);
            }
        });
        this.LogResolutionPanel.add(this.MessageViewButton);
        this.LogInfoPanel.add(this.LogResolutionPanel);
        this.ClearLogsButton.setText("Clear Logs");
        this.ClearLogsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggingMonitor.this.ClearLogsButtonAction(evt);
            }
        });
        this.LogClearPanel.add(this.ClearLogsButton);
        this.LogInfoPanel.add(this.LogClearPanel);
        this.add(this.LogInfoPanel);
        this.LogScroller.setVerticalScrollBarPolicy(22);
        this.LogScroller.setHorizontalScrollBarPolicy(30);
        this.LogScroller.setPreferredSize(new Dimension(1000, 500));
        this.LogText.setBorder(new SoftBevelBorder(0));
        this.LogScroller.setViewportView(this.LogText);
        this.add(this.LogScroller);
    }

    private void DebugButtonAction(ActionEvent evt) {
        this.LogText = new JTextArea();
        this.LogText.append(this.debugMessages.toString());
        this.LogScroller.setViewportView(this.LogText);
        this.loggingLevel = 10000;
        this.DebugButton.setForeground(Color.red);
        this.InfoButton.setForeground(Color.black);
        this.WarnButton.setForeground(Color.black);
        this.MessageViewButton.setForeground(Color.black);
    }

    private void InfoButtonAction(ActionEvent evt) {
        this.LogText = new JTextArea();
        this.LogText.append(this.infoMessages.toString());
        this.LogScroller.setViewportView(this.LogText);
        this.loggingLevel = 20000;
        this.DebugButton.setForeground(Color.black);
        this.InfoButton.setForeground(Color.red);
        this.WarnButton.setForeground(Color.black);
        this.MessageViewButton.setForeground(Color.black);
    }

    private void WarnButtonAction(ActionEvent evt) {
        this.LogText = new JTextArea();
        this.LogText.append(this.warnMessages.toString());
        this.LogScroller.setViewportView(this.LogText);
        this.loggingLevel = 30000;
        this.DebugButton.setForeground(Color.black);
        this.InfoButton.setForeground(Color.black);
        this.WarnButton.setForeground(Color.red);
        this.MessageViewButton.setForeground(Color.black);
    }

    private void MessageViewButtonAction(ActionEvent evt) {
        this.LogText = new JTextArea();
        this.LogText.append(this.chatMessages.toString());
        this.LogScroller.setViewportView(this.LogText);
        this.loggingLevel = 30001;
        this.DebugButton.setForeground(Color.black);
        this.InfoButton.setForeground(Color.black);
        this.WarnButton.setForeground(Color.black);
        this.MessageViewButton.setForeground(Color.red);
    }

    private void ClearLogsButtonAction(ActionEvent evt) {
        this.debugMessages = new StringBuffer();
        this.infoMessages = new StringBuffer();
        this.warnMessages = new StringBuffer();
        this.LogText = new JTextArea();
        this.LogScroller.setViewportView(this.LogText);
    }

    public void addChatMessage(String chatMsg) {
        final String fullMessage = chatMsg + MSConstants.newline;
        this.chatMessages.append(fullMessage);
        final int caretPosition = this.LogText.getCaretPosition();
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (LoggingMonitor.this.loggingLevel == 30001) {
                    LoggingMonitor.this.LogText.append(fullMessage);
                }
                if (!LoggingMonitor.this.DisableAutoScrolling.isSelected()) {
                    LoggingMonitor.this.LogText.setCaretPosition(LoggingMonitor.this.LogText.getText().length());
                } else {
                    LoggingMonitor.this.LogText.setCaretPosition(caretPosition);
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void addLogMessage(String logMsg, Priority p, String classInfo) {
        final String fullMessage = logMsg + MSConstants.newline;
        final Priority pr = p;
        if (classInfo != null && classInfo.length() > 1 && this.displayLocationInfo) {
            StringTokenizer classTokenizer = new StringTokenizer(classInfo, ".");
            boolean networkMessage = false;
            boolean clientMessage = false;
            while (classTokenizer.hasMoreTokens()) {
                String className = classTokenizer.nextToken();
                if (className.equals("network")) {
                    networkMessage = true;
                }
                if (!className.equals("client")) continue;
                clientMessage = true;
            }
            if (networkMessage && !this.displayNetworkLog) {
                return;
            }
            if (clientMessage && !this.displayClientLog) {
                return;
            }
        }
        if (p.toInt() == 10000) {
            this.debugMessages.append(fullMessage);
        }
        if (p.toInt() == 20000) {
            this.debugMessages.append(fullMessage);
            this.infoMessages.append(fullMessage);
        }
        if (p.toInt() > 20000) {
            this.debugMessages.append(fullMessage);
            this.infoMessages.append(fullMessage);
            this.warnMessages.append(fullMessage);
        }
        final int caretPosition = this.LogText.getCaretPosition();
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (pr.toInt() >= LoggingMonitor.this.loggingLevel) {
                    LoggingMonitor.this.LogText.append(fullMessage);
                }
                if (!LoggingMonitor.this.DisableAutoScrolling.isSelected()) {
                    LoggingMonitor.this.LogText.setCaretPosition(LoggingMonitor.this.LogText.getText().length());
                } else {
                    LoggingMonitor.this.LogText.setCaretPosition(caretPosition);
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public boolean isDisplayLocationInfo() {
        return this.displayLocationInfo;
    }

    public void setDisplayLocationInfo(boolean displayLocationInfo) {
        this.displayLocationInfo = displayLocationInfo;
    }

    public boolean isDisplayNetworkLog() {
        return this.displayNetworkLog;
    }

    public void setDisplayNetworkLog(boolean displayNetworkLog) {
        this.displayNetworkLog = displayNetworkLog;
    }

    public boolean isDisplayClientLog() {
        return this.displayClientLog;
    }

    public void setDisplayClientLog(boolean displayClientLog) {
        this.displayClientLog = displayClientLog;
    }
}

