/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class GlobalHistoryView
extends JDialog {
    private JPanel TitlePanel;
    private JLabel TitleLabel;
    private JScrollPane TableScroller;
    private Vector columnHeaders;
    private Vector data;
    private JTable table;
    private Vector clients = ServerVariables.clients;
    public static Category log = Category.getInstance(GlobalHistoryView.class);

    public GlobalHistoryView(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.formAllData();
    }

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.TableScroller = new JScrollPane();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setTitle("Global History");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GlobalHistoryView.this.closeDialog(evt);
            }
        });
        this.TitlePanel.setBackground(Color.white);
        this.TitleLabel.setText("Global History");
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setFont(new Font("Bookman Old Style", 0, 18));
        this.TitlePanel.add(this.TitleLabel);
        this.getContentPane().add(this.TitlePanel);
        this.getContentPane().add(this.TableScroller);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.getContentPane().setSize(new Dimension((int)((double)screen.width * 0.7), (int)((double)screen.height * 0.7)));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void initData() {
        try {
            ClientData cdata = (ClientData)ServerVariables.clients.get(0);
            int numMatches = cdata.getNumMatches();
            Vector generalHeaders = this.getGeneralHeaders();
            Vector matchHeaders = new Vector();
            for (int i = 0; i < numMatches; ++i) {
                matchHeaders = this.union(matchHeaders, this.getMatchHeaders(i));
            }
            this.columnHeaders = this.union(generalHeaders, matchHeaders);
            this.data = new Vector();
            for (int m = 0; m < numMatches; ++m) {
                for (int r = 0; r < cdata.getNumRounds(m); ++r) {
                    for (int c = 0; c < ServerVariables.clients.size(); ++c) {
                        ClientData client = (ClientData)ServerVariables.clients.get(c);
                        Vector columns = client.getColumnData(m);
                        Vector<String> row = new Vector<String>();
                        row.add("" + m);
                        row.add("" + r);
                        row.add("" + client.getGroupId());
                        row.add("" + client.getName());
                        row.add("" + client.getId());
                        for (int i = 0; i < matchHeaders.size(); ++i) {
                            String header = (String)matchHeaders.get(i);
                            if (generalHeaders.contains(header)) continue;
                            for (int j = 0; j < columns.size(); ++j) {
                                Hashtable column = (Hashtable)columns.get(j);
                                String title = (String)column.get("title");
                                if (title == null || !title.equals(header)) continue;
                                String sdata = (String)column.get(new Integer(r));
                                row.add(sdata);
                            }
                        }
                        this.data.add(row);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to form Global History View" + MSConstants.newline + e));
        }
    }

    private void displayTable() {
        this.table = new JTable(this.data, this.columnHeaders);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.getContentPane().remove(this.TableScroller);
        this.TableScroller = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension((int)((double)screen.width * 0.69), (int)((double)screen.height * 0.65)));
        this.getContentPane().add(this.TableScroller);
    }

    private Vector getGeneralHeaders() {
        Vector<String> gen = new Vector<String>();
        gen.add("Match");
        gen.add("Round");
        gen.add("Group");
        gen.add("Name");
        gen.add("ID");
        return gen;
    }

    private Vector union(Vector v1, Vector v2) {
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            return v2;
        }
        Vector union = new Vector(v1);
        for (int i = 0; i < v2.size(); ++i) {
            Object item = v2.get(i);
            if (v1.contains(item)) continue;
            union.add(item);
        }
        return union;
    }

    private Vector getMatchHeaders(int match) {
        Vector headers = new Vector();
        ClientData cdata = (ClientData)ServerVariables.clients.get(0);
        Vector columns = cdata.getColumnData(match);
        if (columns == null) {
            return headers;
        }
        for (int i = 0; i < columns.size(); ++i) {
            Hashtable column = (Hashtable)columns.get(i);
            if (column == null) continue;
            headers.add(column.get("title"));
        }
        return headers;
    }

    private Vector orderClientsByPartners(int match) {
        try {
            this.clients = ServerVariables.clients;
            Vector<ClientData> ordered = new Vector<ClientData>();
            for (int i = 0; i < this.clients.size(); ++i) {
                if (ordered.contains(this.clients.get(i))) continue;
                ClientData client = (ClientData)this.clients.get(i);
                ordered.add(client);
                int[] partners = client.getPartnerHistory(match);
                for (int j = 0; j < partners.length; ++j) {
                    ClientData partner = (ClientData)this.clients.get(partners[j]);
                    if (partner == client) continue;
                    ordered.add(partner);
                }
            }
            return ordered;
        }
        catch (Exception e) {
            log.error((Object)("Failed to order clients by partners for match " + match + MSConstants.newline + e));
            return null;
        }
    }

    public void formAllData() {
        try {
            Runnable genData = new Runnable(){

                public void run() {
                    try {
                        GlobalHistoryView.this.initData();
                        Runnable doUpdate = new Runnable(){

                            public void run() {
                                try {
                                    GlobalHistoryView.this.displayTable();
                                    GlobalHistoryView.this.pack();
                                    GlobalHistoryView.this.centerOnScreen();
                                    GlobalHistoryView.this.setVisible(true);
                                    log.debug((Object)"Formed all global history data successfully");
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Swing error in constructing global history table - Do not attempt to open history for the remainder of the experiment" + MSConstants.newline + e));
                                }
                            }
                        };
                        SwingUtilities.invokeLater(doUpdate);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to construct a global history data - Do not attempt to open history for the remainder of the experiment" + MSConstants.newline + e));
                    }
                }
            };
            Thread genThread = new Thread(genData);
            genThread.start();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to construct a global history table - Do not attempt to open history for the remainder of the experiment" + MSConstants.newline + e));
        }
    }

    private int getMaxRounds(int match) {
        int numRounds = 0;
        Vector clients = ServerVariables.clients;
        for (int i = 0; i < clients.size(); ++i) {
            ClientData cdata = (ClientData)clients.get(i);
            int maxRound = cdata.getNumRounds(match);
            if (maxRound <= numRounds) continue;
            numRounds = maxRound;
        }
        return numRounds;
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

