/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.interfaces.ClientHistoryPanel;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ClientHistoryFrame
extends JDialog {
    private ClientHistoryPanel hPanel;

    public ClientHistoryFrame(JFrame owner, ClientData cdata, String name) {
        super(owner);
        this.setTitle("Client History");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ClientHistoryFrame.this.exitForm(evt);
            }
        });
        this.hPanel = new ClientHistoryPanel(cdata, name);
        this.getContentPane().add(this.hPanel);
        this.setSize(550, 500);
        this.centerOnScreen();
        this.setVisible(true);
    }

    public void update(ClientData cdata) {
        this.hPanel.rebuild(cdata);
    }

    private void exitForm(WindowEvent evt) {
        ServerVariables.ui.deselectHistoryButton(this);
        this.dispose();
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

