/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.interfaces;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.network.ServerAuthenticator;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class AuthStatusView
extends JDialog {
    private JPanel TitlePanel;
    private JLabel AuthStatusLabel;
    private JPanel ButtonPanel;
    private JButton CancelButton;
    private JPanel ButtonFiller;
    private JScrollPane ClientScroller;
    private JPanel ClientPane;
    private JButton DoneButton;
    private int numClients;
    private Vector clients;
    private ServerAuthenticator auth;
    public static int STATUS_INVALID = 0;
    public static int STATUS_CONNECTED = 1;
    public static int STATUS_WAITING = 2;
    public static int STATUS_DROPPED = 3;
    private static Category log = Category.getInstance(AuthStatusView.class);

    public AuthStatusView(JFrame owner, int numClients, ServerAuthenticator auth) {
        super(owner);
        this.auth = auth;
        this.clients = new Vector();
        this.setTitle("Authentication");
        this.setResizable(false);
        this.numClients = numClients;
        this.initComponents();
        this.centerOnScreen();
    }

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.AuthStatusLabel = new JLabel();
        this.ButtonPanel = new JPanel();
        this.CancelButton = new JButton();
        this.DoneButton = new JButton();
        this.ButtonFiller = new JPanel();
        this.ClientScroller = new JScrollPane();
        this.ClientPane = new JPanel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AuthStatusView.this.exitForm(evt);
            }
        });
        this.AuthStatusLabel.setText("Authentication Status");
        this.AuthStatusLabel.setForeground(Color.black);
        this.AuthStatusLabel.setHorizontalAlignment(0);
        this.AuthStatusLabel.setFont(new Font("Arial Unicode MS", 1, 18));
        this.TitlePanel.add(this.AuthStatusLabel);
        this.getContentPane().add(this.TitlePanel);
        this.ClientPane.setLayout(new BoxLayout(this.ClientPane, 1));
        this.fillClients();
        this.ClientScroller.setViewportView(this.ClientPane);
        this.ClientScroller.setPreferredSize(new Dimension(400, 400));
        this.getContentPane().add(this.ClientScroller);
        this.ButtonPanel.setLayout(new FlowLayout(2));
        this.DoneButton.setText("Confirm");
        this.DoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthStatusView.this.DoneButtonAction(evt);
            }
        });
        this.ButtonPanel.add(this.DoneButton);
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthStatusView.this.CancelButtonAction(evt);
            }
        });
        this.CancelButton.setPreferredSize(new Dimension(81, 27));
        this.ButtonPanel.add(this.CancelButton);
        this.ButtonFiller.setPreferredSize(new Dimension(19, 10));
        this.ButtonPanel.add(this.ButtonFiller);
        this.getContentPane().add(this.ButtonPanel);
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void destroy() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                AuthStatusView.this.setVisible(false);
                AuthStatusView.this.dispose();
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void fillClients() {
        for (int i = 0; i < this.numClients; ++i) {
            JPanel ClientInfoPanel = new JPanel();
            JLabel ClientLabel = new JLabel();
            JLabel StatusLabel = new JLabel();
            JButton DropButton = new JButton();
            ClientLabel.setText("Client " + i);
            ClientLabel.setForeground(Color.black);
            ClientLabel.setFont(new Font("Bookman Old Style", 1, 14));
            ClientLabel.setPreferredSize(new Dimension(120, 18));
            ClientInfoPanel.add(ClientLabel);
            StatusLabel.setText("Waiting");
            StatusLabel.setForeground(Color.red);
            StatusLabel.setPreferredSize(new Dimension(90, 17));
            ClientInfoPanel.add(StatusLabel);
            DropButton.setText("Drop Client");
            DropButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AuthStatusView.this.DropButtonAction(evt);
                }
            });
            ClientInfoPanel.add(DropButton);
            this.ClientPane.add(ClientInfoPanel);
            Vector<Serializable> newPane = new Vector<Serializable>();
            newPane.add(ClientLabel);
            newPane.add(StatusLabel);
            newPane.add(DropButton);
            newPane.add(new Integer(STATUS_WAITING));
            this.clients.add(newPane);
        }
    }

    public int addConnected(String name) {
        for (int i = 0; i < this.clients.size(); ++i) {
            Vector clientInfo = (Vector)this.clients.get(i);
            JLabel status = (JLabel)clientInfo.get(1);
            if (!status.getText().equals("Waiting")) continue;
            this.setStatus(i, STATUS_CONNECTED);
            this.setName(i, name);
            return i;
        }
        return -1;
    }

    public void submitIfTesting() {
        if (ServerVariables.integratedTest && this.checkDoneStatus(this.numClients)) {
            this.DoneButtonAction(null);
        }
    }

    public void setStatus(int client, int status) {
        Vector clientInfo = (Vector)this.clients.get(client);
        JLabel statusLabel = (JLabel)clientInfo.get(1);
        if (status == STATUS_WAITING) {
            statusLabel.setText("Waiting");
            statusLabel.setForeground(Color.red);
        } else if (status == STATUS_CONNECTED) {
            statusLabel.setText("Connected");
            statusLabel.setForeground(new Color(39, 198, 42));
        } else if (status == STATUS_DROPPED) {
            statusLabel.setText("Dropped");
            statusLabel.setForeground(Color.black);
        } else if (status == STATUS_INVALID) {
            statusLabel.setText("Invalid");
            statusLabel.setForeground(new Color(110, 40, 40));
        }
        clientInfo.remove(3);
        clientInfo.add(3, new Integer(status));
    }

    public int getStatus(int clientSlot) {
        Vector vect = (Vector)this.clients.get(clientSlot);
        int status = (Integer)vect.get(3);
        return status;
    }

    public void setName(int client, String name) {
        Vector clientInfo = (Vector)this.clients.get(client);
        JLabel clientName = (JLabel)clientInfo.get(0);
        clientName.setText(name);
    }

    public boolean checkDoneStatus(int numClients) {
        for (int i = 0; i < this.clients.size(); ++i) {
            int status = this.getStatus(i);
            if (status == STATUS_WAITING) {
                if (!ServerVariables.integratedTest) {
                    JOptionPane.showMessageDialog(null, "Server is still waiting for some clients - either drop them or continue waiting", "Network Error", 0);
                }
                return false;
            }
            if (status != STATUS_INVALID) continue;
            if (!ServerVariables.integratedTest) {
                JOptionPane.showMessageDialog(null, "Invalid clients must be dropped before continuing", "Invalid Clients", 0);
            }
            return false;
        }
        return true;
    }

    private void DropButtonAction(ActionEvent evt) {
        int dropID = -1;
        try {
            JButton dropButton = (JButton)evt.getSource();
            int status = STATUS_WAITING;
            for (int i = 0; i < this.clients.size(); ++i) {
                JButton button = (JButton)((Vector)this.clients.get(i)).get(2);
                if (button != dropButton) continue;
                dropID = i;
                status = this.getStatus(i);
            }
            if (status == STATUS_WAITING) {
                if (1 == JOptionPane.showConfirmDialog(null, "Drop this client holder entirely, reducing total number of clients to " + (this.numClients - 1) + "?", "Confirm Drop", 0)) {
                    return;
                }
                dropButton.setEnabled(false);
            } else if (1 == JOptionPane.showConfirmDialog(null, "Drop this client from the experiment?", "Drop Confirm", 0)) {
                return;
            }
            this.auth.dropClient(dropID);
            log.debug((Object)("AuthView notified ServerAuthenticator to drop client " + dropID));
        }
        catch (Exception e) {
            log.error((Object)("Failed to drop client with Drop ID " + dropID + MSConstants.newline + e));
        }
    }

    private void CancelButtonAction(ActionEvent evt) {
        try {
            this.auth.cancelAuthentication();
        }
        catch (Exception e) {
            log.error((Object)"Failed to send a cancellation message to the Server Mail Authenticator");
        }
    }

    private void DoneButtonAction(ActionEvent evt) {
        try {
            this.auth.confirmClients();
        }
        catch (Exception e) {
            log.error((Object)"Failed to send a confirmation message to the Server Mail Authenticator");
        }
    }

    public void setNumClients(int numClients) {
        this.numClients = numClients;
    }

    public int getNumClients() {
        return this.numClients;
    }

    public static void main(String[] args) {
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

