/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.data;

import edu.caltech.ssel.multistage.server.control.ManualMatcher;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.data.Match;
import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.server.util.Param;
import edu.caltech.ssel.multistage.server.util.ParamHolder;
import edu.caltech.ssel.multistage.server.util.ParamVerifier;
import edu.caltech.ssel.multistage.server.util.pluginservice.PluginDescriptor;
import edu.caltech.ssel.multistage.server.util.pluginservice.PluginService;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Category;

public class Parameters
extends ServerVariables
implements Serializable {
    private boolean errors;
    private int numMatches;
    private int exp_id;
    private File paramFile;
    private int repetitions;
    private Vector matches;
    private Hashtable paramMap;
    private Hashtable paramValues;
    private Vector verifiers;
    private Properties fileProps;
    private ParamVerifier verifier;
    private static Category log = Category.getInstance(Parameters.class);

    public Parameters() {
    }

    public Parameters(String paramStr) throws Exception {
        this.init();
        this.parseFile(new File(paramStr));
    }

    public Parameters(File paramFile) throws Exception {
        this.init();
        this.parseFile(paramFile);
    }

    public Parameters(InputStream editIn) throws Exception {
        this.init();
        Exception ex = null;
        try {
            this.parseInputStream(editIn);
        }
        catch (Exception ex2) {
            ex = ex2;
        }
        editIn.close();
        if (ex != null) {
            throw ex;
        }
    }

    public void init() {
        this.errors = false;
        this.numMatches = 0;
        this.matches = new Vector();
        this.paramValues = new Hashtable();
        this.paramMap = new Hashtable();
    }

    private void parseFile(File paramFile) throws Exception {
        this.paramFile = paramFile;
        log.debug((Object)("Getting properties from file: " + paramFile));
        FileInputStream editIn = new FileInputStream(paramFile);
        Exception ex = null;
        try {
            this.parseInputStream(editIn);
        }
        catch (Exception ex2) {
            ex = ex2;
        }
        editIn.close();
        if (ex != null) {
            throw ex;
        }
    }

    private void parseInputStream(InputStream editIn) throws Exception {
        try {
            props = new Properties();
            props.load(editIn);
            this.exp_id = this.parseExpId();
            this.numMatches = this.parseNumMatches();
            for (int m = 0; m < this.numMatches; ++m) {
                log.info((Object)("Parsing Match " + m));
                int clonedMatch = this.parseClone(m);
                if (clonedMatch != -1) {
                    this.cloneProperties(m, clonedMatch);
                }
                String packageName = this.parsePackageName(m);
                String matchType = this.parseMatchType(packageName, m);
                if (pluginService == null) {
                    pluginService = new PluginService(".." + File.separator + "plugins");
                }
                pluginDescriptors.add(m, pluginService.getDescriptor(matchType));
                this.loadVerifier(matchType);
                int groupSize = this.parseGroupSize(m);
                int maxRounds = this.parseMaxRounds(m);
                float exchangeRate = this.parseExchangeRate(m);
                boolean practice = this.parsePractice(m);
                int matchingType = this.parseMatchingType(m, groupSize);
                String matchFile = this.parseMatchFileName(m);
                int historyNumber = this.parseHistoryNumber(m);
                boolean showTotalPayoff = this.parseShowTotalPayoff(m);
                boolean enableChat = this.parseEnableChat(m);
                String chatIdentifier = this.parseChatIdentifier(m);
                boolean preserve = this.parsePreserve(m);
                boolean displayFinishedInfo = this.parseDisplayFinishedInfo(m);
                boolean optionChat = this.parseOptionChat(m);
                String[][] chatOptions = this.parseChatOptions(m, groupSize, optionChat);
                String defaultView = this.parseDefaultView(m);
                boolean viewSwitchable = this.parseViewSwitchable(m);
                int asyncReauthMode = this.parseAsyncReauthMode(m);
                int roundAdvancement = this.parseRoundAdvancement(m);
                this.repetitions = this.parseRepetitions(m);
                Match currentMatch = new Match(maxRounds, groupSize, packageName, matchType, exchangeRate, practice, matchingType, matchFile, historyNumber, showTotalPayoff, enableChat, chatIdentifier, preserve, displayFinishedInfo, optionChat, chatOptions, defaultView, viewSwitchable, asyncReauthMode, roundAdvancement);
                this.matches.add(currentMatch);
                this.parseGameSpecificParams(m, groupSize);
            }
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)("Configuration file not found: " + e + " " + e.getMessage()));
            throw new FileNotFoundException(e.getMessage());
        }
        catch (InvalidParameterException e) {
            log.warn((Object)("Parameter file contains errors: " + e.getMessage()));
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Exception e) {
            log.fatal((Object)("Error parsing the configuration file: " + e + " " + e.getMessage()));
            throw new Exception(e.getMessage());
        }
        this.numMatches = this.matches.size();
    }

    private void loadVerifier(String matchType) {
        this.verifier = null;
        if (matchType == null) {
            return;
        }
        if (props.getProperty("useParameterVerifier", "false").equalsIgnoreCase("true")) {
            try {
                if (pluginService == null) {
                    pluginService = new PluginService(".." + File.separator + "plugins");
                }
                String verifierClassname = pluginService.getDescriptor(matchType).getParameterVerifierClassname();
                this.verifier = (ParamVerifier)Class.forName(verifierClassname).newInstance();
                log.debug((Object)("Found verifier for game " + matchType));
            }
            catch (Throwable e) {
                log.info((Object)("No verifier found for game " + matchType));
            }
        }
    }

    private void parseGameSpecificParams(int m, int groupSize) {
        if (groupSize < 1 || this.verifier == null) {
            return;
        }
        this.verifier.fillParams(groupSize);
        Vector params = this.verifier.getParams();
        Vector<ParamHolder> pHolders = new Vector<ParamHolder>();
        for (int i = 0; i < params.size(); ++i) {
            Param prm = (Param)params.get(i);
            if (!prm.isGameSpecific()) continue;
            pHolders.add(this.parseGSParam(m, prm));
        }
        this.checkGSErrors(m, this.verifier, pHolders);
    }

    private ParamHolder parseGSParam(int m, Param prm) {
        ParamHolder ph = new ParamHolder("match." + m + "." + prm.getParamName());
        String value = props.getProperty(ph.getParamString());
        if (value != null) {
            value = value.trim();
        }
        ph.setParamValue(value);
        ph.setParam(prm);
        this.addParamHolder(m, ph);
        return ph;
    }

    private void checkGSErrors(int m, ParamVerifier verifier, Vector pHolders) {
        Hashtable allValues = (Hashtable)this.paramValues.get(new Integer(m));
        if (allValues == null || pHolders == null) {
            return;
        }
        for (int i = 0; i < pHolders.size(); ++i) {
            ParamHolder ph = (ParamHolder)pHolders.get(i);
            ph.setStyle("gameSpecific");
            Param prm = ph.getParam();
            String value = ph.getParamValue();
            try {
                prm.verify(value, allValues);
                continue;
            }
            catch (InvalidParameterException e) {
                ph.setErrorString(e.getMessage());
                this.errors = true;
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Error when using parameter verifier to check game-specific parameters" + MSConstants.newline + e));
            }
        }
    }

    private int parseExpId() throws Exception {
        int exp_id = -1;
        String exp_id_string = props.getProperty("exp.id");
        if (exp_id_string != null && exp_id_string.length() > 0) {
            try {
                exp_id_string = exp_id_string.trim();
                exp_id = Integer.parseInt(exp_id_string);
            }
            catch (Exception e) {
                throw new InvalidParameterException("Experiment ID must be specified as an integer");
            }
        } else {
            throw new InvalidParameterException("No experiment ID (exp.id) specified!");
        }
        log.info((Object)("Experiment ID parsed: " + exp_id));
        return exp_id;
    }

    private int parseNumMatches() throws Exception {
        int numMatches;
        String numMatches_string = props.getProperty("numOfMatches");
        if (numMatches_string != null && numMatches_string.length() > 0) {
            try {
                numMatches_string = numMatches_string.trim();
                numMatches = Integer.parseInt(numMatches_string);
            }
            catch (Exception e) {
                throw new InvalidParameterException("Number of matches must be specified as an integer");
            }
        } else {
            throw new InvalidParameterException("Number of matches (numOfMatches) not specified!");
        }
        log.info((Object)("Number of Matches parsed: " + numMatches));
        return numMatches;
    }

    private String parseDefaultView(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".defaultView");
        String defaultViewStr = props.getProperty(ph.getParamString(), "tabbed");
        if (defaultViewStr != null) {
            defaultViewStr = defaultViewStr.trim();
        }
        try {
            ph.setParamValue(defaultViewStr);
            if (!defaultViewStr.equals("full") && !defaultViewStr.equals("tabbed")) {
                throw new InvalidParameterException("Default view must be either set to 'full' or 'tabbed' views");
            }
            log.info((Object)("Default history panel view for match " + m + " is " + defaultViewStr));
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return defaultViewStr;
    }

    private boolean parseViewSwitchable(int m) {
        boolean view;
        ParamHolder ph;
        block5: {
            ph = new ParamHolder("match." + m + ".viewSwitchable");
            view = true;
            try {
                String viewStr = props.getProperty(ph.getParamString(), "true");
                if (viewStr != null) {
                    viewStr = viewStr.trim();
                }
                ph.setParamValue(viewStr);
                if (viewStr.equalsIgnoreCase("true")) {
                    view = true;
                    break block5;
                }
                if (viewStr.equalsIgnoreCase("false")) {
                    view = false;
                    break block5;
                }
                throw new InvalidParameterException("View switchable must be set to either 'true' or 'false'");
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        return view;
    }

    private int parseHistoryNumber(int m) {
        int history;
        ParamHolder ph;
        block6: {
            ph = new ParamHolder("match." + m + ".historyRounds");
            history = -1;
            try {
                String historyNumber = props.getProperty(ph.getParamString(), "-1");
                if (historyNumber != null) {
                    historyNumber = historyNumber.trim();
                }
                ph.setParamValue(historyNumber);
                if (historyNumber == null || historyNumber.length() <= 0) break block6;
                try {
                    history = Integer.parseInt(historyNumber);
                }
                catch (Exception e) {
                    throw new InvalidParameterException("The history number for match " + m + " must be specified as an integer (or not included at all)");
                }
                if (history >= 0) {
                    log.info((Object)("Match " + m + " will display " + historyNumber + " rounds of history"));
                }
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        return history;
    }

    private boolean parseShowTotalPayoff(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".showTotalPayoff");
        boolean showPayoff = true;
        try {
            String showTotalPayoff = props.getProperty(ph.getParamString(), "true");
            if (showTotalPayoff != null) {
                showTotalPayoff = showTotalPayoff.trim();
            }
            ph.setParamValue(showTotalPayoff);
            if (showTotalPayoff != null && !showTotalPayoff.equalsIgnoreCase("true") && !showTotalPayoff.equalsIgnoreCase("false")) {
                throw new InvalidParameterException("Show Total Payoff for match " + m + " must be either 'true' or 'false'");
            }
            if (showTotalPayoff != null && showTotalPayoff.equalsIgnoreCase("false")) {
                showPayoff = false;
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return showPayoff;
    }

    private boolean parsePreserve(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".preserveGUI");
        boolean preserve = false;
        try {
            String preserveStr = props.getProperty(ph.getParamString(), "false");
            if (preserveStr != null) {
                preserveStr = preserveStr.trim();
            }
            ph.setParamValue(preserveStr);
            if (preserveStr != null && !preserveStr.equalsIgnoreCase("true") && !preserveStr.equalsIgnoreCase("false")) {
                throw new InvalidParameterException("Preserve boolean for match " + m + " must be either 'true' or 'false'");
            }
            if (preserveStr != null && preserveStr.equalsIgnoreCase("true")) {
                preserve = true;
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return preserve;
    }

    private boolean parseDisplayFinishedInfo(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".displayFinishedInfo");
        boolean displayFinished = false;
        try {
            String displayFinishedStr = props.getProperty(ph.getParamString(), "false");
            if (displayFinishedStr != null) {
                displayFinishedStr = displayFinishedStr.trim();
            }
            ph.setParamValue(displayFinishedStr);
            if (displayFinishedStr != null && !displayFinishedStr.equalsIgnoreCase("true") && !displayFinishedStr.equalsIgnoreCase("false")) {
                throw new InvalidParameterException("Display Finished Info boolean for match " + m + " must be either 'true' or 'false'");
            }
            if (displayFinishedStr.equalsIgnoreCase("true")) {
                displayFinished = true;
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return displayFinished;
    }

    private boolean parseEnableChat(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".enableChat");
        boolean enableChatting = false;
        try {
            String enableChattingStr = props.getProperty(ph.getParamString());
            if (enableChattingStr != null) {
                enableChattingStr = enableChattingStr.trim();
            }
            ph.setParamValue(enableChattingStr);
            if (enableChattingStr != null && !enableChattingStr.equalsIgnoreCase("true") && !enableChattingStr.equalsIgnoreCase("false")) {
                throw new InvalidParameterException("Enable Chatting parameter for match " + m + " must be either 'true' or 'false'");
            }
            if (enableChattingStr != null && enableChattingStr.equalsIgnoreCase("true")) {
                enableChatting = true;
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return enableChatting;
    }

    private boolean parseOptionChat(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".optionChat");
        boolean optionChat = false;
        try {
            String optionChatStr = props.getProperty(ph.getParamString(), "false");
            if (optionChatStr != null) {
                optionChatStr = optionChatStr.trim();
            }
            ph.setParamValue(optionChatStr);
            if (optionChatStr != null && !optionChatStr.equalsIgnoreCase("true") && !optionChatStr.equalsIgnoreCase("false")) {
                throw new InvalidParameterException("Option Chat parameter for match " + m + " must be either 'true' or 'false'");
            }
            if (optionChatStr != null && optionChatStr.equalsIgnoreCase("true")) {
                optionChat = true;
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return optionChat;
    }

    private String[][] parseChatOptions(int m, int groupSize, boolean optionChat) throws Exception {
        String[][] chatOptions = new String[groupSize][];
        if (!optionChat) {
            return chatOptions;
        }
        for (int i = 0; i < groupSize; ++i) {
            String message;
            int messageNum = 0;
            Vector<String> messages = new Vector<String>();
            while ((message = props.getProperty("match." + m + ".partner." + i + ".message." + messageNum)) != null) {
                messages.add(message);
                ++messageNum;
            }
            if (messages.size() < 1) {
                throw new InvalidParameterException("Partner " + i + " has no chat options!");
            }
            chatOptions[i] = new String[messages.size()];
            for (int j = 0; j < messages.size(); ++j) {
                chatOptions[i][j] = (String)messages.get(j);
            }
        }
        return chatOptions;
    }

    private String parseChatIdentifier(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".chatIdentifier");
        String cid = "Subject %partner%";
        try {
            cid = props.getProperty(ph.getParamString(), "Subject %partner%");
            ph.setParamValue(cid);
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return cid;
    }

    private int parseAsyncReauthMode(int m) {
        int mode;
        ParamHolder ph;
        block5: {
            ph = new ParamHolder("match." + m + ".asyncReauthMode");
            mode = 0;
            try {
                String reauthMode = props.getProperty(ph.getParamString(), "abort");
                if (reauthMode != null) {
                    reauthMode = reauthMode.trim();
                }
                ph.setParamValue(reauthMode);
                if (reauthMode.equalsIgnoreCase("manual")) {
                    mode = 1;
                    break block5;
                }
                if (reauthMode.equalsIgnoreCase("abort")) {
                    mode = 0;
                    break block5;
                }
                throw new InvalidParameterException("The asyncReauthMode parameter must be set to either 'manual' or 'abort'");
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        return mode;
    }

    private int parseRoundAdvancement(int m) {
        int mode;
        ParamHolder ph;
        block5: {
            ph = new ParamHolder("match." + m + ".roundAdvancement");
            mode = 0;
            try {
                String advancementStr = props.getProperty(ph.getParamString(), "synchronized");
                if (advancementStr != null) {
                    advancementStr = advancementStr.trim();
                }
                ph.setParamValue(advancementStr);
                if (advancementStr.equalsIgnoreCase("independent")) {
                    mode = 1;
                    log.info((Object)("Match " + m + " will use independent round advancement rules"));
                    break block5;
                }
                if (advancementStr.equalsIgnoreCase("synchronized")) {
                    mode = 0;
                    log.info((Object)("Match " + m + " will use synchronized round advancement rules"));
                    break block5;
                }
                throw new InvalidParameterException("The round advancement mode must be set to either 'independent' or 'synchronized'");
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        return mode;
    }

    private int parseClone(int m) {
        int clonedMatch = -1;
        if (this.repetitions > 0) {
            clonedMatch = m - 1;
            --this.repetitions;
            log.info((Object)("Match " + m + " is a clone (by repetition) of match " + clonedMatch));
            return clonedMatch;
        }
        ParamHolder ph = new ParamHolder("match." + m + ".clone");
        try {
            String clone = props.getProperty(ph.getParamString());
            if (clone != null) {
                clone = clone.trim();
            }
            ph.setParamValue(clone);
            if (clone != null && clone.length() > 0) {
                clonedMatch = Integer.parseInt(clone);
                log.info((Object)("Match " + m + " is an explicit clone of match " + clonedMatch));
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return clonedMatch;
    }

    private int parseRepetitions(int m) {
        int reps;
        ParamHolder ph;
        block5: {
            ph = new ParamHolder("match." + m + ".repetitions");
            reps = this.repetitions;
            try {
                String rep_string = props.getProperty(ph.getParamString());
                if (rep_string != null) {
                    rep_string = rep_string.trim();
                }
                ph.setParamValue(rep_string);
                if (rep_string == null || rep_string.length() <= 0) break block5;
                try {
                    reps = Integer.parseInt(rep_string);
                }
                catch (Exception e) {
                    throw new InvalidParameterException("The number or repetitions given for match " + m + " must be specified as an integer");
                }
                log.info((Object)("Match " + m + " will be cloned " + reps + " times"));
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        ph.setStyle("important");
        return reps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseGroupSize(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".groupSize");
        int groupSize = 0;
        try {
            String groupSize_string = props.getProperty(ph.getParamString());
            if (groupSize_string != null) {
                groupSize_string = groupSize_string.trim();
            }
            ph.setParamValue(groupSize_string);
            if (groupSize_string == null || groupSize_string.length() <= 0) throw new IOException("Group size (groupSize) not specified for match " + m);
            try {
                groupSize = Integer.parseInt(groupSize_string);
                if (groupSize <= 0) {
                    groupSize = 0;
                    throw new Exception();
                }
                if (this.verifier != null) {
                    this.verifier.verifyGroupSize(groupSize);
                }
            }
            catch (InvalidParameterException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidParameterException("The group size for match " + m + "  must be specified as a positive integer");
            }
            log.info((Object)("Match " + m + ": Number of players per group parsed: " + groupSize));
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return groupSize;
    }

    private String parsePackageName(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".package");
        String packageName = null;
        try {
            packageName = props.getProperty(ph.getParamString());
            if (packageName != null) {
                packageName = packageName.trim();
                ph.setParamValue(packageName);
                this.addParamHolder(m, ph);
                ph.setStyle("important");
                log.info((Object)("Extension is located in package: " + packageName));
            }
            if (packageName == null) {
                log.info((Object)"Extension is using default packages");
            }
        }
        catch (Exception e) {
            packageName = null;
        }
        return packageName;
    }

    private String parseMatchType(String packageName, int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".type");
        String matchType = null;
        try {
            matchType = props.getProperty(ph.getParamString());
            if (matchType != null) {
                matchType = matchType.trim();
            }
            ph.setParamValue(matchType);
            if (matchType == null) {
                throw new InvalidParameterException("No game type specified for match " + m);
            }
            try {
                if (pluginService == null) {
                    pluginService = new PluginService(".." + File.separator + "plugins");
                }
                pluginDescriptors.add(m, pluginService.getDescriptor(matchType));
                String serverClassname = ((PluginDescriptor)pluginDescriptors.get(m)).getServerClassname();
                ServerControl testCon = (ServerControl)Class.forName(serverClassname).newInstance();
                if (testCon == null) {
                    throw new Exception();
                }
                log.debug((Object)("Match " + m + " found ServerControl of type " + matchType));
                log.info((Object)("Match " + m + " is of type " + matchType));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidParameterException("Failed to find game " + matchType + " for match " + m);
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
                throw new InvalidParameterException("Failed to find game " + matchType + " for match " + m + ": check capitalization (system is case sensitive)");
            }
        }
        catch (Exception e) {
            matchType = null;
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        ph.setStyle("important");
        return matchType;
    }

    private int parseMaxRounds(int m) {
        int maxRounds;
        ParamHolder ph;
        block5: {
            ph = new ParamHolder("match." + m + ".maxRounds");
            maxRounds = 0;
            try {
                String maxRounds_string = props.getProperty(ph.getParamString());
                if (maxRounds_string != null) {
                    maxRounds_string = maxRounds_string.trim();
                }
                ph.setParamValue(maxRounds_string);
                if (maxRounds_string == null || maxRounds_string.length() <= 0) break block5;
                try {
                    maxRounds = Integer.parseInt(maxRounds_string);
                }
                catch (Exception e) {
                    throw new InvalidParameterException("The maximum number of rounds for match " + m + " must be specified as an integer");
                }
                log.info((Object)("Match " + m + ": Maximum number of rounds parsed: " + maxRounds));
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        return maxRounds;
    }

    private float parseExchangeRate(int m) {
        float exchangeRate;
        ParamHolder ph;
        block5: {
            ph = new ParamHolder("match." + m + ".exchangeRate");
            exchangeRate = 1.0f;
            try {
                String exchangeRate_string = props.getProperty(ph.getParamString());
                if (exchangeRate_string != null) {
                    exchangeRate_string = exchangeRate_string.trim();
                }
                ph.setParamValue(exchangeRate_string);
                if (exchangeRate_string == null || exchangeRate_string.length() <= 0) break block5;
                try {
                    exchangeRate = Float.parseFloat(exchangeRate_string);
                }
                catch (Exception e) {
                    throw new InvalidParameterException("The exchange rate for match " + m + " must be specified as a decimal or integer value");
                }
                log.info((Object)("Match " + m + ": Exchange rate: " + exchangeRate));
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        return exchangeRate;
    }

    private boolean parsePractice(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".practice");
        boolean practice = false;
        try {
            String practice_string = props.getProperty(ph.getParamString());
            if (practice_string != null) {
                practice_string = practice_string.trim();
            }
            ph.setParamValue(practice_string);
            if (practice_string != null && !practice_string.equalsIgnoreCase("true") && !practice_string.equalsIgnoreCase("false")) {
                throw new InvalidParameterException("The practice value for match " + m + " must be either 'true' or 'false'");
            }
            if (practice_string != null && practice_string.equalsIgnoreCase("true")) {
                practice = true;
                log.info((Object)("Match " + m + " is a practice match"));
            } else {
                log.info((Object)("Match " + m + " is NOT a practice match"));
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return practice;
    }

    private int parseMatchingType(int m, int groupSize) {
        int matching;
        ParamHolder ph;
        block22: {
            ph = new ParamHolder("match." + m + ".matching");
            String matchingType = "";
            matching = -1;
            try {
                matchingType = m == 0 || !props.getProperty("match." + (m - 1) + ".groupSize").trim().equals("" + groupSize) ? props.getProperty(ph.getParamString(), "random") : props.getProperty(ph.getParamString(), "continue");
                if (matchingType != null) {
                    matchingType = matchingType.trim();
                }
                ph.setParamValue(matchingType);
                if (matchingType.equalsIgnoreCase("random")) {
                    log.info((Object)("Match " + m + " is using random partnerization with role (partner number) preservation"));
                    matching = 96;
                    break block22;
                }
                if (matchingType.equalsIgnoreCase("totalrandom")) {
                    log.info((Object)("Match " + m + " is using total random partnerization"));
                    matching = 2;
                    break block22;
                }
                if (matchingType.equalsIgnoreCase("parameters") || matchingType.equalsIgnoreCase("parameter")) {
                    log.info((Object)("Match " + m + " is using matching specified in the parameter file"));
                    matching = 97;
                    break block22;
                }
                if (matchingType.equalsIgnoreCase("file")) {
                    log.info((Object)("Match " + m + " is using matching specified in matchfile"));
                    String fileStr = props.getProperty("match." + m + ".matchFile");
                    if (fileStr == null) {
                        throw new Exception("No match file specified for match " + m);
                    }
                    matching = 98;
                    break block22;
                }
                if (matchingType.equalsIgnoreCase("zipper")) {
                    log.info((Object)("Match " + m + " is using the zipper algorithm for matching"));
                    matching = 1;
                    break block22;
                }
                if (matchingType.equalsIgnoreCase("rr")) {
                    if (groupSize != 2) {
                        throw new InvalidParameterException("Round Robin matching algorithm is only compatible with group size of 2");
                    }
                    log.info((Object)("Match " + m + " is using the round-robin algorithm for matching"));
                    matching = 3;
                    break block22;
                }
                if (matchingType.equalsIgnoreCase("fixed")) {
                    log.info((Object)("Match " + m + " is using fixed matching: groups will remain identical to those of the last match"));
                    matching = 100;
                    break block22;
                }
                if (matchingType.equalsIgnoreCase("continue")) {
                    log.info((Object)("Match " + m + " is continuing the matching scheme of the previous match"));
                    matching = 99;
                    break block22;
                }
                try {
                    String packageName = this.parsePackageName(m);
                    String matchType = this.parseMatchType(packageName, m);
                    String matcherClassname = ((PluginDescriptor)pluginDescriptors.get(m)).getMatchingClassname();
                    System.out.println("Trying to find matching classname: string pulled from plugin.xml is: " + matcherClassname);
                    ManualMatcher matcher = (ManualMatcher)Class.forName(matcherClassname).newInstance();
                    if (matcher != null) {
                        try {
                            if (!matcher.verifyGroupSize(groupSize)) {
                                throw new InvalidParameterException();
                            }
                            log.info((Object)("Match " + m + " will use the manual matching scheme " + matchingType));
                            matching = 101;
                            break block22;
                        }
                        catch (InvalidParameterException e) {
                            throw new InvalidParameterException("Match " + m + " matcher " + matchingType + " is not compatible with a group size of " + groupSize);
                        }
                    }
                    throw new InvalidParameterException("The matching type " + matchingType + " for match " + m + " is not a set or manual matching algorithm");
                }
                catch (InvalidParameterException e) {
                    throw new InvalidParameterException(e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidParameterException("The matching type " + matchingType + " for match " + m + " is not a set or manual matching algorithm");
                }
                catch (NoClassDefFoundError e) {
                    throw new InvalidParameterException("The matching type " + matchingType + " for match " + m + " is not a set or manual matching algorithm - check the capitalization of the matching algorithm (system is case sensitive)");
                }
                catch (Exception e) {
                    throw new InvalidParameterException("The matching type " + matchingType + " caused an unknown error");
                }
            }
            catch (Exception e) {
                ph.setErrorString(e.getMessage());
            }
        }
        this.addParamHolder(m, ph);
        return matching;
    }

    private String parseMatchFileName(int m) {
        ParamHolder ph = new ParamHolder("match." + m + ".matchFile");
        String matchFile = null;
        try {
            matchFile = props.getProperty(ph.getParamString());
            if (matchFile != null) {
                matchFile = matchFile.trim();
            }
            ph.setParamValue(matchFile);
            if (matchFile == null) {
                log.debug((Object)("No matchfile found for match " + m));
            } else {
                log.info((Object)("Found matchfile " + matchFile + " for match " + m));
            }
        }
        catch (Exception e) {
            ph.setErrorString(e.getMessage());
        }
        this.addParamHolder(m, ph);
        return matchFile;
    }

    private void cloneProperties(int m, int original) {
        Enumeration<?> allProps = props.propertyNames();
        while (allProps.hasMoreElements()) {
            String origPrefix;
            String prop = (String)allProps.nextElement();
            if (!prop.startsWith(origPrefix = "match." + original + ".")) continue;
            int matchIndex = origPrefix.length();
            String prefix = "match." + m + ".";
            String suffix = prop.substring(matchIndex);
            String newProp = prefix + suffix;
            if (!props.getProperty(newProp, "noprop").equals("noprop") || newProp.equals("match." + m + ".repetitions") || newProp.equals("match." + m + ".clone") || newProp.equals("match." + m + ".matching")) continue;
            props.setProperty(newProp, props.getProperty(prop));
        }
        log.debug((Object)("Match " + original + " properties have been cloned for match " + m));
    }

    private String arrayToString(int[] ints) {
        String array = "[";
        for (int i = 0; i < ints.length - 1; ++i) {
            array = array + " " + ints[i] + ",";
        }
        array = array + " " + ints[ints.length - 1] + " ]";
        return array;
    }

    private void addParamHolder(int m, ParamHolder ph) {
        try {
            Hashtable<String, String> match;
            String value;
            ph.setStyle("normal");
            String param = ph.getParamString();
            if (param != null) {
                param.trim();
            }
            if ((value = ph.getParamValue()) != null) {
                value.trim();
            }
            this.paramMap.put(param + "=" + value, ph);
            String error = ph.getErrorString();
            if (error != null) {
                this.errors = true;
            }
            if ((match = (Hashtable<String, String>)this.paramValues.get(new Integer(m))) == null) {
                match = new Hashtable<String, String>();
                this.paramValues.put(new Integer(m), match);
            }
            if (value != null) {
                match.put(this.getParamName(param), value);
            }
        }
        catch (Exception e) {
            ph.setErrorString("Invalid parameter formatting - unknown parsing error");
        }
    }

    private String getParamName(String extName) {
        StringTokenizer tokenizer = new StringTokenizer(extName, ".=");
        tokenizer.nextToken();
        tokenizer.nextToken();
        return tokenizer.nextToken().trim();
    }

    public Vector getMatches() {
        return this.matches;
    }

    public int getNumMatches() {
        return this.numMatches;
    }

    public void setNumMatches(int numMatches) {
        this.numMatches = numMatches;
    }

    public int getId() {
        return this.exp_id;
    }

    public Hashtable getParamMap() {
        return this.paramMap;
    }

    public Hashtable getParamValues() {
        return this.paramValues;
    }

    public File getParamFile() {
        return this.paramFile;
    }

    public PluginDescriptor getPluginDescriptor() {
        return (PluginDescriptor)pluginDescriptors.get(currentMatch);
    }

    public PluginDescriptor getPluginDescriptor(int m) {
        return (PluginDescriptor)pluginDescriptors.get(m);
    }

    public boolean containsErrors() {
        return this.errors;
    }
}

