/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.data;

import java.util.Hashtable;
import java.util.Vector;

public class Match {
    private int numRounds;
    private String gameType;
    private int groupSize;
    private float exchangeRate;
    private boolean practice;
    private int matchingType;
    private String matchFile;
    private int historyNumber;
    private boolean showTotalPayoff;
    private boolean enableChat;
    private String chatIdentifier;
    private boolean preserve;
    private boolean displayFinishedInfo;
    private boolean optionChat;
    private String[][] chatOptions;
    private String defaultView;
    private boolean viewSwitchable;
    private int asyncReauthMode;
    private Hashtable roundOutput;
    private Hashtable matchOutput;
    private int roundAdvancement;
    private String packageName;
    private String serverClassname;
    private String clientClassname;
    private String manualMatcherClassname;
    private String parameterVerifierClassname;

    public Match(int numRounds, int groupSize, String packageName, String gameType, float exchangeRate, boolean practice, int matchingType, String matchFile, int historyNumber, boolean showTotalPayoff, boolean enableChat, String chatIdentifier, boolean preserve, boolean displayFinishedInfo, boolean optionChat, String[][] chatOptions, String defaultView, boolean viewSwitchable, int asyncReauthMode, int roundAdvancement) {
        this.groupSize = groupSize;
        this.gameType = gameType;
        this.numRounds = numRounds;
        this.exchangeRate = exchangeRate;
        this.practice = practice;
        this.matchingType = matchingType;
        this.matchFile = matchFile;
        this.historyNumber = historyNumber;
        this.showTotalPayoff = showTotalPayoff;
        this.enableChat = enableChat;
        this.chatIdentifier = chatIdentifier;
        this.preserve = preserve;
        this.displayFinishedInfo = displayFinishedInfo;
        this.optionChat = optionChat;
        this.chatOptions = chatOptions;
        this.defaultView = defaultView;
        this.viewSwitchable = viewSwitchable;
        this.asyncReauthMode = asyncReauthMode;
        this.roundAdvancement = roundAdvancement;
        this.packageName = packageName;
        this.roundOutput = new Hashtable();
        this.matchOutput = new Hashtable();
    }

    public Match(Match clone) {
        this.groupSize = clone.getGroupSize();
        this.gameType = clone.getGameType();
        this.numRounds = clone.getNumRounds();
        this.exchangeRate = clone.getExchangeRate();
        this.practice = clone.isPracticeMatch();
        this.historyNumber = clone.getHistoryNumber();
        this.showTotalPayoff = clone.getShowTotalPayoff();
        this.enableChat = clone.getEnableChat();
        this.chatIdentifier = clone.getChatIdentifier();
        this.preserve = clone.getPreserve();
    }

    public int getNumRounds() {
        return this.numRounds;
    }

    public void setNumRounds(int numRounds) {
        this.numRounds = numRounds;
    }

    public String getGameType() {
        return this.gameType;
    }

    public void setGameType(String gameType) {
        this.gameType = gameType;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
    }

    public float getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(float exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public boolean isPracticeMatch() {
        return this.practice;
    }

    public void setPracticeMatch(boolean practice) {
        this.practice = practice;
    }

    public int getMatchingType() {
        return this.matchingType;
    }

    public void setMatchingType(int matchingType) {
        this.matchingType = matchingType;
    }

    public String getMatchFile() {
        return this.matchFile;
    }

    public void setMatchFile(String matchFile) {
        this.matchFile = matchFile;
    }

    public int getHistoryNumber() {
        return this.historyNumber;
    }

    public void setHistoryNumber(int historyNumber) {
        this.historyNumber = historyNumber;
    }

    public boolean getShowTotalPayoff() {
        return this.showTotalPayoff;
    }

    public void setShowTotalPayoff(boolean showTotalPayoff) {
        this.showTotalPayoff = showTotalPayoff;
    }

    public boolean getEnableChat() {
        return this.enableChat;
    }

    public void setEnableChat(boolean enableChat) {
        this.enableChat = enableChat;
    }

    public String getChatIdentifier() {
        return this.chatIdentifier;
    }

    public void setChatIdentifier(String chatIdentifier) {
        this.chatIdentifier = chatIdentifier;
    }

    public boolean getPreserve() {
        return this.preserve;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public boolean getDisplayFinishedInfo() {
        return this.displayFinishedInfo;
    }

    public void setDisplayFinishedInfo(boolean displayFinishedInfo) {
        this.displayFinishedInfo = displayFinishedInfo;
    }

    public boolean getOptionChat() {
        return this.optionChat;
    }

    public void setOptionChat(boolean optionChat) {
        this.optionChat = optionChat;
    }

    public String[][] getChatOptions() {
        return this.chatOptions;
    }

    public void setChatOptions(String[][] chatOptions) {
        this.chatOptions = chatOptions;
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public boolean getViewSwitchable() {
        return this.viewSwitchable;
    }

    public void setViewSwitchable(boolean viewSwitchable) {
        this.viewSwitchable = viewSwitchable;
    }

    public int getAsyncReauthMode() {
        return this.asyncReauthMode;
    }

    public void setAsyncReauthMode(int asyncReauthMode) {
        this.asyncReauthMode = asyncReauthMode;
    }

    public int getRoundAdvancement() {
        return this.roundAdvancement;
    }

    public void setRoundAdvancement(int roundAdvancement) {
        this.roundAdvancement = roundAdvancement;
    }

    public void addRoundOutput(int groupNum, int roundNum, String[] output) {
        Vector<String[]> group;
        Hashtable<Integer, Vector<String[]>> round = (Hashtable<Integer, Vector<String[]>>)this.roundOutput.get(new Integer(roundNum));
        if (round == null) {
            round = new Hashtable<Integer, Vector<String[]>>();
            this.roundOutput.put(new Integer(roundNum), round);
        }
        if ((group = (Vector<String[]>)round.get(new Integer(groupNum))) == null) {
            group = new Vector<String[]>();
            round.put(new Integer(groupNum), group);
        }
        group.add(output);
    }

    public void addMatchOutput(int groupNum, String[] output) {
        Vector<String[]> out = (Vector<String[]>)this.matchOutput.get(new Integer(groupNum));
        if (out == null) {
            out = new Vector<String[]>();
            this.matchOutput.put(new Integer(groupNum), out);
        }
        out.add(output);
    }

    public Vector getRoundOutput(int groupNum, int roundNum) {
        Hashtable round = (Hashtable)this.roundOutput.get(new Integer(roundNum));
        if (round == null) {
            return new Vector();
        }
        Vector group = (Vector)round.get(new Integer(groupNum));
        if (group == null) {
            return new Vector();
        }
        return group;
    }

    public Vector getMatchOutput(int group) {
        Vector goutput = (Vector)this.matchOutput.get(new Integer(group));
        if (goutput == null) {
            return new Vector();
        }
        return goutput;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getServerClassname() {
        return this.serverClassname;
    }

    public void setServerClassname(String scn) {
        this.serverClassname = scn;
    }

    public String getClientClassname() {
        return this.clientClassname;
    }

    public void setClientClassname(String ccn) {
        this.clientClassname = ccn;
    }

    public String getManualMatcherClassname() {
        return this.manualMatcherClassname;
    }

    public void setManualMatcherClassname(String mmc) {
        this.manualMatcherClassname = mmc;
    }

    public String getParameterVerifierClassname() {
        return this.parameterVerifierClassname;
    }

    public void setParameterVerifierClassname(String pvc) {
        this.parameterVerifierClassname = pvc;
    }
}

