/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamematchers;

import edu.caltech.ssel.multistage.server.control.ManualMatcher;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import java.util.Random;
import java.util.Vector;

public class RandomNoRepMatcher
extends ManualMatcher {
    private Vector remaining;
    private Vector groupArrays;
    private int index;

    public int[][] continueManualMatching() throws Exception {
        if (this.index >= this.groupArrays.size()) {
            return this.manualMatching();
        }
        int[][] gr = (int[][])this.groupArrays.get(this.index);
        ++this.index;
        return gr;
    }

    public int[][] generateGroup() throws Exception {
        int[][] groups = new int[numPlayers / groupSize][groupSize];
        Vector<Integer> notAssigned = new Vector<Integer>();
        for (int i = 0; i < numPlayers; ++i) {
            notAssigned.add(new Integer(i));
        }
        int groupNum = 0;
        while (true) {
            int i = -1;
            i = this.getSmallest(notAssigned);
            if (groupNum == 0) {
                i = rand.nextInt(numPlayers);
            }
            if (i == -1) break;
            notAssigned.remove(new Integer(i));
            groups[groupNum][0] = i;
            Vector allowed = (Vector)this.remaining.get(i);
            Vector repository = this.intersection(notAssigned, allowed);
            if (repository.size() < groupSize - 1) {
                return null;
            }
            for (int j = 1; j < groupSize; ++j) {
                if (repository.size() <= 0) {
                    return null;
                }
                Integer chosen = (Integer)repository.remove(this.choosePlayer(i, repository));
                int chosenInt = chosen;
                groups[groupNum][j] = chosen;
                for (int member = 0; member <= j; ++member) {
                    Vector allowedV = (Vector)this.remaining.get(groups[groupNum][member]);
                    for (int k = 0; k <= j; ++k) {
                        allowedV.remove(new Integer(groups[groupNum][k]));
                    }
                }
                notAssigned.remove(chosen);
                Vector chosenAllowed = (Vector)this.remaining.get(chosenInt);
                repository = this.intersection(repository, chosenAllowed);
            }
            ++groupNum;
        }
        return groups;
    }

    private void printRepositories(Vector notAssigned) {
        for (int i = 0; i < this.remaining.size(); ++i) {
            System.out.println("Player " + i + ": " + this.intersection(notAssigned, (Vector)this.remaining.get(i)));
        }
    }

    private int choosePlayer(int P, Vector repository) {
        Vector allowed = (Vector)this.remaining.get(P);
        int largestLoss = 0;
        Vector<Integer> largestLosers = new Vector<Integer>();
        largestLosers.add(new Integer(rand.nextInt(repository.size())));
        int largestLoser = rand.nextInt(repository.size());
        for (int i = 0; i < repository.size(); ++i) {
            int partner = (Integer)repository.get(i);
            Vector partnerRepo = (Vector)this.remaining.get(partner);
            int amountLost = this.intersection(partnerRepo, repository).size();
            if (amountLost > largestLoss) {
                largestLoss = amountLost;
                largestLosers = new Vector();
                largestLosers.add(new Integer(i));
                continue;
            }
            if (amountLost != largestLoss) continue;
            largestLoss = amountLost;
            largestLosers.add(new Integer(i));
        }
        return (Integer)largestLosers.get(rand.nextInt(largestLosers.size()));
    }

    private int getSmallest(Vector notAssigned) {
        int smallest = -1;
        int player = -1;
        for (int i = 0; i < this.remaining.size(); ++i) {
            if (!notAssigned.contains(new Integer(i))) continue;
            Vector allowed = (Vector)this.remaining.get(i);
            Vector repository = this.intersection(notAssigned, allowed);
            if (smallest == -1) {
                player = i;
                smallest = repository.size();
                continue;
            }
            if (repository.size() > smallest) continue;
            player = i;
            smallest = repository.size();
        }
        return player;
    }

    public int[][] manualMatching() throws Exception {
        int[][] group;
        this.remaining = new Vector();
        this.groupArrays = new Vector();
        this.index = 0;
        long numCombinations = this.factorial(numPlayers, groupSize) / this.factorial(groupSize);
        long playersPerGroup = numPlayers / groupSize;
        int optimalNumGroups = (int)(numCombinations / playersPerGroup);
        for (int i = 0; i < numPlayers; ++i) {
            Vector<Integer> allowed = new Vector<Integer>();
            for (int j = 0; j < numPlayers; ++j) {
                allowed.add(new Integer(j));
            }
            this.remaining.add(allowed);
        }
        while ((group = this.generateGroup()) != null) {
            this.groupArrays.add(group);
        }
        if (this.groupArrays.size() == optimalNumGroups) {
            ++this.index;
            return (int[][])this.groupArrays.get(0);
        }
        return this.manualMatching();
    }

    private long factorial(int X, int num) {
        if (num == 1) {
            return X;
        }
        return (long)X * this.factorial(X - 1, num - 1);
    }

    private long factorial(int X) {
        if (X == 1) {
            return X;
        }
        return (long)X * this.factorial(X - 1);
    }

    public Vector intersection(Vector v1, Vector v2) {
        Vector r = new Vector();
        for (int i = 0; i < v1.size(); ++i) {
            Object element = v1.get(i);
            if (!v2.contains(element)) continue;
            r.add(element);
        }
        return r;
    }

    public static void main(String[] args) {
        ServerVariables.rand = new Random();
        ServerVariables.numPlayers = 10;
        ServerVariables.groupSize = 2;
        RandomNoRepMatcher mm = new RandomNoRepMatcher();
        mm.test(50);
    }

    public boolean verifyGroupSize(int groupSize) throws InvalidParameterException {
        return groupSize == 2;
    }
}

