/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamematchers;

import edu.caltech.ssel.multistage.server.control.ManualMatcher;
import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class ParameterMatcher
extends ManualMatcher {
    public static Category log = Logger.getLogger(ParameterMatcher.class);

    public int[][] continueManualMatching() throws Exception {
        return this.manualMatching();
    }

    public int[][] manualMatching() throws Exception {
        int i;
        String prefix = "match." + currentMatch + ".matching.";
        int numGroups = 0;
        try {
            numGroups = Integer.parseInt(props.getProperty(prefix + "numGroups"));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        if (numGroups != numPlayers / groupSize) {
            log.error((Object)("The Parameter matching service is expecting " + numPlayers / groupSize + " groups, but the file specifies " + numGroups + "."));
            throw new InvalidParameterException("The Parameter matching service is expecting " + numPlayers / groupSize + " groups, but the file specifies " + numGroups + ".");
        }
        int[][] groups = new int[numGroups][groupSize];
        boolean[] used = new boolean[numPlayers];
        for (i = 0; i < used.length; ++i) {
            used[i] = false;
        }
        for (i = 0; i < numGroups; ++i) {
            if (!props.containsKey(prefix + "group." + i)) {
                log.error((Object)("The Parameter matching service is expecting parameters for " + numGroups + " different groups, group.0 through group." + (numGroups - 1) + ", but " + prefix + ".group." + i + " is missing"));
                throw new InvalidParameterException("The Parameter matching service is expecting parameters for " + numGroups + " different groups, group.0 through group." + (numGroups - 1) + ", but " + prefix + ".group." + i + " is missing");
            }
            String gs = props.getProperty(prefix + "group." + i);
            StringTokenizer tok = new StringTokenizer(gs, ",");
            if (tok.countTokens() != groupSize) {
                log.error((Object)("The Parameter matching service is expecting groups of size " + groupSize + ", but the parameters file contains the value \"" + gs + "\", which has " + tok.countTokens() + " entries."));
                throw new InvalidParameterException("The Parameter matching service is expecting groups of size " + groupSize + ", but the parameters file contains the value \"" + gs + "\", which has " + tok.countTokens() + " entries.");
            }
            for (int g = 0; g < groupSize; ++g) {
                int player = 0;
                String token = tok.nextToken().trim();
                try {
                    player = Integer.parseInt(token);
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)("The Parameter matching service expects group entries to be integers from 0 to " + (groupSize - 1) + ", but the group." + i + " parameter contains an entry of: " + token + ".  This isn't a properly formed integer."));
                    throw new InvalidParameterException("The Parameter matching service expects group entries to be integers from 0 to " + (groupSize - 1) + ", but the group." + i + " parameter contains an entry of: " + token + ".  This isn't a properly formed integer.");
                }
                if (player >= numPlayers) {
                    log.error((Object)("The Parameter matching service is expecting matching information for " + numPlayers + " different players, but the parameter file contains an entry for player " + player + ", which is too high"));
                    throw new InvalidParameterException("The Parameter matching service is expecting matching information for " + numPlayers + " different players, but the parameter file contains an entry for player " + player + ", which is too high");
                }
                if (player < 0) {
                    log.error((Object)("The Parameter matching service is expecting matching information for " + numPlayers + " different players, but the parameter file contains an entry for player " + player + ", which is less than zero, and not allowed."));
                    throw new InvalidParameterException("The Parameter matching service is expecting matching information for " + numPlayers + " different players, but the parameter file contains an entry for player " + player + ", which is less than zero, and not allowed.");
                }
                groups[i][g] = player;
                used[player] = true;
            }
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i]) continue;
            log.error((Object)("The Parameter matching service is expecting one entry for every player, and the player numbered " + i + " was not mentioned in the parameters.  Please check and see if some other player was used more than once."));
            throw new InvalidParameterException("The Parameter matching service is expecting one entry for every player, and the player numbered " + i + " was not mentioned in the parameters.  Please check and see if some other player was used more than once.");
        }
        return groups;
    }

    public boolean verifyGroupSize(int groupSize) throws InvalidParameterException {
        return true;
    }
}

