/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamecontrollers;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Category;

public class WebCampaignControl
extends ServerControl {
    private int[] gameNum;
    private int[] stateNum;
    private String commandLine;
    private String libPath;
    private int numQuestions;
    private int numStates;
    private Vector[] assignments;
    private Boolean debug;
    private boolean askQuestions;
    private Vector[][] survey;
    private boolean singlePlayerTest;
    private String finishedMessage;
    private Thread[] surveyThreads;
    private Long timePerState;
    private Information[] lastMessages;
    protected static Vector randStates;
    public static final int NUMOFSTATES = 5;
    public static Category log;

    public void initialize() {
        this.gameNum = new int[groupSize];
        this.stateNum = new int[groupSize];
        this.numQuestions = this.getIntProperty("questionsPerState", 4);
        this.numStates = this.getIntProperty("statesPerPlayer", 5);
        this.commandLine = this.getStringProperty("browserCommand");
        this.libPath = this.getStringProperty("libPath");
        this.debug = Boolean.valueOf(this.getStringProperty("debug", "false"));
        this.singlePlayerTest = Boolean.valueOf(this.getStringProperty("singlePlayerTest", "false"));
        this.finishedMessage = this.getStringProperty("finishedMessage", "You have successfully answered all questions");
        this.askQuestions = Boolean.valueOf(this.getStringProperty("askQuestions", "false"));
        this.timePerState = new Long(this.getStringProperty("timePerState", "100"));
        if (this.askQuestions) {
            this.survey = this.constructQuestions();
        }
        if (!this.singlePlayerTest) {
            this.assignments = this.assignStates();
        }
        this.surveyThreads = new Thread[groupSize];
    }

    public void runSequence() throws AbortRoundException {
        try {
            Information[] info = new Information[groupSize];
            for (int i = 0; i < groupSize; ++i) {
                info[i] = new Information();
                info[i].addInfo("commandLine", this.commandLine);
                info[i].addInfo("libPath", this.libPath);
                info[i].addInfo("debug", this.debug);
                info[i].addBooleanInfo("singlePlayerTest", this.singlePlayerTest);
            }
            Information[] informationArray = this.askAsynchronous(info);
        }
        catch (Exception e) {
            log.error((Object)"Failed to run the WebCampaign controller", (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected Information[] processRound(MessageProcessor proc) throws AbortRoundException {
        try {
            this.lastMessages = new Information[groupSize];
            for (int i = 0; i < groupSize; ++i) {
                Information info = new Information();
                String question = this.getStringPropertyParsed("game.0.query", "No question entered for this round");
                String homepage = "";
                homepage = !this.singlePlayerTest ? this.getStringProperty((String)this.assignments[i].get(this.stateNum[i])) : "http://www.yahoo.com";
                info.addInfo("query", question);
                info.addInfo("homepage", homepage);
                info.addInfo("newState", "true");
                info.addInfo("time", this.timePerState);
                if (!this.singlePlayerTest) {
                    this.addOutput(i, "state.0", (String)this.assignments[i].get(this.stateNum[i]));
                }
                this.send(i, info);
                this.lastMessages[i] = info;
                log.debug((Object)("Sent game request to partner " + i + " with homepage " + homepage + " and query " + question));
            }
            while (true) {
                int i;
                MessagePacket mes = this.mproc.receive();
                final int src = mes.getSource();
                int type = mes.getType();
                Information responses = (Information)mes.getObject();
                String responseType = (String)responses.getInfo("responseType");
                log.debug((Object)("WebCampaign control has received a message from source " + src + " of type " + type + " with instruction " + responseType));
                if (responseType.equals("resend")) {
                    this.send(src, this.lastMessages[src]);
                    log.warn((Object)("Server resending previous WebCampaign message to partner number " + src));
                    continue;
                }
                boolean expired = false;
                if (responseType.equals("expired")) {
                    expired = true;
                }
                if (!expired) {
                    String prepender = "state." + this.stateNum[src] + ".query." + this.gameNum[src] + ".";
                    this.addOutput(src, prepender + "response", (String)responses.getInfo("response"));
                    this.addOutput(src, prepender + "numClicks", (String)responses.getInfo("numClicks"));
                    this.addOutput(src, prepender + "time", (String)responses.getInfo("time"));
                }
                int n = src;
                this.gameNum[n] = this.gameNum[n] + 1;
                if (this.gameNum[src] >= this.numQuestions || expired) {
                    this.gameNum[src] = 0;
                    int n2 = src;
                    this.stateNum[n2] = this.stateNum[n2] + 1;
                    if (this.askQuestions) {
                        final Vector[] qs = new Vector[this.survey.length];
                        for (int i2 = 0; i2 < qs.length; ++i2) {
                            qs[i2] = this.survey[i2][src];
                        }
                        Runnable run = new Runnable(){

                            public void run() {
                                WebCampaignControl.this.questionSubject(src, qs, true);
                            }
                        };
                        Thread updateThread = new Thread(run);
                        updateThread.start();
                        this.surveyThreads[src] = updateThread;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.stateNum[src] == 5) {
                    log.debug((Object)("Partner " + src + " has finished last state"));
                    Information info = new Information();
                    info.addInfo("finishedMessage", this.finishedMessage);
                    this.send(src, info);
                }
                boolean roundComplete = true;
                for (i = 0; i < this.stateNum.length; ++i) {
                    if (this.stateNum[i] == 5) continue;
                    roundComplete = false;
                }
                if (roundComplete) {
                    log.debug((Object)"All partners have finished the round");
                    for (i = 0; i < this.surveyThreads.length; ++i) {
                        Thread thr = this.surveyThreads[i];
                        if (thr == null || !thr.isAlive()) continue;
                        thr.join();
                    }
                    break;
                }
                if (this.stateNum[src] >= 5) continue;
                log.debug((Object)("Sending " + src + " the next question"));
                String question = this.getStringPropertyParsed("game." + this.gameNum[src] + ".query", "No question entered for this round");
                String homepage = "";
                homepage = !this.singlePlayerTest ? this.getStringProperty((String)this.assignments[src].get(this.stateNum[src])) : "http://www.yahoo.com";
                Information info = new Information();
                info.addInfo("query", question);
                info.addInfo("homepage", homepage);
                if (this.gameNum[src] == 0) {
                    info.addInfo("newState", "true");
                    info.addInfo("time", this.timePerState);
                    if (!this.singlePlayerTest) {
                        this.addOutput(src, "state." + this.stateNum[src], (String)this.assignments[src].get(this.stateNum[src]));
                    }
                } else {
                    info.addInfo("newState", "false");
                }
                this.send(src, info);
                log.debug((Object)("Sent game request (in response) to partner " + src + " with homepage " + homepage + " and query " + question));
                this.lastMessages[src] = info;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Failed to run the WebCampaign controller", (Throwable)e);
            e.printStackTrace();
            throw new AbortRoundException();
        }
    }

    public synchronized void proceed() {
        this.notifyAll();
    }

    private Vector[] assignStatesDeprecated() {
        int i;
        Vector[] assignments = new Vector[groupSize];
        int numPasses = groupSize / 10;
        for (i = 0; i < groupSize; ++i) {
            assignments[i] = new Vector();
        }
        for (i = 0; i < numPasses; ++i) {
            Vector states = WebCampaignControl.getStateVector();
            int chooser = 0;
            while (!states.isEmpty()) {
                Vector player = assignments[chooser];
                String state = (String)states.get(this.rand.nextInt(states.size()));
                if (!player.contains(state)) {
                    player.add(state);
                    states.remove(state);
                    ++chooser;
                }
                if (chooser < groupSize) continue;
                chooser = 0;
            }
        }
        return assignments;
    }

    private Vector[] assignStates() {
        Vector[] assignments = new Vector[groupSize];
        Vector states = WebCampaignControl.getStateVector();
        for (int i = 0; i < assignments.length; ++i) {
            int startNum;
            assignments[i] = new Vector();
            for (int j = startNum = i * 5; j < startNum + 5; ++j) {
                int index = j + this.groupNumber;
                if (index < startNum + 5) {
                    assignments[i].add(states.get(index));
                    continue;
                }
                assignments[i].add(states.get(index - 5));
            }
        }
        return assignments;
    }

    private void printAssignments(Vector[] assignments) {
        for (int i = 0; i < groupSize; ++i) {
            Vector player = assignments[i];
            for (int j = 0; j < player.size(); ++j) {
                System.out.println("Player " + i + ", State " + j + ": " + (String)player.get(j));
            }
        }
    }

    protected static Vector getStateVector() {
        if (randStates != null) {
            return randStates;
        }
        randStates = new Vector();
        Vector<String> states = new Vector<String>();
        states.add("al");
        states.add("ak");
        states.add("az");
        states.add("ar");
        states.add("ca");
        states.add("co");
        states.add("ct");
        states.add("de");
        states.add("fl");
        states.add("ga");
        states.add("hi");
        states.add("id");
        states.add("il");
        states.add("in");
        states.add("ia");
        states.add("ks");
        states.add("ky");
        states.add("la");
        states.add("me");
        states.add("md");
        states.add("ma");
        states.add("mi");
        states.add("mn");
        states.add("ms");
        states.add("mo");
        states.add("mt");
        states.add("ne");
        states.add("nv");
        states.add("nh");
        states.add("nj");
        states.add("nm");
        states.add("ny");
        states.add("nc");
        states.add("nd");
        states.add("oh");
        states.add("ok");
        states.add("or");
        states.add("pa");
        states.add("ri");
        states.add("sc");
        states.add("sd");
        states.add("tn");
        states.add("tx");
        states.add("ut");
        states.add("vt");
        states.add("va");
        states.add("wa");
        states.add("wv");
        states.add("wi");
        states.add("wy");
        Random rand = new Random(System.currentTimeMillis());
        for (int size = states.size(); size > 0; --size) {
            randStates.add(states.remove(Math.abs(rand.nextInt() % size)));
        }
        return randStates;
    }

    static {
        log = Category.getInstance(WebCampaignControl.class);
    }
}

