/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamecontrollers;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.ChoiceQuestion;
import edu.caltech.ssel.multistage.shared.data.DegreeQuestion;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.data.InstructionQuestion;
import edu.caltech.ssel.multistage.shared.data.Question;
import edu.caltech.ssel.multistage.shared.data.TextQuestion;
import java.text.DecimalFormat;
import java.util.Vector;
import org.apache.log4j.Category;

public class InformationControl
extends ServerControl {
    private Vector[] questions;
    private Question[] tieBreaker;
    private int tieBreakerTime;
    private float p1;
    private float p2;
    private float p3;
    private float p4;
    private boolean doTask;
    private int predictionMethod;
    private int feedbackType;
    private int feedbackMethod;
    private int feedbackThreshold;
    private int priceChoiceFeedback;
    private int maxFeedbackPrice;
    private float payoffChoicePrediction;
    private float quadA;
    private float quadB;
    private String positivePrediction;
    private String negativePrediction;
    private int sequence;
    private int numSignals;
    private int freeInfo;
    private int taskTime;
    private float questionRate;
    private float endowment;
    private boolean runQuiz;
    private boolean runSurvey;
    private boolean showPayoff;
    private Vector[] quiz;
    private Vector[] survey;
    private static int NO_FEEDBACK = 0;
    private static int YES_FEEDBACK = 1;
    private static int WTP_FEEDBACK = 2;
    private static int FIXED_CHOICE_FEEDBACK = 3;
    private static int ABSOLUTE_PREDICTION = 0;
    private static int RELATIVE_PREDICTION = 1;
    private static int ABSOLUTE_FEEDBACK = 0;
    private static int RELATIVE_FEEDBACK = 1;
    private static int PROB_PREDICTION = 0;
    private static int BINARY_PREDICTION = 1;
    private static int PS_SEQUENCE = 0;
    private static int SP_SEQUENCE = 1;
    private static int YES_FREE_INFO = 0;
    private static int NO_FREE_INFO = 1;
    private static int CHOOSE_FREE_INFO = 2;
    private static int TASK_REQUEST = 0;
    private static int PREDICTION_REQUEST = 1;
    private static int FEEDBACK_PURCHASE_REQUEST = 2;
    private static int FREE_INFO_REQUEST = 3;
    private static Category log = Category.getInstance(InformationControl.class);

    public void initialize() {
        this.loadVariables();
        this.questions = this.loadQuestions("question", false);
        this.tieBreaker = new Question[groupSize];
        for (int i = 0; i < this.tieBreaker.length; ++i) {
            this.tieBreaker[i] = (Question)this.questions[i].remove(this.questions[i].size() - 1);
        }
        this.runQuiz = this.getBooleanProperty("runQuiz", false);
        if (this.runQuiz) {
            this.quiz = this.loadQuestions("quiz", true);
        }
        this.runSurvey = this.getBooleanProperty("runSurvey", false);
        if (this.runSurvey) {
            this.survey = this.loadQuestions("survey", false);
        }
    }

    private void loadVariables() {
        this.endowment = this.getFloatProperty("endowment", 50.0f);
        this.showPayoff = this.getBooleanProperty("showPayoff", true);
        this.doTask = this.getBooleanProperty("doTask", true);
        if (this.doTask) {
            this.taskTime = this.getIntProperty("taskTime", 100);
            this.questionRate = this.getFloatProperty("questionRate", 10.0f);
            this.tieBreakerTime = this.getIntProperty("tieBreakerTime", 30);
        }
        this.feedbackThreshold = this.getIntProperty("feedbackThreshold", 10);
        this.predictionMethod = PROB_PREDICTION;
        String str = this.getStringProperty("predictionMethod", "prob");
        if (str.equalsIgnoreCase("binary")) {
            this.predictionMethod = BINARY_PREDICTION;
        }
        if (this.predictionMethod == BINARY_PREDICTION) {
            this.payoffChoicePrediction = this.getFloatProperty("payoffChoicePrediction", 10.0f);
            this.positivePrediction = this.getStringProperty("positivePrediction", "I am in the top 10%");
            this.negativePrediction = this.getStringProperty("negativePrediction", "I am not in the top 10%");
        }
        if (this.predictionMethod == PROB_PREDICTION) {
            this.quadA = this.getFloatProperty("quadA", 10.0f);
            this.quadB = this.getFloatProperty("quadB", 10.0f);
        }
        this.feedbackMethod = NO_FEEDBACK;
        str = this.getStringProperty("feedbackMethod", "no");
        if (str.equalsIgnoreCase("yes")) {
            this.feedbackMethod = YES_FEEDBACK;
        }
        if (str.equalsIgnoreCase("wtp")) {
            this.feedbackMethod = WTP_FEEDBACK;
        }
        if (str.equalsIgnoreCase("choice")) {
            this.feedbackMethod = FIXED_CHOICE_FEEDBACK;
        }
        if (this.feedbackMethod == WTP_FEEDBACK) {
            this.sequence = PS_SEQUENCE;
            str = this.getStringProperty("sequence", "ps");
            if (str.equalsIgnoreCase("sp")) {
                this.sequence = SP_SEQUENCE;
            }
            this.maxFeedbackPrice = this.getIntProperty("maxFeedbackPrice", 10);
        }
        if (this.feedbackMethod == FIXED_CHOICE_FEEDBACK) {
            this.priceChoiceFeedback = this.getIntProperty("priceChoiceFeedback", 10);
        }
        this.numSignals = this.getIntProperty("numSignals", 1);
        this.feedbackType = ABSOLUTE_FEEDBACK;
        str = this.getStringProperty("feedbackType", "absolute");
        if (str.equalsIgnoreCase("relative")) {
            this.feedbackType = RELATIVE_FEEDBACK;
        }
        this.feedbackThreshold = this.getIntProperty("feedbackThreshold", 10);
        this.p1 = this.getFloatProperty("p1", 0.8f);
        this.p2 = this.getFloatProperty("p2", 0.2f);
        if (this.numSignals == 2) {
            this.p3 = this.getFloatProperty("p3", 0.8f);
            this.p4 = this.getFloatProperty("p4", 0.2f);
        }
        this.freeInfo = NO_FREE_INFO;
        str = this.getStringProperty("freeInfo", "no");
        if (str.equalsIgnoreCase("yes")) {
            this.freeInfo = YES_FREE_INFO;
        }
        if (str.equalsIgnoreCase("choose")) {
            this.freeInfo = CHOOSE_FREE_INFO;
        }
    }

    public Vector[] loadQuestions(String modifier, boolean checkCorrect) {
        String text;
        Vector[] questions = new Vector[groupSize];
        for (int i = 0; i < questions.length; ++i) {
            questions[i] = new Vector();
        }
        int numQuestions = this.getIntProperty(modifier + ".numQuestions", 0);
        for (int i = 0; i < numQuestions && (text = this.getStringProperty(modifier + "." + i)) != null; ++i) {
            int j;
            String option;
            String type = this.getStringProperty(modifier + "." + i + ".type", "choice");
            if (type.equalsIgnoreCase("instruction")) {
                for (int j2 = 0; j2 < groupSize; ++j2) {
                    InstructionQuestion question = new InstructionQuestion(text);
                    questions[j2].add(question);
                }
                continue;
            }
            if (type.equalsIgnoreCase("text")) {
                String correctAnswer = this.getStringProperty(modifier + "." + i + ".correctanswer", "none");
                for (int j3 = 0; j3 < groupSize; ++j3) {
                    TextQuestion question = new TextQuestion(text);
                    question.setAnswer(correctAnswer);
                    question.setSurvey(!checkCorrect);
                    question.setOutputName(modifier + "." + i + ".answer");
                    questions[j3].add(question);
                }
                continue;
            }
            int correctAnswer = this.getIntProperty(modifier + "." + i + ".correctanswer", 0);
            Vector<String> optionsVect = new Vector<String>();
            int numOptions = this.getIntProperty(modifier + "." + i + ".numOptions", 0);
            for (int o = 0; o < numOptions && (option = this.getStringProperty(modifier + "." + i + ".answer." + o)) != null; ++o) {
                optionsVect.add(option);
            }
            String[] options = new String[optionsVect.size()];
            for (j = 0; j < options.length; ++j) {
                options[j] = (String)optionsVect.get(j);
            }
            for (j = 0; j < groupSize; ++j) {
                ChoiceQuestion question = new ChoiceQuestion(text, options);
                question.setAnswerIndex(correctAnswer);
                question.setSurvey(!checkCorrect);
                question.setOutputName(modifier + "." + i + ".answer");
                questions[j].add(question);
            }
        }
        return questions;
    }

    public void runSequence() throws AbortRoundException {
        if (this.runQuiz) {
            this.questionSubjects(this.quiz, "Experiment Understanding Quiz", "Submit");
        }
        int[][] taskInfo = this.doTask(this.questions);
        int[] numCorrect = taskInfo[0];
        int[] rankings = taskInfo[1];
        int[] tieBreakCorrect = taskInfo[2];
        boolean[] percentileResults = this.getPercentileResults(this.feedbackThreshold, rankings);
        int[][] prediction = this.doPrediction(false, this.feedbackType, this.predictionMethod, this.feedbackMethod, this.feedbackThreshold, this.positivePrediction, this.negativePrediction, null, null);
        int[][] signalInfo = this.getSignal(this.feedbackMethod, this.numSignals, this.maxFeedbackPrice, this.priceChoiceFeedback);
        String[] feedback = new String[groupSize];
        int[] sources = new int[groupSize];
        for (int i = 0; i < signalInfo.length; ++i) {
            int signalReceived;
            sources[i] = signalReceived = signalInfo[i][0];
            if (signalReceived == -1) {
                feedback[i] = null;
            }
            if (signalReceived == 1) {
                feedback[i] = this.getFeedback(this.feedbackType, this.p1, this.p2, numCorrect[i], percentileResults[i], this.feedbackThreshold);
            }
            if (signalReceived == 2) {
                feedback[i] = this.getFeedback(this.feedbackType, this.p3, this.p4, numCorrect[i], percentileResults[i], this.feedbackThreshold);
            }
            this.addOutput(i, "Signal_Realization", feedback[i]);
        }
        this.outputFeedback(this.feedbackMethod, sources, feedback, this.numSignals);
        int[][] revisedPredictions = this.doPrediction(false, this.feedbackType, this.predictionMethod, this.feedbackMethod, this.feedbackThreshold, this.positivePrediction, this.negativePrediction, feedback, prediction);
        int[] signalCost = new int[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            signalCost[i] = signalInfo[i][1];
        }
        this.doFreeInfo(this.freeInfo, this.feedbackType, this.feedbackThreshold, numCorrect, percentileResults);
        float[] payoffs = this.calculatePayoff(numCorrect, rankings, signalCost, prediction, revisedPredictions, this.predictionMethod, this.payoffChoicePrediction, this.quadA, this.quadB, this.feedbackThreshold, this.feedbackType);
        this.addPayoffs(payoffs);
        if (this.showPayoff) {
            this.displayPayoffInfo();
        }
        if (this.runSurvey) {
            this.questionSubjects(this.survey, "Experiment Survey", "Submit");
        }
    }

    private void displayPayoffInfo() {
        DecimalFormat formatter = new DecimalFormat("######.##");
        Object[] messages = new String[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            messages[i] = "<html><center>Your total payoff accumulated so far is: <font color=red><big>" + formatter.format(this.clientData[i].getTotalPayoff()) + "</big></font></center></html>";
        }
        this.displayMessage("Payoff", messages);
    }

    private int[][] doTask(Vector[] questions) throws AbortRoundException {
        int[][] taskInfo = new int[3][groupSize];
        Information[] info = new Information[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            info[i] = new Information();
            info[i].addIntInfo("type", TASK_REQUEST);
            info[i].addInfo("questions", questions[i]);
            info[i].addIntInfo("time", this.taskTime);
            info[i].addInfo("tieBreaker", this.tieBreaker[i]);
            info[i].addIntInfo("tieBreakerTime", this.tieBreakerTime);
        }
        Information[] responses = this.askAllPlayers(info);
        Vector[] answers = new Vector[groupSize];
        Question[] tieBreakAnswers = new Question[groupSize];
        int[] tieBreakTimes = new int[groupSize];
        for (int i = 0; i < responses.length; ++i) {
            answers[i] = (Vector)responses[i].getInfo("answers");
            tieBreakAnswers[i] = (Question)responses[i].getInfo("tbAnswer");
            tieBreakTimes[i] = responses[i].getIntInfo("tbTime");
            System.out.println("Partner " + i + " answered the tiebreaker in " + tieBreakTimes[i] + " + seconds");
        }
        int[] numCorrect = new int[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            numCorrect[i] = this.outputQuestionResults(i, answers);
        }
        boolean[] tieBreakCorrect = this.outputTieBreakerResults(tieBreakAnswers, tieBreakTimes);
        int[] rankings = this.getRankings(numCorrect, tieBreakCorrect, tieBreakTimes);
        taskInfo[0] = numCorrect;
        taskInfo[1] = rankings;
        taskInfo[2] = new int[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            taskInfo[2][i] = tieBreakCorrect[i] ? 1 : 0;
        }
        return taskInfo;
    }

    private boolean[] outputTieBreakerResults(Question[] answers, int[] times) {
        boolean[] correct = new boolean[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            Question ques = answers[i];
            this.addOutput(i, "question.tiebreak.timeAnswered", "" + times[i]);
            String realAnswer = ques.getAnswer();
            String chosenAnswer = ques.getChosenAnswer();
            System.out.println("Chosen Answer: " + chosenAnswer + "; Real Answer: " + realAnswer);
            if (realAnswer != null && chosenAnswer != null && realAnswer.equalsIgnoreCase(chosenAnswer)) {
                this.addOutput(i, "question.tiebreak.correct", "TRUE");
                correct[i] = true;
                continue;
            }
            this.addOutput(i, "question.tiebreak.correct", "FALSE");
            correct[i] = false;
        }
        return correct;
    }

    private void doFreeInfo(int freeInfo, int feedbackType, int feedbackThreshold, int[] numCorrect, boolean[] results) throws AbortRoundException {
        int i;
        boolean[] receiveFreeInfo = new boolean[groupSize];
        String[] truePerformance = new String[groupSize];
        for (i = 0; i < truePerformance.length; ++i) {
            truePerformance[i] = this.getActual(i, feedbackType, numCorrect[i], results[i], feedbackThreshold);
        }
        if (freeInfo == NO_FREE_INFO) {
            for (i = 0; i < groupSize; ++i) {
                receiveFreeInfo[i] = false;
            }
        } else if (freeInfo == YES_FREE_INFO) {
            Object[] messages = new String[groupSize];
            for (int i2 = 0; i2 < groupSize; ++i2) {
                receiveFreeInfo[i2] = true;
                messages[i2] = "Your True Performance: " + truePerformance[i2];
            }
            this.displayMessage("Your Performance", messages, "OK");
        } else if (freeInfo == CHOOSE_FREE_INFO) {
            Information[] info = new Information[groupSize];
            for (int i3 = 0; i3 < groupSize; ++i3) {
                info[i3] = new Information();
                info[i3].addIntInfo("type", FREE_INFO_REQUEST);
                info[i3].addIntInfo("feedbackType", feedbackType);
                info[i3].addIntInfo("threshold", feedbackThreshold);
                info[i3].addStringInfo("actual", truePerformance[i3]);
            }
            Information[] responses = this.askAllPlayers(info);
            for (int i4 = 0; i4 < responses.length; ++i4) {
                receiveFreeInfo[i4] = responses[i4].getBooleanInfo("receivedInfo");
            }
        }
        for (int i5 = 0; i5 < receiveFreeInfo.length; ++i5) {
            if (receiveFreeInfo[i5]) {
                this.addOutput(i5, "receivedFreeInfo", "1");
                continue;
            }
            this.addOutput(i5, "receivedFreeInfo", "0");
        }
    }

    private int[][] doPrediction(boolean forNextPeriod, int predictionType, int predictionMethod, int feedbackMethod, int feedbackThreshold, String positiveChoice, String negativeChoice, String[] feedback, int[][] oldPrediction) throws AbortRoundException {
        int[][] prediction = new int[groupSize][2];
        Information[] info = new Information[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            info[i] = new Information();
            info[i].addIntInfo("type", PREDICTION_REQUEST);
            info[i].addBooleanInfo("forNextPeriod", forNextPeriod);
            info[i].addIntInfo("predictionType", predictionType);
            info[i].addIntInfo("predictionMethod", predictionMethod);
            info[i].addIntInfo("threshold", feedbackThreshold);
            info[i].addIntInfo("feedbackMethod", feedbackMethod);
            if (predictionMethod == BINARY_PREDICTION) {
                info[i].addStringInfo("positiveChoice", positiveChoice);
                info[i].addStringInfo("negativeChoice", negativeChoice);
                info[i].addFloatInfo("choicePayoff", this.payoffChoicePrediction);
            }
            if (feedback != null) {
                info[i].addBooleanInfo("revisionStage", true);
                if (feedback[i] == null) {
                    info[i].addBooleanInfo("receivedFeedback", false);
                    continue;
                }
                info[i].addBooleanInfo("receivedFeedback", true);
                info[i].addStringInfo("feedback", feedback[i]);
                continue;
            }
            info[i].addBooleanInfo("revisionStage", false);
            info[i].addBooleanInfo("receivedFeedback", false);
        }
        Information[] res = this.askAllPlayers(info);
        for (int i = 0; i < groupSize; ++i) {
            if (feedback == null || feedback[i] != null) {
                prediction[i][0] = res[i].getIntInfo("probAffirmative");
                prediction[i][1] = predictionMethod == BINARY_PREDICTION ? res[i].getIntInfo("choice") : -1;
                if (feedback == null) {
                    this.addOutput(i, "initialProbAffirmative", "" + prediction[i][0]);
                    if (predictionMethod != BINARY_PREDICTION) continue;
                    this.addOutput(i, "initialBinaryChoice", "" + prediction[i][1]);
                    continue;
                }
                this.addOutput(i, "revisedProbAffirmative", "" + prediction[i][0]);
                if (predictionMethod != BINARY_PREDICTION) continue;
                this.addOutput(i, "revisedBinaryChoice", "" + prediction[i][1]);
                continue;
            }
            prediction[i][0] = oldPrediction[i][0];
            prediction[i][1] = oldPrediction[i][1];
        }
        return prediction;
    }

    private int[][] getSignal(int feedbackMethod, int numSignals, int maxFeedbackPrice, int priceChoiceFeedback) throws AbortRoundException {
        int signalChosen;
        int i;
        Information[] res;
        int i2;
        if (feedbackMethod == WTP_FEEDBACK) {
            String text = "";
            text = numSignals == 1 ? "<html><center>You have the option of purchasing information on your performance from an information source.<br><br>You will be asked to state the maximum price you would be willing to pay to observe a signal of your performance from this source.<br><br>The computer will randomly pick a price for the information, called <font color=red>P</font> from the interval (0, " + maxFeedbackPrice + ").<br><br>" + "If <font color=red>Your Max Price is GREATER than P</font> you pay P and observe the signal.<br><br>" + "If <font color=red>Your Max Price is LESS than P</font> you don't pay anything and don't observe the signal.<br><br>" + "Properties of the information source are displayed on the projector screens.</center></html>" : "<html><center>You have the option of purchasing information on your performance from one of the two different information sources.<br><br>For each source, you will be asked to state the maximum price you would be willing to pay to observe a signal from that source.<br><br>The computer will pick one of the sources randomly. It will also randomly pick a price for that source, called <font color=red>P</font> from the interval (0, " + maxFeedbackPrice + ").<br><br>" + "If <font color=red>Your Max Price is GREATER than P</font> you pay P and observe a signal from that source.<br><br>" + "If <font color=red>Your Max Price is LESS than P</font> you don't pay anything and don't observe the signal.<br><br>" + "Properties of the two information sources are displayed on the projector screens.</center></html>";
            this.displayUniversalMessage("Information", text, "Proceed");
        }
        int[][] signalInfo = new int[groupSize][2];
        for (i2 = 0; i2 < groupSize; ++i2) {
            signalInfo[i2][1] = 0;
        }
        if (feedbackMethod == NO_FEEDBACK) {
            for (i2 = 0; i2 < groupSize; ++i2) {
                signalInfo[i2][0] = -1;
            }
        } else if (feedbackMethod == YES_FEEDBACK) {
            for (i2 = 0; i2 < groupSize; ++i2) {
                signalInfo[i2][0] = 1;
            }
        } else if (feedbackMethod == FIXED_CHOICE_FEEDBACK) {
            Information[] info = new Information[groupSize];
            for (int i3 = 0; i3 < groupSize; ++i3) {
                info[i3] = new Information();
                info[i3].addIntInfo("type", FEEDBACK_PURCHASE_REQUEST);
                info[i3].addIntInfo("feedbackMethod", feedbackMethod);
                info[i3].addIntInfo("numSignals", numSignals);
                info[i3].addIntInfo("priceChoiceFeedback", priceChoiceFeedback);
            }
            res = this.askAllPlayers(info);
            for (i = 0; i < groupSize; ++i) {
                signalChosen = res[i].getIntInfo("signalChosen");
                System.out.println("Signal chosen by client " + i + ": " + signalChosen);
                signalInfo[i][0] = signalChosen;
                signalInfo[i][1] = priceChoiceFeedback;
            }
        } else if (feedbackMethod == WTP_FEEDBACK) {
            Information[] info = new Information[groupSize];
            for (int i4 = 0; i4 < groupSize; ++i4) {
                info[i4] = new Information();
                info[i4].addIntInfo("type", FEEDBACK_PURCHASE_REQUEST);
                info[i4].addIntInfo("feedbackMethod", feedbackMethod);
                info[i4].addIntInfo("numSignals", numSignals);
                info[i4].addIntInfo("maxFeedbackPrice", maxFeedbackPrice);
            }
            res = this.askAllPlayers(info);
            for (i = 0; i < groupSize; ++i) {
                signalChosen = this.rand.nextInt(numSignals) + 1;
                int wtp = res[i].getIntInfo("wtp-" + signalChosen);
                int draw = this.rand.nextInt(maxFeedbackPrice + 1);
                if (draw <= wtp) {
                    signalInfo[i][0] = signalChosen;
                    signalInfo[i][1] = draw;
                } else {
                    signalInfo[i][0] = -1;
                }
                this.addOutput(i, "wtp_signalChosen", "" + signalChosen);
                this.addOutput(i, "wtp_compPrice", "" + draw);
                this.addOutput(i, "wtp_signal-1", "" + res[i].getIntInfo("wtp-1"));
                if (numSignals != 2) continue;
                this.addOutput(i, "wtp_signal-2", "" + res[i].getIntInfo("wtp-2"));
            }
        }
        for (int i5 = 0; i5 < signalInfo.length; ++i5) {
            this.addOutput(i5, "signalSource", "" + signalInfo[i5][0]);
            this.addOutput(i5, "signalCost", "" + signalInfo[i5][1]);
        }
        return signalInfo;
    }

    private String getFeedback(int type, float posProb, float negProb, int numCorrect, boolean inPercentile, int feedbackThreshold) {
        boolean posState;
        boolean negDraw;
        String feedback = "";
        float draw = this.rand.nextFloat();
        boolean posDraw = draw < posProb;
        boolean bl = negDraw = draw < negProb;
        if (type == ABSOLUTE_FEEDBACK) {
            posState = numCorrect > feedbackThreshold;
            feedback = posState && posDraw || !posState && !negDraw ? "You answered at least " + feedbackThreshold + " questions correctly" : "You answered less than " + feedbackThreshold + " questions correctly";
        }
        if (type == RELATIVE_FEEDBACK) {
            posState = inPercentile;
            feedback = posState && posDraw || !posState && !negDraw ? "You were in the TOP " + feedbackThreshold + "% of the distribution" : "You were in the BOTTOM " + (100 - feedbackThreshold) + "% of the distribution";
        }
        return feedback;
    }

    private String getActual(int partnerNum, int type, int numCorrect, boolean inPercentile, int threshold) {
        String actual = "";
        boolean posState = false;
        if (type == ABSOLUTE_FEEDBACK) {
            boolean bl = posState = numCorrect > this.feedbackThreshold;
            actual = posState ? "You answered at least " + this.feedbackThreshold + " questions correctly" : "You answered less than " + this.feedbackThreshold + " questions correctly";
        } else if (type == RELATIVE_FEEDBACK) {
            posState = inPercentile;
            actual = posState ? "You were in the TOP " + this.feedbackThreshold + "% of the distribution" : "You were in the BOTTOM " + (100 - this.feedbackThreshold) + "% of the distribution";
        }
        this.addOutput(partnerNum, "thresholdMet", "" + posState);
        return actual;
    }

    private void outputFeedback(int feedbackMethod, int[] sources, String[] feedback, int numSignals) {
        Object[] messages = new String[groupSize];
        if (feedbackMethod == WTP_FEEDBACK) {
            for (int i = 0; i < messages.length; ++i) {
                String message = null;
                if (sources[i] != -1 && feedback[i] != null) {
                    message = numSignals == 2 ? "<html><center>Your Max Price was greater than the price picked by the computer.<br><br>The chosen source was SOURCE " + sources[i] + ".<br>" + "The signal from SOURCE " + sources[i] + " says:<br><br>" + "<font color=#003366>" + feedback[i] + "</font></center></html>" : "<html><center>Your Max Price was greater than the price picked by the computer.<br><br>The signal says:<br><br><font color=#003366>" + feedback[i] + "</font></center></html>";
                }
                messages[i] = message;
            }
        } else if (feedbackMethod == FIXED_CHOICE_FEEDBACK) {
            for (int i = 0; i < messages.length; ++i) {
                String message = null;
                if (sources[i] != -1 && feedback[i] != null) {
                    message = numSignals == 2 ? "<html><center>You will now receive a signal of your performance.<br>The chosen source was SOURCE " + sources[i] + ".<br>" + "The properties of this signal are displayed on the projector screens.<br><br>" + "The signal from SOURCE " + sources[i] + " says:<br>" + "<font color=#003366>" + feedback[i] + "</font></center></html>" : "<html><center>You will now receive a signal of your performance.<br>The signal says:<br><br><font color=#003366>" + feedback[i] + "</font></center></html>";
                }
                messages[i] = message;
            }
        } else if (feedbackMethod == YES_FEEDBACK) {
            for (int i = 0; i < messages.length; ++i) {
                String message = null;
                if (sources[i] != -1 && feedback[i] != null) {
                    message = "<html><center>You will now receive a signal of your performance.<br>The properties of this signal are displayed on the projector screens.<br><br>The signal says:<br><font color=#003366>" + feedback[i] + "</font></center></html>";
                }
                messages[i] = message;
            }
        }
        this.displayMessage("Feedback", messages, "OK");
    }

    private float[] calculatePayoff(int[] numCorrect, int[] rankings, int[] signalCost, int[][] originalPrediction, int[][] revisedPrediction, int predictionMethod, float payoffChoicePrediction, float quadA, float quadB, int feedbackThreshold, int feedbackType) {
        int i;
        float[] payoffs = new float[groupSize];
        boolean[] posState = new boolean[groupSize];
        boolean[] results = this.getPercentileResults(feedbackThreshold, rankings);
        for (i = 0; i < groupSize; ++i) {
            int[] finalPrediction = null;
            if (this.rand.nextBoolean()) {
                finalPrediction = originalPrediction[i];
                this.addOutput(i, "payoffPrediction", "original");
            } else {
                finalPrediction = revisedPrediction[i];
                this.addOutput(i, "payoffPrediction", "revised");
            }
            posState[i] = false;
            if (feedbackType == ABSOLUTE_PREDICTION && numCorrect[i] > feedbackThreshold) {
                posState[i] = true;
            }
            if (feedbackType == RELATIVE_PREDICTION && results[i]) {
                posState[i] = true;
            }
            float p = (float)finalPrediction[0] / 100.0f;
            if (predictionMethod == PROB_PREDICTION) {
                if (posState[i]) {
                    payoffs[i] = quadA - quadB * 2.0f * (1.0f - p) * (1.0f - p);
                    continue;
                }
                payoffs[i] = quadA - quadB * 2.0f * p * p;
                continue;
            }
            if (predictionMethod != BINARY_PREDICTION) continue;
            if (posState[i] && finalPrediction[1] == 0) {
                payoffs[i] = payoffChoicePrediction;
                continue;
            }
            if (posState[i] || finalPrediction[1] != 1) continue;
            payoffs[i] = payoffChoicePrediction;
        }
        for (i = 0; i < payoffs.length; ++i) {
            float taskPayoff = this.questionRate * (float)numCorrect[i];
            this.addOutput(i, "taskPayoff", "" + taskPayoff);
            this.addOutput(i, "predictionPayoff", "" + payoffs[i]);
            payoffs[i] = payoffs[i] - (float)signalCost[i] + taskPayoff + this.endowment;
        }
        return payoffs;
    }

    private int getRank(int partner, int[] numCorrect, boolean[] tbCorrect, int[] tbTimes) {
        int rank = numCorrect.length;
        for (int i = 0; i < numCorrect.length; ++i) {
            if (i == partner) continue;
            if (numCorrect[partner] < numCorrect[i]) {
                --rank;
                continue;
            }
            if (numCorrect[partner] == numCorrect[i] && !tbCorrect[partner] && tbCorrect[i]) {
                --rank;
                continue;
            }
            if (numCorrect[partner] != numCorrect[i] || !tbCorrect[partner] || !tbCorrect[i] || tbTimes[partner] <= tbTimes[i]) continue;
            --rank;
        }
        return rank;
    }

    private int[] getRankings(int[] numCorrect, boolean[] tbCorrect, int[] tbTimes) {
        int[] rankings = new int[numCorrect.length];
        for (int i = 0; i < rankings.length; ++i) {
            rankings[i] = this.getRank(i, numCorrect, tbCorrect, tbTimes);
        }
        return rankings;
    }

    private boolean[] getPercentileResults(float percentile, int[] rankings) {
        boolean[] results = new boolean[rankings.length];
        int numNeeded = (int)Math.ceil(percentile / 100.0f * (float)rankings.length);
        int topRank = rankings.length;
        for (int i = 0; i < numNeeded; ++i) {
            boolean foundSomething = false;
            for (int j = 0; j < rankings.length; ++j) {
                if (rankings[j] != topRank || results[j]) continue;
                results[j] = true;
                foundSomething = true;
                break;
            }
            if (foundSomething) continue;
            --topRank;
            --i;
        }
        return results;
    }

    private int outputQuestionResults(int type, Vector[] questions) {
        int numCorrect = 0;
        for (int i = 0; i < questions[type].size(); ++i) {
            Question ques = (Question)questions[type].get(i);
            String realAnswer = ques.getAnswer();
            String chosenAnswer = ques.getChosenAnswer();
            if (realAnswer != null && chosenAnswer != null && realAnswer.equalsIgnoreCase(chosenAnswer)) {
                this.addOutput(type, "question." + i + ".correct", "TRUE");
                ++numCorrect;
                continue;
            }
            this.addOutput(type, "question." + i + ".correct", "FALSE");
        }
        this.addOutput(type, "numCorrect", "" + numCorrect);
        return numCorrect;
    }

    protected Information[] processRound(MessageProcessor mproc) throws AbortRoundException {
        return null;
    }

    private void askSurveyQuestions() {
        int numSurveyQuestions = this.getIntProperty("survey.numQuestions");
        int numDegrees = this.getIntProperty("survey.numDegrees", 7);
        String instructions = this.getStringProperty("survey.instructions");
        String[] questionStrings = new String[numSurveyQuestions];
        for (int i = 0; i < questionStrings.length; ++i) {
            questionStrings[i] = this.getStringProperty("survey.question." + i);
        }
        String[] options = new String[numDegrees];
        for (int i = 0; i < options.length; ++i) {
            options[i] = "";
        }
        options[0] = "Strongly Agree";
        options[numDegrees - 1] = "Strongly Disagree";
        options[3] = "Neutral";
        DegreeQuestion survey1 = new DegreeQuestion(instructions, questionStrings, options, "surveyAnswers");
        DegreeQuestion survey2 = new DegreeQuestion(instructions, questionStrings, options, "surveyAnswers");
        Vector[] questions = new Vector[2];
        questions[0] = new Vector();
        questions[0].add(survey1);
        questions[1] = new Vector();
        questions[1].add(survey2);
        this.questionSubjects(questions);
    }
}

