/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamecontrollers;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.Information;
import org.apache.log4j.Category;

public class DictatorControl
extends ServerControl {
    private int maxOfferAmount;
    private Information payoffs;
    private static int SPLITTER_PLAYER = 0;
    public static Category log = Category.getInstance(DictatorControl.class);

    public void initialize() {
        this.completionMessage = "Game successfully completed";
        log.debug((Object)"A new Dictator controller has been instantiated");
        this.maxOfferAmount = this.getIntProperty("maxOffer");
        if (this.maxOfferAmount == INT_NOT_FOUND) {
            this.maxOfferAmount = 100;
        }
    }

    public void runSequence() throws AbortRoundException {
        try {
            this.initHistoryPanel();
            for (int player = 1; player < groupSize; ++player) {
                this.updateStatus(player, "Please Wait");
            }
            Information info = new Information();
            info.addInfo("maxOffer", new Integer(this.maxOfferAmount));
            Information payoffs = this.askPlayer(SPLITTER_PLAYER, info);
            this.updateStatus(SPLITTER_PLAYER, "Please Wait");
            this.addOutput(SPLITTER_PLAYER, "split_offer", "" + payoffs.getInfo(new Integer(SPLITTER_PLAYER)));
            for (int player = 1; player < groupSize; ++player) {
                this.askPlayer(player, info);
                this.addOutput(player, "split_response_" + player, "" + payoffs.getInfo(new Integer(player)));
            }
            this.updateHistoryAndPayoff(payoffs);
        }
        catch (Exception e) {
            log.warn((Object)"Dictator control has failed: aborting round");
            throw new AbortRoundException();
        }
    }

    private void initHistoryPanel() {
        for (int player = 1; player < groupSize; ++player) {
            this.addColumnData(player, "Round", "");
            this.addColumnData(player, "Your Payoff", "");
        }
    }

    private void updateHistoryAndPayoff(Information payoffs) {
        for (int player = 0; player < groupSize; ++player) {
            this.addColumnData(player, "Round", "" + (this.roundNum + 1));
            Integer payoff = (Integer)payoffs.getInfo(new Integer(player));
            this.addPayoff(player, payoff.intValue());
            this.addColumnData(player, "Your Payoff", "" + payoff);
        }
    }

    protected Information[] processRound(MessageProcessor proc) throws AbortRoundException {
        return null;
    }
}

