/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamecontrollers;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.DegreeQuestion;
import edu.caltech.ssel.multistage.shared.data.Information;
import java.util.Vector;
import org.apache.log4j.Category;

public class DelegationControl
extends ServerControl {
    String[] questions;
    String[][] answers;
    int[] correctAnswers;
    private boolean existOutsiders;
    private boolean purchaseDelegation;
    private int absoluteFeedbackThreshold;
    private float relativeFeedbackThreshold;
    private static int DOER = 0;
    private static int OUTSIDER = 1;
    private static int ABSOLUTE_FEEDBACK = 0;
    private static int RELATIVE_FEEDBACK = 1;
    private static int TASK_REQUEST = 0;
    private static int WAIT_FOR_TASK_REQUEST = 1;
    private static int DECISION_REQUEST = 2;
    private static int WAIT_FOR_DECISION_REQUEST = 3;
    private static Category log = Category.getInstance(DelegationControl.class);

    public void initialize() {
        this.loadTaskQuestions();
    }

    public void loadTaskQuestions() {
        int i;
        String question;
        Vector<String> questionVect = new Vector<String>();
        Vector answerVect = new Vector();
        Vector<Integer> correctVect = new Vector<Integer>();
        int qNumber = 0;
        while ((question = this.getStringProperty("quiz." + qNumber)) != null) {
            String option;
            questionVect.add(question);
            int correctAnswer = this.getIntProperty("quiz." + qNumber + ".correctanswer", 0);
            correctVect.add(new Integer(correctAnswer));
            Vector<String> optionsVect = new Vector<String>();
            int oNumber = 0;
            while ((option = this.getStringProperty("quiz." + qNumber + ".answer." + oNumber)) != null) {
                optionsVect.add(option);
                ++oNumber;
            }
            answerVect.add(optionsVect);
            ++qNumber;
        }
        this.questions = new String[questionVect.size()];
        for (i = 0; i < questionVect.size(); ++i) {
            this.questions[i] = (String)questionVect.get(i);
        }
        this.correctAnswers = new int[correctVect.size()];
        for (i = 0; i < correctVect.size(); ++i) {
            this.correctAnswers[i] = (Integer)correctVect.get(i);
        }
        this.answers = new String[answerVect.size()][];
        for (i = 0; i < answerVect.size(); ++i) {
            Vector optionsVect = (Vector)answerVect.get(i);
            this.answers[i] = new String[optionsVect.size()];
            for (int j = 0; j < optionsVect.size(); ++j) {
                this.answers[i][j] = (String)optionsVect.get(j);
            }
        }
    }

    public void runSequence() throws AbortRoundException {
    }

    private int[] doTask(boolean outsiderTask) throws AbortRoundException {
        Information[] info = new Information[groupSize];
        Information[] responses = null;
        for (int i = 0; i < info.length; ++i) {
            if (i == DOER || outsiderTask) {
                info[i] = new Information();
                info[i].addIntInfo("type", TASK_REQUEST);
                info[i].addInfo("questions", this.questions);
                info[i].addInfo("options", this.answers);
                continue;
            }
            info[i].addIntInfo("type", WAIT_FOR_TASK_REQUEST);
        }
        responses = this.askAllPlayers(info);
        int[] numCorrect = new int[2];
        numCorrect[DelegationControl.DOER] = this.outputQuestionResults(DOER, responses);
        numCorrect[DelegationControl.OUTSIDER] = this.outputQuestionResults(OUTSIDER, responses);
        return numCorrect;
    }

    private void makeDecision(String[] feedback, boolean allDecide, int delegator, int recipient) {
        Information decisionInfo = new Information();
    }

    private String getFeedback(int type, float posProb, float negProb, int numCorrect, int[] popCorrect, boolean forSelf) {
        boolean negDraw;
        String feedback = "";
        float draw = this.rand.nextFloat();
        boolean posDraw = draw < posProb;
        boolean bl = negDraw = draw < negProb;
        if (type == ABSOLUTE_FEEDBACK) {
            boolean posState;
            boolean bl2 = posState = numCorrect > this.absoluteFeedbackThreshold;
            feedback = posState && posDraw || !posState && !negDraw ? (forSelf ? "You answered " + this.absoluteFeedbackThreshold + " questions correctly" : "The doer answered " + this.absoluteFeedbackThreshold + " questions correctly") : (forSelf ? "You did not answer " + this.absoluteFeedbackThreshold + " questions correctly" : "The doer did not answer " + this.absoluteFeedbackThreshold + " questions correctly");
        }
        if (type == RELATIVE_FEEDBACK) {
            boolean posState;
            float percentile = this.getPercentile(numCorrect, popCorrect);
            boolean bl3 = posState = percentile > this.relativeFeedbackThreshold;
            feedback = posState && posDraw || !posState && !negDraw ? (forSelf ? "You are in the top " + this.absoluteFeedbackThreshold + "th percentile" : "The doer is in the top " + this.absoluteFeedbackThreshold + "th percnetile") : (forSelf ? "You are not in the top " + this.absoluteFeedbackThreshold + "th percentile" : "The doer is not in the top " + this.absoluteFeedbackThreshold + "th percnetile");
        }
        return feedback;
    }

    private float getPercentile(int numCorrect, int[] popCorrect) {
        int rank = popCorrect.length;
        for (int i = 0; i < popCorrect.length; ++i) {
            if (numCorrect >= popCorrect[i]) continue;
            --rank;
        }
        return (float)rank / (float)popCorrect.length;
    }

    private int outputQuestionResults(int type, Information[] responses) {
        boolean answeredQuestions = responses[type].getBooleanInfo("answeredQuestions");
        if (!answeredQuestions) {
            return -1;
        }
        int[] answers = (int[])responses[type].getInfo("answers");
        int numCorrect = 0;
        for (int i = 0; i < answers.length; ++i) {
            if (answers[i] != this.correctAnswers[i]) continue;
            ++numCorrect;
        }
        return numCorrect;
    }

    protected Information[] processRound(MessageProcessor mproc) throws AbortRoundException {
        return null;
    }

    private void askSurveyQuestions() {
        int numSurveyQuestions = this.getIntProperty("survey.numQuestions");
        int numDegrees = this.getIntProperty("survey.numDegrees", 7);
        String instructions = this.getStringProperty("survey.instructions");
        String[] questionStrings = new String[numSurveyQuestions];
        for (int i = 0; i < questionStrings.length; ++i) {
            questionStrings[i] = this.getStringProperty("survey.question." + i);
        }
        String[] options = new String[numDegrees];
        for (int i = 0; i < options.length; ++i) {
            options[i] = "";
        }
        options[0] = "Strongly Agree";
        options[numDegrees - 1] = "Strongly Disagree";
        options[3] = "Neutral";
        DegreeQuestion survey1 = new DegreeQuestion(instructions, questionStrings, options, "surveyAnswers");
        DegreeQuestion survey2 = new DegreeQuestion(instructions, questionStrings, options, "surveyAnswers");
        Vector[] questions = new Vector[2];
        questions[0] = new Vector();
        questions[0].add(survey1);
        questions[1] = new Vector();
        questions[1].add(survey2);
        this.questionSubjects(questions);
    }
}

