/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamecontrollers;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.data.Question;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompetitionControl
extends ServerControl {
    private static Category log = Category.getInstance(CompetitionControl.class);
    public static final int BDM = 0;
    public static final int FIRST_PRICE = 1;
    public static final int SECOND_PRICE = 2;
    public static final int ENGLISH = 3;
    public static final String INDIVIDUAL_TYPE = "individual";
    public static final String COMPETITION_TYPE = "competition";
    private boolean showHistory;
    private boolean showImage;
    private boolean runSurvey;
    private int majorTickSpacing;
    private int minorTickSpacing;
    private boolean endogenous;
    private Vector[][] questions;
    private int numImages;
    private static LinkedList<Integer> mixed;
    private static String[] imgLinks;
    private String type;
    private int auction;
    private boolean[] bidding;
    private boolean showRemaining;
    private int remainingBidders;
    private int timeLimit;
    private int startBid;
    private int curBid;
    private int incBid;
    private Information[] rec;
    private String thermometerDisplayType;
    private String biddersLabelText;
    private String thermometerLabelText;
    private int endBid;
    private int[] dist;
    private int[] draw;
    private String feedback;
    private String imgLink;
    private String metaLabelText;
    private String itemLabelText;
    private String bidPromptText;
    private String bidButtonText;
    private String stopButtonText;
    private String histYourBid;
    private String histHighestBid;
    private String histItem;
    private String histYourStatus;
    private String histWinnerPay;
    private String histYourPay;

    @Override
    public void initialize() {
        String imageOrderStr;
        String askQuestionsStr;
        this.type = this.getStringProperty("treatment", INDIVIDUAL_TYPE);
        this.endBid = this.getIntProperty("endBid", 100);
        String aucStr = this.getStringProperty("auction", "bdm");
        this.auction = aucStr.equals("bdm") ? 0 : (aucStr.equals("1stPrice") ? 1 : (aucStr.equals("2ndPrice") ? 2 : 3));
        if (this.auction == 0) {
            String distString = this.getStringProperty("draws");
            this.parseDist(distString);
        } else if (this.auction == 3) {
            this.startBid = this.getIntProperty("startBid", 0);
            this.incBid = this.getIntProperty("incBid", 1);
            this.timeLimit = this.getIntProperty("timeLimit", 15);
            this.thermometerDisplayType = this.getStringProperty("thermometerDisplayType", "linear");
            this.bidding = new boolean[groupSize];
            for (int i = 0; i < groupSize; ++i) {
                this.bidding[i] = true;
            }
        }
        log.info((Object)("Auction type: " + this.auction));
        this.showImage = this.getBooleanProperty("gui.showImage");
        this.metaLabelText = this.getStringProperty("gui.metaLabel", "Match %num% type: %type%");
        this.metaLabelText = this.metaLabelText.replaceAll("%num%", String.valueOf(currentMatch));
        this.metaLabelText = this.metaLabelText.replaceAll("%type%", this.type);
        if (this.auction != 0) {
            String auc = "1st Price";
            if (this.auction == 2) {
                auc = "2nd Price";
            } else if (this.auction == 3) {
                auc = "English";
            }
            this.metaLabelText = this.metaLabelText.replaceAll("%auction%", auc);
        }
        this.itemLabelText = this.getStringProperty("gui.itemLabel", "food");
        if (this.auction == 3) {
            this.showRemaining = this.getBooleanProperty("gui.showRemaining", true);
            this.bidPromptText = this.getStringProperty("gui.bidPromptLabel", "Continue Bidding?");
            this.biddersLabelText = this.getStringProperty("gui.biddersLabelText", "Remaining Bidders");
            this.thermometerLabelText = this.getStringProperty("gui.thermometerLabelText", "Price");
            this.bidButtonText = this.getStringProperty("gui.submitButtonLabel", "Yes");
            this.stopButtonText = this.getStringProperty("gui.stopButtonLabel", "No");
        } else {
            this.bidPromptText = this.getStringProperty("gui.bidPromptLabel", "Your Bid?");
            this.bidButtonText = this.getStringProperty("gui.submitButtonLabel", "Submit");
            this.majorTickSpacing = this.getIntProperty("gui.majorTickSpacing", 2);
            this.minorTickSpacing = this.getIntProperty("gui.minorTickSpacing", 1);
        }
        this.feedback = this.getStringProperty("gui.feedback", "Auction Result: %status%; Highest Bid: %highbid%; Your Bid: %yourbid%");
        this.imgLink = this.getStringProperty("gui.img", "img/food1.png");
        this.showHistory = this.getBooleanProperty("showHistory", true);
        if (this.showHistory) {
            this.histYourBid = this.getStringProperty("hist.yourBid", "Your Bid");
            this.histHighestBid = this.getStringProperty("hist.highBid", "Highest Bid");
            this.histItem = this.getStringProperty("hist.item", "Food Item");
            this.histYourStatus = this.getStringProperty("hist.yourStatus", "Your Status");
            this.histWinnerPay = this.getStringProperty("hist.winnerPay", "Winner's Payment");
            this.histYourPay = this.getStringProperty("hist.yourPay", "Your Payment");
        }
        if ((askQuestionsStr = this.getStringProperty("askQuestions")) != null && askQuestionsStr.equalsIgnoreCase("true")) {
            this.runSurvey = true;
            this.questions = this.constructQuestions();
        }
        this.endogenous = (imageOrderStr = this.getStringProperty("imageOrderType")) != null && imageOrderStr.equalsIgnoreCase("endogenous");
    }

    @Override
    public void runSequence() throws AbortRoundException {
        int i;
        if (this.runSurvey) {
            log.info((Object)"Running survey");
            Vector[][] surveyResponses = this.questionSubjects(this.questions, "Food Rating Survey", "Submit");
            log.info((Object)"Survey completed.");
            if (this.endogenous && mixed == null) {
                this.numImages = surveyResponses.length;
                LinkedList<Float> avgRatings = new LinkedList<Float>();
                imgLinks = new String[this.numImages];
                this.populateRatingsAndLinks(avgRatings, surveyResponses);
                mixed = this.makeSortedIndecesArray(avgRatings);
                this.separateAndShuffleHalves(mixed);
            }
        }
        Information[] info = new Information[groupSize];
        for (i = 0; i < info.length; ++i) {
            info[i] = new Information();
            info[i].addStringInfo("type", this.type);
            info[i].addIntInfo("auction", this.auction);
            info[i].addIntInfo("endBid", this.endBid);
            info[i].addBooleanInfo("showHistory", this.showHistory);
            info[i].addBooleanInfo("showImage", this.showImage);
            if (this.auction == 3) {
                info[i].addIntInfo("remainingBidders", groupSize);
                info[i].addIntInfo("startBid", this.startBid);
                this.curBid = this.startBid + this.incBid;
                info[i].addIntInfo("bid", this.curBid);
                info[i].addIntInfo("timeLimit", this.timeLimit);
                info[i].addStringInfo("thermometerDisplayType", this.thermometerDisplayType);
                info[i].addBooleanInfo("postRound", false);
                info[i].addBooleanInfo("showRemaining", this.showRemaining);
                info[i].addStringInfo("biddersLabelText", this.biddersLabelText);
                info[i].addStringInfo("thermometerLabelText", this.thermometerLabelText);
                info[i].addStringInfo("stopButtonText", this.stopButtonText);
            } else {
                info[i].addIntInfo("majorTickSpacing", this.majorTickSpacing);
                info[i].addIntInfo("minorTickSpacing", this.minorTickSpacing);
            }
            info[i].addStringInfo("metaLabelText", this.metaLabelText);
            info[i].addStringInfo("itemLabelText", this.itemLabelText);
            info[i].addStringInfo("bidPromptText", this.bidPromptText);
            info[i].addStringInfo("bidButtonText", this.bidButtonText);
            if (this.endogenous) {
                info[i].addStringInfo("imgLink", imgLinks[mixed.get(currentMatch)]);
            } else {
                info[i].addStringInfo("imgLink", this.imgLink);
            }
            if (!this.showHistory) continue;
            this.addColumnData(i, this.histItem, this.itemLabelText);
            if (this.auction != 0) {
                this.addColumnData(i, this.histHighestBid, "");
                this.addColumnData(i, this.histWinnerPay, "");
            }
            this.addColumnData(i, this.histYourStatus, "");
            this.addColumnData(i, this.histYourPay, "");
            if (this.auction == 3) {
                this.addColumnData(i, "Rounds Elapsed", "0");
                this.addColumnData(i, this.histYourBid, this.startBid + "");
                this.addColumnData(i, this.biddersLabelText, groupSize + "");
                continue;
            }
            this.addColumnData(i, this.histYourBid, "");
        }
        this.rec = this.askAllPlayers(info);
        if (this.auction == 3) {
            this.runEnglish(info);
            for (i = 0; i < info.length; ++i) {
                info[i].addBooleanInfo("postRound", true);
                info[i].addIntInfo("remainingBidders", this.remainingBidders);
            }
            this.askAllPlayers(info);
        }
        List<List<Bid>> sortedBids = this.sortBids(this.rec);
        this.determineWinner(sortedBids);
        this.determinePayment(sortedBids);
        float[] payoffs = new float[groupSize];
        int winnerIdx = -1;
        int payment = -1;
        HashMap<Integer, Bid> bidMap = new HashMap<Integer, Bid>();
        for (List<Bid> bids : sortedBids) {
            for (Bid b : bids) {
                payoffs[b.getPid()] = b.getPayment();
                bidMap.put(b.getPid(), b);
                if (!b.isWinner() || this.auction == 0) continue;
                winnerIdx = b.getPid();
                payment = b.getPayment();
            }
        }
        String[] feedbacks = this.updateHistoryAndOutput(bidMap, payment, winnerIdx);
        info = new Information[groupSize];
        for (int i2 = 0; i2 < info.length; ++i2) {
            info[i2] = new Information();
            info[i2].addStringInfo("finalFeedback", feedbacks[i2]);
        }
        this.addPayoffs(payoffs);
    }

    @Override
    protected Information[] processRound(MessageProcessor proc) throws AbortRoundException {
        return null;
    }

    private void runEnglish(Information[] info) throws AbortRoundException {
        int i;
        boolean biddingOver;
        boolean ascending = this.startBid < this.endBid;
        int roundNumber = 0;
        do {
            biddingOver = true;
            this.remainingBidders = 0;
            for (i = 0; i < this.rec.length; ++i) {
                this.bidding[i] = this.rec[i].getBooleanInfo("stillIn");
                info[i].addIntInfo("roundNumber", roundNumber);
                if (this.bidding[i]) {
                    ++this.remainingBidders;
                }
                if (!this.showHistory) continue;
                this.addColumnData(i, "Rounds Elapsed", roundNumber + 1 + "");
                this.addColumnData(i, this.histYourBid, this.rec[i].getIntInfo("bid") + "");
            }
            if (this.showHistory) {
                for (i = 0; i < this.rec.length; ++i) {
                    this.addColumnData(i, this.biddersLabelText, this.remainingBidders + "");
                }
            }
            if ((ascending && this.curBid + this.incBid <= this.endBid || !ascending && this.curBid + this.incBid >= this.endBid) && this.remainingBidders > 1) {
                biddingOver = false;
                this.curBid += this.incBid;
                for (i = 0; i < groupSize; ++i) {
                    info[i].addIntInfo("remainingBidders", this.remainingBidders);
                    info[i].addIntInfo("bid", this.curBid);
                }
                this.rec = this.askAllPlayers(info);
            }
            ++roundNumber;
        } while (!biddingOver);
        this.remainingBidders = 0;
        for (i = 0; i < this.rec.length; ++i) {
            this.bidding[i] = this.rec[i].getBooleanInfo("stillIn");
            if (!this.bidding[i]) continue;
            ++this.remainingBidders;
        }
    }

    private List<List<Bid>> sortBids(Information[] bids) {
        Vector<List<Bid>> sortedBids = new Vector<List<Bid>>();
        for (int i = 0; i < bids.length; ++i) {
            Bid bid = new Bid(i, bids[i].getIntInfo("bid"));
            if (this.showHistory) {
                this.addColumnData(i, this.histYourBid, String.valueOf(bid.getBid()));
            }
            for (int j = 0; j < sortedBids.size(); ++j) {
                List sameBids = (List)sortedBids.get(j);
                Bid sameBid = (Bid)sameBids.get(0);
                if (sameBid.getBid() == bid.getBid()) {
                    sameBids.add(bid);
                    bid = null;
                    break;
                }
                if (bid.getBid() <= sameBid.getBid()) continue;
                Vector<Bid> newBids = new Vector<Bid>();
                newBids.add(bid);
                sortedBids.add(j, newBids);
                bid = null;
                break;
            }
            if (bid == null) continue;
            Vector<Bid> newBids = new Vector<Bid>();
            newBids.add(bid);
            sortedBids.add(newBids);
        }
        return sortedBids;
    }

    private void parseDist(String distStr) {
        StringTokenizer tokenizer = new StringTokenizer(distStr, ",");
        this.dist = new int[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            this.dist[i] = Integer.parseInt(tokenizer.nextToken());
            ++i;
        }
        log.info((Object)("Parsed distribution data: " + this.dist.length + " " + this.dist.toString()));
    }

    private void determineWinner(List<List<Bid>> sortedBids) {
        switch (this.auction) {
            case 0: {
                this.draw = new int[groupSize];
                for (List<Bid> bids : sortedBids) {
                    for (Bid b : bids) {
                        int i = b.getPid();
                        this.draw[i] = this.dist[this.rand.nextInt(this.dist.length)];
                        log.info((Object)("bdm auction draw for player " + i + ": " + this.draw[i]));
                        if (b.getBid() <= this.draw[i]) continue;
                        b.setWinner(true);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                List<Bid> winningBids = this.auction == 3 && this.startBid > this.endBid ? sortedBids.get(sortedBids.size() - 1) : sortedBids.get(0);
                int winner = this.rand.nextInt(winningBids.size());
                winningBids.get(winner).setWinner(true);
                break;
            }
        }
    }

    private void determinePayment(List<List<Bid>> sortedBids) {
        block0 : switch (this.auction) {
            case 0: {
                for (List<Bid> bids : sortedBids) {
                    for (Bid b : bids) {
                        if (!b.isWinner()) continue;
                        b.setPayment(b.getBid());
                    }
                }
                break;
            }
            case 1: {
                List<Bid> winningBids = sortedBids.get(0);
                for (Bid b : winningBids) {
                    if (!b.isWinner()) continue;
                    b.setPayment(b.getBid());
                    break block0;
                }
                break;
            }
            case 2: 
            case 3: {
                List<Bid> winningBids = this.auction == 3 && this.startBid > this.endBid ? sortedBids.get(sortedBids.size() - 1) : sortedBids.get(0);
                for (Bid b : winningBids) {
                    if (!b.isWinner()) continue;
                    if (sortedBids.size() == 1 || winningBids.size() > 1) {
                        b.setPayment(b.getBid());
                        continue;
                    }
                    if (this.auction == 3 && this.startBid > this.endBid) {
                        b.setPayment(sortedBids.get(sortedBids.size() - 2).get(0).getBid());
                        continue;
                    }
                    b.setPayment(sortedBids.get(1).get(0).getBid());
                }
                break;
            }
        }
    }

    private String[] updateHistoryAndOutput(Map<Integer, Bid> bidMap, int payment, int winnerIdx) {
        this.addMatchOutput("item", this.itemLabelText);
        if (this.endogenous) {
            this.addMatchOutput("image", imgLinks[mixed.get(currentMatch)]);
        }
        if (this.auction != 0) {
            this.addMatchOutput("winner", String.valueOf(winnerIdx));
            this.addMatchOutput("payment", String.valueOf(payment));
        }
        String[] responses = new String[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            this.addMatchOutput(i, "bid", String.valueOf(bidMap.get(i).getBid()));
            this.addMatchOutput(i, "winning", String.valueOf(bidMap.get(i).isWinner()));
            if (this.auction == 0) {
                this.addMatchOutput(i, "bdm_draw", String.valueOf(this.draw[i]));
            }
            if (this.showHistory) {
                this.addColumnData(i, this.histYourBid, String.valueOf(bidMap.get(i).getBid()));
                if (this.auction != 0) {
                    this.addColumnData(i, this.histHighestBid, String.valueOf(bidMap.get(winnerIdx).getBid()));
                    this.addColumnData(i, this.histWinnerPay, String.valueOf(payment));
                }
                this.addColumnData(i, this.histYourStatus, bidMap.get(i).isWinner() ? "Winner" : "Not A Winner");
                this.addColumnData(i, this.histYourPay, String.valueOf(bidMap.get(i).getPayment()));
            }
            responses[i] = new String(this.feedback);
            responses[i] = responses[i].replaceAll("%status%", bidMap.get(i).isWinner() ? "Winner" : "Not A Winner");
            String hBid = this.auction == 0 ? String.valueOf(this.draw[i]) : String.valueOf(payment);
            responses[i] = responses[i].replaceAll("%highbid%", hBid);
            responses[i] = responses[i].replaceAll("%mybid%", String.valueOf(bidMap.get(i).getBid()));
        }
        return responses;
    }

    private void populateRatingsAndLinks(List<Float> avgRatings, Vector[][] surveyResponses) {
        for (int i = 0; i < this.numImages; ++i) {
            float total = 0.0f;
            for (int j = 0; j < surveyResponses[i].length; ++j) {
                int result = Integer.parseInt(((Question)surveyResponses[i][j].get(0)).getChosenAnswer());
                log.debug((Object)("Response (" + i + "," + j + ", group number " + this.groupNumber + "): " + result));
                total += (float)result;
            }
            float average = total / (float)surveyResponses[i].length;
            avgRatings.add(i, Float.valueOf(average));
            log.info((Object)("Average rating for item " + i + ": " + average));
            CompetitionControl.imgLinks[i] = this.processImgLink(((Question)surveyResponses[i][0].get(0)).getQuestion());
            log.debug((Object)("imgLinks[" + i + "]=" + imgLinks[i]));
            log.debug((Object)("avgRatings.get(" + i + ")=" + average));
        }
    }

    private String processImgLink(String rawString) {
        log.debug((Object)("rawString = " + rawString));
        int firstIndx = rawString.lastIndexOf("\\");
        log.debug((Object)("firstIndx = " + (firstIndx + 2)));
        int lastIndx = rawString.indexOf("\"", ++firstIndx);
        log.debug((Object)("lastIndx = " + lastIndx));
        String processedString = rawString.substring(firstIndx, lastIndx);
        if (processedString.equals("")) {
            log.debug((Object)("No filename found at: " + rawString));
            return "";
        }
        return "/images/competition/".concat(processedString);
    }

    private LinkedList<Integer> makeSortedIndecesArray(List<Float> avgRatings) {
        int i;
        LinkedList<Integer> indeces = new LinkedList<Integer>();
        LinkedList<Float> sortedAvgRatings = new LinkedList<Float>();
        for (i = 0; i < this.numImages; ++i) {
            sortedAvgRatings.add(avgRatings.get(i));
        }
        Collections.sort(sortedAvgRatings);
        for (i = 0; i < this.numImages; ++i) {
            float curValue = ((Float)sortedAvgRatings.pop()).floatValue();
            for (int j = 0; j < this.numImages; ++j) {
                if (curValue != avgRatings.get(j).floatValue()) continue;
                indeces.add(j);
                avgRatings.set(j, Float.valueOf(Float.NaN));
                log.debug((Object)("Found " + curValue + " at avgRatings.get(" + j + ")"));
                log.debug((Object)("Added value " + j + " to indeces"));
            }
        }
        return indeces;
    }

    private List<Integer> makeSortedIndecesArray1(List<Float> avgRatings) {
        HashMap indeces = new HashMap();
        Collections.sort(avgRatings);
        ArrayList<Integer> sorted = new ArrayList<Integer>();
        for (int i = 0; i < this.numImages; ++i) {
            sorted.add((Integer)indeces.get(avgRatings.get(i)));
        }
        return sorted;
    }

    private void separateAndShuffleHalves(LinkedList unshuffled) {
        int i;
        LinkedList mixedA = new LinkedList();
        LinkedList mixedB = new LinkedList();
        for (i = 0; i < this.numImages; ++i) {
            log.debug((Object)("unshuffled.get(" + i + ")= " + unshuffled.get(i)));
        }
        for (i = 0; i < this.numImages / 2; ++i) {
            mixedA.add(unshuffled.pop());
            mixedB.add(unshuffled.pop());
        }
        log.debug((Object)"Contents of mixedA:");
        for (i = 0; i < this.numImages / 2; ++i) {
            log.debug((Object)("mixedA.get(" + i + ")= " + mixedA.get(i)));
        }
        log.debug((Object)"Contents of mixedB:");
        for (i = 0; i < this.numImages / 2; ++i) {
            log.debug((Object)("mixedB.get(" + i + ")= " + mixedB.get(i)));
        }
        Collections.shuffle(mixedA);
        Collections.shuffle(mixedB);
        unshuffled.clear();
        for (i = 0; i < this.numImages / 2; ++i) {
            unshuffled.add(mixedA.pop());
        }
        for (i = 0; i < this.numImages / 2; ++i) {
            unshuffled.add(mixedB.pop());
        }
        log.debug((Object)"Separating and shuffling complete.");
        for (i = 0; i < this.numImages; ++i) {
            log.debug((Object)("mixed.get(" + i + ")= " + unshuffled.get(i)));
        }
    }

    class Bid {
        private int pid;
        private int bid;
        private boolean winner;
        private int payment;

        Bid(int pid, int bid) {
            this.pid = pid;
            this.bid = bid;
        }

        int getPid() {
            return this.pid;
        }

        void setPid(int pid) {
            this.pid = pid;
        }

        int getBid() {
            return this.bid;
        }

        void setBid(int bid) {
            this.bid = bid;
        }

        public boolean isWinner() {
            return this.winner;
        }

        public void setWinner(boolean winner) {
            this.winner = winner;
        }

        public int getPayment() {
            return this.payment;
        }

        public void setPayment(int payment) {
            this.payment = payment;
        }
    }
}

