/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamecontrollers;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.data.Question;
import java.util.Vector;
import org.apache.log4j.Category;

public class BasicSurveyControl
extends ServerControl {
    private Question[] questions;
    private boolean askQuestions;
    private boolean outputSubjectName;
    private float[] payoffVector;
    public static Category log = Category.getInstance(BasicSurveyControl.class);

    public void initialize() {
        this.rand.setSeed(System.currentTimeMillis());
        log.debug((Object)"A new BasicSurvey Controller has been initialized");
    }

    protected Information[] processRound(MessageProcessor proc) throws AbortRoundException {
        return null;
    }

    public void runSequence() throws AbortRoundException {
        try {
            String askQuestionsStr = this.getStringProperty("askQuestions");
            String randomizeQuestionsStr = this.getStringProperty("randomizeQuestions");
            String randomTypeStr = this.getStringProperty("randomType");
            this.outputSubjectName = this.getBooleanProperty("outputSubjectName");
            System.out.println("outputSubjectName==" + this.outputSubjectName);
            if (askQuestionsStr != null && askQuestionsStr.equalsIgnoreCase("true")) {
                this.askQuestions = true;
                Vector[][] questions = this.constructQuestions();
                if (randomizeQuestionsStr != null && randomizeQuestionsStr.equalsIgnoreCase("true")) {
                    if (randomTypeStr != null && randomTypeStr.equalsIgnoreCase("randomrounds")) {
                        System.out.print("old questions.size= " + questions.length);
                        questions = this.randomizeQuestions(questions, true);
                        System.out.println(", new questions.size= " + questions.length);
                    } else {
                        System.out.print("old questions.size= " + questions.length);
                        questions = this.randomizeQuestions(questions);
                        System.out.println(", new questions.size= " + questions.length);
                    }
                }
                this.questionSubjectsPostMatch(questions);
            }
            Information[] information = new Information[groupSize];
            for (int i = 0; i < information.length; ++i) {
                information[i] = new Information();
            }
            Information[] responseInfo = this.askAllPlayers(information);
            for (int i = 0; i < groupSize; ++i) {
                if (!this.getBooleanProperty("outputSubjectName")) continue;
                this.addOutput(i, "name", this.clientData[i].getName());
            }
        }
        catch (AbortRoundException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)("Failed to run the BasicSurvey main game sequence" + newline + e));
            e.printStackTrace();
            throw new AbortRoundException();
        }
    }

    private Vector[][] randomizeQuestions(Vector[][] input) {
        return this.randomizeQuestions(input, false);
    }

    private Vector[][] randomizeQuestions(Vector[][] input, boolean randomizeRounds) {
        try {
            int i;
            int nRounds = input.length;
            Vector[][] output = new Vector[nRounds][groupSize];
            int numQuestions = 0;
            for (int i2 = 0; i2 < input.length; ++i2) {
                System.out.println("input[" + i2 + "][0].size()=" + input[i2][0].size());
                numQuestions += input[i2][0].size();
                for (int j = 0; j < groupSize; ++j) {
                    output[i2][j] = new Vector();
                    output[i2][j].setSize(input[i2][0].size());
                }
            }
            System.out.println("numQuestions== " + numQuestions);
            if (!randomizeRounds) {
                Vector<Integer> v = new Vector<Integer>();
                v.setSize(numQuestions);
                for (i = 0; i < numQuestions; ++i) {
                    v.set(i, new Integer(i));
                }
                System.out.println("v.size()=" + v.size() + ", groupSize= " + groupSize);
                for (int g = 0; g < groupSize; ++g) {
                    for (int o = 0; o < numQuestions; ++o) {
                        int r;
                        System.out.print("o=" + o);
                        int rnum = this.rand.nextInt(v.size());
                        int originalnum = (Integer)v.elementAt(rnum);
                        System.out.println(", rnum=" + rnum + ", originalnum=" + originalnum);
                        int iround = -1;
                        int icol = -1;
                        int oround = -1;
                        int ocol = -1;
                        int temp = 0;
                        for (r = 0; r < nRounds; ++r) {
                            System.out.println("temp==" + temp + ", input[" + r + "][" + g + "].size()==" + input[r][g].size());
                            if (originalnum < temp + input[r][g].size() && iround == -1) {
                                iround = r;
                                icol = originalnum - temp;
                                System.out.println("iround=" + iround + ", icol=" + icol);
                            }
                            temp += input[r][g].size();
                        }
                        temp = 0;
                        for (r = 0; r < nRounds; ++r) {
                            System.out.println("temp==" + temp + ", ouitput[" + r + "][" + g + "].size()==" + output[r][g].size());
                            if (o < temp + output[r][g].size() && oround == -1) {
                                oround = r;
                                ocol = o - temp;
                            }
                            temp += output[r][g].size();
                        }
                        System.out.println(", output[" + oround + "][" + ocol + "]=input[" + iround + "][" + icol + "].");
                        output[oround][g].set(ocol, input[iround][g].elementAt(icol));
                        v.removeElementAt(rnum);
                    }
                }
            } else {
                Vector<Integer> v = new Vector<Integer>();
                v.setSize(nRounds);
                for (i = 0; i < nRounds; ++i) {
                    v.set(i, new Integer(i));
                }
                for (int r = 0; r < nRounds; ++r) {
                    System.out.println("r= " + r);
                    int rnum = this.rand.nextInt(v.size());
                    int originalnum = (Integer)v.elementAt(rnum);
                    System.out.println(", rnum=" + rnum + ", originalnum=" + originalnum);
                    System.out.println("output[" + r + "]= input[" + originalnum + "].");
                    output[r] = input[originalnum];
                    v.removeElementAt(rnum);
                }
            }
            return output;
        }
        catch (Exception e) {
            log.error((Object)("Malformed question parameters when using randomizeQuestions helper in BasicSurveyControl" + newline + e), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }
}

