/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control.gamecontrollers;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.text.NumberFormat;
import java.util.Vector;
import org.apache.log4j.Category;

public class BankRunOldControl
extends ServerControl {
    private int timePerRound;
    private int numWithdrawn;
    private int numRemaining;
    private int reauthTime;
    private float bondReturn;
    private float liquidationRate;
    private float interestRate;
    private boolean[] withdrawn;
    private float[][] payoffGrid;
    private float bondHoldings;
    private boolean messaging;
    private String autoWithdraw;
    private int trialWithdrawNum;
    private float probOneWithdraw;
    private float probTwoWithdraw;
    private Vector withdrawHistory;
    private Vector cumulativeHistory;
    private Vector depositorHistory;
    private Vector withdrawPaymentHistory;
    private boolean[][] autoWithdrawSchedule;
    private static Category log = Category.getInstance(BankRunOldControl.class);

    public void initialize() {
        this.timePerRound = this.getIntProperty("timePerTrial", 45);
        this.reauthTime = this.getIntProperty("reauthTime", 20);
        this.bondReturn = this.getFloatProperty("returnOnBonds", 0.7f);
        this.liquidationRate = this.getFloatProperty("liquidationRate", 0.6f);
        this.interestRate = this.getFloatProperty("interestRate", 0.5f);
        this.autoWithdraw = this.getStringProperty("autoWithdraw", "no");
        this.trialWithdrawNum = this.getIntProperty("autoTrialWithdrawNum", 0);
        this.probOneWithdraw = this.getFloatProperty("autoOppWithdrawProb1", 0.0f);
        this.probTwoWithdraw = this.getFloatProperty("autoOppWithdrawProb2", 0.0f);
        this.messaging = Boolean.valueOf(this.getStringProperty("messaging", "false"));
        this.numWithdrawn = 0;
        this.numRemaining = groupSize;
        this.bondHoldings = groupSize;
        this.withdrawn = new boolean[groupSize];
        this.autoWithdrawSchedule = new boolean[this.match.getNumRounds()][groupSize];
        for (int i = 0; i < this.autoWithdrawSchedule.length; ++i) {
            for (int j = 0; j < this.autoWithdrawSchedule[i].length; ++j) {
                this.autoWithdrawSchedule[i][j] = false;
            }
        }
        if (this.autoWithdraw.equalsIgnoreCase("trial")) {
            Vector<Integer> chosenClients = new Vector<Integer>();
            for (int i = 0; i < this.trialWithdrawNum; ++i) {
                int client = this.rand.nextInt(groupSize);
                if (!chosenClients.contains(new Integer(client))) {
                    int round = this.rand.nextInt(this.autoWithdrawSchedule.length);
                    this.autoWithdrawSchedule[round][client] = true;
                    chosenClients.add(new Integer(client));
                    continue;
                }
                --i;
            }
        }
        this.withdrawHistory = new Vector();
        this.cumulativeHistory = new Vector();
        this.depositorHistory = new Vector();
        this.withdrawPaymentHistory = new Vector();
        this.updateTrialNumbers();
    }

    protected Information[] processRound(MessageProcessor proc) throws AbortRoundException {
        return null;
    }

    public void runSequence() throws AbortRoundException {
        int i;
        String trialNumber = this.getTrialNumber();
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        if (this.autoWithdraw.equalsIgnoreCase("opp")) {
            int i2;
            int numAuto = 0;
            float prob = this.rand.nextFloat();
            if (prob <= this.probOneWithdraw) {
                numAuto = 1;
            }
            if (prob > this.probOneWithdraw && prob <= this.probOneWithdraw + this.probTwoWithdraw) {
                numAuto = 2;
            }
            Vector<Integer> chosenClients = new Vector<Integer>();
            for (i2 = 0; i2 < groupSize; ++i2) {
                if (!this.withdrawn[i2]) continue;
                chosenClients.add(new Integer(i2));
            }
            while (this.numRemaining < numAuto) {
                --numAuto;
            }
            for (i2 = 0; i2 < numAuto; ++i2) {
                int client = this.rand.nextInt(groupSize);
                if (!chosenClients.contains(new Integer(client))) {
                    chosenClients.add(new Integer(client));
                    this.autoWithdrawSchedule[this.roundNum][client] = true;
                    continue;
                }
                --i2;
            }
        }
        this.payoffGrid = new float[this.numRemaining + 1][2];
        for (int i3 = 0; i3 < this.payoffGrid.length; ++i3) {
            this.payoffGrid[i3][0] = i3 == 0 ? -1.0f : Math.min(1.0f, this.liquidationRate * this.bondHoldings / (float)i3);
            this.payoffGrid[i3][1] = i3 == this.numRemaining ? -1.0f : Math.max(0.0f, Math.min(1.0f + this.interestRate, (this.bondHoldings - (float)i3 / this.liquidationRate) * (1.0f + this.bondReturn) / (float)(this.numRemaining - i3)));
        }
        Information[] info = new Information[groupSize];
        for (int i4 = 0; i4 < groupSize; ++i4) {
            info[i4] = new Information();
            info[i4].addInfo("time", new Integer(this.timePerRound));
            info[i4].addInfo("numWithdrawn", new Integer(this.numWithdrawn));
            info[i4].addInfo("numRemaining", new Integer(this.numRemaining));
            info[i4].addInfo("opportunityNum", this.getRomanNumeral(this.roundNum + 1));
            info[i4].addInfo("trialNum", trialNumber);
            info[i4].addInfo("withdrawn", new Boolean(this.withdrawn[i4]));
            info[i4].addInfo("payoffGrid", this.payoffGrid);
            info[i4].addInfo("reauthTime", new Integer(this.reauthTime));
            info[i4].addInfo("autoWithdraw", new Boolean(this.autoWithdrawSchedule[this.roundNum][i4]));
            info[i4].addInfo("messaging", new Boolean(this.messaging));
        }
        Information[] responses = this.askAllPlayers(info);
        int numWithdrawnThisRound = 0;
        boolean[] withdrawnThisRound = new boolean[groupSize];
        for (int i5 = 0; i5 < responses.length; ++i5) {
            String withdrawStr = (String)responses[i5].getInfo("withdrawn");
            if (!withdrawStr.equals("true") || this.withdrawn[i5]) continue;
            this.withdrawn[i5] = true;
            ++this.numWithdrawn;
            --this.numRemaining;
            ++numWithdrawnThisRound;
            withdrawnThisRound[i5] = true;
        }
        this.withdrawHistory.add(new Integer(numWithdrawnThisRound));
        this.cumulativeHistory.add(new Integer(this.numWithdrawn));
        this.depositorHistory.add(new Integer(this.numRemaining));
        if (numWithdrawnThisRound > 0) {
            this.withdrawPaymentHistory.add("" + formatter.format(this.payoffGrid[numWithdrawnThisRound][0]));
        } else {
            this.withdrawPaymentHistory.add("N/A");
        }
        float[] payments = new float[groupSize];
        for (i = 0; i < payments.length; ++i) {
            payments[i] = withdrawnThisRound[i] ? this.payoffGrid[numWithdrawnThisRound][0] : (this.isLastRound() && !this.withdrawn[i] ? this.payoffGrid[numWithdrawnThisRound][1] : 0.0f);
        }
        this.addPayoffs(payments);
        this.bondHoldings = Math.max(0.0f, (float)groupSize - (float)this.numWithdrawn / this.liquidationRate);
        if (this.bondHoldings <= 0.0f) {
            this.endMatch();
        }
        if (this.isLastRound() || this.bondHoldings <= 0.0f) {
            for (i = 0; i < groupSize; ++i) {
                float[] earningsArray = new float[]{this.clientData[i].getMatchPayoff(currentMatch), this.clientData[i].getTotalPayoff()};
                this.sendImmediateGameUpdate(i, earningsArray);
            }
            this.displayEndRoundMessages(trialNumber, true);
        } else {
            this.displayEndRoundMessages(trialNumber, false);
        }
        for (i = 0; i < groupSize; ++i) {
            if (withdrawnThisRound[i]) {
                this.addOutput(i, "withdraw", "yes");
                continue;
            }
            this.addOutput(i, "withdraw", "no");
        }
        this.addOutput("numWithdrawals", "" + numWithdrawnThisRound);
        this.addOutput("cumulativeWithdrawals", "" + this.numWithdrawn);
        this.addOutput("bondHoldings", "" + this.bondHoldings);
    }

    private void displayEndRoundMessages(String trial, boolean lastRound) {
        int i;
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        Object[] endTrialMessages = new String[groupSize];
        Object[] endRoundMessages = new String[groupSize];
        StringBuffer table = new StringBuffer();
        table.append("<html><center><font color=red>Trial ").append(trial).append("</font></center>");
        table.append("<center><big>Withdrawal Request History</big></center><br><table border>");
        table.append("<tr><td><center><b>Opportunity</b></center></td><td><center><b>New Requests</b></center></td><td><center><b>Amount Received</b></center></td><td><center><b>Remaining Depositors</b></center</td></TR>");
        for (i = 0; i <= this.roundNum; ++i) {
            table.append("<tr><td><center>").append(this.getRomanNumeral(i + 1)).append("</center></td><td><center>").append(this.withdrawHistory.get(i));
            table.append("</center></td><td><center>").append(this.withdrawPaymentHistory.get(i)).append("</center></td><td><center>").append(this.depositorHistory.get(i));
            table.append("</center></td></tr>");
        }
        table.append("</table></html>");
        for (i = 0; i < groupSize; ++i) {
            endRoundMessages[i] = table.toString();
        }
        if (lastRound) {
            for (i = 0; i < groupSize; ++i) {
                endTrialMessages[i] = "<html><center><big><b>Trial " + trial + " is over!</b></big></center><br>" + "<center>Your payment for <font color=red>trial " + trial + "</font> is <font color=blue>" + formatter.format(this.clientData[i].getMatchPayoff(currentMatch)) + "</font></center><br>" + "<center>Your <b>total earnings</b> excluding show-up fee are <font color=blue>" + formatter.format(this.clientData[i].getTotalPayoff()) + "</font></center></html>";
            }
        }
        this.displayMessage("Opportunity Summary", endRoundMessages, "Continue");
        if (lastRound) {
            this.displayMessage("Trial Complete", endTrialMessages, "Continue");
        }
    }

    private String getTrialNumber() {
        try {
            if (this.autoWithdraw.equalsIgnoreCase("no")) {
                Integer num = (Integer)experimentData.get("treatment1");
                return "A" + num;
            }
            if (this.autoWithdraw.equalsIgnoreCase("opp")) {
                Integer num = (Integer)experimentData.get("treatment2");
                return "B" + num;
            }
            if (this.autoWithdraw.equalsIgnoreCase("trial")) {
                Integer num = (Integer)experimentData.get("treatment3");
                return "C" + num;
            }
            return "0";
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve the trial number" + MSConstants.newline + e));
            return "0";
        }
    }

    private String getRomanNumeral(int number) {
        if (number == 20) {
            return "XX";
        }
        if (number >= 10) {
            return "X" + this.getRomanNumeral(number - 10);
        }
        if (number == 9) {
            return "IX";
        }
        if (number == 4) {
            return "IV";
        }
        if (number >= 5) {
            return "V" + this.getRomanNumeral(number - 5);
        }
        if (number == 0) {
            return "";
        }
        if (number < 4) {
            return "I" + this.getRomanNumeral(number - 1);
        }
        return "";
    }

    private void updateTrialNumbers() {
        if (this.primaryControl) {
            int treatment1 = 0;
            int treatment2 = 0;
            int treatment3 = 0;
            Integer tr1 = (Integer)experimentData.get("treatment1");
            Integer tr2 = (Integer)experimentData.get("treatment2");
            Integer tr3 = (Integer)experimentData.get("treatment3");
            if (tr1 != null) {
                treatment1 = tr1;
            }
            if (tr2 != null) {
                treatment2 = tr2;
            }
            if (tr3 != null) {
                treatment3 = tr3;
            }
            if (this.autoWithdraw.equalsIgnoreCase("no")) {
                experimentData.put("treatment1", new Integer(++treatment1));
            }
            if (this.autoWithdraw.equalsIgnoreCase("opp")) {
                experimentData.put("treatment2", new Integer(++treatment2));
            }
            if (this.autoWithdraw.equalsIgnoreCase("trial")) {
                experimentData.put("treatment3", new Integer(++treatment3));
            }
        }
    }
}

