/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.data.Match;
import edu.caltech.ssel.multistage.server.util.outputservice.BadOutputFormatException;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.CSVOutputWriter;
import edu.caltech.ssel.multistage.server.util.outputservice.xml.HTMLOutputWriter;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.MatchHistory;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Category;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class StateWriter {
    private static Category log = Category.getInstance(StateWriter.class);
    protected Properties stateProps;
    protected File targetFile;
    protected FileWriter fwriter;
    protected Element experiment = null;

    protected void writeClientInfo() {
        try {
            Vector clients = ServerVariables.clients;
            this.fwriter.write("numOfSubjects=" + clients.size() + MSConstants.newline + MSConstants.newline);
            for (int i = 0; i < clients.size(); ++i) {
                ClientData cdata = (ClientData)clients.get(i);
                this.fwriter.write("client." + i + ".id=" + cdata.getId() + MSConstants.newline);
                this.fwriter.write("client." + i + ".name=" + cdata.getName() + MSConstants.newline);
            }
            this.fwriter.write("" + MSConstants.newline);
        }
        catch (Exception e) {
            log.error((Object)("Failed to write generic client data to output " + MSConstants.newline + e));
        }
    }

    protected void writeClientPayoffs() {
        try {
            this.fwriter.write("# Client Payoff Information" + MSConstants.newline + MSConstants.newline);
            Vector clients = ServerVariables.clients;
            for (int i = 0; i < clients.size(); ++i) {
                ClientData cdata = (ClientData)clients.get(i);
                int numMatches = cdata.getNumMatches();
                for (int m = 0; m < numMatches; ++m) {
                    this.fwriter.write("client." + i + ".match." + m + ".payoff=" + cdata.getMatchPayoff(m) + MSConstants.newline);
                }
                this.fwriter.write("client." + i + ".totalPayoff=" + cdata.getTotalPayoff() + MSConstants.newline + MSConstants.newline);
            }
            this.fwriter.write("" + MSConstants.newline);
        }
        catch (Exception e) {
            log.error((Object)("Failed to write client payoff information to output" + MSConstants.newline + e));
        }
    }

    protected void writePayoffFile() {
        try {
            String payoffFile = this.targetFile.getAbsolutePath() + ".pay";
            FileWriter filewriter = new FileWriter(payoffFile);
            filewriter.write("# Multistage Payoff Summary" + MSConstants.newline + MSConstants.newline);
            String format = "%1$-40s %2$-10s %3$-10s %4$-10s\n";
            StringBuffer str = new StringBuffer();
            String[] a = new String[]{"# Name", "In-Game", "Exchanged", "Rounded"};
            Formatter formatter = new Formatter(str, Locale.US);
            formatter.format(format, a);
            format = "%1$-40s %2$-10.2f %3$-10.2f %4$-10.2f\n";
            for (int i = 0; i < ServerVariables.clients.size(); ++i) {
                ClientData client = (ClientData)ServerVariables.clients.get(i);
                String name = "# ID " + client.getId() + ": " + client.getName();
                double inGame = client.getTotalPayoff();
                double exchanged = client.getTotalPayoffExchanged();
                double payoff = client.getTotalPayoffExchangedAndRounded();
                Object[] b = new Object[]{name, new Float(inGame), new Float(exchanged), new Float(payoff)};
                formatter.format(format, b);
            }
            filewriter.write(str + MSConstants.newline);
            filewriter.write("" + MSConstants.newline + MSConstants.newline);
            filewriter.close();
            log.info((Object)("Wrote payoff summary to output payoff file: " + payoffFile));
        }
        catch (Exception e) {
            log.error((Object)("Failed to write the payoff summary" + MSConstants.newline + e));
        }
    }

    protected Element writeClientPayoffsToXML() {
        Element payoffs = new Element("Payoffs");
        Vector clients = ServerVariables.clients;
        for (int i = 0; i < clients.size(); ++i) {
            ClientData cdata = (ClientData)clients.get(i);
            Element client = new Element("client");
            client.setAttribute("id", Integer.toString(i));
            int numMatches = cdata.getNumMatches();
            for (int m = 0; m < numMatches; ++m) {
                Element matchPayoff = new Element("matchPayoff");
                matchPayoff.setAttribute("matchId", Integer.toString(m));
                matchPayoff.addContent(Float.toString(cdata.getMatchPayoff(m)));
                client.addContent((Content)matchPayoff);
            }
            client.addContent((Content)new Element("payoff").addContent(Float.toString(cdata.getTotalPayoff())));
            payoffs.addContent((Content)client);
        }
        return payoffs;
    }

    protected void writeMatcherData() {
    }

    protected void writeMatchData(int match) {
        try {
            int i;
            Vector clients = ServerVariables.clients;
            Match realMatch = (Match)ServerVariables.matches.get(match);
            int numGroups = clients.size() / realMatch.getGroupSize();
            boolean aborted = this.wasAborted(match);
            if (aborted) {
                this.fwriter.write("match." + match + ".status=ABORTED" + MSConstants.newline);
            } else {
                this.fwriter.write("match." + match + ".status=OK" + MSConstants.newline);
            }
            this.fwriter.write("match." + match + ".practice=" + realMatch.isPracticeMatch() + MSConstants.newline);
            this.fwriter.write(MSConstants.newline);
            if (this.writeMatcherOutput(match)) {
                this.fwriter.write(MSConstants.newline);
            }
            if (aborted) {
                return;
            }
            for (i = 0; i < numGroups; ++i) {
                String str = "";
                for (int g = 0; g < realMatch.getGroupSize(); ++g) {
                    for (int j = 0; j < clients.size(); ++j) {
                        ClientData cdata = (ClientData)clients.get(j);
                        int gid = cdata.getGroupId(match);
                        int pnum = cdata.getPartnerNum(match);
                        if (gid != i || pnum != g) continue;
                        str = str + "" + j + ",";
                    }
                }
                this.fwriter.write("match." + match + ".group." + i + ".clients=" + str.substring(0, str.length() - 1) + MSConstants.newline);
                this.writeGroupMatchOutput(match, i);
            }
            for (i = 0; i < clients.size(); ++i) {
                this.writeClientMatchOutput(match, i);
            }
            this.fwriter.write(MSConstants.newline);
        }
        catch (Exception e) {
            log.error((Object)("Failed to write match data for persistence file match " + match + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private boolean writeMatcherOutput(int match) {
        try {
            boolean dataAdded = false;
            if (ServerVariables.manualMatcher != null) {
                Vector matcherOutput = ServerVariables.manualMatcher.getMatchOutput(match);
                if (matcherOutput != null) {
                    for (int j = 0; j < matcherOutput.size(); ++j) {
                        String[] output = (String[])matcherOutput.get(j);
                        this.fwriter.write("match." + match + ".matcher." + output[0] + "=" + output[1] + MSConstants.newline);
                        dataAdded = true;
                    }
                }
                for (int i = 0; i < ServerVariables.clients.size(); ++i) {
                    Vector moutput = ServerVariables.manualMatcher.getMatchOutput(i, match);
                    if (moutput == null) continue;
                    for (int j = 0; j < moutput.size(); ++j) {
                        String[] output = (String[])moutput.get(j);
                        this.fwriter.write("match." + match + ".matcher.client." + i + "." + output[0] + "=" + output[1] + MSConstants.newline);
                        dataAdded = true;
                    }
                }
            }
            return dataAdded;
        }
        catch (Exception e) {
            log.error((Object)("Failed to write the Manual Matcher output for match " + match));
            return false;
        }
    }

    private void writeGroupMatchOutput(int match, int group) {
        try {
            Match realMatch = (Match)ServerVariables.matches.get(match);
            Vector generalOutput = realMatch.getMatchOutput(group);
            if (generalOutput != null) {
                for (int j = 0; j < generalOutput.size(); ++j) {
                    String[] output = (String[])generalOutput.get(j);
                    this.fwriter.write("match." + match + ".group." + group + "." + output[0] + "=" + output[1] + MSConstants.newline);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to write group-specific match output for match " + match + ", group " + group));
        }
    }

    private void writeClientMatchOutput(int match, int client) {
        try {
            ClientData cdata = (ClientData)ServerVariables.clients.get(client);
            String substring = "match." + match + ".client." + client + ".";
            Vector clientOutput = cdata.getMatchOutput(match);
            if (clientOutput != null) {
                for (int j = 0; j < clientOutput.size(); ++j) {
                    String[] output = (String[])clientOutput.get(j);
                    this.fwriter.write(substring + output[0] + "=" + output[1] + MSConstants.newline);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to write client-specific match output for match " + match + ", client " + client));
        }
    }

    protected void writeRoundData(int match, int round) {
        try {
            int i;
            Vector clients = ServerVariables.clients;
            Match realMatch = (Match)ServerVariables.matches.get(match);
            int numGroups = clients.size() / realMatch.getGroupSize();
            this.fwriter.write("match." + match + ".round." + round + ".status=" + this.parseStatus(this.getRoundStatus(match, round)) + MSConstants.newline);
            for (i = 0; i < numGroups; ++i) {
                this.writeGroupRoundOutput(round, match, i);
            }
            for (i = 0; i < clients.size(); ++i) {
                if (this.wasClientAborted(match, round, i)) continue;
                ClientData cdata = (ClientData)clients.get(i);
                String substring = "match." + match + ".client." + i + ".round." + round + ".";
                this.fwriter.write(substring + "payoff=" + cdata.getPayoff(match, round) + MSConstants.newline);
                this.writeClientRoundOutput(round, match, i);
            }
            this.fwriter.write(MSConstants.newline);
        }
        catch (Exception e) {
            log.error((Object)("Failed to write persistence output for match " + match + " and round " + round + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void writeGroupRoundOutput(int round, int match, int group) {
        try {
            Match realMatch = (Match)ServerVariables.matches.get(match);
            Vector generalOutput = realMatch.getRoundOutput(group, round);
            if (generalOutput != null) {
                for (int j = 0; j < generalOutput.size(); ++j) {
                    String[] output = (String[])generalOutput.get(j);
                    this.fwriter.write("match." + match + ".group." + group + ".round." + round + "." + output[0] + "=" + output[1] + MSConstants.newline);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to write group-specific round output for round " + round + ", match " + match + ", group " + group));
        }
    }

    private void writeClientRoundOutput(int round, int match, int client) {
        try {
            ClientData cdata = (ClientData)ServerVariables.clients.get(client);
            String substring = "match." + match + ".client." + client + ".round." + round + ".";
            Vector clientOutput = cdata.getRoundOutput(match, round);
            if (clientOutput != null) {
                for (int j = 0; j < clientOutput.size(); ++j) {
                    String[] output = (String[])clientOutput.get(j);
                    this.fwriter.write(substring + output[0] + "=" + output[1] + MSConstants.newline);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to write client-specific round output for round " + round + ", match " + match + ", client " + client));
        }
    }

    protected Element writeMatchDataToXML(int match) {
        Element matchElmt = new Element("match");
        matchElmt.setAttribute("id", Integer.toString(match));
        Vector clients = ServerVariables.clients;
        Match realMatch = (Match)ServerVariables.matches.get(match);
        if (this.wasAborted(match)) {
            matchElmt.setAttribute("status", "ABORTED");
        } else {
            matchElmt.setAttribute("status", "OK");
        }
        matchElmt.setAttribute("practice", Boolean.toString(realMatch.isPracticeMatch()));
        this.writeMatcherOutputToXML(match, matchElmt);
        int numGroups = clients.size() / realMatch.getGroupSize();
        for (int i = 0; i < numGroups; ++i) {
            Element group = new Element("group");
            group.setAttribute("id", Integer.toString(i));
            Element general = new Element("general");
            if (this.writeGroupMatchOutputToXML(match, i, general)) {
                group.addContent((Content)general);
            }
            for (int j = 0; j < clients.size(); ++j) {
                ClientData cdata = (ClientData)clients.get(j);
                if (cdata.getGroupId(match) != i) continue;
                Element client = new Element("client");
                client.setAttribute("id", Integer.toString(j));
                this.writeClientMatchOutputToXML(match, j, client);
                group.addContent((Content)client);
            }
            matchElmt.addContent((Content)group);
        }
        return matchElmt;
    }

    private void writeMatcherOutputToXML(int match, Element parent) {
        if (ServerVariables.manualMatcher != null) {
            Element matcher = new Element("matcher");
            Vector matcherOutput = ServerVariables.manualMatcher.getMatchOutput(match);
            if (matcherOutput != null && matcherOutput.size() > 0) {
                Element general = new Element("general");
                for (int j = 0; j < matcherOutput.size(); ++j) {
                    String[] output = (String[])matcherOutput.get(j);
                    general.addContent((Content)new Element(output[0]).addContent(output[1]));
                }
                matcher.addContent((Content)general);
            }
            for (int i = 0; i < ServerVariables.clients.size(); ++i) {
                Vector moutput = ServerVariables.manualMatcher.getMatchOutput(i, match);
                if (moutput == null || moutput.size() <= 0) continue;
                Element client = new Element("client");
                client.setAttribute("id", Integer.toString(i));
                for (int j = 0; j < moutput.size(); ++j) {
                    String[] output = (String[])moutput.get(j);
                    client.addContent((Content)new Element(output[0]).addContent(output[1]));
                }
                matcher.addContent((Content)client);
            }
            parent.addContent((Content)matcher);
        }
    }

    private boolean writeGroupMatchOutputToXML(int match, int group, Element parent) {
        Match realMatch = (Match)ServerVariables.matches.get(match);
        Vector groupOutput = realMatch.getMatchOutput(group);
        if (groupOutput != null && groupOutput.size() > 0) {
            for (int j = 0; j < groupOutput.size(); ++j) {
                String[] output = (String[])groupOutput.get(j);
                parent.addContent((Content)new Element(output[0]).addContent(output[1]));
            }
            return true;
        }
        return false;
    }

    private void writeClientMatchOutputToXML(int match, int client, Element parent) {
        ClientData cdata = (ClientData)ServerVariables.clients.get(client);
        Vector clientOutput = cdata.getMatchOutput(match);
        if (clientOutput != null) {
            for (int k = 0; k < clientOutput.size(); ++k) {
                String[] output = (String[])clientOutput.get(k);
                parent.addContent((Content)new Element(output[0]).addContent(output[1]));
            }
        }
    }

    protected void writeRoundDataToXML(Element matchElmt, int round) {
        if (matchElmt == null) {
            return;
        }
        int match = Integer.parseInt(matchElmt.getAttributeValue("id"));
        Match realMatch = (Match)ServerVariables.matches.get(match);
        Vector clients = ServerVariables.clients;
        int numGroups = clients.size() / realMatch.getGroupSize();
        Element roundElmt = new Element("round");
        roundElmt.setAttribute("id", Integer.toString(round));
        roundElmt.setAttribute("status", this.parseStatus(this.getRoundStatus(match, round)));
        for (int j = 0; j < numGroups; ++j) {
            if (this.wasGroupAborted(match, round, j)) continue;
            Element group = new Element("group");
            group.setAttribute("id", Integer.toString(j));
            Element general = new Element("general");
            if (this.writeGroupRoundOutputToXML(round, match, j, general)) {
                group.addContent((Content)general);
            }
            for (int i = 0; i < clients.size(); ++i) {
                ClientData cdata;
                if (this.wasClientAborted(match, round, i) || (cdata = (ClientData)clients.get(i)).getGroupId(match) != j) continue;
                Element client = new Element("client");
                client.setAttribute("id", Integer.toString(i));
                client.addContent((Content)new Element("payoff").addContent(Float.toString(cdata.getPayoff(match, round))));
                this.writeClientRoundOutputToXML(round, match, i, client);
                group.addContent((Content)client);
            }
            roundElmt.addContent((Content)group);
        }
        matchElmt.addContent((Content)roundElmt);
    }

    private void writeClientRoundOutputToXML(int round, int match, int client, Element parent) {
        ClientData cdata = (ClientData)ServerVariables.clients.get(client);
        Vector clientOutput = cdata.getRoundOutput(match, round);
        if (clientOutput != null) {
            for (int j = 0; j < clientOutput.size(); ++j) {
                String[] output = (String[])clientOutput.get(j);
                parent.addContent((Content)new Element(output[0]).addContent(output[1]));
            }
        }
    }

    private boolean writeGroupRoundOutputToXML(int round, int match, int group, Element parent) {
        Match realMatch = (Match)ServerVariables.matches.get(match);
        Vector groupOutput = realMatch.getRoundOutput(group, round);
        if (groupOutput != null && groupOutput.size() > 0) {
            for (int j = 0; j < groupOutput.size(); ++j) {
                String[] output = (String[])groupOutput.get(j);
                parent.addContent((Content)new Element(output[0]).addContent(output[1]));
            }
            return true;
        }
        return false;
    }

    protected int getRoundStatus(int match, int round, int client) {
        ClientData cdata = (ClientData)ServerVariables.clients.get(client);
        return cdata.getRoundStatus(match, round);
    }

    protected int getRoundStatus(int match, int round) {
        Vector clients = ServerVariables.clients;
        int finalStatus = -1;
        for (int i = 0; i < clients.size(); ++i) {
            int status = this.getRoundStatus(match, round, i);
            if (status == MatchHistory.ROUND_ABORTED) {
                return MatchHistory.ROUND_ABORTED;
            }
            if (status == MatchHistory.ROUND_UNPLAYED) {
                if (finalStatus == MatchHistory.ROUND_OK) {
                    return MatchHistory.ROUND_ABORTED;
                }
                finalStatus = MatchHistory.ROUND_UNPLAYED;
                continue;
            }
            if (status != MatchHistory.ROUND_OK) continue;
            if (finalStatus == MatchHistory.ROUND_UNPLAYED) {
                return MatchHistory.ROUND_ABORTED;
            }
            finalStatus = MatchHistory.ROUND_OK;
        }
        return finalStatus;
    }

    protected String parseStatus(int status) {
        if (status == MatchHistory.ROUND_OK) {
            return "OK";
        }
        if (status == MatchHistory.ROUND_UNPLAYED) {
            return "UNPLAYED";
        }
        if (status == MatchHistory.ROUND_ABORTED) {
            return "ABORTED";
        }
        return "ABORTED";
    }

    protected boolean wasAborted(int matchNum) {
        Vector clients = ServerVariables.clients;
        for (int i = 0; i < clients.size(); ++i) {
            ClientData cdata = (ClientData)clients.get(i);
            if (cdata.getMatchFinished(matchNum)) continue;
            return true;
        }
        return false;
    }

    protected boolean wasAborted(int match, int round) {
        Vector clients = ServerVariables.clients;
        for (int i = 0; i < clients.size(); ++i) {
            if (this.wasClientAborted(match, round, i)) continue;
            return false;
        }
        return true;
    }

    protected boolean wasClientAborted(int match, int round, int client) {
        int status = this.getRoundStatus(match, round, client);
        return false;
    }

    protected boolean wasGroupAborted(int match, int round, int group) {
        Vector clients = ServerVariables.clients;
        return false;
    }

    protected int getNumRounds(int matchNum) {
        Match match = (Match)ServerVariables.matches.get(matchNum);
        int numRounds = match.getNumRounds();
        if (numRounds > 0) {
            return numRounds;
        }
        Vector clients = ServerVariables.clients;
        for (int i = 0; i < clients.size(); ++i) {
            ClientData cdata = (ClientData)clients.get(i);
            int maxRound = cdata.getNumRounds(matchNum);
            if (maxRound <= numRounds) continue;
            numRounds = maxRound;
        }
        return numRounds;
    }

    protected Element findMatchElement(int matchId) {
        if (this.experiment == null) {
            return null;
        }
        List matches = this.experiment.getChildren("match");
        for (Element match : matches) {
            int mid = Integer.parseInt(match.getAttributeValue("id"));
            if (mid != matchId) continue;
            return match;
        }
        return null;
    }

    protected Element findRoundElement(Element match, int roundId) {
        if (match == null) {
            return null;
        }
        List rounds = this.experiment.getChildren("round");
        for (Element round : rounds) {
            int rid = Integer.parseInt(round.getAttributeValue("id"));
            if (rid != roundId) continue;
            return round;
        }
        return null;
    }

    protected void persistXML() throws IOException {
        if (this.targetFile == null || this.experiment == null) {
            String msg = "Failed to persist experiment DATA in XML format, either output file or XML is not initialized properly";
            log.error((Object)msg);
            throw new IOException(msg);
        }
        String fileName = this.targetFile.getAbsolutePath();
        Document expDoc = new Document(this.experiment);
        XMLOutputter xmlOutput = new XMLOutputter(Format.getPrettyFormat());
        BufferedOutputStream bs = new BufferedOutputStream(new FileOutputStream(fileName + ".xml"));
        xmlOutput.output(expDoc, (OutputStream)bs);
        bs.flush();
        bs.close();
    }

    protected void persistHTML() throws IOException, BadOutputFormatException {
        if (this.targetFile == null || this.experiment == null) {
            String msg = "Failed to persist experiment DATA in HTML format, either output file or XML is not initialized properly";
            log.error((Object)msg);
            throw new IOException(msg);
        }
        String fileName = this.targetFile.getAbsolutePath();
        HTMLOutputWriter htmlWriter = new HTMLOutputWriter(fileName + ".html", this.experiment);
        htmlWriter.writeOutputToHTML();
    }

    protected void persistCSV() throws IOException, BadOutputFormatException {
        if (this.targetFile == null || this.experiment == null) {
            String msg = "Failed to persist experiment DATA in CSV format, either output file or XML is not initialized properly";
            log.error((Object)msg);
            throw new IOException(msg);
        }
        String fileName = this.targetFile.getAbsolutePath();
        CSVOutputWriter csvWriter = new CSVOutputWriter(fileName + ".csv", this.experiment);
        csvWriter.writeOutputToCSV();
    }
}

