/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.ChatProcessor;
import edu.caltech.ssel.multistage.server.control.FinishControl;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ResponseControl;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.data.Match;
import edu.caltech.ssel.multistage.shared.data.ChoiceQuestion;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.ClientUpdate;
import edu.caltech.ssel.multistage.shared.data.DropdownQuestion;
import edu.caltech.ssel.multistage.shared.data.EssayQuestion;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.data.InstructionQuestion;
import edu.caltech.ssel.multistage.shared.data.MatchHistory;
import edu.caltech.ssel.multistage.shared.data.Question;
import edu.caltech.ssel.multistage.shared.data.SliderQuestion;
import edu.caltech.ssel.multistage.shared.data.TextQuestion;
import edu.caltech.ssel.multistage.shared.interfaces.BarGraphUpdate;
import edu.caltech.ssel.multistage.shared.interfaces.StatPanelUpdate;
import edu.caltech.ssel.multistage.shared.network.GameMessage;
import edu.caltech.ssel.multistage.shared.network.GameRequest;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Message;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import edu.caltech.ssel.multistage.shared.network.Request;
import edu.caltech.ssel.multistage.shared.network.RequestPacket;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Category;

public abstract class ServerControl
extends ServerVariables
implements MSConstants,
Runnable {
    protected Match match;
    protected String completionMessage = "";
    protected int[] players;
    protected ClientData[] clientData;
    protected Request[] lastRequests;
    protected boolean endMatch = false;
    protected boolean lastRoundComplete = false;
    protected int roundNum = -1;
    protected Random rand;
    protected float exchangeRate;
    protected boolean asyncMode;
    protected MessageProcessor mproc;
    protected long timeLeft;
    private Object[] postMatchQuestions;
    private Object[] gameUpdates;
    private Object[] roundInfoStore;
    private Object[] postRoundQuestions;
    private static Category log = Category.getInstance(ServerControl.class);
    private ClientUpdate[][] updateBank;
    private ClientUpdate[] clientUpdates;
    private ClientUpdate[] readyUpdates;
    private boolean[] sendFullRequest;
    private boolean moveToNextGame;
    private Timer countdownTimer;
    private Timer elapseTimer;
    private Hashtable reauthMessages = new Hashtable();
    private boolean[] requestSent;
    protected boolean primaryControl;
    private ChatProcessor cproc;
    protected int groupNumber;
    private ResponseControl[] rcons;
    protected int roundAdvancement;
    protected int maxRounds;
    private boolean abortingMatch = false;
    private boolean active = true;
    protected boolean outputWrongQuestionAnswers = false;
    public static int INT_NOT_FOUND = -32000;
    public static float FLOAT_NOT_FOUND = -32000.0f;

    public synchronized void run() {
        try {
            while (!this.lastRoundComplete) {
                int i;
                ++this.roundNum;
                this.cproc.newRound();
                this.resetClientUpdates();
                this.moveToNextGame = false;
                log.info((Object)("Current round for clients " + this.arrayToNames(this.players) + " is " + this.roundNum));
                for (i = 0; i < this.players.length; ++i) {
                    this.clientData[i].setNumRounds(currentMatch, this.roundNum + 1);
                    ui.updateClientStatus(this.players[i], "Waiting for Partners");
                    this.requestSent[i] = false;
                }
                try {
                    this.runSequence();
                    this.setRoundStatus(this.roundNum, MatchHistory.ROUND_OK);
                }
                catch (AbortRoundException e) {
                    this.processAbortedRound(e);
                    this.setRoundStatus(this.roundNum, MatchHistory.ROUND_ABORTED);
                }
                for (i = 0; i < this.players.length; ++i) {
                    ui.updateClientInfo(this.players[i]);
                }
                if (this.roundAdvancement == 1) {
                    if (this.roundNum == this.maxRounds - 1) {
                        this.endMatch = true;
                        log.info((Object)("This is the final round for group " + this.groupNumber + " in match " + currentMatch));
                    }
                    this.sendAllGameUpdates();
                    this.wait(gameDelay);
                }
                if (this.endMatch) {
                    this.lastRoundComplete = true;
                }
                if (!this.endMatch) {
                    for (i = 0; i < this.players.length; ++i) {
                        this.clientUpdates[i].setNumRounds(this.roundNum + 2);
                        if (this.roundAdvancement != 0) continue;
                        ui.setReadyForNextGame(this.players[i]);
                    }
                }
                this.swapUpdateBank();
                while (!this.moveToNextGame && !this.endMatch && this.roundAdvancement == 0) {
                    this.wait();
                }
            }
            this.finishMatch();
            log.info((Object)("Players " + this.arrayToNames(this.players) + " have finished the match.  Server Controller has been destroyed"));
            this.active = false;
        }
        catch (Exception e) {
            log.error((Object)("Failed to run the main game sequence in the ServerControl" + MSConstants.newline + e), (Throwable)e);
            e.printStackTrace();
        }
    }

    public synchronized void nextGame() {
        this.moveToNextGame = true;
        this.notifyAll();
    }

    public void endMatch() {
        this.endMatch = true;
    }

    public synchronized void abortMatch() {
        this.abortingMatch = true;
        this.endMatch();
        if (this.abortRound(false)) {
            return;
        }
        this.lastRoundComplete = true;
        this.notifyAll();
    }

    public void abortAsynchronousRound() {
        if (this.asyncMode && this.mproc != null) {
            this.mproc.abortRound();
        }
    }

    public boolean abortRound(boolean displayMessage) {
        try {
            boolean aborted = false;
            for (int i = 0; i < this.rcons.length; ++i) {
                if (this.rcons[i] == null || !this.rcons[i].abortRound(displayMessage)) continue;
                aborted = true;
            }
            return aborted;
        }
        catch (Exception e) {
            log.error((Object)"Failed to manually abort the round with a SERVER_INITIATED_ABORT", (Throwable)e);
            return false;
        }
    }

    public void reauthenticate(int playerNum) {
        try {
            Match match = (Match)matches.get(currentMatch);
            int partnerNum = this.getPartnerNum(playerNum);
            Request req = this.lastRequests[partnerNum];
            ClientData cdata = this.clientData[partnerNum];
            Request iReq = this.buildReauthRequest(match, cdata);
            com.sendRequest(playerNum, iReq);
            if (req.getType() != 5) {
                com.sendRequest(playerNum, req);
            }
            this.sendReauthMessages(partnerNum);
            if (this.asyncMode) {
                GameMessage mes = new GameMessage(null, 27, -2);
                com.sendMessage(playerNum, mes);
            }
            log.info((Object)"Sent init game requests and last game request to reauthenticating client");
        }
        catch (Exception e) {
            log.error((Object)("Failed to resent the init game request to client " + playerNum + " in reauthentication" + newline + e), (Throwable)e);
        }
    }

    public void initControl(int[] players) {
        this.players = players;
        this.clientData = new ClientData[players.length];
        this.updateBank = new ClientUpdate[2][players.length];
        this.gameUpdates = new String[players.length];
        this.rcons = new ResponseControl[players.length];
        this.match = (Match)params.getMatches().get(currentMatch);
        this.rand = ServerVariables.rand;
        this.roundAdvancement = this.match.getRoundAdvancement();
        this.maxRounds = this.match.getNumRounds();
        for (int i = 0; i < this.clientData.length; ++i) {
            this.clientData[i] = (ClientData)clients.get(players[i]);
        }
        this.lastRequests = new Request[players.length];
        this.sendFullRequest = new boolean[players.length];
        this.requestSent = new boolean[players.length];
        this.exchangeRate = this.clientData[0].getExchangeRate(currentMatch);
        this.primaryControl = false;
        this.cproc = new ChatProcessor(this, players, this.clientData);
        this.cproc.activateReceivers();
        Thread chatProcessor = new Thread(this.cproc);
        chatProcessor.start();
        this.clientUpdates = this.updateBank[0];
        this.readyUpdates = this.updateBank[1];
        this.resetClientUpdates();
        this.resetReadyUpdates();
        for (int i = 0; i < players.length; ++i) {
            if (currentMatch == 0) {
                this.sendFullRequest[i] = true;
            } else {
                this.installMatchUpdates();
            }
            this.requestSent[i] = false;
            if (players[i] != 0) continue;
            this.primaryControl = true;
        }
    }

    public void setControlNumber(int controlNumber) {
        this.groupNumber = controlNumber;
    }

    public void sendAllGameUpdates() {
        for (int i = 0; i < this.gameUpdates.length; ++i) {
            if (this.gameUpdates[i] == null) continue;
            this.sendImmediateGameUpdate(i, this.gameUpdates[i]);
            this.gameUpdates[i] = null;
        }
        if (this.roundInfoStore != null) {
            this.displayMessage((String)this.roundInfoStore[0], (Object[])this.roundInfoStore[1], (String)this.roundInfoStore[2]);
            this.roundInfoStore = null;
        }
        if (this.postRoundQuestions != null) {
            this.questionSubjects((Vector[][])this.postRoundQuestions[0], (int)((Integer)this.postRoundQuestions[1]), (String)this.postRoundQuestions[2], (String)this.postRoundQuestions[3]);
            this.postRoundQuestions = null;
        }
        log.debug((Object)"Server controller has sent post game updates to all clients");
    }

    public abstract void initialize();

    public void respondToChat(int partnerNum, String messageText, int messageId) {
    }

    public abstract void runSequence() throws AbortRoundException;

    public void terminateAsyncEarly() throws AbortRoundException {
        try {
            if (this.elapseTimer != null) {
                this.elapseTimer.cancel();
            }
            if (this.countdownTimer != null) {
                this.countdownTimer.cancel();
            }
            MessagePacket elapsed = new MessagePacket(null, 19, -2);
            this.mproc.addMessage(elapsed);
        }
        catch (Exception e) {
            log.error((Object)("Failed to terminate an asynchronous round early" + newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected Information askPlayer(int partnerNum) throws AbortRoundException {
        return this.askPlayer(partnerNum, null);
    }

    protected Information askPlayer(int partnerNum, Information info) throws AbortRoundException {
        try {
            this.asyncMode = false;
            int playerNum = this.players[partnerNum];
            if (info != null) {
                this.sendRequest(playerNum, info);
            } else {
                this.sendRequest(playerNum);
            }
            RequestPacket res = this.getResponse(playerNum);
            return res.getGameInfo();
        }
        catch (Exception e) {
            log.error((Object)("Failed in sending request/getting response with player " + this.players[partnerNum] + MSConstants.newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected Information[] askAsynchronous(Information[] info, long time) throws AbortRoundException {
        try {
            this.asyncMode = true;
            if (time >= 0L && this.roundAdvancement == 0) {
                ServerVariables.ui.activateAsyncMode();
            }
            for (int i = 0; i < this.players.length; ++i) {
                this.sendRequest(this.players[i], info[i]);
            }
            this.initMessageProcessor(time);
            this.initCountDown(time);
            Information[] moves = this.processRound(this.mproc);
            this.makeDummyMoves();
            this.mproc.close();
            this.elapseTimer.cancel();
            this.countdownTimer.cancel();
            for (int i = 0; i < groupSize; ++i) {
                this.lastRequests[i].invalidate();
            }
            if (time >= 0L && this.roundAdvancement == 0) {
                ServerVariables.ui.deactivateAsyncMode();
            }
            this.asyncMode = false;
            return moves;
        }
        catch (AbortRoundException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("Failed to start an asynchronous game sequence for game " + MSConstants.newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected Information[] askAsynchronous(Information[] info) throws AbortRoundException {
        return this.askAsynchronous(info, -1L);
    }

    protected abstract Information[] processRound(MessageProcessor var1) throws AbortRoundException;

    protected void send(int partnerNum, Object obj) throws AbortRoundException {
        try {
            GameMessage mes = new GameMessage(obj, 21, -3);
            com.sendMessage(this.players[partnerNum], mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a server asynchronous message to client partner num " + partnerNum + newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected void sendMessage(int partnerNum, int source, int type, Object obj) throws AbortRoundException {
        try {
            GameMessage mes = new GameMessage(obj, type, source);
            com.sendMessage(this.players[partnerNum], mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a general message to client partner num " + partnerNum + newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected Information[] askAllPlayers(Information[] info) throws AbortRoundException {
        try {
            this.asyncMode = false;
            for (int i = 0; i < this.players.length; ++i) {
                this.sendRequest(this.players[i], info[i]);
            }
            Vector responses = this.getResponses();
            Information[] moves = new Information[responses.size()];
            for (int i = 0; i < responses.size(); ++i) {
                moves[i] = ((RequestPacket)responses.get(i)).getGameInfo();
            }
            return moves;
        }
        catch (AbortRoundException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Failed in sending request simulateously to all players in the Server Control", (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected Information[] askAllPlayers() throws AbortRoundException {
        return this.askAllPlayers(null);
    }

    protected void addColumnData(int partnerNum, String column, String data, Color color) {
        ClientData cdata = this.clientData[partnerNum];
        if (this.roundNum == 0) {
            cdata.addColumnData(currentMatch, this.roundNum, column, data, color);
        }
        this.clientUpdates[partnerNum].addColumnData(currentMatch, column, data, color);
        log.debug((Object)("Added data " + data + " to column " + column + " for partner " + partnerNum));
    }

    protected void addColumnData(int partnerNum, String column, String data) {
        this.addColumnData(partnerNum, column, data, Color.black);
    }

    protected void setColumnVisible(int partnerNum, String column, boolean visible) {
        ClientData cdata = this.clientData[partnerNum];
        cdata.setColumnVisible(currentMatch, column, visible);
        this.clientUpdates[partnerNum].setColumnVisible(currentMatch, column, visible);
    }

    protected void setColumnVisibleAllMatches(int partnerNum, String column, boolean visible) {
        ClientData cdata = this.clientData[partnerNum];
        for (int i = 0; i <= currentMatch; ++i) {
            cdata.setColumnVisible(i, column, visible);
            this.clientUpdates[partnerNum].setColumnVisible(i, column, visible);
        }
    }

    protected void alterHistoryLabels(int partnerNum, String matchStr, String totalStr, String matchTotalStr, String practiceMatchStr, String normalMatchStr) {
        try {
            if (matchStr == null) {
                matchStr = "";
            }
            if (totalStr == null) {
                totalStr = "";
            }
            if (matchTotalStr == null) {
                matchTotalStr = "";
            }
            if (practiceMatchStr == null) {
                practiceMatchStr = "";
            }
            if (normalMatchStr == null) {
                normalMatchStr = "";
            }
            Vector<String> labels = new Vector<String>();
            labels.add(matchStr);
            labels.add(totalStr);
            labels.add(matchTotalStr);
            labels.add(practiceMatchStr);
            labels.add(normalMatchStr);
            GameMessage mes = new GameMessage(labels, 28, -2);
            this.storeReauthMessage(partnerNum, "history_labels", mes);
            com.sendMessage(this.players[partnerNum], mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send an alter history labels message to partner " + partnerNum + newline + e), (Throwable)e);
        }
    }

    protected void addPayoff(int partnerNum, float payoff) {
        ClientData payoffClient = this.clientData[partnerNum];
        payoffClient.addPayoffToHistory(currentMatch, this.roundNum, payoff);
        this.clientUpdates[partnerNum].setPayoff(payoff);
        log.debug((Object)("Payoff of " + payoff + " successfully added to client " + payoffClient.getName() + " (ID: " + this.players[partnerNum] + ")"));
    }

    protected void addPayoffs(float[] payoffs) {
        for (int i = 0; i < this.players.length; ++i) {
            this.addPayoff(i, payoffs[i]);
        }
    }

    protected float[] setPayoffToMatches(int[] matches) {
        float[] totalPayoff = new float[groupSize];
        for (int i = 0; i < matches.length; ++i) {
            for (int j = 0; j < groupSize; ++j) {
                int n = j;
                totalPayoff[n] = totalPayoff[n] + this.clientData[j].getMatchPayoff(matches[i]);
            }
        }
        this.setSingularPayoffs(totalPayoff);
        return totalPayoff;
    }

    protected void setSingularPayoffs(float[] singlePayoff) {
        for (int i = 0; i < groupSize; ++i) {
            this.clientData[i].clearAllPayoffs();
        }
        this.addPayoffs(singlePayoff);
    }

    protected void setSingularMatchPayoff(float[] matchPayoff) {
        for (int i = 0; i < groupSize; ++i) {
            this.clientData[i].clearPayoffs(currentMatch);
        }
        this.addPayoffs(matchPayoff);
    }

    protected float[] setPayoffToRounds(int[] matches, Vector[] rounds) {
        float[] totalPayoff = new float[groupSize];
        for (int i = 0; i < matches.length; ++i) {
            Vector payoffRounds = rounds[i];
            for (int j = 0; j < groupSize; ++j) {
                for (int m = 0; m < payoffRounds.size(); ++m) {
                    int payoffRound = (Integer)payoffRounds.get(m);
                    int n = j;
                    totalPayoff[n] = totalPayoff[n] + this.clientData[j].getPayoff(matches[i], payoffRound);
                }
            }
        }
        this.setSingularPayoffs(totalPayoff);
        return totalPayoff;
    }

    protected float[] setPayoffToRounds(int[] matches, int[] rounds) {
        Vector[] payoffRounds = new Vector[rounds.length];
        for (int i = 0; i < rounds.length; ++i) {
            payoffRounds[i] = new Vector();
            payoffRounds[i].add(new Integer(rounds[i]));
        }
        return this.setPayoffToRounds(matches, payoffRounds);
    }

    protected float[] setPayoffToRounds(int[] rounds) {
        float[] totalPayoff = new float[groupSize];
        for (int i = 0; i < rounds.length; ++i) {
            for (int j = 0; j < this.clientData.length; ++j) {
                int n = j;
                totalPayoff[n] = totalPayoff[n] + this.clientData[j].getPayoff(currentMatch, rounds[i]);
            }
        }
        this.setSingularMatchPayoff(totalPayoff);
        return totalPayoff;
    }

    protected float[] setPayoffsToRound(int round) {
        int[] rounds = new int[]{round};
        return this.setPayoffToRounds(rounds);
    }

    protected int getRandomRound(int match) {
        ClientData cdata = this.clientData[0];
        return this.rand.nextInt(cdata.getNumRounds(match));
    }

    protected int getNumTotalRounds() {
        ClientData cdata = this.clientData[0];
        int numRounds = 0;
        for (int i = 0; i <= currentMatch; ++i) {
            numRounds += cdata.getNumRounds(i);
        }
        return numRounds;
    }

    protected void sendMessageString(int partnerNum, String message) throws AbortRoundException {
        try {
            GameMessage mes = new GameMessage(message, 2, -2);
            com.sendMessage(this.players[partnerNum], mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a text message to client partner num " + partnerNum + newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    protected void updateStatus(int partnerNum, String message) {
        try {
            GameMessage mes = new GameMessage(message, 3, -2);
            com.sendMessage(this.players[partnerNum], mes);
            log.debug((Object)("Status of player " + this.players[partnerNum] + " updated to " + message + " for client GUI display"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to send an update status message to partner num " + partnerNum + newline + e), (Throwable)e);
        }
    }

    protected void sendImmediateGameUpdate(int partnerNum, Object message) {
        try {
            GameMessage mes = new GameMessage(message, 5, -2);
            com.sendMessage(this.players[partnerNum], mes);
            log.debug((Object)("Sent a game specific request to player " + this.players[partnerNum] + " to be processed by client GUI"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to send an immediate game update to the clients" + newline + e), (Throwable)e);
        }
    }

    protected void sendUpdatePostRound(int partnerNum, Object message) {
        this.gameUpdates[partnerNum] = message;
        log.debug((Object)("Stored game specific request (update) with player " + this.players[partnerNum] + " and message: " + message));
    }

    protected float getFloatProperty(String prop) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return FLOAT_NOT_FOUND;
            }
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve float match property " + prop + " in match " + currentMatch + newline + e), (Throwable)e);
            return FLOAT_NOT_FOUND;
        }
    }

    protected float getFloatProperty(String prop, float defaultFloat) {
        float value = this.getFloatProperty(prop);
        if (value == FLOAT_NOT_FOUND) {
            value = defaultFloat;
        }
        return value;
    }

    protected int getIntProperty(String prop) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return INT_NOT_FOUND;
            }
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve int match property " + prop + " in match " + currentMatch + newline + e), (Throwable)e);
            return INT_NOT_FOUND;
        }
    }

    protected int getIntProperty(String prop, int defaultInt) {
        int value = this.getIntProperty(prop);
        if (value == INT_NOT_FOUND) {
            value = defaultInt;
        }
        return value;
    }

    protected boolean getBooleanProperty(String prop) {
        return this.getBooleanProperty(prop, false);
    }

    protected boolean getBooleanProperty(String prop, boolean defaultBool) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return defaultBool;
            }
            return Boolean.valueOf(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve boolean match property " + prop + " in match " + currentMatch + newline + e), (Throwable)e);
            return defaultBool;
        }
    }

    protected String getStringProperty(String prop) {
        try {
            String fullstr = "match." + currentMatch + "." + prop;
            String val = props.getProperty(fullstr);
            if (val != null) {
                val = val.trim();
            }
            log.debug((Object)("Retrieved match " + currentMatch + " property " + prop + " = " + val));
            return val;
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve string match property " + prop + " in match " + currentMatch + newline + e), (Throwable)e);
            return null;
        }
    }

    protected String getStringProperty(String prop, String defaultStr) {
        String value = this.getStringProperty(prop);
        if (value == null) {
            value = defaultStr;
        }
        return value;
    }

    protected String getStringPropertyParsed(String prop, String defaultStr) {
        String value = this.getStringProperty(prop);
        if (value == null) {
            value = defaultStr;
        }
        return this.parseString(value);
    }

    protected String parseString(String orig, Hashtable varMap) {
        try {
            String[] splitString;
            String finalStr = orig;
            while ((splitString = finalStr.split("%", 3)).length > 2) {
                Object hashrep;
                String prefix = splitString[0];
                String prm = splitString[1];
                String suffix = splitString[2];
                String replacement = this.getStringProperty(prm);
                if (varMap != null && (hashrep = varMap.get(prm)) != null) {
                    replacement = hashrep.toString();
                }
                if (replacement == null) {
                    replacement = "_temp_" + prm + "_temp_";
                }
                if (prefix.endsWith("\\")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                    replacement = "_temp_" + prm + "%";
                }
                finalStr = prefix + replacement + suffix;
            }
            finalStr = finalStr.replaceAll("_temp_", "%");
            log.debug((Object)("Parsed string " + orig + " on server-side into string " + finalStr));
            return finalStr;
        }
        catch (Exception e) {
            log.error((Object)("Failed to parse the string " + orig + " for variable substitutions. Returning un-parsed string" + MSConstants.newline + e), (Throwable)e);
            return orig;
        }
    }

    protected String parseString(String orig) {
        return this.parseString(orig, null);
    }

    protected void addOutput(int partnerNum, String propName, String propValue) {
        try {
            ClientData cdata = this.clientData[partnerNum];
            String[] output = new String[]{propName, propValue};
            cdata.addRoundOutput(currentMatch, this.roundNum, output);
            log.debug((Object)("Added client-specific round output to player " + this.players[partnerNum] + " in match " + currentMatch + ": " + propName + " = " + propValue));
        }
        catch (Exception e) {
            log.error((Object)("Failed to add client-specific round output to player " + this.players[partnerNum] + " in match " + currentMatch + ": " + propName + " = " + propValue + newline + e));
        }
    }

    protected void addOutput(String propName, String propValue) {
        try {
            String[] output = new String[]{propName, propValue};
            this.match.addRoundOutput(this.groupNumber, this.roundNum, output);
            log.debug((Object)("Added general round output in match " + currentMatch + ": " + propName + " = " + propValue));
        }
        catch (Exception e) {
            log.error((Object)("Failed to add general round output in match " + currentMatch + ": " + propName + " = " + propValue + newline + e), (Throwable)e);
        }
    }

    protected void addMatchOutput(int partnerNum, String propName, String propValue) {
        try {
            ClientData cdata = this.clientData[partnerNum];
            String[] output = new String[]{propName, propValue};
            cdata.addMatchOutput(currentMatch, output);
            log.debug((Object)("Added client-specific match output to player " + this.players[partnerNum] + " in match " + currentMatch + ": " + propName + " = " + propValue));
        }
        catch (Exception e) {
            log.error((Object)("Failed to add client-specific match output to player " + this.players[partnerNum] + " in match " + currentMatch + ": " + propName + " = " + propValue + newline + e));
        }
    }

    protected void addMatchOutput(String propName, String propValue) {
        try {
            String[] output = new String[]{propName, propValue};
            this.match.addMatchOutput(this.groupNumber, output);
            log.debug((Object)("Added general match output in match " + currentMatch + ": " + propName + " = " + propValue));
        }
        catch (Exception e) {
            log.error((Object)("Failed to add general match output in match " + currentMatch + ": " + propName + " = " + propValue + newline + e), (Throwable)e);
        }
    }

    protected void displayMessagePostRound(String title, Object[] messages, String buttonText) {
        Object[] storage = new Object[]{title, messages, buttonText};
        this.roundInfoStore = storage;
        log.debug((Object)"Stored round info messages for to display post-round");
    }

    protected void displayMessagePostRound(Object[] messages) {
        this.displayMessagePostRound("Results", messages, "OK");
    }

    protected void displayUniversalMessage(String message) {
        this.displayUniversalMessage("Results", message, "OK");
    }

    protected void displayUniversalMessage(String title, String message) {
        this.displayUniversalMessage(title, message, "OK");
    }

    protected void displayUniversalMessage(String title, String message, String buttonText) {
        Object[] messages = new Object[groupSize];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = message;
        }
        this.displayMessage(title, messages, buttonText);
    }

    protected void displayMessage(String title, Object[] messages) {
        this.displayMessage(title, messages, "OK");
    }

    protected void displayMessage(Object[] messages) {
        this.displayMessage("Results", messages, "OK");
    }

    protected void displayMessage(String title, Object[] messages, String buttonText) {
        try {
            int i;
            Vector<Integer> nullList = new Vector<Integer>();
            GameMessage rmes = null;
            if (messages.length != groupSize) {
                log.warn((Object)"Aborted sending round info messages - the number of messages did nto equal the group size");
                return;
            }
            for (i = 0; i < groupSize; ++i) {
                if (messages[i] == null) {
                    nullList.add(new Integer(i));
                    continue;
                }
                Object[] info = new Object[]{title, messages[i], buttonText};
                rmes = new GameMessage(info, 20, -2);
                this.storeReauthMessage(i, "round_info", rmes);
                com.sendMessage(this.players[i], rmes);
                ui.updateClientStatus(this.players[i], "Confirming Message");
            }
            block3: for (i = 0; i < groupSize; ++i) {
                while (!nullList.contains(new Integer(i))) {
                    MessagePacket mes = com.getMessage(this.players[i]);
                    if (mes.getType() == 24) {
                        this.removeReauthMessage(i, "round_info");
                        ui.updateClientStatus(this.players[i], "Message Confirmed");
                        continue block3;
                    }
                    System.out.println("discarded received message of type " + mes.getType());
                    com.sendInternalMessage(this.players[i], mes);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to send the round info dialogues to clients and wait for confirmation" + newline + e), (Throwable)e);
        }
    }

    protected void displayMessageNonBlocking(String title, Object[] messages, String buttonText) {
        try {
            final Vector<Integer> nullList = new Vector<Integer>();
            GameMessage rmes = null;
            if (messages.length != groupSize) {
                log.warn((Object)"Aborted sending round info messages - the number of messages did nto equal the group size");
                return;
            }
            for (int i = 0; i < groupSize; ++i) {
                if (messages[i] == null) {
                    nullList.add(new Integer(i));
                    continue;
                }
                Object[] info = new Object[]{title, messages[i], buttonText};
                rmes = new GameMessage(info, 20, -2);
                this.storeReauthMessage(i, "round_info", rmes);
                com.sendMessage(this.players[i], rmes);
                ui.updateClientStatus(this.players[i], "Confirming Message");
            }
            Runnable getAck = new Runnable(){

                public void run() {
                    block0: for (int i = 0; i < ServerVariables.groupSize; ++i) {
                        while (!nullList.contains(new Integer(i))) {
                            MessagePacket mes = ServerVariables.com.getMessage(ServerControl.this.players[i]);
                            if (mes.getType() == 24) {
                                ServerControl.this.removeReauthMessage(i, "round_info");
                                ServerVariables.ui.updateClientStatus(ServerControl.this.players[i], "Message Confirmed");
                                continue block0;
                            }
                            System.out.println("discarded received message of type " + mes.getType());
                            ServerVariables.com.sendInternalMessage(ServerControl.this.players[i], mes);
                        }
                    }
                }
            };
            Thread updateThread = new Thread(getAck);
            updateThread.start();
        }
        catch (Exception e) {
            log.error((Object)("Failed to send the round info dialogues to clients and wait for confirmation" + newline + e), (Throwable)e);
        }
    }

    protected Vector[] questionSubjects(Vector[] questions, int timeLimit, String titleText, String buttonText) {
        Vector[][] batches = new Vector[1][questions.length];
        for (int i = 0; i < batches[0].length; ++i) {
            batches[0][i] = questions[i];
        }
        Vector[][] responses = this.questionSubjects(batches, timeLimit, titleText, buttonText);
        Vector[] singleBatch = new Vector[questions.length];
        for (int i = 0; i < singleBatch.length; ++i) {
            singleBatch[i] = responses[0][i];
        }
        return singleBatch;
    }

    protected Vector[] questionSubjects(Vector[] questions, int timeLimit) {
        return this.questionSubjects(questions, timeLimit, null, null);
    }

    protected Vector[] questionSubjects(Vector[] questions, String titleText, String buttonText) {
        return this.questionSubjects(questions, -1, titleText, buttonText);
    }

    protected Vector[] questionSubjects(Vector[] questions) {
        return this.questionSubjects(questions, -1, null, null);
    }

    protected Vector[][] questionSubjects(Vector[][] questions, int timeLimit) {
        return this.questionSubjects(questions, timeLimit, null, null);
    }

    protected Vector[][] questionSubjects(Vector[][] questions, String titleText, String buttonText) {
        return this.questionSubjects(questions, -1, titleText, buttonText);
    }

    protected Vector[][] questionSubjects(Vector[][] questions) {
        return this.questionSubjects(questions, -1, null, null);
    }

    protected Vector[][] questionSubjects(Vector[][] questions, int timeLimit, String titleText, String buttonText) {
        try {
            if (questions == null) {
                return null;
            }
            Vector[][] responses = new Vector[questions.length][questions[0].length];
            for (int z = 0; z < questions.length; ++z) {
                int i;
                Vector[] batch = questions[z];
                Vector<Integer> nullList = new Vector<Integer>();
                GameMessage qmes = null;
                if (batch.length != groupSize) {
                    log.warn((Object)"Aborted asking client questions - the number of question vectors did not equal the group size");
                    return null;
                }
                for (i = 0; i < groupSize; ++i) {
                    if (batch[i] == null) {
                        nullList.add(new Integer(i));
                        continue;
                    }
                    Object[] qPacket = new Object[]{titleText, buttonText, new Integer(timeLimit), batch[i]};
                    qmes = new GameMessage(qPacket, 25, -2);
                    this.storeReauthMessage(i, "question_message", qmes);
                    com.sendMessage(this.players[i], qmes);
                    ui.updateClientStatus(this.players[i], "Answering Questions");
                }
                block4: for (i = 0; i < groupSize; ++i) {
                    while (!nullList.contains(new Integer(i))) {
                        MessagePacket mes = com.getMessage(this.players[i]);
                        if (mes.getType() == 34) {
                            Vector answers;
                            this.removeReauthMessage(i, "question_message");
                            ui.updateClientStatus(this.players[i], "Questions Answered");
                            responses[z][i] = answers = (Vector)mes.getObject();
                            this.outputSurveyAnswers(z, i, answers);
                            continue block4;
                        }
                        System.out.println("message received was of type " + mes.getType());
                        com.sendInternalMessage(this.players[i], mes);
                    }
                }
            }
            return responses;
        }
        catch (Exception e) {
            log.error((Object)("Failed to send the question dialogs to client and wait for their confirmation" + newline + e), (Throwable)e);
            return null;
        }
    }

    protected Vector[] questionSubject(int partner, Vector[] questions, boolean blocking, String titleText, String buttonText) {
        return this.questionSubject(partner, questions, blocking, -1, titleText, buttonText);
    }

    protected Vector[] questionSubject(int partner, Vector[] questions, boolean blocking, int timeLimit) {
        return this.questionSubject(partner, questions, blocking, timeLimit, null, null);
    }

    protected Vector[] questionSubject(int partner, Vector[] questions, boolean blocking) {
        return this.questionSubject(partner, questions, blocking, -1, null, null);
    }

    protected Vector[] questionSubject(int partner, Vector[] questions, boolean blocking, int timeLimit, String titleText, String buttonText) {
        try {
            final int player = this.players[partner];
            final int partnerNum = partner;
            final Vector[] responses = new Vector[questions.length];
            for (int i = 0; i < questions.length; ++i) {
                Object[] qPacket = new Object[]{titleText, buttonText, new Integer(timeLimit), questions[i]};
                GameMessage qmes = new GameMessage(qPacket, 25, -2);
                this.storeReauthMessage(partner, "question_message", qmes);
                com.sendMessage(player, qmes);
                ui.updateClientStatus(player, "Answering Questions");
                final int index = i;
                Runnable getAnswers = new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                MessagePacket mes;
                                if ((mes = ServerVariables.com.getMessage(player)).getType() == 24) {
                                    ServerControl.this.removeReauthMessage(partnerNum, "question_message");
                                    ServerVariables.ui.updateClientStatus(player, "Questions Answered");
                                    Vector answers = (Vector)mes.getObject();
                                    ServerControl.this.outputSurveyAnswers(index, partnerNum, answers);
                                    responses[index] = answers;
                                    break;
                                }
                                ServerVariables.com.sendInternalMessage(player, mes);
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("Error receiving question answers non-blocking from player " + player + MSConstants.newline + e), (Throwable)e);
                        }
                    }
                };
                if (blocking) {
                    getAnswers.run();
                    continue;
                }
                if (blocking) continue;
                Thread updateThread = new Thread(getAnswers);
                updateThread.start();
                return null;
            }
            return responses;
        }
        catch (Exception e) {
            log.error((Object)("Error sending question with non-blocking to player " + this.players[partner] + newline + e), (Throwable)e);
            return null;
        }
    }

    protected void questionSubjectsPostMatch(Vector[][] questions, int timeLimit, String titleText, String buttonText) {
        this.postMatchQuestions = new Object[4];
        this.postMatchQuestions[0] = questions;
        this.postMatchQuestions[1] = new Integer(timeLimit);
        this.postMatchQuestions[2] = titleText;
        this.postMatchQuestions[3] = buttonText;
    }

    protected void questionSubjectsPostMatch(Vector[][] questions, int timeLimit) {
        this.questionSubjectsPostMatch(questions, timeLimit, null, null);
    }

    protected void questionSubjectsPostMatch(Vector[][] questions, String titleText, String buttonText) {
        this.questionSubjectsPostMatch(questions, -1, titleText, buttonText);
    }

    protected void questionSubjectsPostMatch(Vector[][] questions) {
        this.questionSubjectsPostMatch(questions, -1, null, null);
    }

    protected void questionSubjectsPostMatch(Vector[] questions, int timeLimit, String titleText, String buttonText) {
        Vector[][] batches = new Vector[1][questions.length];
        for (int i = 0; i < batches[0].length; ++i) {
            batches[0][i] = questions[i];
        }
        this.questionSubjectsPostMatch(batches, timeLimit, titleText, buttonText);
    }

    protected void questionSubjectsPostMatch(Vector[] questions, int timeLimit) {
        this.questionSubjectsPostMatch(questions, timeLimit, null, null);
    }

    protected void questionSubjectsPostMatch(Vector[] questions, String titleText, String buttonText) {
        this.questionSubjectsPostMatch(questions, -1, titleText, buttonText);
    }

    protected void questionSubjectsPostMatch(Vector[] questions) {
        this.questionSubjectsPostMatch(questions, -1, null, null);
    }

    protected void questionSubjectsPostRound(Vector[][] questions, int timeLimit, String titleText, String buttonText) {
        this.postRoundQuestions = new Object[4];
        this.postRoundQuestions[0] = questions;
        this.postRoundQuestions[1] = new Integer(timeLimit);
        this.postRoundQuestions[2] = titleText;
        this.postRoundQuestions[3] = buttonText;
    }

    protected void questionSubjectsPostRound(Vector[][] questions, int timeLimit) {
        this.questionSubjectsPostRound(questions, timeLimit, null, null);
    }

    protected void questionSubjectsPostRound(Vector[][] questions, String titleText, String buttonText) {
        this.questionSubjectsPostRound(questions, -1, titleText, buttonText);
    }

    protected void questionSubjectsPostRound(Vector[][] questions) {
        this.questionSubjectsPostRound(questions, -1, null, null);
    }

    protected void questionSubjectsPostRound(Vector[] questions, int timeLimit, String titleText, String buttonText) {
        Vector[][] batches = new Vector[1][questions.length];
        for (int i = 0; i < batches[0].length; ++i) {
            batches[0][i] = questions[i];
        }
        this.questionSubjectsPostRound(batches, timeLimit, titleText, buttonText);
    }

    protected void questionSubjectsPostRound(Vector[] questions, int timeLimit) {
        this.questionSubjectsPostRound(questions, timeLimit, null, null);
    }

    protected void questionSubjectsPostRound(Vector[] questions, String titleText, String buttonText) {
        this.questionSubjectsPostRound(questions, -1, titleText, buttonText);
    }

    protected void questionSubjectsPostRound(Vector[] questions) {
        this.questionSubjectsPostRound(questions, -1, null, null);
    }

    protected void updateBarGraph(int partnerNum, String name, String title, String caption, String[] labels, float[] values, float ymaximum, int formatType) {
        try {
            BarGraphUpdate update = new BarGraphUpdate(name, title, caption, labels, values, ymaximum, formatType);
            GameMessage mes = new GameMessage(update, 7, -2);
            com.sendMessage(this.players[partnerNum], mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to update bar graph " + name + " for player " + this.players[partnerNum] + newline + e), (Throwable)e);
        }
    }

    protected void updateStatPanel(int partnerNum, String name, String[] rowLabels, String[] colLabels, String[][] data) {
        try {
            StatPanelUpdate update = new StatPanelUpdate(name, rowLabels, colLabels, data);
            GameMessage mes = new GameMessage(update, 8, -2);
            com.sendMessage(this.players[partnerNum], mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to update stat panel " + name + " for player " + this.players[partnerNum] + newline + e), (Throwable)e);
        }
    }

    public int getPartnerNum(int playerNum) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] != playerNum) continue;
            return i;
        }
        return -1;
    }

    public int getPlayerNum(int partnerNum) {
        if (partnerNum < 0 || partnerNum >= this.players.length) {
            return -1;
        }
        return this.players[partnerNum];
    }

    protected long getTimeLeft() {
        return this.timeLeft;
    }

    protected boolean isLastRound() {
        int maxRounds = this.match.getNumRounds();
        return this.roundNum == maxRounds - 1;
    }

    protected boolean isLastMatch() {
        int finalMatch = matches.size() - 1;
        return currentMatch >= finalMatch;
    }

    protected void storeReauthMessage(int partnerNum, String key, Message mes) {
        Hashtable<String, Message> partner = (Hashtable<String, Message>)this.reauthMessages.get(new Integer(partnerNum));
        if (partner == null) {
            partner = new Hashtable<String, Message>();
            this.reauthMessages.put(new Integer(partnerNum), partner);
        }
        partner.put(key, mes);
    }

    protected void removeReauthMessage(int partnerNum, String key) {
        Hashtable partner = (Hashtable)this.reauthMessages.get(new Integer(partnerNum));
        if (partner == null) {
            return;
        }
        partner.remove(key);
    }

    protected void updateFinishMessage(int partnerNum, String message) {
        try {
            GameMessage mes = new GameMessage(message, 4, -2);
            com.sendMessage(this.players[partnerNum], mes);
            log.debug((Object)("Completion message sent to player " + this.players[partnerNum]));
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a completion message to partnerNum " + partnerNum + newline + e), (Throwable)e);
        }
    }

    protected Vector[][] constructQuestions() {
        try {
            Vector<Question> qs = null;
            Object singleRound = null;
            int rounds = this.getIntProperty("roundsOfQuestions");
            Vector[][] questions = new Vector[rounds][groupSize];
            for (int j = 0; j < rounds; ++j) {
                int i;
                int numOfQuestions = this.getIntProperty("round." + j + ".numOfQuestions");
                qs = new Vector<Question>();
                log.info((Object)("round : " + j + " # q " + numOfQuestions));
                for (i = 0; i < numOfQuestions; ++i) {
                    String initText;
                    String outputName;
                    int correctIndex;
                    int k;
                    String[] options;
                    int numOfOptions;
                    Question question;
                    String value;
                    String type = this.getStringProperty("round." + j + ".question." + i + ".type");
                    if (type == null) {
                        type = "choice";
                    }
                    if ((value = this.getStringProperty("round." + j + ".question." + i)) == null) continue;
                    if (type.equalsIgnoreCase("instruction")) {
                        question = new InstructionQuestion(value);
                        qs.add(question);
                    }
                    if (type.equalsIgnoreCase("choice")) {
                        question = new ChoiceQuestion(value);
                        numOfOptions = 0;
                        while (this.getStringProperty("round." + j + ".question." + i + ".ans." + numOfOptions) != null) {
                            ++numOfOptions;
                        }
                        options = new String[numOfOptions];
                        for (k = 0; k < numOfOptions; ++k) {
                            options[k] = this.getStringProperty("round." + j + ".question." + i + ".ans." + k);
                        }
                        question.setOptions(options);
                        correctIndex = this.getIntProperty("round." + j + ".question." + i + ".correct");
                        ((ChoiceQuestion)question).setAnswerIndex(correctIndex);
                        outputName = this.getStringProperty("round." + j + ".question." + i + ".outputName");
                        question.setOutputName(outputName);
                        if (this.getStringProperty("round." + j + ".question." + i + ".other") != null) {
                            ((ChoiceQuestion)question).setOtherChoice(this.getStringProperty("round." + j + ".question." + i + ".other"));
                        }
                        if (((ChoiceQuestion)question).getAnswerIndex() < 0) {
                            question.setSurvey(true);
                        }
                        qs.add(question);
                    }
                    if (type.equalsIgnoreCase("dropdown")) {
                        question = new DropdownQuestion(value);
                        numOfOptions = 0;
                        while (this.getStringProperty("round." + j + ".question." + i + ".ans." + numOfOptions) != null) {
                            ++numOfOptions;
                        }
                        options = new String[numOfOptions];
                        for (k = 0; k < numOfOptions; ++k) {
                            options[k] = this.getStringProperty("round." + j + ".question." + i + ".ans." + k);
                        }
                        question.setOptions(options);
                        correctIndex = this.getIntProperty("round." + j + ".question." + i + " .correct");
                        ((DropdownQuestion)question).setAnswerIndex(correctIndex);
                        outputName = this.getStringProperty("round." + j + ".question." + i + ".outputName");
                        question.setOutputName(outputName);
                        if (((DropdownQuestion)question).getAnswerIndex() < 0) {
                            question.setSurvey(true);
                        }
                        qs.add(question);
                    }
                    if (type.equalsIgnoreCase("slider")) {
                        question = null;
                        int min = this.getIntProperty("round." + j + ".question." + i + ".min");
                        int max = this.getIntProperty("round." + j + ".question." + i + ".max");
                        int inc = this.getIntProperty("round." + j + ".question." + i + ".inc");
                        outputName = this.getStringProperty("round." + j + ".question." + i + ".outputName");
                        String answer = this.getStringProperty("round." + j + ".question." + i + ".answer");
                        question = answer == null ? new SliderQuestion(value, min, inc, max, outputName) : new SliderQuestion(value, answer, min, inc, max);
                        qs.add(question);
                    }
                    if (type.equalsIgnoreCase("text")) {
                        initText = this.getStringProperty("round." + j + ".question." + i + ".initText");
                        String outputName2 = this.getStringProperty("round." + j + ".question." + i + ".outputName");
                        TextQuestion question2 = new TextQuestion(value, initText, outputName2);
                        qs.add(question2);
                    }
                    if (!type.equalsIgnoreCase("essay")) continue;
                    initText = this.getStringProperty("round." + j + ".question." + i + ".initText");
                    String outputName3 = this.getStringProperty("round." + j + ".question." + i + ".outputName");
                    EssayQuestion question3 = new EssayQuestion(value, initText, outputName3);
                    qs.add(question3);
                }
                for (i = 0; i < groupSize; ++i) {
                    questions[j][i] = qs;
                }
            }
            return questions;
        }
        catch (Exception e) {
            log.error((Object)("Malformed question parameters when using constructQuestions helper in ServerControl" + newline + e), (Throwable)e);
            return null;
        }
    }

    protected void endExperiment() {
        lastMatch = true;
        log.info((Object)"Experiment terminated by extension control - No matches after current match");
    }

    protected void activateGroupChatRouting() {
        this.cproc.activateGroupRouting();
    }

    protected void clearChatRoutingTable() {
        this.cproc.clearRoutingInfo();
    }

    public void insertChatRoute(int sender, int receiver) {
        this.cproc.insertRoute(sender, receiver);
    }

    public void removeChatRoute(int sender, int receiver) {
        this.cproc.removeRoute(sender, receiver);
    }

    public void insertChatRoutingTable(Vector[] routingTable) {
        this.cproc.insertRoutingTable(routingTable);
    }

    private void initMessageProcessor(long expireTime) {
        this.mproc = new MessageProcessor(this.players);
        this.mproc.flushBoxes();
        this.mproc.activateReceivers();
        this.elapseTimer = new Timer();
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    MessagePacket elapsed = new MessagePacket(null, 19, -2);
                    ServerControl.this.mproc.addMessage(elapsed);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to create asynchronous time expiration message" + MSConstants.newline + e), (Throwable)e);
                }
            }
        };
        if (expireTime > 0L) {
            this.elapseTimer.schedule(task, expireTime);
        }
    }

    private void initCountDown(long initialTime) {
        final long initTime = initialTime;
        this.timeLeft = initialTime;
        this.countdownTimer = new Timer();
        TimerTask countdownTask = new TimerTask(){

            public void run() {
                try {
                    ServerControl.this.timeLeft = ServerControl.this.timeLeft > 1000L ? (ServerControl.this.timeLeft -= 1000L) : 0L;
                    if (ServerControl.this.primaryControl && initTime >= 0L && ServerControl.this.roundAdvancement == 0) {
                        ServerVariables.ui.updateTimeLeft(ServerVariables.currentMatch, ServerControl.this.roundNum, ServerControl.this.timeLeft / 1000L);
                    }
                    if (ServerControl.this.primaryControl && initTime < 0L && ServerControl.this.roundAdvancement == 0) {
                        ServerVariables.ui.updateTimeLeft(ServerVariables.currentMatch, ServerControl.this.roundNum, -1L);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed to initialize asynchronous countdown timer" + MSConstants.newline + e), (Throwable)e);
                }
            }
        };
        this.countdownTimer.scheduleAtFixedRate(countdownTask, 1000L, 1000L);
    }

    private void makeDummyMoves() {
        try {
            for (int i = 0; i < groupSize; ++i) {
                System.out.println(" >>> sending dummy req to " + i);
                com.sendMessage(this.players[i], new GameMessage(null, 23, -2));
                com.getResponse(this.players[i]);
                System.out.println(" >>> got dummy res from " + i);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to tell clients to make dummy moves in attempt to run async round or abort round" + newline + e), (Throwable)e);
        }
    }

    private void sendRequest(int playerNum) throws AbortRoundException {
        this.sendRequest(playerNum, null);
    }

    private void sendRequest(int playerNum, Information info) {
        try {
            GameRequest req = new GameRequest(1);
            if (info != null) {
                req.setGameInfo(info);
            }
            int partnerNum = this.getPartnerNum(playerNum);
            System.out.println(" >>> constructing req to " + partnerNum + " reqType " + req.getType());
            if (!this.sendFullRequest[partnerNum]) {
                this.readyUpdates[partnerNum].setFutureClientColumns(this.clientUpdates[partnerNum].getClientColumns());
                Information sysInfo = new Information();
                sysInfo.addInfo("clientUpdate", this.readyUpdates[partnerNum]);
                req.setSystemInfo(sysInfo);
                System.out.println(" >>> send req to " + partnerNum + " reqType " + req.getType());
                com.sendRequest(playerNum, req);
            }
            this.clientUpdates[partnerNum].resetClientColumns();
            GameRequest firstReq = new GameRequest(1);
            if (info != null) {
                firstReq.setGameInfo(info);
            }
            firstReq.setType(4);
            Information sysInfo = new Information();
            sysInfo.addInfo("clientData", this.clientData[partnerNum]);
            firstReq.setSystemInfo(sysInfo);
            this.lastRequests[partnerNum] = req;
            if (this.sendFullRequest[partnerNum]) {
                System.out.println(" >>> send req to " + partnerNum + " reqType " + firstReq.getType());
                com.sendRequest(playerNum, firstReq);
                this.sendFullRequest[partnerNum] = false;
            }
            this.requestSent[partnerNum] = true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a request to player " + playerNum + MSConstants.newline + e), (Throwable)e);
            e.printStackTrace();
        }
    }

    private Vector getResponses() throws AbortRoundException {
        try {
            Thread responder;
            int i;
            Vector<RequestPacket> responses = new Vector<RequestPacket>();
            Vector<Thread> responders = new Vector<Thread>();
            for (i = 0; i < this.players.length; ++i) {
                this.rcons[i] = new ResponseControl(this.players[i], this.lastRequests[i]);
                responder = new Thread(this.rcons[i]);
                responder.start();
                responders.add(responder);
            }
            for (i = 0; i < this.players.length; ++i) {
                responder = (Thread)responders.get(i);
                responder.join();
            }
            for (i = 0; i < this.players.length; ++i) {
                RequestPacket res = this.rcons[i].getResponse();
                responses.add(res);
            }
            return responses;
        }
        catch (InterruptedException e) {
            log.error((Object)("Failed to retrieve client responses simultaneously (in getResponses())" + MSConstants.newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    private RequestPacket getResponse(int playerNum) throws AbortRoundException {
        try {
            int partnerNum = this.getPartnerNum(playerNum);
            this.rcons[partnerNum] = new ResponseControl(playerNum, this.lastRequests[partnerNum]);
            Thread responder = new Thread(this.rcons[partnerNum]);
            responder.start();
            responder.join();
            RequestPacket res = this.rcons[partnerNum].getResponse();
            return res;
        }
        catch (InterruptedException e) {
            log.error((Object)("Failed to get a response from player " + playerNum + MSConstants.newline + e), (Throwable)e);
            throw new AbortRoundException();
        }
    }

    private void processAbortedRound(AbortRoundException e) {
        try {
            log.warn((Object)"Round aborted: starting a new round with the same game");
            Object[] messages = new String[groupSize];
            if (this.asyncMode) {
                this.mproc.close();
                this.elapseTimer.cancel();
                this.countdownTimer.cancel();
                ServerVariables.ui.deactivateAsyncMode();
            }
            for (int i = 0; i < groupSize; ++i) {
                if (!this.requestSent[i] && !this.sendFullRequest[i]) {
                    this.sendUpdateRequest(i, false);
                }
                if (e.getMessage() != null && e.getMessage().length() > 0) {
                    messages[i] = e.getMessage();
                } else if (e.getAbortionType() == AbortRoundException.ACCIDENTAL_ABORTION) {
                    messages[i] = "Due to a technical difficulty, the last round was aborted." + newline + "Payoff earned in the last round will not be counted in the total.";
                } else if (e.getAbortionType() == AbortRoundException.MANUAL_ABORTION) {
                    messages[i] = "The last round has been aborted." + newline + "Payoff earned in the last round will not be counted in the total.";
                }
                this.addPayoff(i, 0.0f);
                if (!this.asyncMode && (e.getAbortionType() != AbortRoundException.MANUAL_ABORTION || this.rcons[i].receivedMove())) continue;
                GameMessage mes = new GameMessage(null, 27, -2);
                com.sendMessage(this.players[i], mes);
            }
            if (e.getDisplayMessage()) {
                this.displayMessage(messages);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Failed to abort round " + this.roundNum), (Throwable)ex);
        }
    }

    private void sendReauthMessages(int partnerNum) {
        Vector messages = this.getReauthMessages(partnerNum);
        for (int i = 0; i < messages.size(); ++i) {
            Message mes = (Message)messages.get(i);
            com.sendMessage(this.players[partnerNum], mes);
        }
    }

    private void finishMatch() {
        try {
            int i;
            int i2;
            for (i2 = 0; i2 < this.players.length; ++i2) {
                this.updateStatus(i2, this.completionMessage);
                this.updateFinishMessage(i2, this.completionMessage);
                this.sendAllGameUpdates();
                this.sendUpdateRequest(i2, true);
            }
            if (!this.abortingMatch) {
                if (this.postMatchQuestions != null) {
                    this.questionSubjects((Vector[][])this.postMatchQuestions[0], (int)((Integer)this.postMatchQuestions[1]), (String)this.postMatchQuestions[2], (String)this.postMatchQuestions[3]);
                    this.postMatchQuestions = null;
                }
                for (i2 = 0; i2 < this.players.length; ++i2) {
                    GameMessage mes = new GameMessage(null, 26, -2);
                    this.storeReauthMessage(i2, "finish_match", mes);
                    com.sendMessage(this.players[i2], mes);
                }
                Thread[] fthreads = new Thread[this.players.length];
                for (i = 0; i < this.players.length; ++i) {
                    FinishControl fcontrol = new FinishControl(this.players[i]);
                    fthreads[i] = new Thread(fcontrol);
                    fthreads[i].start();
                }
                for (i = 0; i < this.players.length; ++i) {
                    fthreads[i].join();
                }
            }
            this.cproc.close();
            for (i2 = 0; i2 < this.clientData.length; ++i2) {
                this.clientData[i2].setMatchFinished(currentMatch, true);
            }
            int maxR = ((Match)matches.get(currentMatch)).getNumRounds();
            for (i = this.roundNum + 1; i < maxR; ++i) {
                this.setRoundStatus(i, MatchHistory.ROUND_UNPLAYED);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to send end game / receive confirmed response from clients when finishing game" + MSConstants.newline + e), (Throwable)e);
        }
    }

    private void sendUpdateRequest(int partnerNum, boolean endgame) {
        try {
            GameRequest req = new GameRequest(2);
            Information sysInfo = new Information();
            sysInfo.addInfo("clientUpdate", this.readyUpdates[partnerNum]);
            req.setSystemInfo(sysInfo);
            if (endgame) {
                req.setType(3);
            }
            System.out.println(" >>> send update req to " + partnerNum + " reqType " + req.getType());
            com.sendRequest(this.players[partnerNum], req);
            GameRequest firstReq = new GameRequest(2);
            firstReq.setType(4);
            Information sysInfo2 = new Information();
            sysInfo2.addInfo("clientData", this.clientData[partnerNum]);
            firstReq.setSystemInfo(sysInfo2);
            if (endgame) {
                firstReq.setType(3);
            }
            this.lastRequests[partnerNum] = firstReq;
            log.debug((Object)("Sent update game request to player " + this.players[partnerNum]));
        }
        catch (Exception e) {
            log.error((Object)("Failed to send an update game request to player " + this.players[partnerNum] + newline + e), (Throwable)e);
        }
    }

    private Request buildReauthRequest(Match match, ClientData cdata) {
        try {
            GameRequest req = new GameRequest(0);
            Information sysInfo = new Information();
            sysInfo.addIntInfo("id", cdata.getId());
            sysInfo.addStringInfo("gameType", match.getGameType());
            sysInfo.addIntInfo("partnerNum", cdata.getPartnerNum());
            sysInfo.addIntInfo("groupSize", match.getGroupSize());
            sysInfo.addBooleanInfo("preserve", false);
            sysInfo.addStringInfo("defaultView", match.getDefaultView());
            sysInfo.addInfo("chatOptions", match.getChatOptions());
            sysInfo.addBooleanInfo("optionChat", match.getOptionChat());
            sysInfo.addBooleanInfo("enableChat", match.getEnableChat());
            sysInfo.addStringInfo("chatIdentifier", match.getChatIdentifier());
            sysInfo.addBooleanInfo("displayFinishedInfo", match.getDisplayFinishedInfo());
            sysInfo.addIntInfo("historyNumber", match.getHistoryNumber());
            sysInfo.addBooleanInfo("viewSwitchable", match.getViewSwitchable());
            sysInfo.addBooleanInfo("showTotalPayoff", match.getShowTotalPayoff());
            sysInfo.addStringInfo("serverClassname", match.getServerClassname());
            sysInfo.addStringInfo("clientClassname", match.getClientClassname());
            String packageName = match.getPackageName();
            if (packageName != null) {
                sysInfo.addStringInfo("packageName", packageName);
            }
            req.setSystemInfo(sysInfo);
            return req;
        }
        catch (Exception e) {
            log.error((Object)("Failed to build a reauthentication request for client " + cdata.getId()));
            return null;
        }
    }

    protected void outputSurveyAnswers(int questionRound, int partner, Vector questions) {
        if (questions == null) {
            return;
        }
        for (int i = 0; i < questions.size(); ++i) {
            String outputName;
            Question question = (Question)questions.get(i);
            if (question.isSurvey() && question.getStyle() != Question.INSTRUCTION_QUESTION) {
                String answer = question.getChosenAnswer();
                outputName = question.getOutputName();
                if (outputName == null) {
                    outputName = "questionRound." + questionRound + ".question." + i + ".answer";
                }
                log.info((Object)("output question response: " + answer + " " + outputName));
                if (answer != null) {
                    this.addOutput(partner, outputName, answer);
                }
            }
            if (!this.outputWrongQuestionAnswers || question.getWrongAnswers() == null || question.getWrongAnswers().size() <= 0) continue;
            for (int w = 0; w < question.getWrongAnswers().size(); ++w) {
                outputName = question.getOutputName();
                if (outputName == null) {
                    outputName = "questionRound." + questionRound + ".question." + i + ".wrongAnswer." + w;
                }
                String wrongAnswer = (String)question.getWrongAnswers().elementAt(w);
                this.addOutput(partner, outputName, wrongAnswer);
            }
        }
    }

    protected void outputSurveyAnswersIndexed(int partner, Vector questions) {
        if (questions == null) {
            return;
        }
        for (int i = 0; i < questions.size(); ++i) {
            Question question = (Question)questions.get(i);
            if (!question.isSurvey() || question.getStyle() == Question.INSTRUCTION_QUESTION) continue;
            String outputName = question.getOutputName();
            if (outputName == null) {
                outputName = "question." + i + ".answer";
            }
            String answer = question.getChosenAnswer();
            if (question.getStyle() == Question.CHOICE_QUESTION) {
                ChoiceQuestion cq = (ChoiceQuestion)question;
                answer = "" + cq.getChosenAnswerIndex();
            }
            if (question.getStyle() == Question.DROP_DOWN_QUESTION) {
                DropdownQuestion ddq = (DropdownQuestion)question;
                answer = "" + ddq.getChosenAnswerIndex();
            }
            if (answer == null) continue;
            this.addOutput(partner, outputName, answer);
        }
    }

    private void setRoundStatus(int round, int status) {
        for (int i = 0; i < this.clientData.length; ++i) {
            this.clientData[i].setRoundStatus(currentMatch, round, status);
        }
    }

    private String arrayToString(int[] ints) {
        String array = "[";
        for (int i = 0; i < ints.length - 1; ++i) {
            array = array + " " + ints[i] + ",";
        }
        array = array + " " + ints[ints.length - 1] + " ]";
        return array;
    }

    private String arrayToNames(int[] ints) {
        String names = "";
        for (int i = 0; i < ints.length - 1; ++i) {
            String name = ((ClientData)ServerVariables.clients.get(ints[i])).getName();
            names = names + name + " (id: " + ints[i] + "), ";
        }
        String name = ((ClientData)ServerVariables.clients.get(ints[ints.length - 1])).getName();
        names = names + name + " (id: " + ints[ints.length - 1] + ")";
        return names;
    }

    private void resetClientUpdates() {
        for (int i = 0; i < this.clientUpdates.length; ++i) {
            this.clientUpdates[i] = new ClientUpdate(currentMatch, this.roundNum);
        }
    }

    private void resetReadyUpdates() {
        for (int i = 0; i < this.readyUpdates.length; ++i) {
            this.readyUpdates[i] = new ClientUpdate(currentMatch, this.roundNum);
        }
    }

    private void installMatchUpdates() {
        for (int i = 0; i < this.readyUpdates.length; ++i) {
            this.readyUpdates[i].installMatchInfo(this.clientData[i]);
        }
    }

    private void swapUpdateBank() {
        ClientUpdate[] tmp = this.readyUpdates;
        this.readyUpdates = this.clientUpdates;
        this.clientUpdates = tmp;
    }

    private Vector getReauthMessages(int partnerNum) {
        Hashtable partner = (Hashtable)this.reauthMessages.get(new Integer(partnerNum));
        if (partner == null) {
            return new Vector();
        }
        return new Vector(partner.values());
    }

    public boolean isActive() {
        return this.active;
    }
}

