/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.MatchMaker;
import edu.caltech.ssel.multistage.server.control.OutputWriter;
import edu.caltech.ssel.multistage.server.control.PeriodicPinger;
import edu.caltech.ssel.multistage.server.control.PersistWriter;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.data.Match;
import edu.caltech.ssel.multistage.server.data.Parameters;
import edu.caltech.ssel.multistage.server.interfaces.LoginGUI;
import edu.caltech.ssel.multistage.server.interfaces.ServerGUI;
import edu.caltech.ssel.multistage.server.network.MailServerAuthenticator;
import edu.caltech.ssel.multistage.server.network.ServerAuthenticator;
import edu.caltech.ssel.multistage.server.network.Verifier;
import edu.caltech.ssel.multistage.server.util.guiAppender;
import edu.caltech.ssel.multistage.server.util.pluginservice.PluginDescriptor;
import edu.caltech.ssel.multistage.server.util.pluginservice.PluginService;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.interfaces.WaitingDialog;
import edu.caltech.ssel.multistage.shared.network.GameMessage;
import edu.caltech.ssel.multistage.shared.network.GameRequest;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.QueuedMailbox;
import edu.caltech.ssel.multistage.shared.network.Request;
import edu.caltech.ssel.multistage.shared.network.RequestPacket;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;

public class ServerAdmin
extends ServerVariables
implements MSConstants,
Runnable {
    private int roundsLeft;
    private ServerAuthenticator auth;
    private File outputFile;
    private File persistenceFile;
    private boolean persistInDB;
    private Mailbox guiInput;
    private Mailbox guiOutput;
    public OutputWriter outputWriter;
    public PersistWriter stateFileWriter;
    private static Category log = Category.getInstance(ServerAdmin.class);
    URL multiConfig;
    private boolean exit;
    private WaitingDialog waitDialog;
    private Vector servThreads;
    private int itest_gmultiple;
    private String itest_paramPath;
    private String itest_outputPath;

    public ServerAdmin(boolean itest) {
        try {
            integratedTest = itest;
            this.guiInput = new QueuedMailbox(15);
            this.guiOutput = new QueuedMailbox(15);
            ServerVariables.ui = new ServerGUI(this.guiOutput, this.guiInput);
            ServerVariables.rand = new Random();
            ServerVariables.experimentData = new Hashtable();
            this.waitDialog = new WaitingDialog(ui, true, "System Message", false, itest);
            Category root = Category.getRoot();
            root.addAppender((Appender)new guiAppender(ui.getLoggingMonitor()));
            String resource = "mult-server.properties";
            this.multiConfig = ClassLoader.getSystemResource(resource);
            if (this.multiConfig == null) {
                log.warn((Object)"Could not find multistage.properties file, using default configuration");
            } else {
                multistageProps = new Properties();
                multistageProps.load(this.multiConfig.openStream());
                log.info((Object)"Loaded multistage.properties file, reading configuration information");
                this.readConfigurationFile(multistageProps);
            }
            pluginService = new PluginService(".." + File.separator + "plugins");
            writingOutput = false;
            log.info((Object)"Server GUI link established");
        }
        catch (Exception e) {
            log.fatal((Object)("Failed to construct a new Server Administrator / GUI" + newline + e), (Throwable)e);
        }
    }

    public ServerAdmin() {
        this(false);
    }

    private void readConfigurationFile(Properties configProps) {
        this.loadGameDelayProperty(configProps);
        this.loadLoginProperty(configProps);
    }

    private void loadGameDelayProperty(Properties configProps) {
        ServerVariables.gameDelay = 0L;
        String gameDelayStr = configProps.getProperty("gameDelay");
        if (gameDelayStr != null && gameDelayStr.length() > 0) {
            try {
                ServerVariables.gameDelay = Long.parseLong(gameDelayStr);
                log.info((Object)("Using default game delay of " + gameDelay + " milliseconds"));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse game delay number" + newline + e));
            }
        }
    }

    private void loadVerifierProperty(Properties configProps) {
        verifier = null;
        String verifierStr = configProps.getProperty("verifier");
        if (verifierStr != null && verifierStr.length() > 0) {
            try {
                log.debug((Object)("Searching for verifier of type " + verifierStr + "..."));
                try {
                    verifier = (Verifier)Class.forName("edu.caltech.ssel.projects.multistage.server.network.gameverifiers." + verifierStr + "Verifier").newInstance();
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("No verifier of type " + verifierStr + " found"));
                }
                catch (NoClassDefFoundError e) {
                    log.warn((Object)("No verifier of type " + verifierStr + " found - check capitalization"));
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to initialize verifier of type " + verifierStr + " - Verifier will not be used" + newline + e));
                }
                if (verifier != null) {
                    log.info((Object)("Found and instantiated Verifier of type: " + verifierStr));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse verifier class type from properties file" + newline + e));
            }
        }
    }

    private void loadLoginProperty(Properties configProps) {
        String loginStr = configProps.getProperty("login", "false");
        if (loginStr.equalsIgnoreCase("true")) {
            this.requestLogin();
        } else {
            log.debug((Object)"No server login (name/email) required for this experiment");
        }
    }

    private void requestLogin() {
        try {
            QueuedMailbox box = new QueuedMailbox(3);
            LoginGUI login = new LoginGUI(integratedTest, box, ui);
            login.setVisible(true);
            expName = (String)box.receive();
            expEmail = (String)box.receive();
            log.info((Object)("Received experimenter name: " + expName + ", and email: " + expEmail));
        }
        catch (Exception e) {
            log.error((Object)("Failed to log experimenter into admin system" + newline + e));
        }
    }

    public void setIntegratedTestingMode(boolean mode) {
        integratedTest = mode;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void run() {
        try {
            if (integratedTest) {
                ui.initIntegratedTest(this.itest_paramPath, this.itest_outputPath);
            }
            this.exit = false;
            String message = "";
            while (!this.exit) {
                message = (String)this.guiInput.receive();
                this.performAction(message);
            }
        }
        catch (Exception e) {
            log.fatal((Object)("Error trying to send/receive message to/from the server UI" + e.getStackTrace()), (Throwable)e);
            e.printStackTrace();
            log.fatal((Object)("" + e.getStackTrace()));
        }
    }

    private void performAction(String message) throws Exception {
        if (message.equals("authenticate")) {
            this.init();
            this.authenticate();
        }
        if (message.equals("numPlayersChange")) {
            String intStr = (String)this.guiInput.receive();
            numPlayers = Integer.parseInt(intStr);
            log.info((Object)("Number of players changed to " + numPlayers));
            ui.setNumPlayers(numPlayers);
        }
        if (message.equals("persistence file")) {
            this.persistenceFile = (File)this.guiInput.receive();
            log.info((Object)("Server has received a new persistence file: " + this.persistenceFile.getName()));
        }
        if (message.equals("output file")) {
            this.outputFile = (File)this.guiInput.receive();
            this.writeMultistageProperty("output_home", this.outputFile.getAbsolutePath());
            this.outputWriter = new OutputWriter(this.outputFile);
            log.info((Object)("Server has received a new output file: " + this.outputFile.getName()));
        }
        if (message.equals("write_output")) {
            this.writeFinalOutput();
            this.killClients();
            this.disconnectServer();
        }
        if (message.equals("force_output")) {
            this.writeForcedOutput();
        }
        if (message.equals("abort_round")) {
            this.abortRound(true);
        }
        if (message.equals("abort_match")) {
            this.endAllGames();
        }
        if (message.equals("parameters")) {
            this.loadParameters();
        }
        if (message.equals("start")) {
            this.startGame();
        }
        if (message.equals("nextgame")) {
            this.nextGame();
        }
        if (message.equals("nextmatch")) {
            this.nextMatch();
        }
        if (message.equals("initmatch")) {
            this.initMatch();
        }
        if (message.equals("disconnect")) {
            this.killClients();
            this.disconnectServer();
        }
        if (message.equals("reset pre_auth")) {
            this.resetPreAuth();
        }
        if (message.equals("reset post_auth")) {
            this.resetPostAuth();
        }
        if (message.equals("reauthenticate")) {
            this.reauthenticate();
        }
        if (message.equals("send messages")) {
            this.sendMessages();
        }
        if (message.equals("move update")) {
            this.sendUpdatesReadyAlert();
        }
    }

    public void init() {
        log.info((Object)("Server is initializing for " + numPlayers + " players..."));
        this.auth = new MailServerAuthenticator(numPlayers);
        this.loadVerifierProperty(multistageProps);
        log.info((Object)"Server initialization complete");
    }

    private void authenticate() throws Exception {
        log.info((Object)"Server authentication started");
        if (this.auth.getClients()) {
            this.waitDialog.setActive("Please Wait", "Establishing Network Connections");
            clients = this.auth.getClientData();
            numPlayers = clients.size();
            ui.setNumPlayers(numPlayers);
            ui.formClientData(false);
            log.info((Object)"Server authentication complete");
            this.initCommunication();
        } else {
            this.auth.close();
            ServerVariables.serverConnected = false;
            ui.cancelAuthentication();
            log.info((Object)"Server authentication canceled or interrupted");
        }
    }

    private void initCommunication() {
        if (numPlayers == 0) {
            log.info((Object)"No players authenticated - disconnecting");
            ui.cancelAuthentication();
            this.auth.close();
            return;
        }
        com = this.auth.getCommunicator();
        ServerVariables.serverConnected = true;
        this.initializePinger();
        log.info((Object)"Server communications successfully established");
        this.waitDialog.setInactive();
    }

    private void loadParameters() {
        try {
            paramsFile = (File)this.guiInput.receive();
            params = (Parameters)this.guiInput.receive();
            multistageProps.setProperty("type", (String)((Hashtable)params.getParamValues().get(new Integer(0))).get("type"));
            this.writeMultistageProperty("parameters_home", paramsFile.getAbsolutePath());
            matches = params.getMatches();
            currentMatch = 0;
            groupLCM = this.getGroupLCM();
            log.info((Object)"Server has received new game parameters");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load parameters and reset matches vector", (Throwable)e);
        }
    }

    private void initializePinger() {
        PeriodicPinger pinger = new PeriodicPinger(3000);
        Thread pingerControl = new Thread(pinger);
        pingerControl.start();
    }

    private void transferMatchData() {
        Match m = (Match)matches.get(currentMatch);
        float exchangeRate = m.getExchangeRate();
        boolean practiceMatch = m.isPracticeMatch();
        for (int i = 0; i < clients.size(); ++i) {
            ClientData client = (ClientData)clients.get(i);
            client.createNewMatch(currentMatch);
            client.setCurrentMatch(currentMatch);
            client.addExchangeRate(exchangeRate);
            client.addPracticeMatch(practiceMatch);
        }
    }

    private void sendInitializations() {
        try {
            ArrayList<ClientData> completed = new ArrayList<ClientData>();
            for (int i = 0; i < clients.size(); ++i) {
                ClientData client = (ClientData)clients.get(i);
                if (completed.contains(client)) continue;
                int[] partners = client.getPartners();
                Match cmatch = (Match)matches.get(currentMatch);
                String gameType = cmatch.getGameType();
                PluginDescriptor pd = params.getPluginDescriptor();
                if (pd == null) {
                    log.error((Object)("ServerAdmin cannot find plugin of type " + gameType));
                }
                cmatch.setServerClassname(pd.getServerClassname());
                cmatch.setClientClassname(pd.getGuiClassname());
                cmatch.setManualMatcherClassname(pd.getMatchingClassname());
                cmatch.setParameterVerifierClassname(pd.getParameterVerifierClassname());
                matches.set(currentMatch, cmatch);
                Request req = this.buildInitGameRequest(cmatch, client);
                this.sendRequest(client.getId(), req);
                completed.add(client);
                for (int j = 0; j < partners.length; ++j) {
                    if (j == client.getPartnerNum()) continue;
                    ClientData partner = (ClientData)clients.get(partners[j]);
                    Request preq = this.buildInitGameRequest(cmatch, partner);
                    this.sendRequest(partner.getId(), preq);
                    completed.add(partner);
                }
            }
            log.info((Object)"All client initializations have been sent");
        }
        catch (Exception e) {
            log.error((Object)("Failed to send game initialization requests to clients" + newline + e));
        }
    }

    private Request buildInitGameRequest(Match match, ClientData client) {
        try {
            GameRequest req = new GameRequest(0);
            Information sysInfo = new Information();
            sysInfo.addIntInfo("id", client.getId());
            sysInfo.addStringInfo("gameType", match.getGameType());
            sysInfo.addIntInfo("partnerNum", client.getPartnerNum());
            sysInfo.addIntInfo("groupSize", match.getGroupSize());
            sysInfo.addBooleanInfo("preserve", match.getPreserve());
            sysInfo.addStringInfo("defaultView", match.getDefaultView());
            sysInfo.addInfo("chatOptions", match.getChatOptions());
            sysInfo.addBooleanInfo("optionChat", match.getOptionChat());
            sysInfo.addBooleanInfo("enableChat", match.getEnableChat());
            sysInfo.addStringInfo("chatIdentifier", match.getChatIdentifier());
            sysInfo.addBooleanInfo("displayFinishedInfo", match.getDisplayFinishedInfo());
            sysInfo.addIntInfo("historyNumber", match.getHistoryNumber());
            sysInfo.addBooleanInfo("showTotalPayoff", match.getShowTotalPayoff());
            sysInfo.addBooleanInfo("viewSwitchable", match.getViewSwitchable());
            System.out.println("trying to add serverClassname (==" + match.getServerClassname() + ") and clientClassname (==" + match.getClientClassname() + ") to sysInfo...");
            log.info((Object)("trying to add serverClassname (==" + match.getServerClassname() + ") and clientClassname (==" + match.getClientClassname() + ") to sysInfo..."));
            sysInfo.addStringInfo("serverClassname", match.getServerClassname());
            sysInfo.addStringInfo("clientClassname", match.getClientClassname());
            String packageName = match.getPackageName();
            if (packageName != null) {
                sysInfo.addStringInfo("packageName", packageName);
            }
            req.setSystemInfo(sysInfo);
            return req;
        }
        catch (Exception e) {
            log.error((Object)("Failed to build an init game request for match " + currentMatch + " and client " + client.getId() + newline + e));
            return null;
        }
    }

    private void runGames() {
        try {
            ArrayList<ClientData> completed = new ArrayList<ClientData>();
            Match match = (Match)matches.get(currentMatch);
            String gameType = match.getGameType();
            String packageName = match.getPackageName();
            serverControllers = new Vector();
            serverMap = new Hashtable();
            sharedData = new Hashtable();
            this.servThreads = new Vector();
            for (int i = 0; i < clients.size(); ++i) {
                ClientData client = (ClientData)clients.get(i);
                if (completed.contains(client)) continue;
                log.debug((Object)("Searching for controller of type " + gameType + "..."));
                if (packageName == null) {
                    packageName = "edu.caltech.ssel.projects.multistage.server.control.gamecontrollers";
                }
                ServerControl servCon = (ServerControl)Class.forName(match.getServerClassname()).newInstance();
                int[] partners = client.getPartners();
                int groupId = client.getGroupId();
                completed.add(client);
                serverMap.put(new Integer(client.getId()), servCon);
                for (int j = 0; j < partners.length; ++j) {
                    if (j == client.getPartnerNum()) continue;
                    ClientData partner = (ClientData)clients.get(partners[j]);
                    serverMap.put(new Integer(partner.getId()), servCon);
                    completed.add(partner);
                }
                servCon.initControl(partners);
                servCon.setControlNumber(groupId);
                servCon.initialize();
                serverControllers.add(servCon);
                Thread servThread = new Thread(servCon);
                servThread.start();
                this.servThreads.add(servThread);
                log.debug((Object)("Started controller of type " + gameType));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to find class to match parameter file", (Throwable)e);
        }
    }

    private void startGame() {
        try {
            if (this.persistenceFile == null) {
                String fileName = this.outputFile.getAbsolutePath();
                this.persistenceFile = new File(fileName + ".tmp");
            }
            this.stateFileWriter = new PersistWriter(this.persistenceFile);
            int maxrounds = ((Match)matches.get(currentMatch)).getNumRounds();
            this.roundsLeft = maxrounds > 0 ? maxrounds : -1;
            this.transferMatchData();
            this.partnerPlayers();
        }
        catch (Exception e) {
            log.error((Object)("Error attempting to start game" + newline + e));
        }
    }

    private void initMatch() {
        try {
            Match match;
            this.sendInitializations();
            this.runGames();
            lastMatch = currentMatch >= params.getNumMatches() - 1;
            if (this.roundsLeft == 1) {
                this.endAllGames();
                log.info((Object)"This is the final round: regardless of next choices, match will end");
            }
            if ((match = (Match)matches.get(currentMatch)).getRoundAdvancement() == 0) {
                ui.setMatchRoundLabel(currentMatch, 0);
            } else {
                ui.setMatchIndependentLabel(currentMatch);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to complete the startup process" + newline + e));
        }
    }

    private void partnerPlayers() {
        Runnable matchingProcess = new Runnable(){

            public void run() {
                try {
                    MatchMaker matcher = new MatchMaker();
                    ServerVariables.groupSize = ((Match)ServerVariables.matches.get(ServerVariables.currentMatch)).getGroupSize();
                    matcher.assignGroups();
                    ServerVariables.ui.eraseClientData();
                    ServerVariables.ui.formClientData(true);
                    ServerAdmin.this.guiInput.deposit("initmatch");
                }
                catch (Exception e) {
                    log.error((Object)("Failed to run partner matching thread" + MSConstants.newline + e));
                }
            }
        };
        Thread matchingThread = new Thread(matchingProcess);
        matchingThread.start();
        log.debug((Object)"Initialized matching thread to partner players");
    }

    private void disconnectServer() {
        try {
            if (serverMap != null) {
                serverMap = null;
            }
            this.auth.close();
            serverConnected = false;
            currentMatch = 0;
            lastMatch = false;
            manualMatcher = null;
            matchings = null;
            experimentData = new Hashtable();
            log.info((Object)"Server has been disconnected from all clients");
            if (integratedTest) {
                ui.setVisible(false);
                ui.dispose();
                this.exit = true;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to disconnect server successfully", (Throwable)e);
        }
    }

    private void writeForcedOutput() {
        if (this.outputWriter != null && this.outputFile != null) {
            this.outputWriter.writeState();
            this.outputWriter.writeStateToXML();
        }
    }

    private void writeFinalOutput() {
        if (this.stateFileWriter != null) {
            int maxrounds = ((Match)matches.get(currentMatch)).getNumRounds();
            int currentRound = maxrounds - this.roundsLeft;
            this.stateFileWriter.writeState(currentMatch, currentRound);
        }
        if (this.outputWriter != null && this.outputFile != null) {
            this.outputWriter.writeState();
            this.outputWriter.writeStateToXML();
            this.outputWriter = null;
            this.outputFile = null;
        }
    }

    private void reauthenticate() {
        try {
            int clientNum = (Integer)this.guiInput.receive();
            ClientData client = (ClientData)clients.get(clientNum);
            boolean reauthenticated = this.auth.reauthenticate(clientNum);
            if (reauthenticated) {
                if (serverMap != null) {
                    ServerControl servCon = (ServerControl)serverMap.get(new Integer(clientNum));
                    servCon.reauthenticate(clientNum);
                } else if (manualMatcher != null) {
                    manualMatcher.reauthenticate(clientNum);
                }
                ui.setConnected(clientNum);
                com.sendMessage(clientNum, new GameMessage("Reauthentication Complete", 2, -2));
            } else {
                ui.setDisconnected(clientNum);
            }
            ui.enableReauthenticateButtons();
        }
        catch (Exception e) {
            log.error((Object)("Failed to send reauthentication request to the server authenticator" + newline + e));
            ui.enableReauthenticateButtons();
        }
    }

    private void nextGame() {
        try {
            int maxrounds = ((Match)matches.get(currentMatch)).getNumRounds();
            int currentRound = maxrounds - this.roundsLeft;
            this.stateFileWriter.writeState(currentMatch, currentRound);
            if (this.roundsLeft > 1) {
                --this.roundsLeft;
                log.info((Object)("There are now " + this.roundsLeft + " rounds left"));
            }
            if (this.roundsLeft == 1) {
                this.endAllGames();
                log.info((Object)"This is the final round for all groups: regardless of next choices, match will end");
            }
            for (int i = 0; i < serverControllers.size(); ++i) {
                ServerControl servCon = (ServerControl)serverControllers.get(i);
                servCon.nextGame();
            }
            ui.setMatchRoundLabel(currentMatch, currentRound + 1);
        }
        catch (Exception e) {
            log.error((Object)("Failed to notify Server Control threads to reactivate upon receiving a next game request" + newline + e));
        }
    }

    private void nextMatch() {
        int maxrounds = ((Match)matches.get(currentMatch)).getNumRounds();
        int currentRound = maxrounds - this.roundsLeft;
        this.stateFileWriter.writeState(currentMatch, currentRound);
        maxrounds = ((Match)matches.get(++currentMatch)).getNumRounds();
        this.roundsLeft = maxrounds > 0 ? maxrounds : -1;
        this.transferMatchData();
        this.partnerPlayers();
    }

    private void sendMessages() {
        try {
            Vector client_ids = (Vector)this.guiInput.receive();
            String message_str = (String)this.guiInput.receive();
            GameMessage cmessage = new GameMessage(message_str, 2, -2);
            for (int i = 0; i < client_ids.size(); ++i) {
                int client_id = (Integer)client_ids.get(i);
                com.sendMessage(client_id, cmessage);
            }
            log.info((Object)("Message '" + message_str + "' has been processed and sent by server to all recipients"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a text message from server to clients in the ServerAdmin" + newline + e));
        }
    }

    private void sendUpdatesReadyAlert() {
        for (int i = 0; i < serverControllers.size(); ++i) {
            ServerControl servCon = (ServerControl)serverControllers.get(i);
            servCon.sendAllGameUpdates();
        }
    }

    private void abortRound(boolean displayMessage) {
        log.info((Object)"Server is initiating an immediate round abortion");
        for (int i = 0; i < serverControllers.size(); ++i) {
            ServerControl servCon = (ServerControl)serverControllers.get(i);
            if (!servCon.isActive()) continue;
            servCon.abortRound(displayMessage);
        }
    }

    private void abortMatch() {
        log.info((Object)"Server is activating a rapid match abortion");
        for (int i = 0; i < serverControllers.size(); ++i) {
            ServerControl servCon = (ServerControl)serverControllers.get(i);
            if (!servCon.isActive()) continue;
            servCon.abortMatch();
        }
    }

    private void endAllGames() {
        for (int i = 0; i < serverControllers.size(); ++i) {
            ServerControl servCon = (ServerControl)serverControllers.get(i);
            if (!servCon.isActive()) continue;
            servCon.endMatch();
        }
        log.info((Object)"Maximum rounds reached or manual termination received: ending all games");
    }

    public void sendRequest(int client, Request req) {
        com.sendRequest(client, req);
        log.debug((Object)("Server has sent a request to client id: " + client));
    }

    public void sendAll(Request req) {
        log.info((Object)"Sending request to all clients");
        for (int i = 0; i < numPlayers; ++i) {
            this.sendRequest(i, req);
        }
    }

    public RequestPacket getResponse(int client) {
        RequestPacket res = com.getResponse(client);
        log.debug((Object)"Server has received a client response");
        return res;
    }

    public void writeMultistageProperty(String prop, String value) {
        try {
            multistageProps.setProperty(prop, value);
            multistageProps.store(new FileOutputStream(this.multiConfig.getFile()), "Multistage Properties File");
        }
        catch (Exception e) {
            log.error((Object)("Failed to write property " + prop + " with value " + value + " to the multistage.properties file" + newline + e));
        }
    }

    public void resetPreAuth() {
        try {
            log.debug((Object)"Server is initiating a pre-auth reset");
            this.abortMatch();
            for (int i = 0; i < this.servThreads.size(); ++i) {
                Thread thr = (Thread)this.servThreads.get(i);
                if (thr == null) continue;
                thr.join();
            }
            log.debug((Object)"ServerControl threads have been aborted, continuing reset (sending reset messages)...");
            ui.disconnectUpdate();
            GameMessage mes = new GameMessage(null, 31, -1);
            for (int i = 0; i < numPlayers; ++i) {
                com.sendMessage(i, mes);
            }
            this.disconnectServer();
        }
        catch (Exception e) {
            log.error((Object)"Failed to reset clients to pre-authentication state", (Throwable)e);
        }
    }

    public void resetPostAuth() {
        try {
            GameMessage mes = new GameMessage(null, 32, -1);
            for (int i = 0; i < numPlayers; ++i) {
                com.sendMessage(i, mes);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a KILL_CLIENT_MESSAGE to clients" + newline + e));
        }
    }

    public void killClients() {
        try {
            log.debug((Object)"Server is aborting current match in preparation to kill clients");
            this.abortMatch();
            log.debug((Object)"Server is sending a kill clients message to all clients");
            GameMessage mes = new GameMessage(null, 30, -1);
            for (int i = 0; i < numPlayers; ++i) {
                com.sendMessage(i, mes);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to send a KILL_CLIENT_MESSAGE to clients", (Throwable)e);
        }
    }

    public void setNumberOfPlayers(int numPlayers) {
        ServerAdmin.numPlayers = numPlayers;
    }

    public int getNumberOfPlayers() {
        return numPlayers;
    }

    private int getGroupLCM() {
        int lcm;
        int[] groupSizes = new int[ServerVariables.matches.size()];
        for (int i = 0; i < ServerVariables.matches.size(); ++i) {
            groupSizes[i] = ((Match)ServerVariables.matches.get(i)).getGroupSize();
        }
        if (groupSizes.length == 0) {
            boolean bl = false;
        }
        if (groupSizes.length == 1) {
            lcm = groupSizes[0];
        } else {
            int m = groupSizes[0];
            for (int i = 0; i < groupSizes.length - 1; ++i) {
                int n = groupSizes[i + 1];
                m = this.lcm(m, n);
            }
            lcm = m;
        }
        log.info((Object)("Found the lowest common multiple of the group sizes: " + lcm));
        return lcm;
    }

    private int lcm(int m, int n) {
        return m / this.gcd(m, n) * n;
    }

    private int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return this.gcd(n, m % n);
    }
}

