/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.network.GameResponse;
import edu.caltech.ssel.multistage.shared.network.Request;
import edu.caltech.ssel.multistage.shared.network.RequestPacket;
import org.apache.log4j.Category;

public class ResponseControl
extends ServerVariables
implements Runnable {
    private Request lastRequest;
    private int playerNum;
    private RequestPacket res;
    private boolean abortRound;
    private boolean displayMessage;
    private boolean receivedMove;
    public static Category log = Category.getInstance(ResponseControl.class);

    public ResponseControl(int playerNum, Request lastRequest) {
        this.playerNum = playerNum;
        this.lastRequest = lastRequest;
        this.abortRound = false;
        this.receivedMove = false;
    }

    public void run() {
        try {
            ui.updateClientStatus(this.playerNum, "Waiting for Response");
            this.res = com.getResponse(this.playerNum);
            if (this.res.getType() != 2) {
                this.receivedMove = true;
            }
            this.lastRequest.invalidate();
            ui.updateClientStatus(this.playerNum, "Received Response");
        }
        catch (Exception e) {
            log.error((Object)("Failed to get a response from the communicator for player " + this.playerNum + " in ResponseControl"), (Throwable)e);
        }
    }

    public RequestPacket getResponse() throws AbortRoundException {
        if (this.abortRound) {
            AbortRoundException e = new AbortRoundException(AbortRoundException.MANUAL_ABORTION);
            e.setDisplayMessage(this.displayMessage);
            throw e;
        }
        return this.res;
    }

    public boolean abortRound(boolean displayMessage) {
        try {
            if (!this.receivedMove) {
                this.displayMessage = displayMessage;
                this.abortRound = true;
                com.sendInternalResponse(this.playerNum, new GameResponse(2));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get ResponseControl of player " + this.playerNum + " set up for round abortion"), (Throwable)e);
            return false;
        }
    }

    public boolean receivedMove() {
        return this.receivedMove;
    }
}

