/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.control.StateWriter;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Category;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;

public class PersistWriter
extends StateWriter {
    private static Category log = Category.getInstance(PersistWriter.class);
    private String fileName;

    public PersistWriter(File targetFile) {
        this.targetFile = targetFile;
        this.fileName = targetFile.getAbsolutePath();
    }

    public void setFile(File targetFile) {
        this.targetFile = targetFile;
        this.fileName = targetFile.getAbsolutePath();
    }

    public File getFile() {
        return this.targetFile;
    }

    private void initializeState() {
        try {
            Vector matches = ServerVariables.matches;
            Vector clients = ServerVariables.clients;
            this.fwriter = new FileWriter(this.targetFile);
            this.fwriter.write("# Multistage State File" + MSConstants.newline);
            if (ServerVariables.expName != null) {
                this.fwriter.write("# Experimenter Name: " + ServerVariables.expName + MSConstants.newline);
            }
            if (ServerVariables.expEmail != null) {
                this.fwriter.write("# Experimenter Email: " + ServerVariables.expEmail + MSConstants.newline);
            }
            this.fwriter.write("# Experiment time: " + new Date().toString() + "" + MSConstants.newline);
            this.fwriter.write("exptime=" + new Date().toString() + "" + MSConstants.newline + MSConstants.newline);
            this.fwriter.close();
            log.debug((Object)("Initialized a new persistence file: " + this.targetFile.getName()));
        }
        catch (Exception e) {
            log.error((Object)("Failed to write mid-game output" + MSConstants.newline + e));
        }
    }

    private void initializeStateToXML() {
        if (this.experiment == null) {
            Vector matches = ServerVariables.matches;
            Vector clients = ServerVariables.clients;
            this.experiment = new Element("experiment");
            this.experiment.addContent((Content)new Comment("Multistage State File"));
            this.experiment.setAttribute("exptime", new Date().toString());
            this.experiment.setAttribute("numOfMatches", Integer.toString(matches.size()));
            this.experiment.setAttribute("numOfSubjects", Integer.toString(clients.size()));
            log.debug((Object)("Initialized the root element for experiment: " + this.experiment.getAttributeValue("exptime")));
        }
    }

    public void writeState(int match, int round) {
        try {
            ServerVariables.writingOutput = true;
            if (this.fwriter == null) {
                this.initializeState();
            }
            this.fwriter = new FileWriter(this.fileName, true);
            if (round == 0) {
                this.writeMatchData(match);
            }
            this.writeRoundData(match, round);
            this.fwriter.close();
            this.writePayoffFile();
            ServerVariables.writingOutput = false;
            log.info((Object)("Appended match " + match + " round " + round + " to the persistence file: " + this.fileName));
        }
        catch (Exception e) {
            log.error((Object)("Failed to update output file state for match " + match + " and round " + round + MSConstants.newline + e));
            ServerVariables.writingOutput = false;
        }
    }

    public void writeStateToXML(int match, int round) {
        Element roundElmt;
        ServerVariables.writingOutput = true;
        this.initializeState();
        Element matchElmt = this.findMatchElement(match);
        if (round == 0) {
            if (matchElmt != null) {
                this.experiment.removeContent((Content)matchElmt);
            }
            matchElmt = this.writeMatchDataToXML(match);
        }
        if ((roundElmt = this.findRoundElement(matchElmt, round)) != null) {
            matchElmt.removeContent((Content)roundElmt);
        }
        this.writeRoundDataToXML(matchElmt, round);
        this.experiment.addContent((Content)matchElmt);
        try {
            this.persistXML();
        }
        catch (IOException e) {
            log.error((Object)("Failed to update output data XML element for match " + match + " and round " + round + MSConstants.newline + e));
            ServerVariables.writingOutput = false;
        }
        this.writePayoffFile();
        ServerVariables.writingOutput = false;
        log.info((Object)("Appended match " + match + " round " + round + " to the experiment root element."));
    }

    protected boolean wasAborted(int matchNum) {
        return false;
    }
}

