/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.data.Match;
import org.apache.log4j.Category;

public class PeriodicPinger
extends ServerVariables
implements Runnable {
    private boolean[] connections;
    private int period;
    private static Category log = Category.getInstance(PeriodicPinger.class);

    public PeriodicPinger(int period) {
        this.period = period;
        this.connections = new boolean[numPlayers];
        for (int i = 0; i < this.connections.length; ++i) {
            this.connections[i] = true;
        }
    }

    public synchronized void run() {
        try {
            while (ServerVariables.serverConnected) {
                for (int i = 0; i < numPlayers; ++i) {
                    ServerControl scon;
                    if (ServerVariables.writingOutput) continue;
                    boolean connected = com.checkConnection(i);
                    if (connected && !this.connections[i]) {
                        this.connections[i] = true;
                        ui.setConnected(i);
                    }
                    if (connected || !this.connections[i]) continue;
                    this.connections[i] = false;
                    ui.setDisconnected(i);
                    Match match = (Match)ServerVariables.matches.get(ServerVariables.currentMatch);
                    if (match.getAsyncReauthMode() != 0 || serverMap == null || (scon = (ServerControl)serverMap.get(new Integer(i))) == null) continue;
                    scon.abortAsynchronousRound();
                }
                this.wait(this.period);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to check the connection of a client in the PeriodicPinger", (Throwable)e);
        }
    }
}

