/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.control.StateWriter;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Category;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;

public class OutputWriter
extends StateWriter {
    private static Category log = Category.getInstance(OutputWriter.class);

    public OutputWriter(File targetFile) {
        this.targetFile = targetFile;
    }

    public void setFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public File getFile() {
        return this.targetFile;
    }

    public void writeState() {
        try {
            ServerVariables.writingOutput = true;
            this.fwriter = new FileWriter(this.targetFile);
            Vector matches = ServerVariables.matches;
            this.fwriter.write("# Multistage Output File" + MSConstants.newline);
            if (ServerVariables.expName != null) {
                this.fwriter.write("# Experimenter Name: " + ServerVariables.expName + MSConstants.newline);
            }
            if (ServerVariables.expEmail != null) {
                this.fwriter.write("# Experimenter Email: " + ServerVariables.expEmail + MSConstants.newline);
            }
            this.fwriter.write("# Experiment time: " + new Date().toString() + "" + MSConstants.newline);
            this.fwriter.write("exptime=" + new Date().toString() + "" + MSConstants.newline);
            this.fwriter.write(MSConstants.newline);
            this.writePayoffFile();
            for (int i = 0; i < matches.size(); ++i) {
                int numRounds = this.getNumRounds(i);
                for (int j = 0; j < numRounds; ++j) {
                    if (j == 0) {
                        this.writeMatchData(i);
                    }
                    this.writeRoundData(i, j);
                }
            }
            this.writeClientPayoffs();
            this.writeMatchParams();
            this.fwriter.close();
            ServerVariables.writingOutput = false;
            log.info((Object)"Final output file written and closed");
        }
        catch (Exception e) {
            log.error((Object)("Failed to write full output file" + MSConstants.newline + e));
            ServerVariables.writingOutput = false;
        }
    }

    public void writeStateToXML() {
        try {
            ServerVariables.writingOutput = true;
            Vector matches = ServerVariables.matches;
            this.experiment = new Element("experiment");
            this.experiment.addContent((Content)new Comment("Multistage State File"));
            if (ServerVariables.expName != null) {
                this.experiment.setAttribute("experimenterName", ServerVariables.expName);
            }
            if (ServerVariables.expEmail != null) {
                this.experiment.setAttribute("experimenterEmail", ServerVariables.expEmail);
            }
            this.experiment.setAttribute("exptime", new Date().toString());
            this.experiment.setAttribute("numOfMatches", Integer.toString(matches.size()));
            this.experiment.setAttribute("numOfSubjects", Integer.toString(ServerVariables.clients.size()));
            log.debug((Object)("Initialized the root element for experiment: " + this.experiment.getAttributeValue("exptime")));
            for (int i = 0; i < matches.size(); ++i) {
                int numRounds = this.getNumRounds(i);
                Element match = null;
                for (int j = 0; j < numRounds; ++j) {
                    if (j == 0) {
                        match = this.writeMatchDataToXML(i);
                    }
                    this.writeRoundDataToXML(match, j);
                }
                this.experiment.addContent(match);
            }
            this.experiment.addContent((Content)this.writeClientPayoffsToXML());
            this.writeMatchParamsToXML();
            this.persistXML();
            this.persistHTML();
            this.persistCSV();
            ServerVariables.writingOutput = false;
            log.info((Object)"Final output data written in XML and closed");
        }
        catch (Exception e) {
            log.error((Object)("Failed to write full output data to XML/HTML/CSV" + MSConstants.newline + e));
            ServerVariables.writingOutput = false;
        }
    }

    private void writeProperty(String prop) {
        try {
            String val = this.stateProps.getProperty(prop);
            this.fwriter.write(prop + "=" + val + MSConstants.newline);
        }
        catch (Exception e) {
            log.error((Object)("Error writing property string " + prop + MSConstants.newline + e));
        }
    }

    private void writePayoffSummary() {
        try {
            this.fwriter.write("#  Payoff Summary (Exchanged and Rounded)" + MSConstants.newline + MSConstants.newline);
            for (int i = 0; i < ServerVariables.clients.size(); ++i) {
                ClientData client = (ClientData)ServerVariables.clients.get(i);
                String name = client.getName();
                double payoff = client.getTotalPayoffExchangedAndRounded();
                StringBuffer str = new StringBuffer();
                str.append("#  ");
                str.append(name);
                for (int j = 0; j < 40 - name.length(); ++j) {
                    str.append(" ");
                }
                str.append(payoff);
                this.fwriter.write(str + MSConstants.newline);
            }
            this.fwriter.write("" + MSConstants.newline + MSConstants.newline);
            log.debug((Object)"Wrote payoff summary to output file");
        }
        catch (Exception e) {
            log.error((Object)("Failed to write the payoff summary" + MSConstants.newline + e));
        }
    }

    private void writePayoffSummaryToXML() {
        try {
            this.fwriter.write("#  Payoff Summary (Exchanged and Rounded)" + MSConstants.newline + MSConstants.newline);
            for (int i = 0; i < ServerVariables.clients.size(); ++i) {
                ClientData client = (ClientData)ServerVariables.clients.get(i);
                String name = client.getName();
                double payoff = client.getTotalPayoffExchangedAndRounded();
                StringBuffer str = new StringBuffer();
                str.append("#  ");
                str.append(name);
                for (int j = 0; j < 40 - name.length(); ++j) {
                    str.append(" ");
                }
                str.append(payoff);
                this.fwriter.write(str + MSConstants.newline);
            }
            this.fwriter.write("" + MSConstants.newline + MSConstants.newline);
            log.debug((Object)"Wrote payoff summary to output file");
        }
        catch (Exception e) {
            log.error((Object)("Failed to write the payoff summary" + MSConstants.newline + e));
        }
    }

    private void writeMatchParams() throws IOException {
        String line;
        this.fwriter.write("# Parameters File" + MSConstants.newline + MSConstants.newline);
        BufferedReader input = new BufferedReader(new FileReader(ServerVariables.paramsFile));
        while ((line = input.readLine()) != null) {
            this.fwriter.write(line + MSConstants.newline);
        }
    }

    private void writeMatchParamsToXML() throws IOException {
        Element matchParams = this.experiment.getChild("matchParams");
        if (matchParams != null) {
            this.experiment.removeContent((Content)matchParams);
        }
        matchParams = new Element("matchParams");
        matchParams.addContent((Content)new Comment("Experiment Parameters, copying from the match parameter file."));
        BufferedReader input = new BufferedReader(new FileReader(ServerVariables.paramsFile));
        StringBuffer content = new StringBuffer();
        String line = null;
        while ((line = input.readLine()) != null) {
            content.append(line + MSConstants.newline);
        }
        matchParams.addContent(content.toString());
        this.experiment.addContent((Content)matchParams);
    }
}

