/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import org.apache.log4j.Category;

public class MessageReceiver
extends ServerVariables
implements Runnable {
    private MessageProcessor mproc;
    private int partnerNum;
    private int playerNum;
    private boolean die;
    private static Category log = Category.getInstance(MessageReceiver.class);

    public MessageReceiver(MessageProcessor mproc, int partnerNum, int playerNum) {
        this.mproc = mproc;
        this.partnerNum = partnerNum;
        this.playerNum = playerNum;
    }

    public void run() {
        try {
            while (!this.die) {
                MessagePacket mes = com.getMessage(this.playerNum);
                if (this.die) {
                    com.sendInternalMessage(this.playerNum, mes);
                    break;
                }
                int type = mes.getType();
                if (type == 22 || type == 19) {
                    this.mproc.addMessage(mes);
                    continue;
                }
                com.sendInternalMessage(this.playerNum, mes);
            }
        }
        catch (Exception e) {
            log.error((Object)("The Server-side message receiver for client " + this.playerNum + " has malfunctioned"), (Throwable)e);
        }
    }

    public void kill() {
        try {
            this.die = true;
        }
        catch (Exception e) {
            log.error((Object)"Failed to kill the client-side message receiver for the next match", (Throwable)e);
        }
    }
}

