/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageReceiver;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.util.Vector;
import org.apache.log4j.Category;

public class MessageProcessor
extends ServerVariables {
    private int[] players;
    private Vector messageReceivers;
    private Vector queue;
    private boolean abortRound;
    private static Category log = Category.getInstance(MessageProcessor.class);

    public MessageProcessor(int[] players) {
        this.players = players;
        this.messageReceivers = new Vector();
        this.queue = new Vector();
        this.abortRound = false;
        for (int i = 0; i < players.length; ++i) {
            MessageReceiver rec = new MessageReceiver(this, i, players[i]);
            this.messageReceivers.add(rec);
        }
    }

    public void flushBoxes() {
        for (int i = 0; i < this.players.length; ++i) {
            com.flushIncomingMessages(this.players[i]);
        }
    }

    public void activateReceivers() {
        for (int i = 0; i < this.messageReceivers.size(); ++i) {
            MessageReceiver rec = (MessageReceiver)this.messageReceivers.get(i);
            Thread mth = new Thread(rec);
            mth.start();
        }
    }

    public synchronized void addMessage(MessagePacket mes) {
        this.queue.add(mes);
        this.notifyAll();
    }

    public MessagePacket receiveIfPossible() {
        if (this.queue.size() < 1) {
            return null;
        }
        MessagePacket mes = (MessagePacket)this.queue.remove(0);
        return mes;
    }

    public synchronized MessagePacket receive() throws AbortRoundException {
        try {
            MessagePacket mes;
            while (true) {
                if (this.abortRound) {
                    throw new AbortRoundException();
                }
                mes = this.receiveIfPossible();
                if (mes != null) break;
                this.wait();
            }
            return mes;
        }
        catch (InterruptedException e) {
            log.error((Object)("Failed to receive a message from the MessageProcessor" + MSConstants.newline + e));
            return null;
        }
    }

    public void close() {
        for (int i = 0; i < this.messageReceivers.size(); ++i) {
            MessageReceiver rec = (MessageReceiver)this.messageReceivers.get(i);
            rec.kill();
        }
    }

    public synchronized void abortRound() {
        this.abortRound = true;
        this.notifyAll();
    }
}

