/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ManualMatcher;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.control.gamematchers.ParameterMatcher;
import edu.caltech.ssel.multistage.server.data.Match;
import edu.caltech.ssel.multistage.server.util.matchingservice.Grouping;
import edu.caltech.ssel.multistage.server.util.matchingservice.GroupingList;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchClass;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchGroup;
import edu.caltech.ssel.multistage.server.util.matchingservice.MatchingService;
import edu.caltech.ssel.multistage.server.util.pluginservice.PluginDescriptor;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Category;

public class MatchMaker
extends ServerVariables {
    private int matchingType;
    private static Category log = Category.getInstance(MatchMaker.class);

    public void assignGroups() {
        Match match = (Match)matches.get(currentMatch);
        this.matchingType = match.getMatchingType();
        if (this.matchingType == 2) {
            activeMatchingType = 2;
            matchings = new MatchingService(clients.size(), groupSize, 2, true);
        }
        if (this.matchingType == 1) {
            activeMatchingType = 1;
            matchings = new MatchingService(clients.size(), groupSize, 1);
        }
        if (this.matchingType == 3) {
            activeMatchingType = 3;
            matchings = new MatchingService(clients.size(), 1, 3);
        }
        if (this.matchingType == 98) {
            activeMatchingType = 98;
            matchings = new MatchingService(match.getMatchFile());
        }
        if (this.matchingType == 96) {
            activeMatchingType = 96;
            matchings = new MatchingService(clients.size(), groupSize, 2, false);
        }
        if (this.matchingType == 100) {
            activeMatchingType = 100;
            matchings = null;
        }
        if (this.matchingType == 101) {
            activeMatchingType = 101;
            matchings = null;
        }
        if (this.matchingType == 97) {
            activeMatchingType = 97;
            matchings = null;
        }
        this.assignMatchGroups();
    }

    public void assignMatchGroups() {
        try {
            if (matchings == null) {
                if (activeMatchingType == 100) {
                    this.assignFixedGroups();
                }
                if (activeMatchingType == 101) {
                    this.assignManualGroups();
                }
                if (activeMatchingType == 97) {
                    this.assignParameterGroups();
                }
                return;
            }
            if (matchings.getMatchingAlgorithm() == 2) {
                if (matchings.getRandomTyping()) {
                    this.assignRandomGroups();
                } else {
                    this.assignRolePreservedRandomGroups();
                }
                return;
            }
            if (matchings.getMatchingAlgorithm() == 3) {
                matchings.setGroupSize(groupSize);
                this.assignRoundRobinGroups();
                return;
            }
            int numGroups = clients.size() / groupSize;
            int[][] groups = new int[numGroups][groupSize];
            GroupingList list = matchings.getGroupingListAt(currentMatch);
            for (int i = 0; i < list.size(); ++i) {
                Grouping player = list.getGroupingAt(i);
                groups[player.getGroupNum()][player.getType() - 1] = player.getPlayerID() - 1;
            }
            log.info((Object)"Finished group creation through matching service");
            this.storeGroupInformation(groups);
        }
        catch (Exception e) {
            log.error((Object)("Error reading from matching service" + MSConstants.newline + e));
        }
    }

    private void assignRoundRobinGroups() {
        try {
            int numGroups = clients.size() / groupSize;
            int[][] groups = new int[numGroups][groupSize];
            Vector matchClasses = matchings.getMatchClasses();
            MatchClass matchClass = (MatchClass)matchClasses.get(currentMatch % matchClasses.size());
            for (int i = 0; i < matchClass.getNumberOfMatchGroups(); ++i) {
                MatchGroup matchGroup = matchClass.getMatchGroupAt(i);
                for (int j = 0; j < matchGroup.getSize(); ++j) {
                    int player;
                    groups[i][j] = player = matchGroup.getPlayerAt(j) - 1;
                }
            }
            log.info((Object)"Finished group creation through round robin algorithm in matching service");
            this.storeGroupInformation(groups);
        }
        catch (Exception e) {
            log.error((Object)("Failed to create matchings through the matching service round robin algorithm" + MSConstants.newline + e));
        }
    }

    public void assignRandomGroups() {
        try {
            Random rand = ServerVariables.rand;
            Vector<Integer> alreadyUsed = new Vector<Integer>();
            int[][] groups = new int[clients.size() / groupSize][groupSize];
            for (int i = 0; i < groups.length; ++i) {
                for (int j = 0; j < groups[i].length; ++j) {
                    int partner = -1;
                    while (partner == -1 || alreadyUsed.contains(new Integer(partner))) {
                        partner = rand.nextInt(clients.size());
                    }
                    groups[i][j] = partner;
                    alreadyUsed.add(new Integer(partner));
                    ClientData client = (ClientData)clients.get(partner);
                    log.debug((Object)("Assigned " + client.getName() + " (Client " + partner + ") to temp group " + i));
                }
            }
            log.info((Object)("Completed random partnerization of " + clients.size() + " clients"));
            this.storeGroupInformation(groups);
        }
        catch (Exception e) {
            log.error((Object)("Failed to assign random partners to " + clients.size() + " clients"));
        }
    }

    private void assignRolePreservedRandomGroups() {
        int i;
        Match match = (Match)matches.get(currentMatch);
        if (match.getMatchingType() == 96) {
            this.assignRandomGroups();
            return;
        }
        Random rand = ServerVariables.rand;
        int numGroups = clients.size() / groupSize;
        int[][] groups = new int[numGroups][groupSize];
        for (i = 0; i < groups.length; ++i) {
            for (int j = 0; j < groups[i].length; ++j) {
                groups[i][j] = -1;
            }
        }
        for (i = 0; i < clients.size(); ++i) {
            int group;
            ClientData client = (ClientData)clients.get(i);
            int partnerNum = client.getPartnerNum();
            while (groups[group = rand.nextInt(numGroups)][partnerNum] != -1) {
            }
            groups[group][partnerNum] = i;
            log.debug((Object)("Placed player " + i + " with partner num " + partnerNum + " into group " + group));
        }
        log.info((Object)"Completed random partnerization with role (partner number) preservation");
        this.storeGroupInformation(groups);
    }

    private void assignFixedGroups() {
        if (currentMatch == 0) {
            log.info((Object)"Cannot use fixed matching on the first match - using random matching instead");
            this.assignRandomGroups();
            return;
        }
        Match match = (Match)matches.get(currentMatch);
        Match previousMatch = (Match)matches.get(currentMatch - 1);
        if (match.getGroupSize() != previousMatch.getGroupSize()) {
            log.warn((Object)"Cannot use fixed matching - group size has changed between matches - using random matching instead");
            this.assignRandomGroups();
            return;
        }
        for (int i = 0; i < clients.size(); ++i) {
            ClientData client = (ClientData)clients.get(i);
            int[] group = client.getPartnerHistory(currentMatch - 1);
            int groupId = client.getGroupId(currentMatch - 1);
            client.addPartnersToHistory(currentMatch, group);
            client.setGroupId(currentMatch, groupId);
        }
        log.info((Object)"Successfully transferred group information from the previous match");
    }

    private void assignManualGroups() {
        try {
            int[][] groups = null;
            if (this.matchingType == 101 || manualMatcher == null) {
                String matchType = props.getProperty("match." + currentMatch + ".type");
                log.debug((Object)("Searching for manual matcher of type " + matchType + "..."));
                try {
                    System.out.println("trying to get a manual matcher of classname: " + ((PluginDescriptor)pluginDescriptors.elementAt(currentMatch)).getMatchingClassname());
                    manualMatcher = (ManualMatcher)Class.forName(((PluginDescriptor)pluginDescriptors.elementAt(currentMatch)).getMatchingClassname()).newInstance();
                    if (manualMatcher == null) {
                        throw new Exception();
                    }
                    log.info((Object)("Found manual matcher of type " + ((PluginDescriptor)pluginDescriptors.elementAt(currentMatch)).getMatchingClassname()));
                    ui.setMatcherLabel(currentMatch);
                    manualMatcher.initialize();
                    groups = manualMatcher.manualMatching();
                }
                catch (Exception e) {
                    log.error((Object)("Manual matcher of type " + matchType + " not found - using random matching instead"));
                    e.printStackTrace();
                    this.assignRandomGroups();
                    return;
                }
                catch (NoClassDefFoundError e) {
                    log.error((Object)("Manual matcher of type " + matchType + " not found (check capitalization) - Using random matching instead"));
                    this.assignRandomGroups();
                    return;
                }
            }
            if (this.matchingType == 99 && manualMatcher != null) {
                groups = manualMatcher.continueManualMatching();
            }
            if (groups == null) {
                throw new Exception();
            }
            this.storeGroupInformation(groups);
        }
        catch (Exception e) {
            log.error((Object)("Manual matching has failed - using random matching instead" + MSConstants.newline + e));
            this.assignRandomGroups();
        }
    }

    private void assignParameterGroups() {
        try {
            int[][] groups = null;
            if (this.matchingType == 97 || manualMatcher == null) {
                String matchType = props.getProperty("match." + currentMatch + ".type");
                log.debug((Object)("Searching for manual matcher of type " + matchType + "..."));
                try {
                    manualMatcher = new ParameterMatcher();
                    if (manualMatcher == null) {
                        throw new Exception();
                    }
                    log.info((Object)"Found parameter matcher.");
                    ui.setMatcherLabel(currentMatch);
                    manualMatcher.initialize();
                    groups = manualMatcher.manualMatching();
                }
                catch (Exception e) {
                    log.error((Object)"Parameter matcher not found - using random matching instead");
                    e.printStackTrace();
                    this.assignRandomGroups();
                    return;
                }
                catch (NoClassDefFoundError e) {
                    log.error((Object)"Parameter matcher not found using random matching instead");
                    this.assignRandomGroups();
                    return;
                }
            }
            if (this.matchingType == 99 && manualMatcher != null) {
                groups = manualMatcher.continueManualMatching();
            }
            if (groups == null) {
                throw new Exception();
            }
            this.storeGroupInformation(groups);
        }
        catch (Exception e) {
            log.error((Object)("Parameter matching has failed - using random matching instead" + MSConstants.newline + e));
            this.assignRandomGroups();
        }
    }

    private void storeGroupInformation(int[][] groups) {
        try {
            for (int i = 0; i < groups.length; ++i) {
                for (int j = 0; j < groups[i].length; ++j) {
                    ClientData client = (ClientData)clients.get(groups[i][j]);
                    client.setPartnerNum(j);
                    client.setPartners(groups[i]);
                    client.addPartnersToHistory(currentMatch, client.getPartners());
                    client.setGroupId(i);
                    client.setGroupId(currentMatch, i);
                    log.debug((Object)("Client " + client.getId() + " has name " + client.getName() + " and partner num " + j + " in group " + i));
                }
            }
            log.debug((Object)"Successfully stored all partner info into the ClientData objects");
        }
        catch (Exception e) {
            log.error((Object)("Failed to store partner info into the ClientData objects " + MSConstants.newline + e));
            e.printStackTrace();
        }
    }
}

