/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.util.InvalidParameterException;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.GameRequest;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Request;
import edu.caltech.ssel.multistage.shared.network.RequestPacket;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;

public abstract class ManualMatcher
extends ServerVariables
implements MSConstants {
    private Request[] lastRequest;
    private Hashtable matchOutput;
    private Hashtable clientOutput;
    public static int INT_NOT_FOUND = -32000;
    public static float FLOAT_NOT_FOUND = -32000.0f;
    private static Category log = Category.getInstance(ManualMatcher.class);

    public void initialize() {
        this.lastRequest = new Request[clients.size()];
        this.matchOutput = new Hashtable();
        this.clientOutput = new Hashtable();
    }

    public void test(int N) {
        try {
            System.out.println(this.toString(this.manualMatching()));
            for (int i = 1; i < N; ++i) {
                System.out.println(this.toString(this.continueManualMatching()));
            }
        }
        catch (Exception e) {
            System.out.println("Test Failed " + MSConstants.newline + e);
            e.printStackTrace();
        }
    }

    public Vector getMatchOutput(int match) {
        Vector moutput = (Vector)this.matchOutput.get(new Integer(match));
        if (moutput == null) {
            return new Vector();
        }
        return moutput;
    }

    public abstract boolean verifyGroupSize(int var1) throws InvalidParameterException;

    public abstract int[][] manualMatching() throws Exception;

    public abstract int[][] continueManualMatching() throws Exception;

    protected int[][] assignCategorizedGroups(Vector[] categories) {
        try {
            int i;
            int numGroups = clients.size() / groupSize;
            int[][] groups = new int[numGroups][groupSize];
            Vector[] players = new Vector[categories.length];
            for (i = 0; i < categories.length; ++i) {
                players[i] = new Vector(categories[i]);
            }
            for (i = 0; i < groups.length; ++i) {
                Vector targetCategory = players[rand.nextInt(players.length)];
                for (int j = 0; j < groups[i].length; ++j) {
                    if (targetCategory != null && targetCategory.size() > 0) {
                        int target = rand.nextInt(targetCategory.size());
                        groups[i][j] = (Integer)targetCategory.remove(target);
                        continue;
                    }
                    targetCategory = players[rand.nextInt(players.length)];
                    --j;
                }
            }
            log.info((Object)"Completed grouping for category-based matching");
            return groups;
        }
        catch (Exception e) {
            log.error((Object)("Failed to assign groups based on continuation of categories" + MSConstants.newline + e));
            return null;
        }
    }

    protected Vector[] askQuestions(Vector questions) throws Exception {
        try {
            Information info;
            int i;
            Vector[] responses = new Vector[clients.size()];
            for (i = 0; i < clients.size(); ++i) {
                GameRequest req = new GameRequest(6);
                info = new Information();
                info.addInfo("questions", questions);
                req.setSystemInfo(info);
                com.sendRequest(i, req);
                this.lastRequest[i] = req;
            }
            log.info((Object)"Matching questions sent to all clients - awaiting responses");
            for (i = 0; i < clients.size(); ++i) {
                Vector answers;
                RequestPacket received = com.getResponse(i);
                info = received.getGameInfo();
                responses[i] = answers = (Vector)info.getInfo("answers");
                this.lastRequest[i] = null;
            }
            log.info((Object)"Responses to matching questions received");
            return responses;
        }
        catch (Exception e) {
            log.error((Object)("Failed to send matching questions to clients and receive responses" + MSConstants.newline + e));
            e.printStackTrace();
            throw new Exception();
        }
    }

    public void reauthenticate(int client) {
        try {
            System.out.println("manual matcher reauthenticating " + client);
            if (this.lastRequest[client] == null) {
                log.info((Object)("Client " + client + " has already responded to all ManualMatcher requests - no reauthenticating request resent"));
                return;
            }
            com.sendRequest(client, this.lastRequest[client]);
            log.info((Object)("ManualMatcher sending re-sending request back to client " + client + " in response to reauthentication"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to re-send a prior request in the ManualMatcher in response to reauthentication" + MSConstants.newline + e));
        }
    }

    protected float getFloatProperty(String prop) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return FLOAT_NOT_FOUND;
            }
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve float match property " + prop + " in match " + currentMatch + newline + e));
            return FLOAT_NOT_FOUND;
        }
    }

    protected float getFloatProperty(String prop, float defaultFloat) {
        float value = this.getFloatProperty(prop);
        if (value == FLOAT_NOT_FOUND) {
            value = defaultFloat;
        }
        return value;
    }

    protected int getIntProperty(String prop) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return INT_NOT_FOUND;
            }
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve int match property " + prop + " in match " + currentMatch + newline + e));
            return INT_NOT_FOUND;
        }
    }

    protected int getIntProperty(String prop, int defaultInt) {
        int value = this.getIntProperty(prop);
        if (value == INT_NOT_FOUND) {
            value = defaultInt;
        }
        return value;
    }

    protected boolean getBooleanProperty(String prop) {
        return this.getBooleanProperty(prop, false);
    }

    protected boolean getBooleanProperty(String prop, boolean defaultBool) {
        try {
            String str = this.getStringProperty(prop);
            if (str == null) {
                return defaultBool;
            }
            return Boolean.valueOf(str);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve boolean match property " + prop + " in match " + currentMatch + newline + e));
            return defaultBool;
        }
    }

    protected String getStringProperty(String prop) {
        try {
            String fullstr = "match." + currentMatch + "." + prop;
            String val = props.getProperty(fullstr);
            if (val != null) {
                val = val.trim();
            }
            log.debug((Object)("Retrieved match " + currentMatch + " property " + prop + " = " + val));
            return val;
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve string match property " + prop + " in match " + currentMatch + newline + e));
            return null;
        }
    }

    protected String getStringProperty(String prop, String defaultStr) {
        String value = this.getStringProperty(prop);
        if (value == null) {
            value = defaultStr;
        }
        return value;
    }

    protected void addOutput(String propName, String propValue) {
        String[] output = new String[]{propName, propValue};
        this.addMatchOutput(currentMatch, output);
    }

    protected void addOutput(int playerNum, String propName, String propValue) {
        String[] output = new String[]{propName, propValue};
        this.addMatchOutput(playerNum, currentMatch, output);
    }

    private void addMatchOutput(int player, int matchNum, String[] output) {
        Vector<String[]> client;
        Hashtable<Integer, Vector<String[]>> match = (Hashtable<Integer, Vector<String[]>>)this.clientOutput.get(new Integer(matchNum));
        if (match == null) {
            match = new Hashtable<Integer, Vector<String[]>>();
            this.clientOutput.put(new Integer(matchNum), match);
        }
        if ((client = (Vector<String[]>)match.get(new Integer(player))) == null) {
            client = new Vector<String[]>();
            match.put(new Integer(player), client);
        }
        client.add(output);
    }

    public Vector getMatchOutput(int player, int matchNum) {
        Hashtable match = (Hashtable)this.clientOutput.get(new Integer(matchNum));
        if (match == null) {
            return new Vector();
        }
        Vector client = (Vector)match.get(new Integer(player));
        if (client == null) {
            return new Vector();
        }
        return client;
    }

    private void addMatchOutput(int match, String[] output) {
        Vector<String[]> out = (Vector<String[]>)this.matchOutput.get(new Integer(match));
        if (out == null) {
            out = new Vector<String[]>();
            this.matchOutput.put(new Integer(match), out);
        }
        out.add(output);
    }

    private String toString(int[][] groups) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < groups.length; ++i) {
            sb.append("{");
            for (int j = 0; j < groups[i].length; ++j) {
                if (j == groups[i].length - 1) {
                    sb.append(groups[i][j]);
                    continue;
                }
                sb.append(groups[i][j]).append(", ");
            }
            if (i == groups.length - 1) {
                sb.append("}");
                continue;
            }
            sb.append("} ");
        }
        return sb.toString();
    }
}

