/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ChatProcessor;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import org.apache.log4j.Category;

public class ChatReceiver
extends ServerVariables
implements Runnable {
    private int partnerNum;
    private int playerNum;
    private ChatProcessor proc;
    private boolean die;
    private static Category log = Category.getInstance(ChatReceiver.class);

    public ChatReceiver(ChatProcessor proc, int partnerNum, int playerNum) {
        this.proc = proc;
        this.partnerNum = partnerNum;
        this.playerNum = playerNum;
    }

    public void run() {
        try {
            while (!this.die) {
                MessagePacket mes = com.getChat(this.playerNum);
                if (mes.getType() == 29) {
                    this.proc.addMessage(mes);
                }
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.error((Object)("The Server-side chat receiver for client " + this.playerNum + " has malfunctioned" + MSConstants.newline + e));
        }
    }

    public void kill() {
        try {
            this.die = true;
            com.sendInternalChat(this.playerNum, new MessagePacket());
        }
        catch (Exception e) {
            log.error((Object)("Failed to kill the client-side chat receiver for the next match" + MSConstants.newline + e));
        }
    }
}

