/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.server.control;

import edu.caltech.ssel.multistage.server.control.ChatReceiver;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.server.control.ServerVariables;
import edu.caltech.ssel.multistage.server.data.Match;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.network.ChatMessage;
import edu.caltech.ssel.multistage.shared.network.GameMessage;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.util.Vector;
import org.apache.log4j.Category;

public class ChatProcessor
extends ServerVariables
implements Runnable {
    private int[] players;
    private int[] messageCounts;
    private Vector chatReceivers;
    private Vector queue;
    private boolean die;
    private ServerControl scon;
    private ClientData[] cdata;
    private long startTime;
    private Vector[] routingInfo;
    private static Category log = Category.getInstance(ChatProcessor.class);

    public ChatProcessor(ServerControl scon, int[] players, ClientData[] cdata) {
        this.players = players;
        this.scon = scon;
        this.cdata = cdata;
        this.chatReceivers = new Vector();
        this.messageCounts = new int[players.length];
        this.queue = new Vector();
        this.die = false;
        this.activateGroupRouting();
        for (int i = 0; i < players.length; ++i) {
            ChatReceiver rec = new ChatReceiver(this, i, players[i]);
            this.chatReceivers.add(rec);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void newRound() {
        for (int i = 0; i < this.messageCounts.length; ++i) {
            this.messageCounts[i] = 0;
        }
        this.startTime = System.currentTimeMillis();
    }

    public void activateReceivers() {
        for (int i = 0; i < this.chatReceivers.size(); ++i) {
            ChatReceiver rec = (ChatReceiver)this.chatReceivers.get(i);
            Thread mth = new Thread(rec);
            mth.start();
        }
    }

    public synchronized void addMessage(MessagePacket mes) {
        this.queue.add(mes);
        this.notifyAll();
    }

    public MessagePacket receiveIfPossible() {
        if (this.queue.size() < 1) {
            return null;
        }
        MessagePacket mes = (MessagePacket)this.queue.remove(0);
        return mes;
    }

    public synchronized MessagePacket receive() {
        try {
            while (true) {
                MessagePacket mes;
                if ((mes = this.receiveIfPossible()) == null) {
                    this.wait();
                    continue;
                }
                ChatMessage cmes = (ChatMessage)mes.getObject();
                int sender = cmes.getSourcePartnerNum();
                cmes.setSourcePlayerNum(this.scon.getPlayerNum(sender));
                this.appendToServerGUI(cmes);
                this.addToOutput(cmes);
                this.scon.respondToChat(sender, (String)cmes.getMessage(), this.getMessageId(cmes));
                mes.setObject(cmes);
                this.routeMessage(sender, mes);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to receive a message from the MessageProcessor" + MSConstants.newline + e));
            return null;
        }
    }

    private void routeMessage(int sender, MessagePacket mes) {
        try {
            if (sender >= this.routingInfo.length) {
                log.warn((Object)("Invalid routing table being used by chat processor - message from partner " + sender + " + not sent"));
                return;
            }
            Vector router = this.routingInfo[sender];
            if (router == null) {
                log.warn((Object)("Invalid (null) routing table being used by chat processor - message from partner " + sender + " not sent"));
                return;
            }
            for (int i = 0; i < router.size(); ++i) {
                int receiver = (Integer)router.get(i);
                com.sendChat(this.players[receiver], new GameMessage(mes));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error routing message from partner " + sender + " to receivers" + MSConstants.newline + e));
        }
    }

    private int getMessageId(ChatMessage cmes) {
        Match match = (Match)matches.get(currentMatch);
        int source = cmes.getSourcePartnerNum();
        ClientData cd = this.cdata[source];
        String messageStr = (String)cmes.getMessage();
        int value = -1;
        if (match.getOptionChat()) {
            String[] messages = match.getChatOptions()[source];
            for (int i = 0; i < messages.length; ++i) {
                if (!messageStr.equals(messages[i])) continue;
                value = i;
                break;
            }
        }
        return value;
    }

    private void addToOutput(ChatMessage cmes) {
        Match match = (Match)matches.get(currentMatch);
        int source = cmes.getSourcePartnerNum();
        String value = (String)cmes.getMessage();
        if (match.getOptionChat()) {
            value = "" + this.getMessageId(cmes);
        }
        this.scon.addOutput(source, "message." + this.messageCounts[source], value);
        this.scon.addOutput(source, "message." + this.messageCounts[source] + ".time", "" + (System.currentTimeMillis() - this.startTime));
        int n = source;
        this.messageCounts[n] = this.messageCounts[n] + 1;
    }

    private void appendToServerGUI(ChatMessage cmes) {
        String str = (String)cmes.getMessage();
        int source = cmes.getSourcePartnerNum();
        int player = this.players[source];
        String name = ((ClientData)clients.get(player)).getName();
        ui.getLoggingMonitor().addChatMessage(name + " [ID: " + player + "]" + ": " + str);
    }

    public synchronized void close() {
        this.die = true;
        for (int i = 0; i < this.chatReceivers.size(); ++i) {
            ChatReceiver rec = (ChatReceiver)this.chatReceivers.get(i);
            rec.kill();
        }
        this.notifyAll();
    }

    public void run() {
        while (!this.die) {
            this.receive();
        }
    }

    public void activateGroupRouting() {
        this.routingInfo = new Vector[this.players.length];
        for (int i = 0; i < this.routingInfo.length; ++i) {
            this.routingInfo[i] = new Vector();
            for (int j = 0; j < this.players.length; ++j) {
                this.routingInfo[i].add(new Integer(j));
            }
        }
    }

    public void clearRoutingInfo() {
        this.routingInfo = new Vector[this.players.length];
        for (int i = 0; i < this.routingInfo.length; ++i) {
            this.routingInfo[i] = new Vector();
        }
    }

    public void insertRoute(int sender, int receiver) {
        if (sender >= this.routingInfo.length) {
            log.warn((Object)("Attempted an invalid message route insertion: partner " + sender + " does not exist"));
            return;
        }
        Vector<Integer> vect = this.routingInfo[sender];
        if (vect == null) {
            vect = new Vector<Integer>();
        }
        vect.add(new Integer(receiver));
    }

    public void removeRoute(int sender, int receiver) {
        if (sender >= this.routingInfo.length) {
            log.warn((Object)("Attempted to remove a route from an invalid sender: partner " + sender + " does not exist"));
            return;
        }
        Vector vect = this.routingInfo[sender];
        if (vect == null) {
            return;
        }
        vect.remove(new Integer(receiver));
    }

    public void insertRoutingTable(Vector[] routingInfo) {
        this.routingInfo = routingInfo;
    }
}

