/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.network;

import edu.caltech.ssel.multistage.shared.network.GamePingPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.PingPacket;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import org.apache.log4j.Category;

public class MailClientPingReceiver
implements Runnable,
MSConstants {
    private int id;
    private Mailbox ping_in;
    private Mailbox ping_out;
    private static Category log = Category.getInstance(MailClientPingReceiver.class);

    public MailClientPingReceiver(int id, Mailbox ping_in, Mailbox ping_out) {
        this.id = id;
        this.ping_in = ping_in;
        this.ping_out = ping_out;
    }

    public void run() {
        try {
            while (true) {
                PingPacket packet;
                if ((packet = (PingPacket)this.ping_in.receive()).getStatus() == 2) {
                    this.ping_out.close();
                    this.ping_in.close();
                    log.debug((Object)("Client " + this.id + " has shut down connection verification system"));
                    break;
                }
                log.debug((Object)("Client " + this.id + " has received a connection verification ping packet"));
                GamePingPacket outPacket = new GamePingPacket(1);
                this.outputPingPacket(outPacket);
                log.debug((Object)("Client " + this.id + " has sent the server a verification packet"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to bounce back a ping connection verification request", (Throwable)e);
        }
    }

    private void outputPingPacket(PingPacket outPacket) {
        try {
            this.ping_out.deposit(outPacket);
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to establish an outgoing connection using the pinging communication channel -- retrying");
            this.outputPingPacket(outPacket);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing outgoing connection using pinging communication channel -- retrying");
            System.out.println("PINGING ConnectIOException occurred -- retrying");
            this.outputPingPacket(outPacket);
        }
        catch (Exception e) {
            log.error((Object)"Failed to send a pinging system outpacket to the server to monitor client connection status", (Throwable)e);
        }
    }
}

