/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.network;

import edu.caltech.ssel.multistage.client.network.ClientCommunicator;
import edu.caltech.ssel.multistage.client.network.MailClientPingReceiver;
import edu.caltech.ssel.multistage.shared.network.GamePingPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.Message;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import edu.caltech.ssel.multistage.shared.network.Request;
import edu.caltech.ssel.multistage.shared.network.RequestPacket;
import edu.caltech.ssel.multistage.shared.network.Response;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import org.apache.log4j.Category;

public class MailClientCommunicator
implements ClientCommunicator,
MSConstants {
    private String host;
    private int id;
    private Mailbox in;
    private Mailbox out;
    private Mailbox ping_in;
    private Mailbox ping_out;
    private Mailbox message_in;
    private Mailbox message_out;
    private Mailbox chat_in;
    private Mailbox chat_out;
    private static Category log = Category.getInstance(MailClientCommunicator.class);

    public MailClientCommunicator(int id, String host, Mailbox in, Mailbox out, Mailbox ping_in, Mailbox ping_out, Mailbox message_in, Mailbox message_out, Mailbox chat_in, Mailbox chat_out) {
        try {
            log.debug((Object)("Creating a new mail communicator for client " + id));
            this.id = id;
            this.host = host;
            this.in = in;
            this.out = out;
            this.ping_in = ping_in;
            this.ping_out = ping_out;
            this.message_in = message_in;
            this.message_out = message_out;
            this.chat_in = chat_in;
            this.chat_out = chat_out;
            this.startConnectionVerifier();
        }
        catch (Exception e) {
            log.error((Object)("Failed to create the mail communicator for client " + id + " with host: " + host), (Throwable)e);
        }
    }

    private void startConnectionVerifier() {
        log.debug((Object)("Client " + this.id + " is starting the Ping receiver..."));
        MailClientPingReceiver pinger = new MailClientPingReceiver(this.id, this.ping_in, this.ping_out);
        Thread pingControl = new Thread(pinger);
        pingControl.start();
        log.info((Object)("Client " + this.id + " has started the Ping receiver to verify connections"));
    }

    public void sendResponse(Response res) {
        try {
            this.out.deposit(res);
            log.debug((Object)"Client has sent response to server");
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to establish an outgoing connection using the main communication channel -- retrying");
            this.sendResponse(res);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing outgoing connection using main communication channel -- retrying");
            System.out.println("ConnectIOException occurred -- retrying");
            this.sendResponse(res);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send response to the server using mail communicator with host: " + this.host), (Throwable)e);
        }
    }

    public RequestPacket getRequest() {
        try {
            Request req = (Request)this.in.receive();
            log.debug((Object)"Client has received request from server");
            return this.getRequestPacket(req);
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to establish an incoming connection using the main communication channel -- retrying");
            return this.getRequest();
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing incoming connection using main communication channel -- retrying");
            System.out.println("ConnectIOException occurred -- retrying");
            return this.getRequest();
        }
        catch (Exception e) {
            log.error((Object)("Failed to get request from server using mail communicator with host: " + this.host), (Throwable)e);
            return null;
        }
    }

    private RequestPacket getRequestPacket(Request req) {
        try {
            return req.getRequestPacket();
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to retrieve data from request using the main communication channel due to network error -- retrying");
            return this.getRequestPacket(req);
        }
        catch (Exception e) {
            log.error((Object)"Failed to retrieve data from request using the main communication channel", (Throwable)e);
            return null;
        }
    }

    public MessagePacket getMessage() {
        try {
            Message mes = (Message)this.message_in.receive();
            log.debug((Object)"Client has received a message from server");
            return this.getMessagePacket(mes);
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to establish an incoming connection using the message communication channel -- retrying");
            return this.getMessage();
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing incoming connection using message communication channel -- retrying");
            System.out.println("ConnectIOException occurred -- retrying");
            return this.getMessage();
        }
        catch (Exception e) {
            log.error((Object)("Failed to get a message from the server using mail communicator with host: " + this.host), (Throwable)e);
            return null;
        }
    }

    private MessagePacket getMessagePacket(Message mes) {
        try {
            return mes.getMessagePacket();
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to retrieve data from message using the message or chat communication channel due to network error -- retrying");
            return this.getMessagePacket(mes);
        }
        catch (Exception e) {
            log.error((Object)"Failed to retrieve data from message using the message or chat communication channel", (Throwable)e);
            return null;
        }
    }

    public void close() {
        try {
            this.out.close();
            this.in.close();
            this.message_in.close();
            this.message_out.close();
            this.chat_in.close();
            this.chat_out.close();
            this.ping_in.deposit(new GamePingPacket(2));
            log.info((Object)("Client " + this.id + " communicator has been shut down"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to shut down client communicator" + newline + e), (Throwable)e);
        }
    }

    public void sendMessage(Message mes) {
        try {
            this.message_out.deposit(mes);
            log.debug((Object)"Client has sent instant message to server");
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to establish an outgoing connection using the message communication channel -- retrying");
            this.sendMessage(mes);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing outgoing connection using message communication channel -- retrying");
            System.out.println("ConnectIOException occurred -- retrying");
            this.sendMessage(mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send instant message to server using mail communicator with host: " + this.host), (Throwable)e);
        }
    }

    public void sendChat(Message mes) {
        try {
            this.chat_out.deposit(mes);
            log.debug((Object)"Client has sent a chat message to server");
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to establish an outgoing connection using the chat communication channel -- retrying");
            this.sendChat(mes);
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing outgoing connection using chat communication channel -- retrying");
            System.out.println("ConnectIOException occurred -- retrying");
            this.sendChat(mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send chat message to server using mail communicator with host: " + this.host), (Throwable)e);
        }
    }

    public MessagePacket getChat() {
        try {
            Message mes = (Message)this.chat_in.receive();
            log.debug((Object)"Client has received a chat message from server");
            return this.getMessagePacket(mes);
        }
        catch (ConnectException e) {
            log.warn((Object)"Client failed to establish an incoming connection using the chat communication channel -- retrying");
            return this.getChat();
        }
        catch (ConnectIOException e) {
            log.warn((Object)"Input / Output error while establishing incoming connection using chat communication channel -- retrying");
            System.out.println("ConnectIOException occurred -- retrying");
            return this.getChat();
        }
        catch (Exception e) {
            log.error((Object)("Failed to get a chat message from the server using mail communicator with host: " + this.host), (Throwable)e);
            return null;
        }
    }

    public void sendInternalRequest(Request req) {
        try {
            this.in.deposit(req);
            log.debug((Object)"Client has added an internal request to the request inbox");
        }
        catch (Exception e) {
            log.error((Object)"Failed to insert an internal request to the client mailbox", (Throwable)e);
        }
    }

    public void sendInternalMessage(Message mes) {
        try {
            this.message_in.deposit(mes);
            log.debug((Object)"Client has added an internal message to the message inbox");
        }
        catch (Exception e) {
            log.error((Object)"Failed to send an internal message to the client message mailbox", (Throwable)e);
        }
    }
}

