/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.network;

import edu.caltech.ssel.multistage.client.network.ClientAuthenticator;
import edu.caltech.ssel.multistage.client.network.ClientCommunicator;
import edu.caltech.ssel.multistage.client.network.MailClientCommunicator;
import edu.caltech.ssel.multistage.shared.network.AuthorizationPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.SimpleObjectRegistry;
import java.rmi.NotBoundException;
import org.apache.log4j.Category;

public class MailClientAuthenticator
extends ClientAuthenticator
implements MSConstants {
    private static Category log = Category.getInstance(MailClientAuthenticator.class);
    private Mailbox auth_out;
    private Mailbox auth_in;
    private Mailbox com_out;
    private Mailbox com_in;
    private Mailbox ping_in;
    private Mailbox ping_out;
    private Mailbox message_in;
    private Mailbox message_out;
    private Mailbox chat_in;
    private Mailbox chat_out;

    public MailClientAuthenticator(String host, String name) {
        super(host, name);
    }

    public void initAuthenticator() {
        try {
            try {
                this.auth_out = (Mailbox)SimpleObjectRegistry.findObject("auth_inbox", this.host);
                this.auth_in = (Mailbox)SimpleObjectRegistry.findObject("auth_outbox", this.host);
            }
            catch (NotBoundException e) {
                log.info((Object)"Mailboxes not yet ready - sleeping for 1 s then trying again");
                Thread.sleep(1000L);
                this.initAuthenticator();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while trying to get mailboxes from server" + newline + e));
        }
    }

    public void initCommunicator(int id) {
        try {
            this.com_in = (Mailbox)SimpleObjectRegistry.findObject("outbox-" + id, this.host);
            this.com_out = (Mailbox)SimpleObjectRegistry.findObject("inbox-" + id, this.host);
            this.ping_in = (Mailbox)SimpleObjectRegistry.findObject("pingOut-" + id, this.host);
            this.ping_out = (Mailbox)SimpleObjectRegistry.findObject("pingIn-" + id, this.host);
            this.message_in = (Mailbox)SimpleObjectRegistry.findObject("messageOut-" + id, this.host);
            this.message_out = (Mailbox)SimpleObjectRegistry.findObject("messageIn-" + id, this.host);
            this.chat_in = (Mailbox)SimpleObjectRegistry.findObject("chatOut-" + id, this.host);
            this.chat_out = (Mailbox)SimpleObjectRegistry.findObject("chatIn-" + id, this.host);
        }
        catch (NotBoundException e) {
            log.info((Object)"Client lost connection to registry -- retrying");
            this.initCommunicator(id);
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize the client communicator for id: " + id), (Throwable)e);
        }
    }

    public void sendAuthRequest(AuthorizationPacket packet) {
        try {
            this.auth_out.deposit(packet);
        }
        catch (Exception e) {
            log.error((Object)"Failed to send an AuthorizationPacket to the server", (Throwable)e);
        }
    }

    public AuthorizationPacket receiveAuthResponse() {
        try {
            AuthorizationPacket authPack = (AuthorizationPacket)this.auth_in.receive();
            if (!authPack.getName().equals(this.name)) {
                this.auth_in.deposit(authPack);
                return this.receiveAuthResponse();
            }
            return authPack;
        }
        catch (Exception e) {
            log.error((Object)"Failed to receive an AuthorizationPacket from the server", (Throwable)e);
            return null;
        }
    }

    public boolean reconnect() {
        try {
            try {
                this.auth_out = (Mailbox)SimpleObjectRegistry.findObject("auth_inbox", this.host);
                this.auth_in = (Mailbox)SimpleObjectRegistry.findObject("auth_outbox", this.host);
                return this.reauthenticate();
            }
            catch (NotBoundException e) {
                log.debug((Object)"Mailboxes not yet ready - sleeping for 1 ms then trying again");
                Thread.sleep(1000L);
                this.reconnect();
            }
        }
        catch (Exception e) {
            log.debug((Object)("Error while trying to get mailboxes from server" + newline + e));
        }
        return false;
    }

    private boolean reauthenticate() {
        try {
            AuthorizationPacket packet = new AuthorizationPacket(this.name, 1);
            log.debug((Object)"Sending reauthorization request to server");
            this.auth_out.deposit(packet);
            boolean receivedFirstConfirmation = false;
            while (true) {
                AuthorizationPacket authPacket;
                if ((authPacket = (AuthorizationPacket)this.auth_in.receive()).getType() == 2 && authPacket.getName().equals(this.name) && !receivedFirstConfirmation) {
                    this.id = authPacket.getId();
                    this.com_in = (Mailbox)SimpleObjectRegistry.findObject("reauth_com_out", this.host);
                    this.com_out = (Mailbox)SimpleObjectRegistry.findObject("reauth_com_in", this.host);
                    this.ping_in = (Mailbox)SimpleObjectRegistry.findObject("reauth_ping_out", this.host);
                    this.ping_out = (Mailbox)SimpleObjectRegistry.findObject("reauth_ping_in", this.host);
                    this.message_in = (Mailbox)SimpleObjectRegistry.findObject("reauth_message_out", this.host);
                    this.message_out = (Mailbox)SimpleObjectRegistry.findObject("reauth_message_in", this.host);
                    this.chat_in = (Mailbox)SimpleObjectRegistry.findObject("reauth_chat_out", this.host);
                    this.chat_out = (Mailbox)SimpleObjectRegistry.findObject("reauth_chat_in", this.host);
                    log.info((Object)("Client " + this.id + " with name " + this.name + " has been reauthenticated"));
                    receivedFirstConfirmation = true;
                    continue;
                }
                if (authPacket.getType() == 8 && authPacket.getName().equals(this.name) && receivedFirstConfirmation) {
                    return true;
                }
                if (authPacket.getType() == 7 && authPacket.getName().equals(this.name) && receivedFirstConfirmation) {
                    return false;
                }
                this.auth_in.deposit(authPacket);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to reauthenticate the client with the mail authenticator with host: " + this.host + newline + e));
            return false;
        }
    }

    public ClientCommunicator getCommunicator() {
        MailClientCommunicator com = new MailClientCommunicator(this.id, this.host, this.com_in, this.com_out, this.ping_in, this.ping_out, this.message_in, this.message_out, this.chat_in, this.chat_out);
        log.debug((Object)("Created communicator for client attached to host: " + this.host));
        return com;
    }

    public void close() {
        try {
            log.info((Object)"Client authenticator has been shut down");
        }
        catch (Exception e) {
            log.error((Object)("Failed to close down client" + MSConstants.newline + e));
        }
    }
}

